/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.initiator;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiator;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionImpl;
import com.sanrad.nms.server.logic.target.ISCSITarget;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class ISCSIRemoteInitiatorImpl
extends TableRowImpl
implements ISCSIRemoteInitiator {
    private static List m_parameterCodeList;
    private ArrayList m_initiatorAllSessions = new ArrayList();

    public ISCSIRemoteInitiatorImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.ISCSI_REMOTE_INITIATOR, m_parameterCodeList);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        this.toStringValue = this.getInitiatorAlias();
        return changedValues;
    }

    public void clear() throws RemoteException {
        this.m_initiatorAllSessions.clear();
        super.clear();
    }

    public VSwitch getInitiatorVswitchParent() throws RemoteException {
        return this.getParentVSwitch();
    }

    public HashMap getClientParameterList() throws RemoteException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.ISCSI_REMOTE_INITIATOR_SESSIONS, this.getInitiatorSessions());
        return parameterList;
    }

    public ISCSISession[] getInitiatorSessions() throws RemoteException {
        ISCSISession[] sessions = new ISCSISession[this.m_initiatorAllSessions.size()];
        return this.m_initiatorAllSessions.toArray(sessions);
    }

    public void addInitiatorSession(ISCSISessionImpl iscsiSessionImpl) {
        this.m_initiatorAllSessions.add(iscsiSessionImpl);
    }

    public void removeInitiatorSession(ISCSISessionImpl iscsiSessionImpl) {
        this.m_initiatorAllSessions.remove(iscsiSessionImpl);
    }

    public String getInitiatorAlias() throws RemoteException {
        if (this.m_initiatorAllSessions != null && this.m_initiatorAllSessions.size() > 0) {
            ISCSISession firstSession = (ISCSISession)this.m_initiatorAllSessions.get(0);
            return firstSession.getInitiatorAlias();
        }
        return null;
    }

    public String getInitiatorName() throws RemoteException {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_REMOTE_INITIATOR_NAME);
    }

    public ISCSITarget getTarget() throws RemoteException {
        CommKeyClassId scsiTargetCommKeyClassId = (CommKeyClassId)this.getSrValueOf(ParameterCode.SCSI_TARGET_ID);
        ISCSITarget target = null;
        if (scsiTargetCommKeyClassId != null) {
            CommKeyClassId iscsiTargetCommKeyClassId = this.cluster.getISCSIId(scsiTargetCommKeyClassId);
            target = (ISCSITarget)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(iscsiTargetCommKeyClassId);
        }
        return target;
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        return null;
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.ISCSI_REMOTE_INITIATOR_NAME);
        parameterCodes.addElement(ParameterCode.SCSI_TARGET_ID);
        m_parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

