/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.initiator;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.CHAPCredentials;
import com.sanrad.nms.server.logic.identity.SRPCredentials;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.initiator.InitiatorImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.target.ISCSIRemoteDiscoveryPortalValidator;
import com.sanrad.nms.server.logic.target.ISCSIRemotePortalDiscovery;
import com.sanrad.nms.server.logic.target.ISCSIRemotePortalDiscoveryImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTarget;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrType;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class ISCSIInitiatorImpl
extends InitiatorImpl
implements ISCSIInitiator {
    private ArrayList m_sessions = new ArrayList();
    private ArrayList m_remoteTargets = new ArrayList();
    private ArrayList m_remoteDiscoveryPortals = new ArrayList();
    private CHAPCredentials m_chapCredentials;
    private SRPCredentials m_srpCredentials;

    public ISCSIInitiatorImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.ISCSI_INITIATOR);
        this.addParameterCode(ParameterCode.ISCSI_INITIATOR_NAME);
        this.addParameterCode(ParameterCode.ISCSI_INITIATOR_ALIAS);
        this.addParameterCode(ParameterCode.SCSI_DEVICE_ID);
    }

    public HashMap getClientParameterList() throws RemoteException {
        HashMap map = super.getClientParameterList();
        map.put(ClientParameterCode.ISCSI_INITIATOR_REMOTE_TARGETS, this.getISCSIRemoteTargets());
        map.put(ClientParameterCode.ISCSI_INITIATOR_REMOTE_DISCOVERY_PORTALS, this.getISCSIRemoteDiscoveryPortals());
        return map;
    }

    public void clear() throws RemoteException {
        this.m_sessions.clear();
        this.m_remoteTargets.clear();
        this.m_remoteDiscoveryPortals.clear();
        this.setCHAPCredentials(null);
        this.setSRPCredentials(null);
        super.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(ClassID.ISCSI_INITIATOR.toString());
        try {
            sb.append(this.getAlias());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return sb.toString();
    }

    public String getAlias() throws RemoteException {
        return this.getAlias(null);
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        String alias = (String)this.getValueOf(vSwitch, ParameterCode.ISCSI_INITIATOR_ALIAS, vSwitch == null);
        return alias;
    }

    public String getCHAPUserName() throws RemoteException {
        return this.m_chapCredentials == null ? null : this.m_chapCredentials.getUserName();
    }

    public String getSRPUserName() throws RemoteException {
        return this.m_srpCredentials == null ? null : this.m_srpCredentials.getUserName();
    }

    public ISCSIRemoteTarget[] getISCSIRemoteTargets() throws RemoteException {
        ISCSIRemoteTarget[] array = new ISCSIRemoteTarget[this.m_remoteTargets.size()];
        return this.m_remoteTargets.toArray(array);
    }

    public ISCSIRemotePortalDiscovery[] getISCSIRemoteDiscoveryPortals() throws RemoteException {
        ISCSIRemotePortalDiscovery[] array = new ISCSIRemotePortalDiscovery[this.m_remoteDiscoveryPortals.size()];
        return this.m_remoteDiscoveryPortals.toArray(array);
    }

    public ISCSISession[] getISCSISessions() throws RemoteException {
        ISCSISession[] array = new ISCSISession[this.m_sessions.size()];
        return this.m_sessions.toArray(array);
    }

    public void setCHAPCredentials(CHAPCredentials credentials) {
        this.m_chapCredentials = credentials;
    }

    public CHAPCredentials getCHAPCredentials() {
        return this.m_chapCredentials;
    }

    public void setSRPCredentials(SRPCredentials credentials) {
        this.m_srpCredentials = credentials;
    }

    public SRPCredentials getSRPCredentials() {
        return this.m_srpCredentials;
    }

    public void changeElement(HashMap parameterList) throws RemoteException, IllegalValueException {
        String chapUserName = (String)parameterList.get(ClientParameterCode.ISCSI_INITIATOR_CHAP_USER_NAME);
        String chapPassword = (String)parameterList.get(ClientParameterCode.ISCSI_INITIATOR_CHAP_PASSWORD);
        boolean isCHAPCredChange = chapUserName != null || chapPassword != null;
        String srpUserName = (String)parameterList.get(ClientParameterCode.ISCSI_INITIATOR_SRP_USER_NAME);
        String srpPassword = (String)parameterList.get(ClientParameterCode.ISCSI_INITIATOR_SRP_PASSWORD);
        boolean isSRPCredChange = srpUserName != null || srpPassword != null;
        HashMap<ClientParameterCode, String> map = new HashMap<ClientParameterCode, String>();
        if (chapUserName != null) {
            map.put(ClientParameterCode.CHAP_CREDENTIALS_USER_NAME, chapUserName);
        }
        if (chapPassword != null) {
            map.put(ClientParameterCode.CHAP_CREDENTIALS_PASSWORD, chapPassword);
        }
        if (this.m_chapCredentials != null && isCHAPCredChange) {
            this.m_chapCredentials.changeElement(map);
        }
        map.clear();
        if (srpUserName != null) {
            map.put(ClientParameterCode.SRP_CREDENTIALS_USER_NAME, srpUserName);
        }
        if (srpPassword != null) {
            map.put(ClientParameterCode.SRP_CREDENTIALS_PASSWORD, srpPassword);
        }
        if (this.m_srpCredentials != null && isSRPCredChange) {
            this.m_srpCredentials.changeElement(map);
        }
    }

    public boolean isMyIdentity(String identityName) throws RemoteException {
        String name = this.getName();
        return name.equals(identityName);
    }

    private String getInitiatorCommKeyFromIdentityAlias(String identityAlias) {
        StringBuffer sb = new StringBuffer();
        String commKeySuffix = identityAlias.substring(identityAlias.indexOf("_") + 1);
        StringTokenizer st = new StringTokenizer(commKeySuffix, "_");
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            sb.append(".");
        }
        String returnStr = sb.toString().substring(0, sb.toString().length() - 1);
        return returnStr;
    }

    public void addRemoteTarget(ISCSIRemoteTarget remoteTarget) {
        this.m_remoteTargets.add(remoteTarget);
    }

    public void removeRemoteTarget(ISCSIRemoteTarget remoteTarget) {
        this.m_remoteTargets.remove(remoteTarget);
    }

    public void clearAllRemoteTargets() {
        this.m_remoteTargets.clear();
    }

    public void addRemoteDiscoveryPortal(ISCSIRemotePortalDiscovery remoteDiscoveryPortal) {
        this.m_remoteDiscoveryPortals.add(remoteDiscoveryPortal);
    }

    public void removeRemoteDiscoveryPortal(ISCSIRemotePortalDiscovery remoteDiscoveryPortal) {
        this.m_remoteDiscoveryPortals.remove(remoteDiscoveryPortal);
    }

    public void clearAllRemoteDiscoveryPortals() {
        this.m_remoteDiscoveryPortals.clear();
    }

    public ISCSIRemotePortalDiscovery getRemoteDiscoveryPortal(String ip, int port) throws RemoteException {
        for (int index = 0; index < this.m_remoteDiscoveryPortals.size(); ++index) {
            ISCSIRemotePortalDiscovery portal = (ISCSIRemotePortalDiscovery)this.m_remoteDiscoveryPortals.get(index);
            if (!((ISCSIRemotePortalDiscoveryImpl)portal).isEqual(ip, port)) continue;
            return portal;
        }
        return null;
    }

    public boolean isRemoteDiscoveryPortalExisted(String ip, int port) throws RemoteException {
        return this.getRemoteDiscoveryPortal(ip, port) != null;
    }

    public void createRemoteDiscoveryPortal(String ipAddress, Integer port) throws RemoteException, IllegalValueException {
        this.createRemoteDiscoveryPortal(ipAddress, port, null);
    }

    public void createRemoteDiscoveryPortal(String ipAddress, Integer port, Integer period) throws RemoteException, IllegalValueException {
        ISCSIRemoteDiscoveryPortalValidator validator = new ISCSIRemoteDiscoveryPortalValidator(this, ipAddress, port);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ConfigElementData element = new ConfigElementData(ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL);
        SrType[] vswitchesToSet = new CommKeyClassId[]{this.getActiveVswitch().getCommKeyClassId()};
        element.setValues(ParameterCode.VSWITCH_ID, vswitchesToSet);
        element.setValue(ParameterCode.SCSI_INITIATOR_ID, this.getSCSIDeviceId());
        element.setValue(ParameterCode.REMOTE_PORTAL_DISC_ADDRESS, new SrIpAddress(ipAddress));
        element.setValue(ParameterCode.REMOTE_PORTAL_DISC_PORT, new SrInteger((int)port));
        if (period != null) {
            element.setValue(ParameterCode.REMOTE_PORTAL_DISC_PERIOD, new SrInteger((int)period));
        }
        ((ClusterImpl)this.getCluster()).createElement(element, ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL, ipAddress + " : " + String.valueOf(port));
    }

    public boolean isRemoteDiscoveryPortalExistedAsISNSServer(String ip) throws RemoteException {
        ClusterImpl parentCluster = (ClusterImpl)this.getCluster();
        return parentCluster.isIPExistedAsISNSServer(ip);
    }

    public boolean isRemoteDiscoveryPortalExistedAsRadiusServer(String ip) throws RemoteException {
        ClusterImpl parentCluster = (ClusterImpl)this.getCluster();
        return parentCluster.isIPExistedAsRadiusServer(ip);
    }

    public boolean isRemoteDiscoveryPortalExistedAsLocalIP(String ip) throws RemoteException {
        VSwitchImpl parentVSwitch = (VSwitchImpl)this.getParentVSwitch();
        return parentVSwitch.isIPExistedAsLocalIP(ip);
    }

    public boolean isRemoteDiscoveryPortalExistedAsRoutIP(String ip) throws RemoteException {
        VSwitchImpl parentVSwitch = (VSwitchImpl)this.getParentVSwitch();
        return parentVSwitch.isIPExistedAsRoutIP(ip);
    }

    public boolean isRemoteDiscoveryPortalExistedAsLocalPortal(String ip, int port) throws RemoteException {
        VSwitchImpl parentVSwitch = (VSwitchImpl)this.getParentVSwitch();
        return parentVSwitch.isIPExistedAsLocalPortal(ip, port);
    }

    public boolean isRemoteDiscoveryPortalExistedAsSNMPManager(String ip) throws RemoteException {
        VSwitchImpl parentVSwitch = (VSwitchImpl)this.getParentVSwitch();
        return parentVSwitch.isIPExistedAsSNMPManager(ip);
    }

    public boolean isRemoteDiscoveryPortalExistedAsNeighbor(String ip) throws RemoteException {
        VSwitchImpl parentVSwitch = (VSwitchImpl)this.getParentVSwitch();
        return parentVSwitch.isIPExistedAsNeighbor(ip);
    }

    public void addSession(ISCSISession session) {
        this.m_sessions.add(session);
    }

    public void removeSession(ISCSISession session) {
        this.m_sessions.remove(session);
    }

    public void clearAllSessions() {
        this.m_sessions.clear();
    }
}

