/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.identity;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.CredentialsImpl;
import com.sanrad.nms.server.logic.identity.CredentialsValidator;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.identity.SRPCredentials;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrString;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class SRPCredentialsImpl
extends CredentialsImpl
implements SRPCredentials {
    private static List parameterCodeList;

    public SRPCredentialsImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
        super(cluster, classId, parameterCodeList);
    }

    protected void initUserNameParameterCode() {
        this.userNameParameterCode = ParameterCode.SRP_CREDENTIALS_USER_NAME;
    }

    public String getPassword() throws RemoteException {
        return (String)this.getValueOf(null, ParameterCode.SRP_CREDENTIALS_PASSWORD, true);
    }

    public String getPassword(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.SRP_CREDENTIALS_PASSWORD, vSwitch == null);
    }

    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        ((IdentityImpl)this.getIdentityParent()).createSRPCredentials(this.getUserName(), this.getPassword(), this.cluster.getOtherVSwitches(this.getVSwitches()));
        return 2;
    }

    protected void synchronizeMe(HashMap parameterList) throws RemoteException, IllegalValueException {
        String userName = this.getUserName();
        Object userNameParam = parameterList.get(ClientParameterCode.SRP_CREDENTIALS_USER_NAME);
        if (userNameParam != null) {
            userName = (String)((SrString)userNameParam).value();
        }
        String password = null;
        Object passwordParam = parameterList.get(ClientParameterCode.SRP_CREDENTIALS_PASSWORD);
        if (passwordParam != null) {
            password = (String)((SrString)passwordParam).value();
        }
        ((IdentityImpl)this.getIdentityParent()).createSRPCredentials(userName, password, this.cluster.getOtherVSwitches(this.getVSwitches()));
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        String result = super.isValid(parameterList);
        if (result == null) {
            String userName = (String)parameterList.get(ClientParameterCode.SRP_CREDENTIALS_USER_NAME);
            String password = (String)parameterList.get(ClientParameterCode.SRP_CREDENTIALS_PASSWORD);
            Identity chapCredParentIdentity = this.getIdentityParent();
            CredentialsValidator srpCredValidator = new CredentialsValidator(chapCredParentIdentity, ClassID.CHAP_CREDENTIALS, userName, password, false);
            if (userName != null) {
                result = srpCredValidator.isUserNameValid(userName);
                if (result != null) {
                    return result;
                }
                parameterList.put(ClientParameterCode.SRP_CREDENTIALS_USER_NAME, new SrString(userName));
            }
            if (password != null) {
                result = srpCredValidator.isPasswordValid(password);
                if (result != null) {
                    return result;
                }
                parameterList.put(ClientParameterCode.SRP_CREDENTIALS_PASSWORD, new SrString(password));
            }
        }
        return result;
    }

    public String toString() {
        try {
            return "SRP-" + this.getUserName();
        }
        catch (RemoteException re) {
            logger.error(re);
            return "credentials coud not be found";
        }
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.SRP_CREDENTIALS_USER_NAME);
        parameterCodes.addElement(ParameterCode.SRP_CREDENTIALS_PASSWORD);
        parameterCodes.addElement(ParameterCode.CREDENTIALS_PARENT);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

