/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.identity;

import com.sanrad.nms.server.logic.AliasObjectValidator;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import java.rmi.RemoteException;

public class IdentityValidator
extends AliasObjectValidator {
    private Cluster cluster;
    private String description;

    public IdentityValidator(Cluster cluster, String alias, String description) {
        super(alias);
        this.cluster = cluster;
        this.description = description;
    }

    public boolean isValid() throws RemoteException {
        if (!super.isValid()) {
            return false;
        }
        if (((ClusterImpl)this.cluster).getIdentitiesList().isAliasExist(this.alias)) {
            this.setErrorMsg(ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(this.alias));
            return false;
        }
        if (this.alias == null || this.alias.equals("")) {
            this.setErrorMsg("Illegal Alias");
            return false;
        }
        return true;
    }
}

