/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.identity;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.identity.IdentityName;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class IdentityNameImpl
extends SynchronizeableImpl
implements IdentityName {
    private static List parameterCodeList;
    private Identity identityParent;
    private String name;

    public IdentityNameImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
        super(cluster, classId, parameterCodeList);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        this.identityParent = this.getIdentityParent(null);
        this.name = this.getName(null);
        return changedValues;
    }

    public String getName() throws RemoteException {
        return this.name;
    }

    public String getName(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.IDENTITY_NAME_VALUE, vSwitch == null);
    }

    public Identity getIdentityParent() throws RemoteException {
        return this.identityParent;
    }

    public Identity getIdentityParent(VSwitch vSwitch) throws RemoteException {
        CommKeyClassId identCommKeyClassId = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.IDENTITY_NAME_PARENT, vSwitch == null);
        Identity identity = (Identity)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(identCommKeyClassId);
        return identity;
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        logger.debug("Checking synchronizing for " + this.getClassId() + " " + this.toString());
        this.setSynchronizePending(true);
        if (!this.isRedundant()) {
            logger.debug("Begin synchronizing for " + this.getClassId() + " " + this.toString());
            this.synchronizeMe();
        }
        return 2;
    }

    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (!this.isInSynchronizingMode()) {
            ((IdentityImpl)this.getIdentityParent()).synchronizeIdentityName(this.getName(), this.cluster.getOtherVSwitches(this.getVSwitches()));
            this.setSynchronizingMode(true);
        }
        return 2;
    }

    public synchronized void syncDataWasChanged() throws RemoteException, IllegalValueException {
        if (!this.isNeedToSynchronize()) {
            this.doneSynchronizing();
        }
        IdentityImpl identityParent = (IdentityImpl)this.getIdentityParent();
        identityParent.syncDataWasChanged();
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        return null;
    }

    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    public String toString() {
        return this.name;
    }

    public String getAlias() throws RemoteException {
        return "";
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        return "";
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.IDENTITY_NAME_VALUE);
        parameterCodes.addElement(ParameterCode.IDENTITY_NAME_PARENT);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

