/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.identity;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.identity.IdentityAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.acl.AclImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.CHAPCredentials;
import com.sanrad.nms.server.logic.identity.Credentials;
import com.sanrad.nms.server.logic.identity.CredentialsImpl;
import com.sanrad.nms.server.logic.identity.CredentialsValidator;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.identity.IdentityName;
import com.sanrad.nms.server.logic.identity.IdentityNameImpl;
import com.sanrad.nms.server.logic.identity.IdentityNameValidator;
import com.sanrad.nms.server.logic.srv.radius.RadiusServer;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.IdentityPurposeConstant;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class IdentityImpl
extends SynchronizeableImpl
implements Identity {
    public static final String DEF_ALL_IDENTITY_ALIAS_PREFIX = "DEF_ALL";
    public static final String INITIATOR_IDENTITY_ALIAS_PREFIX = "SELF";
    public static final String REMOTE_TARGET_IDENTITY_ALIAS_PREFIX = "REMOTE_TARGET";
    public static final String DR_REMOTE_INITIATOR_IDENTITY_ALIAS_PREFIX = "RemoteInitiator";
    public static final String DR_IDENTITY_ALL_ALIAS = "DR_IDENTITY_ALL";
    private Vector identityNames = new Vector();
    private Vector credentials = new Vector();
    private static List parameterCodeList;
    private String alias;

    public IdentityImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
        super(cluster, classId, parameterCodeList);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        this.alias = this.getAlias(null);
        return changedValues;
    }

    public String getAlias() throws RemoteException {
        return this.alias;
    }

    public String toString() {
        try {
            return this.getAlias();
        }
        catch (RemoteException re) {
            logger.error(re);
            return "";
        }
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.IDENTITY_ALIAS, vSwitch == null);
    }

    public String getDescription() throws RemoteException {
        return this.getDescription(null);
    }

    public String getDescription(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.IDENTITY_DESCRIPTION, vSwitch == null);
    }

    public IdentityPurposeConstant getPurpose() throws RemoteException {
        return this.getPurpose(null);
    }

    public IdentityPurposeConstant getPurpose(VSwitch vSwitch) throws RemoteException {
        IdentityPurposeConstant purpose = (IdentityPurposeConstant)this.getSrValueOf(vSwitch, ParameterCode.IDENTITY_PURPOSE, vSwitch == null);
        if (purpose == null) {
            purpose = IdentityPurposeConstant.UNKNOWN;
        }
        return purpose;
    }

    public boolean isDefAll() throws RemoteException {
        return this.getAlias().equals(DEF_ALL_IDENTITY_ALIAS_PREFIX);
    }

    public boolean isPurposeUnknown() throws RemoteException {
        return this.getPurpose().equals(IdentityPurposeConstant.UNKNOWN);
    }

    public boolean isOfLocalInitiator() throws RemoteException {
        return this.getPurpose().equals(IdentityPurposeConstant.LOCAL_INITIATOR);
    }

    public boolean isOfLocalTarget() throws RemoteException {
        VSwitch[] connectedVswitches = this.getConnectedVSwitches();
        if (connectedVswitches.length == 1) {
            return this.isOfLocalTarget(connectedVswitches[0]);
        }
        VSwitch vswitch1 = connectedVswitches[0];
        VSwitch vswitch2 = connectedVswitches[1];
        return this.isOfLocalTarget(vswitch1) || this.isOfLocalTarget(vswitch2);
    }

    public boolean isOfLocalTarget(VSwitch vSwitch) throws RemoteException {
        return this.getPurpose(vSwitch).equals(IdentityPurposeConstant.LOCAL_TARGET);
    }

    public boolean isOfRemoteInitiator() throws RemoteException {
        return this.getPurpose().equals(IdentityPurposeConstant.REMOTE_INITIATOR);
    }

    public boolean isOfRemoteTarget() throws RemoteException {
        return this.getPurpose().equals(IdentityPurposeConstant.REMOTE_TARGET);
    }

    public boolean isOfRemoteInitiatorDR() throws RemoteException {
        return this.getPurpose().equals(IdentityPurposeConstant.REMOTE_INITIATOR_DR);
    }

    public boolean isDRIdentityAll() throws RemoteException {
        return this.getAlias().equals(DR_IDENTITY_ALL_ALIAS);
    }

    public Vector getIdentityNames() throws RemoteException {
        return this.identityNames;
    }

    private Vector getIdentityNamesStr() throws RemoteException {
        Vector<String> names = new Vector<String>(this.identityNames.size());
        for (int index = 0; index < this.identityNames.size(); ++index) {
            names.add(((IdentityNameImpl)this.identityNames.elementAt(index)).getName());
        }
        return names;
    }

    public void addName(IdentityName name) throws RemoteException {
        this.identityNames.addElement(name);
    }

    public void removeName(IdentityName name) throws RemoteException {
        if (!this.isOfLocalInitiator()) {
            this.identityNames.remove(name);
        }
    }

    public void removeAllCredentials() {
        for (int index = 0; index < this.credentials.size(); ++index) {
            CredentialsImpl credentialsImpl = (CredentialsImpl)this.credentials.get(index);
            credentialsImpl.deleteIdentityParent();
        }
        this.credentials.clear();
    }

    public void removeAllNames() {
        this.identityNames.clear();
    }

    public void addCredentials(Credentials cred) {
        this.credentials.addElement(cred);
    }

    public void removeCredentials(Credentials cred) {
        ((CredentialsImpl)cred).deleteIdentityParent();
        this.credentials.remove(cred);
    }

    public Object isNameExist(String name) throws RemoteException {
        Iterator iter = this.identityNames.iterator();
        while (iter.hasNext()) {
            IdentityName identityName = (IdentityName)iter.next();
            String value = identityName.getName();
            if (!value.equalsIgnoreCase(name)) continue;
            return identityName;
        }
        return null;
    }

    public IdentityName getIdentityName(String name) throws RemoteException {
        Iterator iter = this.identityNames.iterator();
        while (iter.hasNext()) {
            IdentityName identityName = (IdentityName)iter.next();
            String value = identityName.getName();
            if (!value.equalsIgnoreCase(name)) continue;
            return identityName;
        }
        return null;
    }

    public Object isCredentialsExist(ClassID classId, String userName) throws RemoteException {
        Iterator iter = this.credentials.iterator();
        while (iter.hasNext()) {
            String value;
            Credentials credentials = (Credentials)iter.next();
            if (!credentials.getClassId().equals(classId) || !(value = credentials.getUserName()).equalsIgnoreCase(userName)) continue;
            return credentials;
        }
        return null;
    }

    public Object isCredentialExist(ClassID classId, String userName) throws RemoteException {
        Iterator iter = this.credentials.iterator();
        while (iter.hasNext()) {
            Credentials credentials = (Credentials)iter.next();
            if (!credentials.getClassId().equals(classId)) continue;
            String user = credentials.getUserName();
            if (user == null) {
                user = "";
            }
            if (!userName.equalsIgnoreCase(user)) continue;
            return credentials;
        }
        return null;
    }

    public Vector getCredentials() throws RemoteException {
        return this.credentials;
    }

    public Vector getCredentials(ClassID classId) throws RemoteException {
        Vector<Credentials> returnCredentials = new Vector<Credentials>();
        Iterator iter = this.credentials.iterator();
        while (iter.hasNext()) {
            Credentials credentials = (Credentials)iter.next();
            if (!credentials.getClassId().equals(classId)) continue;
            returnCredentials.add(credentials);
        }
        return returnCredentials;
    }

    public Vector getCHAPCredentials() throws RemoteException {
        return this.getCredentials(ClassID.CHAP_CREDENTIALS);
    }

    public Vector getSRPCredentials() throws RemoteException {
        return this.getCredentials(ClassID.SRP_CREDENTIALS);
    }

    public void createIdentityName(String name) throws RemoteException, IllegalValueException {
        this.createIdentityName(name, new Vector<VSwitch>(Arrays.asList(this.getConnectedVSwitches())));
    }

    private void removeAlreadyKnownNames(ArrayList names) throws RemoteException {
        for (int index = 0; index < this.getIdentityNamesStr().size(); ++index) {
            String name = (String)this.getIdentityNamesStr().get(index);
            if (!names.contains(name)) continue;
            names.remove(name);
        }
    }

    public void createUnknownIdentityNames(ArrayList names, Vector vSwitches) throws RemoteException, IllegalValueException {
        this.removeAlreadyKnownNames(names);
        for (int index = 0; index < names.size(); ++index) {
            String name = (String)names.get(index);
            this.createIdentityName(name, vSwitches);
        }
    }

    public void createIdentityName(String name, Vector vSwitches) throws RemoteException, IllegalValueException {
        IdentityNameValidator identityNameValidator = new IdentityNameValidator(this, name);
        if (!identityNameValidator.isValid()) {
            throw new IllegalValueException(identityNameValidator.getErrorMsg());
        }
        this.synchronizeIdentityName(name, vSwitches);
    }

    public void synchronizeIdentityName(String name, Vector vSwitches) throws RemoteException {
        ConfigElementData element = new ConfigElementData(ClassID.IDENTITY_NAME);
        Parameter identName = new Parameter(ParameterCode.IDENTITY_NAME_VALUE, new SrString(name));
        element.addParameter(identName);
        CommKeyClassId identCommKeyClassId = new CommKeyClassId(this.getCommKeys(), this.getClassId());
        Parameter identOwner = new Parameter(ParameterCode.IDENTITY_NAME_PARENT, identCommKeyClassId);
        element.addParameter(identOwner);
        if (vSwitches == null) {
            vSwitches = this.getVSwitches();
        }
        this.cluster.createElement(element, ClassID.IDENTITY_NAME, name, vSwitches);
    }

    public void createSRPCredentials(String userName, String password) throws RemoteException, IllegalValueException {
        CredentialsValidator credentialsValidator = new CredentialsValidator(this, ClassID.SRP_CREDENTIALS, userName, password, false);
        if (!credentialsValidator.isValid()) {
            throw new IllegalValueException(credentialsValidator.getErrorMsg());
        }
        this.createSRPCredentials(userName, password, null);
    }

    public void createSRPCredentials(String userName, String password, Vector vSwitches) throws RemoteException, IllegalValueException {
        ConfigElementData element = new ConfigElementData(ClassID.SRP_CREDENTIALS);
        Parameter user = new Parameter(ParameterCode.SRP_CREDENTIALS_USER_NAME, new SrString(userName));
        element.addParameter(user);
        Parameter pswd = new Parameter(ParameterCode.SRP_CREDENTIALS_PASSWORD, new SrString(password));
        element.addParameter(pswd);
        CommKeyClassId identCommKeyClassId = new CommKeyClassId(this.getCommKeys(), this.getClassId());
        Parameter identOwner = new Parameter(ParameterCode.CREDENTIALS_PARENT, identCommKeyClassId);
        element.addParameter(identOwner);
        this.cluster.createElement(element, ClassID.SRP_CREDENTIALS, userName, vSwitches);
    }

    public void createCHAPCredentials(String userName, String password, boolean isRadiusEnabled) throws RemoteException, IllegalValueException {
        CredentialsValidator credentialsValidator = new CredentialsValidator(this, ClassID.CHAP_CREDENTIALS, userName, password, isRadiusEnabled);
        if (!credentialsValidator.isValid()) {
            throw new IllegalValueException(credentialsValidator.getErrorMsg());
        }
        this.createCHAPCredentials(userName, password, isRadiusEnabled, null);
    }

    public void createCHAPCredentials(String userName, String password, boolean isRadiusEnabled, Vector vSwitches) throws RemoteException, IllegalValueException {
        ConfigElementData element = new ConfigElementData(ClassID.CHAP_CREDENTIALS);
        if (userName != null && !userName.equals("")) {
            Parameter user = new Parameter(ParameterCode.CHAP_CREDENTIALS_USER_NAME, new SrString(userName));
            element.addParameter(user);
        }
        if (password != null && !password.equals("")) {
            Parameter pswd = new Parameter(ParameterCode.CHAP_CREDENTIALS_PASSWORD, new SrString(password));
            element.addParameter(pswd);
        }
        int radiusEn = 1;
        if (isRadiusEnabled) {
            radiusEn = 2;
            element.removeParameter(ParameterCode.CHAP_CREDENTIALS_PASSWORD);
        }
        Parameter radius = new Parameter(ParameterCode.CHAP_CREDENTIALS_RADIUS_ENABLED, new SrInteger(radiusEn));
        element.addParameter(radius);
        CommKeyClassId identCommKeyClassId = new CommKeyClassId(this.getCommKeys(), this.getClassId());
        Parameter identOwner = new Parameter(ParameterCode.CREDENTIALS_PARENT, identCommKeyClassId);
        element.addParameter(identOwner);
        this.cluster.createElement(element, ClassID.CHAP_CREDENTIALS, userName, vSwitches);
    }

    public HashMap checkConsistencyBetweenVSwitches() throws RemoteException {
        HashMap<ParameterCode, String[]> inconsistentValues = super.checkConsistencyBetweenVSwitches();
        if (inconsistentValues == null) {
            inconsistentValues = new HashMap<ParameterCode, String[]>();
        }
        Vector vswitches = this.getVSwitches();
        int vswitchesCount = vswitches.size();
        String[] userNames = new String[vswitchesCount];
        Enumeration e = this.credentials.elements();
        while (e.hasMoreElements()) {
            CredentialsImpl cred = (CredentialsImpl)e.nextElement();
            if (cred.isRedundant()) continue;
            for (int i = 0; i < vswitchesCount; ++i) {
                userNames[i] = cred.getUserName((VSwitch)vswitches.get(i));
            }
            inconsistentValues.put(cred.getUserNameParameterCode(), userNames);
        }
        String[] names = new String[vswitchesCount];
        Enumeration e2 = this.identityNames.elements();
        while (e2.hasMoreElements()) {
            IdentityNameImpl name = (IdentityNameImpl)e2.nextElement();
            if (name.isRedundant()) continue;
            for (int i = 0; i < vswitchesCount; ++i) {
                names[i] = name.getName((VSwitch)vswitches.get(i));
            }
            inconsistentValues.put(ParameterCode.IDENTITY_NAME_VALUE, names);
        }
        return inconsistentValues;
    }

    public boolean isNeedToSynchronize() throws RemoteException {
        if (this.isOfLocalInitiator() || this.isOfRemoteTarget()) {
            return false;
        }
        if (this.getDescription().equalsIgnoreCase("#forTarget#")) {
            return false;
        }
        boolean needSync = super.isNeedToSynchronize();
        boolean isNamesNeedSync = false;
        boolean isCredNeedSync = false;
        Enumeration e = this.identityNames.elements();
        while (e.hasMoreElements()) {
            IdentityName name = (IdentityName)e.nextElement();
            if (this.cluster.getVSwitches().size() <= name.getConnectedVSwitchCounter()) continue;
            isNamesNeedSync = true;
            break;
        }
        Enumeration enumeration = this.credentials.elements();
        while (enumeration.hasMoreElements()) {
            Credentials cred = (Credentials)enumeration.nextElement();
            if (cred instanceof CHAPCredentials && ((CHAPCredentials)cred).isRadiusEnabled()) {
                if (this.cluster.getVSwitches().size() <= cred.getConnectedVSwitchCounter()) continue;
                isCredNeedSync = true;
                break;
            }
            isCredNeedSync = false;
            break;
        }
        return needSync || isNamesNeedSync || isCredNeedSync;
    }

    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (!super.isRedundant()) {
            if (!(this.isOfLocalTarget() || this.isOfRemoteTarget() || this.isOfLocalInitiator() || this.isInSynchronizingMode())) {
                logger.debug("Synchronizing: creating Identity on other " + ClassID.VSWITCH + "es.");
                this.cluster.createIdentity(this.getAlias(), this.getDescription(), this.cluster.getOtherVSwitches(this.getVSwitches()), this.getPurpose());
                this.setSynchronizingMode(true);
                return 2;
            }
            return 0;
        }
        return this.synchronizeNamesAndCredentials();
    }

    private int synchronizeNamesAndCredentials() throws RemoteException, IllegalValueException {
        boolean syncWasSent = false;
        Enumeration e = this.identityNames.elements();
        while (e.hasMoreElements()) {
            IdentityNameImpl identityName = (IdentityNameImpl)e.nextElement();
            if (identityName.isRedundant()) continue;
            logger.debug("Synchronizing: creating Identity Name on other " + ClassID.VSWITCH + "es.");
            identityName.synchronize();
            syncWasSent = true;
        }
        e = this.credentials.elements();
        while (e.hasMoreElements()) {
            CredentialsImpl cred = (CredentialsImpl)e.nextElement();
            if (cred.isRedundant() || !(cred instanceof CHAPCredentials)) continue;
            boolean shouldSynchronize = true;
            if (cred instanceof CHAPCredentials) {
                Vector vSwitches = this.cluster.getOtherVSwitches(cred.getVSwitches());
                boolean isRadiusExist = this.cluster.getRadiusServersList().isServerExistOnVSwitches(vSwitches);
                boolean bl = shouldSynchronize = isRadiusExist && ((CHAPCredentials)((Object)cred)).isRadiusEnabled();
            }
            if (shouldSynchronize) {
                logger.debug("Synchronizing: creating Identity Credentials on other " + ClassID.VSWITCH + "es.");
                cred.synchronize();
                syncWasSent = true;
                continue;
            }
            LogMgr.getServerLog().info("Cannot Synchronize CHAP Credentials (Radius Server is missing or not enabled.");
        }
        return syncWasSent ? 2 : 0;
    }

    public void doneSynchronizing() throws RemoteException {
        try {
            this.synchronizeNamesAndCredentials();
            super.doneSynchronizing();
            if (!this.isNeedToSynchronize()) {
                this.setSynchronizingMode(false);
                Vector targets = this.getCluster().getStorage().getTargetList();
                int targetsListSize = targets.size();
                for (int i = 0; i < targetsListSize; ++i) {
                    ISCSITargetImpl currTarget = (ISCSITargetImpl)targets.get(i);
                    AclImpl currTargetACL = (AclImpl)currTarget.getAclForTarget();
                    if (!currTargetACL.isNeedToSynchronize()) continue;
                    currTargetACL.synchronizeMe();
                }
            }
        }
        catch (IllegalValueException ive) {
            logger.warning("Could not synchronize Name/Credentials for identity - " + this.getAlias() + " " + ive.getMessage());
        }
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        String description;
        if (this.getAlias().equals(DEF_ALL_IDENTITY_ALIAS_PREFIX)) {
            return ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage();
        }
        String alias = (String)parameterList.get(ClientParameterCode.IDENTITY_ALIAS);
        if (alias != null) {
            String errorMsg = this.isAliasValid(alias);
            if (errorMsg != null) {
                return errorMsg;
            }
            if (this.cluster.getIdentitiesList().isAliasExist(alias)) {
                return ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(alias);
            }
            parameterList.put(ClientParameterCode.IDENTITY_ALIAS, new SrString(alias));
        }
        if ((description = (String)parameterList.get(ClientParameterCode.IDENTITY_DESCRIPTION)) != null) {
            parameterList.put(ClientParameterCode.IDENTITY_DESCRIPTION, new SrString(description));
        }
        return null;
    }

    public AlarmGenerator getAlarmGenerator() {
        return IdentityAlarmGenerator.getInstance();
    }

    public void registerToPropagatedStateChange() throws RemoteException {
        this.cluster.addPropagationStateDependentObjectAndListener(this);
    }

    protected String canBeDeleted() throws RemoteException {
        if (this.getAlias().equals(DEF_ALL_IDENTITY_ALIAS_PREFIX)) {
            return "You cannot delete the Identity 'DEF_ALL'";
        }
        return null;
    }

    public boolean isRedundant() throws RemoteException {
        if (this.getAlias().equals(DEF_ALL_IDENTITY_ALIAS_PREFIX)) {
            return true;
        }
        return super.isRedundant();
    }

    public boolean isRADIUSServerInUse(RadiusServer radSrv) throws RemoteException {
        Enumeration e = this.credentials.elements();
        while (e.hasMoreElements()) {
            Credentials credentials = (Credentials)e.nextElement();
            if (!(credentials instanceof CHAPCredentials) || !((CHAPCredentials)credentials).isRadiusEnabled()) continue;
            return true;
        }
        return false;
    }

    public boolean areNamesEqual(ArrayList names) throws RemoteException {
        if (names.size() != this.getIdentityNames().size()) {
            return false;
        }
        Vector identityNamesStr = this.getIdentityNamesStr();
        for (int index = 0; index < names.size(); ++index) {
            String name = (String)names.get(index);
            if (identityNamesStr.contains(name)) continue;
            return false;
        }
        return true;
    }

    public boolean atLeastOneNameIncluded(ArrayList names) throws RemoteException {
        Vector identityNamesStr = this.getIdentityNamesStr();
        for (int index = 0; index < names.size(); ++index) {
            String name = (String)names.get(index);
            if (!identityNamesStr.contains(name)) continue;
            return true;
        }
        return false;
    }

    public void deleteNames(ArrayList namesToDelete) throws RemoteException, IllegalValueException {
        for (int index = 0; index < namesToDelete.size(); ++index) {
            String name = (String)namesToDelete.get(index);
            IdentityName nameElement = this.getIdentityName(name);
            if (nameElement == null) continue;
            nameElement.deleteElement();
        }
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.IDENTITY_ALIAS);
        parameterCodes.addElement(ParameterCode.IDENTITY_DESCRIPTION);
        parameterCodes.addElement(ParameterCode.IDENTITY_PURPOSE);
        parameterCodes.addElement(ParameterCode.IDENTITY_DEVICE_ID);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

