/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.identity;

import com.sanrad.log.Log;
import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.srv.radius.RadiusServer;
import com.sanrad.nms.server.util.types.constants.IdentityPurposeConstant;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class IdentitiesList {
    private Hashtable list;
    public static final String TARGET_IDENTITY_DESCRIPTION = "#forTarget#";
    public static final String DEF_ALL_IDENTITY_ALIAS = "DEF_ALL";
    public static final String DR_DEF_ALL_IDENTITY_ALIAS = "DR_IDENTITY_ALL";
    private static Log logger = LogMgr.getServerLog();
    private HashMap m_pendingDrIdentityCreate = new HashMap();

    public IdentitiesList() {
        this.list = new Hashtable();
    }

    public void addIdentity(Identity identity) throws RemoteException {
        this.list.put(identity.getAlias(), identity);
    }

    public void addIdentity(Identity identity, String vswitchName) throws RemoteException {
        String key = this.createIdentityKey(identity.getAlias(), vswitchName);
        this.list.put(key, identity);
    }

    public Identity removeIdentity(Identity identity) throws RemoteException {
        boolean isLocalInitiatorIdentity = ((IdentityImpl)identity).isOfLocalInitiator();
        String identityKey = identity.getAlias();
        if (isLocalInitiatorIdentity) {
            Enumeration keys = this.list.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!this.list.get(key).equals(identity)) continue;
                identityKey = key;
            }
        }
        if (identity.getConnectedVSwitchCounter() < 2) {
            ((IdentityImpl)identity).removeAllCredentials();
            ((IdentityImpl)identity).removeAllNames();
            this.list.remove(identityKey);
        }
        return identity;
    }

    public void changeEntryKey(Identity identity) throws RemoteException {
        Enumeration keys = this.list.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!this.list.get(key).equals(identity)) continue;
            String alias = identity.getAlias();
            if (!alias.equalsIgnoreCase(key)) {
                this.list.remove(key);
                this.list.put(alias, identity);
            }
            return;
        }
    }

    public void changeEntryKey(Identity identity, String vswitchName) throws RemoteException {
        String newKey = this.createIdentityKey(identity.getAlias(), vswitchName);
        Enumeration keys = this.list.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!this.list.get(key).equals(identity)) continue;
            this.list.remove(key);
            this.list.put(newKey, identity);
            return;
        }
    }

    public void removeAll() {
        this.list.clear();
        this.clearAllPendingCreatingDrIdentities();
    }

    public Object getIdentityByAlias(String alias) {
        return this.list.get(alias);
    }

    public IdentityImpl getDRIdentityByRemoteInitiatorNames(ArrayList existedRemoteInitiatorNames) throws RemoteException {
        Enumeration keys = this.list.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            IdentityImpl identity = (IdentityImpl)this.list.get(key);
            if (!identity.isOfRemoteInitiatorDR() && (!identity.isPurposeUnknown() || !identity.getAlias().startsWith(IdentityPurposeConstant.REMOTE_INITIATOR_DR.getDescriptionName())) || !identity.atLeastOneNameIncluded(existedRemoteInitiatorNames)) continue;
            return identity;
        }
        return null;
    }

    public boolean isAliasExist(String alias) {
        return this.list.containsKey(alias);
    }

    public Vector getAllIdentities() throws RemoteException {
        Enumeration identityList = this.list.elements();
        Vector<Identity> identities = new Vector<Identity>();
        while (identityList.hasMoreElements()) {
            Identity identity = (Identity)identityList.nextElement();
            if (identity.getAlias().equals(TARGET_IDENTITY_DESCRIPTION)) continue;
            identities.addElement(identity);
        }
        return identities;
    }

    public boolean synchronize() throws RemoteException, IllegalValueException {
        StringBuffer errMsg = new StringBuffer();
        boolean errOccured = false;
        Enumeration e = this.list.elements();
        while (e.hasMoreElements()) {
            Identity identity = (Identity)e.nextElement();
            try {
                if (((IdentityImpl)identity).isOfLocalInitiator() || ((IdentityImpl)identity).isOfRemoteTarget() || ((IdentityImpl)identity).isOfLocalTarget()) continue;
                identity.synchronize();
            }
            catch (IllegalValueException ive) {
                errMsg.append("\n");
                errMsg.append(ive.getMessage());
                errOccured = true;
                logger.warning(ive.getMessage() + " when trying to synchronize " + identity.getClassId() + " " + identity);
            }
        }
        if (errOccured) {
            throw new IllegalValueException(errMsg.toString());
        }
        return false;
    }

    public Identity getIdentityUsingRADIUS(RadiusServer radSrv) throws RemoteException {
        Enumeration e = this.list.keys();
        while (e.hasMoreElements()) {
            IdentityImpl identity = (IdentityImpl)this.list.get(e.nextElement());
            if (!identity.isRADIUSServerInUse(radSrv)) continue;
            return identity;
        }
        return null;
    }

    private String createIdentityKey(String identityAlias, String vswitchName) {
        StringBuffer key = new StringBuffer();
        key.append(identityAlias);
        key.append(vswitchName);
        return key.toString();
    }

    public void removeDrIdentityPendingCreateForInitiatorNames(String identityAlias, String identityName) {
        ArrayList nameOfIdentityAlias = (ArrayList)this.m_pendingDrIdentityCreate.get(identityAlias);
        if (nameOfIdentityAlias != null && nameOfIdentityAlias.contains(identityName)) {
            Object ret;
            nameOfIdentityAlias.remove(identityName);
            if (nameOfIdentityAlias.size() == 0 && (ret = this.m_pendingDrIdentityCreate.remove(identityAlias)) == null) {
                logger.warning("Couldn't remove pending created dr identity: " + identityAlias);
            }
        }
    }

    public void addDrIdentityPendingCreateForInitiatorNames(String identityAlias, ArrayList existedRemoteInitiatorNames) {
        this.m_pendingDrIdentityCreate.put(identityAlias, existedRemoteInitiatorNames);
    }

    public boolean isDrIdentityOnPendingCreateForInitiatorNames(ArrayList existedRemoteInitiatorNames) {
        Set keys = this.m_pendingDrIdentityCreate.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String currentKey = (String)i.next();
            ArrayList identityNames = (ArrayList)this.m_pendingDrIdentityCreate.get(currentKey);
            if (!identityNames.containsAll(existedRemoteInitiatorNames)) continue;
            return true;
        }
        return false;
    }

    private void clearAllPendingCreatingDrIdentities() {
        this.m_pendingDrIdentityCreate.clear();
    }
}

