/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.identity;

import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.Synchronizeable;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.Credentials;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.util.SrConstantsBundleKeys;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;

public abstract class CredentialsImpl
extends SynchronizeableImpl
implements Credentials {
    public static final int MIN_USER_NAME_LENGTH = Integer.parseInt(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.CREDENTIALS_MIN_USER_NAME_LENGTH));
    public static final int MAX_USER_NAME_LENGTH = Integer.parseInt(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.CREDENTIALS_MAX_USER_NAME_LENGTH));
    public static final int MIN_PASSWORD_LENGTH = Integer.parseInt(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.CREDENTIALS_MIN_PASSWORD_LENGTH));
    public static final int MAX_PASSWORD_LENGTH = Integer.parseInt(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.CREDENTIALS_MAX_PASSWORD_LENGTH));
    private Identity identityParent;
    protected ParameterCode userNameParameterCode;
    protected String password;
    private Synchronizeable m_iscsiDevice;

    public CredentialsImpl(ClusterImpl cluster, ClassID classId, List parameterCodeList) throws RemoteException {
        super(cluster, classId, parameterCodeList);
        this.initUserNameParameterCode();
    }

    public void changeElement(HashMap parameterList) throws RemoteException, IllegalValueException {
        super.changeElement(parameterList);
        boolean isLocalInitiatorIdentity = this.identityParent.getAlias().startsWith("SELF");
        if (!this.isRedundant() && !isLocalInitiatorIdentity) {
            this.synchronizeMe(parameterList);
        }
    }

    protected abstract void initUserNameParameterCode();

    protected ParameterCode getUserNameParameterCode() {
        return this.userNameParameterCode;
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        this.identityParent = this.getIdentityParent(this.getFirstVSwitch());
        this.password = this.getPassword(null);
        return changedValues;
    }

    public abstract String getPassword(VSwitch var1) throws RemoteException;

    public String getUserName() throws RemoteException {
        return this.getUserName(null);
    }

    public String getUserName(VSwitch vSwitch) throws RemoteException {
        String userName = (String)this.getValueOf(vSwitch, this.userNameParameterCode, vSwitch == null);
        return userName == null ? "" : userName;
    }

    public Identity getIdentityParent() throws RemoteException {
        return this.identityParent;
    }

    public Identity getIdentityParent(VSwitch vSwitch) throws RemoteException {
        CommKeyClassId identCommKeyClassId = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.CREDENTIALS_PARENT, vSwitch == null);
        Identity identity = (Identity)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(identCommKeyClassId);
        return identity;
    }

    public abstract String getPassword() throws RemoteException;

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        logger.debug("Checking synchronizing for " + this.getClassId() + " " + this.toString());
        this.setSynchronizePending(true);
        if (!this.isRedundant()) {
            logger.debug("Begin synchronizing for " + this.getClassId() + " " + this.toString());
            return this.synchronizeMe();
        }
        return 0;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        return null;
    }

    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    public String getAlias() {
        throw new UnsupportedOperationException();
    }

    public String getAlias(VSwitch vSwitch) {
        throw new UnsupportedOperationException();
    }

    protected abstract void synchronizeMe(HashMap var1) throws RemoteException, IllegalValueException;

    public void setISCSIDevice(Synchronizeable device) {
        this.m_iscsiDevice = device;
    }

    public Synchronizeable getISCSIDevice() {
        return this.m_iscsiDevice;
    }

    public void deleteIdentityParent() {
        this.identityParent = null;
    }
}

