/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.identity;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.CHAPCredentials;
import com.sanrad.nms.server.logic.identity.CredentialsImpl;
import com.sanrad.nms.server.logic.identity.CredentialsValidator;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrString;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class CHAPCredentialsImpl
extends CredentialsImpl
implements CHAPCredentials {
    private static List parameterCodeList;
    public static final int RADIUS_DISABLED = 1;
    public static final int RADIUS_ENABLED = 2;

    public CHAPCredentialsImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
        super(cluster, classId, parameterCodeList);
    }

    protected void initUserNameParameterCode() {
        this.userNameParameterCode = ParameterCode.CHAP_CREDENTIALS_USER_NAME;
    }

    public String getPassword(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.CHAP_CREDENTIALS_PASSWORD, vSwitch == null);
    }

    public boolean isRadiusEnabled() throws RemoteException {
        int enabled = (Integer)this.getValueOf(null, ParameterCode.CHAP_CREDENTIALS_RADIUS_ENABLED, true);
        return enabled == 2;
    }

    public String getPassword() throws RemoteException {
        return this.password;
    }

    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (!this.isInSynchronizingMode()) {
            ((IdentityImpl)this.getIdentityParent()).createCHAPCredentials(this.getUserName(), this.getPassword(), this.isRadiusEnabled(), this.cluster.getOtherVSwitches(this.getVSwitches()));
            this.setSynchronizingMode(true);
        }
        return 2;
    }

    protected void synchronizeMe(HashMap parameterList) throws RemoteException, IllegalValueException {
        if (!this.isInSynchronizingMode()) {
            String userName = this.getUserName();
            Object userNameParam = parameterList.get(ClientParameterCode.CHAP_CREDENTIALS_USER_NAME);
            if (userNameParam != null) {
                userName = (String)((SrString)userNameParam).value();
            }
            String password = null;
            Object passwordParam = parameterList.get(ClientParameterCode.CHAP_CREDENTIALS_PASSWORD);
            if (passwordParam != null) {
                password = (String)((SrString)passwordParam).value();
            }
            Boolean isRadiusEnabled = new Boolean(this.isRadiusEnabled());
            Object radiusEnabledParam = parameterList.get(ClientParameterCode.CHAP_CREDENTIALS_RADIUS_ENABLED);
            if (radiusEnabledParam != null) {
                isRadiusEnabled = (Boolean)((SrBoolean)radiusEnabledParam).value();
            }
            ((IdentityImpl)this.getIdentityParent()).createCHAPCredentials(userName, password, isRadiusEnabled, this.cluster.getOtherVSwitches(this.getVSwitches()));
            this.setSynchronizingMode(true);
        }
    }

    public synchronized void syncDataWasChanged() throws RemoteException, IllegalValueException {
        if (!this.isNeedToSynchronize()) {
            this.doneSynchronizing();
        }
        IdentityImpl identityParent = (IdentityImpl)this.getIdentityParent();
        identityParent.syncDataWasChanged();
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        String result = super.isValid(parameterList);
        if (result == null) {
            Object radiusEnabled = parameterList.get(ClientParameterCode.CHAP_CREDENTIALS_RADIUS_ENABLED);
            if (radiusEnabled != null) {
                int value = (Boolean)radiusEnabled != false ? 2 : 1;
                parameterList.put(ClientParameterCode.CHAP_CREDENTIALS_RADIUS_ENABLED, new SrInteger(value));
            }
            String userName = (String)parameterList.get(ClientParameterCode.CHAP_CREDENTIALS_USER_NAME);
            String password = (String)parameterList.get(ClientParameterCode.CHAP_CREDENTIALS_PASSWORD);
            Identity chapCredParentIdentity = this.getIdentityParent();
            CredentialsValidator chapCredValidator = new CredentialsValidator(chapCredParentIdentity, ClassID.CHAP_CREDENTIALS, userName, password, false);
            if (userName != null) {
                result = chapCredValidator.isUserNameValid(userName);
                if (result != null) {
                    return result;
                }
                parameterList.put(ClientParameterCode.CHAP_CREDENTIALS_USER_NAME, new SrString(userName));
            }
            if (password != null) {
                result = chapCredValidator.isPasswordValid(password);
                if (result != null) {
                    return result;
                }
                parameterList.put(ClientParameterCode.CHAP_CREDENTIALS_PASSWORD, new SrString(password));
            }
        }
        return result;
    }

    public String toString() {
        try {
            return "CHAP " + this.getUserName();
        }
        catch (RemoteException re) {
            logger.debug(re);
            return "credentials coud not be found";
        }
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.CHAP_CREDENTIALS_USER_NAME);
        parameterCodes.addElement(ParameterCode.CHAP_CREDENTIALS_PASSWORD);
        parameterCodes.addElement(ParameterCode.CHAP_CREDENTIALS_RADIUS_ENABLED);
        parameterCodes.addElement(ParameterCode.CREDENTIALS_PARENT);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

