/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.hardware;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.vswitch.VSwitchAlarmGenerator;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.hardware.Hardware;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class HardwareImpl
extends TableRowImpl
implements Hardware {
    private static List parameterCodeList;
    private static final String STATUS_OK = "OK";
    private static final String STATUS_FAULTY = "FAULTY";
    private static final String STATUS_WARNING = "WARNING";

    public HardwareImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.HARDWARE, parameterCodeList);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(ClassID.HARDWARE.toString());
        try {
            sb.append(" of ");
            sb.append(ClassID.VSWITCH.toString());
            sb.append(" ");
            sb.append(this.getParentVSwitch().getName());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return sb.toString();
    }

    public AlarmGenerator getAlarmGenerator() {
        return VSwitchAlarmGenerator.getInstance();
    }

    protected String canBeDeleted() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The client cannot delete hardware element");
    }

    protected String isValid(HashMap parameterList) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The client cannot change hardware parameters");
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    public Integer getMaxNumOfPowerSuppliers() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.MAX_NUM_OF_POWER_SUPPLIERS);
    }

    public Integer getCurrentNumOfWorkingPowerSuppliers() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.CURR_NUM_OF_WORKING_POWER_SUPPLIERS);
    }

    public Integer getMaxNumOfFans() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.MAX_NUM_OF_FANS);
    }

    public Integer getCurrentNumOfWorkingFans() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.CURR_NUM_OF_WORKING_FANS);
    }

    public Integer getOnBoardTemp() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ON_BOARD_TEMP);
    }

    public Integer getCPUTemp() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.CPU_TEMP);
    }

    public Integer getOnBoardFactoryTempThresh() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ON_BOARD_FACTORY_TEMP_TRESH);
    }

    public Integer getCPUFactoryTempThresh() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.CPU_FACTORY_TEMP_TRESH);
    }

    public Integer getOnBoardWarningTempThresh() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ON_BOARD_WARNING_TEMP_TRESH);
    }

    public Integer getCPUWarningTempThresh() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.CPU_WARNING_TEMP_TRESH);
    }

    public String getOnBoardTempStatus() throws RemoteException {
        if (this.isOnBoardTempWarning()) {
            return STATUS_WARNING;
        }
        if (this.isOnBoardTempCritical()) {
            return STATUS_FAULTY;
        }
        return STATUS_OK;
    }

    public String getCPUTempStatus() throws RemoteException {
        if (this.isCPUTempWarning()) {
            return STATUS_WARNING;
        }
        if (this.isCPUTempCritical()) {
            return STATUS_FAULTY;
        }
        return STATUS_OK;
    }

    public boolean isFanFaulty() throws RemoteException {
        Integer currNumOfFans = this.getCurrentNumOfWorkingFans();
        if (currNumOfFans > 1) {
            Integer maxNumOfFans = this.getMaxNumOfFans();
            return maxNumOfFans - currNumOfFans > 0;
        }
        return false;
    }

    public boolean isFanCritical() throws RemoteException {
        Integer currNumOfFans = this.getCurrentNumOfWorkingFans();
        return currNumOfFans == 1;
    }

    public boolean isPowerSupplyFaulty() throws RemoteException {
        Integer maxNumOfPowerSuppliers = this.getMaxNumOfPowerSuppliers();
        Integer CurrNumOfPowerSuppliers = this.getCurrentNumOfWorkingPowerSuppliers();
        return maxNumOfPowerSuppliers - CurrNumOfPowerSuppliers > 0;
    }

    public boolean isCPUTempWarning() throws RemoteException {
        Integer cpuTemp = this.getCPUTemp();
        Integer cpuWarningTempTresh = this.getCPUWarningTempThresh();
        if (cpuTemp - cpuWarningTempTresh >= 0) {
            Integer cpuFactoryTempTresh = this.getCPUFactoryTempThresh();
            return cpuTemp - cpuFactoryTempTresh < 0;
        }
        return false;
    }

    public boolean isOnBoardTempWarning() throws RemoteException {
        Integer onBoardTemp = this.getOnBoardTemp();
        Integer onBoardWarningTempTresh = this.getOnBoardWarningTempThresh();
        if (onBoardTemp - onBoardWarningTempTresh >= 0) {
            Integer onBoardFactoryTempTresh = this.getOnBoardFactoryTempThresh();
            return onBoardTemp - onBoardFactoryTempTresh < 0;
        }
        return false;
    }

    public boolean isCPUTempCritical() throws RemoteException {
        Integer cpuTemp = this.getCPUTemp();
        Integer cpuFactoryTempTresh = this.getCPUFactoryTempThresh();
        return cpuTemp - cpuFactoryTempTresh >= 0;
    }

    public boolean isOnBoardTempCritical() throws RemoteException {
        Integer onBoardTemp = this.getOnBoardTemp();
        Integer onBoardFactoryTempTresh = this.getOnBoardFactoryTempThresh();
        return onBoardTemp - onBoardFactoryTempTresh >= 0;
    }

    public boolean isNoFan() throws RemoteException {
        Integer CurrNumOfFans = this.getCurrentNumOfWorkingFans();
        return CurrNumOfFans == 0;
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.ON_BOARD_WARNING_TEMP_TRESH);
        parameterCodes.addElement(ParameterCode.CPU_WARNING_TEMP_TRESH);
        parameterCodes.addElement(ParameterCode.ON_BOARD_FACTORY_TEMP_TRESH);
        parameterCodes.addElement(ParameterCode.CPU_FACTORY_TEMP_TRESH);
        parameterCodes.addElement(ParameterCode.CPU_TEMP);
        parameterCodes.addElement(ParameterCode.ON_BOARD_TEMP);
        parameterCodes.addElement(ParameterCode.CURR_NUM_OF_WORKING_FANS);
        parameterCodes.addElement(ParameterCode.MAX_NUM_OF_FANS);
        parameterCodes.addElement(ParameterCode.CURR_NUM_OF_WORKING_POWER_SUPPLIERS);
        parameterCodes.addElement(ParameterCode.MAX_NUM_OF_POWER_SUPPLIERS);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

