/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.dr;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.dr.DRAsyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRPairImpl;
import com.sanrad.nms.server.logic.dr.DRPrimaryVolumeImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.dr.DRSecondaryVolumeImpl;
import com.sanrad.nms.server.logic.dr.DRVolume;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.Parameters;
import com.sanrad.nms.server.util.types.constants.DRActivateConstant;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import java.rmi.RemoteException;
import java.util.HashMap;

public abstract class DRVolumeImpl
extends GeneralLogicObjectImpl
implements DRVolume {
    private VolumeNode m_localVolume = null;
    private VolumeNode m_remoteVolume = null;

    protected DRVolumeImpl(VolumeNode localVol, VolumeNode remoteVol) throws RemoteException {
        this.updateDRVolume(localVol, DRRoleConstant.LOCAL);
        this.updateDRVolume(remoteVol, DRRoleConstant.REMOTE);
    }

    protected DRVolumeImpl(VolumeNode vol, DRRoleConstant role) throws RemoteException {
        this.updateDRVolume(vol, role);
    }

    public void updateDRVolume(VolumeNode volume, DRRoleConstant role) {
        if (role.equals(DRRoleConstant.LOCAL)) {
            if (this.m_localVolume == null) {
                this.m_localVolume = volume;
            }
        } else if (role.equals(DRRoleConstant.REMOTE)) {
            if (this.m_remoteVolume == null) {
                this.m_remoteVolume = volume;
            }
        } else {
            logger.warning("attempt to set a DR volume with illegal role " + role);
        }
    }

    public void clearLocalVolume() {
        this.m_localVolume = null;
    }

    public void clearRemoteVolume() {
        this.m_remoteVolume = null;
    }

    public VolumeNode getLocalVolume() throws RemoteException {
        return this.m_localVolume;
    }

    public VolumeNode getRemoteVolume() throws RemoteException {
        return this.m_remoteVolume;
    }

    public boolean isEmpty() {
        return this.m_localVolume == null && this.m_remoteVolume == null;
    }

    public HashMap getClientParameterList() throws RemoteException {
        return null;
    }

    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public HashMap checkConsistencyBetweenVSwitches() throws RemoteException {
        return null;
    }

    public VSwitch[] getConnectedVSwitches() throws RemoteException {
        return null;
    }

    public CommKeyClassId getCommKeyClassId() throws RemoteException {
        return null;
    }

    public CommKey[] getCommKeys() throws RemoteException {
        return null;
    }

    public Cluster[] getAllClusters() throws RemoteException {
        return null;
    }

    public VSwitch getActiveVswitch() throws RemoteException {
        VSwitch[] vswitches = this.getConnectedVSwitches();
        if (vswitches.length == 1) {
            return vswitches[0];
        }
        String result = new String(this.getReleventVolume().getParentLU().getParentTarget().getExposedOnVSwitch());
        for (int i = 0; i < vswitches.length; ++i) {
            if (!vswitches[i].toString().equals(result)) continue;
            return vswitches[i];
        }
        return null;
    }

    public VSwitch getInactiveVSwitch() throws RemoteException {
        throw new UnsupportedOperationException("getInactiveVSwitch() not supported");
    }

    public Cluster getCluster() throws RemoteException {
        return null;
    }

    public boolean isInconsistentWithTheVSwitch() {
        return false;
    }

    public boolean isRedundant() {
        return false;
    }

    public void deleteElement() throws RemoteException, IllegalValueException {
        throw new UnsupportedOperationException("deleteElement unsupported for class " + this.getClass());
    }

    public void changeElement(ClientParameterCode code, Object value) throws RemoteException, IllegalValueException {
        throw new UnsupportedOperationException("changeElement unsupported for class " + this.getClass());
    }

    public void changeElement(HashMap parameterList) throws RemoteException, IllegalValueException {
        throw new UnsupportedOperationException("changeElement unsupported for class " + this.getClass());
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        return null;
    }

    public boolean isParameterCodeExsist(ParameterCode code) {
        return false;
    }

    public boolean isParameterEqual(Parameters param, VSwitch vswitch) {
        return false;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
        this.addPropagationStateDependentObjectAndListener((GeneralLogicObjectImpl)((Object)this.getReleventVolume()));
    }

    public boolean equals(Object obj) {
        if (obj instanceof DRVolumeImpl) {
            try {
                if (((DRVolumeImpl)obj).getLocalVolume() != null && ((DRVolumeImpl)obj).getLocalVolume().equals(this.getLocalVolume()) && ((DRVolumeImpl)obj).getRemoteVolume() != null && ((DRVolumeImpl)obj).getRemoteVolume().equals(this.getRemoteVolume())) {
                    return true;
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void validAndActivateForChildren(DRActivateConstant state) throws RemoteException, IllegalValueException {
    }

    public boolean validAndActivate(DRActivateConstant state, boolean isSnapshotNeeded) throws RemoteException, IllegalValueException {
        if (state.equals(DRActivateConstant.DISASTER_FAILOVER) || state.equals(DRActivateConstant.ABORT_REPLICATE)) {
            return true;
        }
        if (this.m_localVolume != null && this.m_remoteVolume != null) {
            VolumeNode nonFunc;
            if (this.m_localVolume.isProvisioned() || this.m_remoteVolume.isProvisioned()) {
                nonFunc = this.m_localVolume;
                if (this.m_remoteVolume.isProvisioned()) {
                    nonFunc = this.m_remoteVolume;
                }
                DRPairImpl pair = DRRootImpl.getInstance().getPairUseingVolume((VolumeNodeImpl)nonFunc);
                if (nonFunc.equals(this.getRemoteVolume()) && nonFunc.isExposed() && pair != null && ((DRAsyncPairImpl)pair).getVolumeLocalCopySize() != null) {
                    logger.info("Do not prevent start replicate on local copy");
                } else {
                    throw new IllegalValueException("Can't activate " + state + " command since the " + nonFunc + " is non functional ");
                }
            }
            if (((VolumeNodeImpl)this.m_localVolume).isInvolvedInActiveCopy(((VolumeNodeImpl)this.m_localVolume).getActiveVswitch()) || ((VolumeNodeImpl)this.m_remoteVolume).isInvolvedInActiveCopy(((VolumeNodeImpl)this.m_remoteVolume).getActiveVswitch())) {
                nonFunc = this.m_localVolume;
                if (this.m_remoteVolume.isNonFunctional()) {
                    nonFunc = this.m_remoteVolume;
                }
                throw new IllegalValueException("Can't activate " + state + " command since the " + nonFunc + " is in copy operation ");
            }
        } else {
            throw new IllegalValueException("one of the volumes is missing!!!");
        }
        if (isSnapshotNeeded) {
            this.checkExsistentOfSnapshot(state);
        }
        if (((VolumeNodeImpl)this.m_localVolume).isInvolvedInActiveCopy(this.m_localVolume.getActiveVswitch()) || ((VolumeNodeImpl)this.m_remoteVolume).isInvolvedInActiveCopy(this.m_remoteVolume.getActiveVswitch())) {
            throw new IllegalValueException("one of the volumes is synchronizing!!!");
        }
        return true;
    }

    private void checkExsistentOfSnapshot(DRActivateConstant state) throws RemoteException, IllegalValueException {
        VolumeNode volume = this.getVolumeAccordingToAction(state);
        if (volume == null) {
            return;
        }
        if (!volume.isSnapshotSource()) {
            throw new IllegalValueException("Can't activate " + state + " command since the " + volume + " doesn't have snapshot ");
        }
    }

    private VolumeNode getVolumeAccordingToAction(DRActivateConstant state) {
        if (state.equals(DRActivateConstant.FALLBACK) && this instanceof DRSecondaryVolumeImpl) {
            return this.m_remoteVolume;
        }
        if (state.equals(DRActivateConstant.PLANNED_FAILOVER) && this instanceof DRPrimaryVolumeImpl) {
            return this.m_localVolume;
        }
        return null;
    }

    public boolean isVolumeComplete() {
        return this.m_localVolume != null && this.m_remoteVolume != null;
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    protected abstract VolumeNode getReleventVolume() throws RemoteException;

    public boolean equalsForPendingAlarmsCheck(Object obj) throws RemoteException {
        return this.equals(obj);
    }

    public boolean equalsByCommKey(Object obj) {
        return false;
    }
}

