/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.dr;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.dr.DRSyncPairAlarmGenerator;
import com.sanrad.nms.server.alarm.dr.DrClusterSyncPairAlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObject;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterSyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRActivate;
import com.sanrad.nms.server.logic.dr.DRActivateImpl;
import com.sanrad.nms.server.logic.dr.DRPairImpl;
import com.sanrad.nms.server.logic.dr.DRSyncPair;
import com.sanrad.nms.server.logic.dr.InnerActivate;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.MasterParameter;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterList;
import com.sanrad.nms.server.util.types.constants.ChangeConstant;
import com.sanrad.nms.server.util.types.constants.DRActivateConstant;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import java.rmi.RemoteException;

public class DRSyncPairImpl
extends DRPairImpl
implements DRSyncPair,
DRActivate {
    private DRSyncPairActivateImpl m_activateSyncPair;

    public DRSyncPairImpl(DRClusterSyncPairImpl element) throws RemoteException {
        super(element);
        if (this.m_activateSyncPair == null) {
            this.m_activateSyncPair = new DRSyncPairActivateImpl(element);
        }
    }

    public void setElement(DRClusterLogicObjectImpl element, DRRoleConstant role) throws RemoteException {
        super.setElement(element, role);
        if (this.m_activateSyncPair == null) {
            this.m_activateSyncPair = new DRSyncPairActivateImpl(element);
        } else {
            this.m_activateSyncPair.setElement(element, role);
        }
    }

    public void removeElement(DRClusterLogicObjectImpl pair) {
        super.removeElement(pair);
        this.m_activateSyncPair.removeElement(pair);
    }

    public void plannedFailover() throws RemoteException, IllegalValueException {
        this.m_activateSyncPair.plannedFailover();
    }

    public void disasterOccured() throws RemoteException, IllegalValueException {
        this.m_activateSyncPair.disasterOccured();
    }

    public void fallback() throws RemoteException, IllegalValueException {
        this.m_activateSyncPair.fallback();
    }

    public AlarmGenerator getAlarmGenerator() {
        return DRSyncPairAlarmGenerator.getInstance();
    }

    public void startReplicate() throws RemoteException, IllegalValueException {
        this.m_activateSyncPair.startReplicate();
    }

    public void abortReplicate() throws RemoteException, IllegalValueException {
        this.m_activateSyncPair.abortReplicate();
    }

    protected ParameterCode getActivateParameterCode() throws RemoteException, IllegalValueException {
        return this.m_activateSyncPair.getLocalElement().getActivateParameterCode();
    }

    protected void validAndActivateForPairs(ParameterList params) throws RemoteException, IllegalValueException {
    }

    public AlarmGenerator getClusterAlarmGenerator() {
        return DrClusterSyncPairAlarmGenerator.getInstance();
    }

    public void recover(CommKeyClassId volume) throws RemoteException, IllegalValueException {
        ConfigElementData ced = new ConfigElementData(ClassID.SYNC_PAIR);
        DRRoleConstant role = this.getRoleOfElementToBeRecovered();
        ced.setValue(ParameterCode.DR_SYNC_PAIR_ROLE, role);
        super.recover(ced, volume);
    }

    public void abortInitialSync() throws RemoteException, IllegalValueException {
        this.validAndActivate(DRActivateConstant.SUSPEND_INIT_SYNC);
        ((LogicObjectImpl)((Object)this.getClusterElementAccordingToMode())).changeElementForActiveVswitch(new MasterParameter(MasterParameterCode.DR_ACTIVATE.getParameterCode(this), DRActivateConstant.SUSPEND_INIT_SYNC));
    }

    public void startInitialSync() throws RemoteException, IllegalValueException {
        this.validAndActivate(DRActivateConstant.RESUME_INIT_SYNC);
        MasterParameter parameter = new MasterParameter(MasterParameterCode.DR_ACTIVATE.getParameterCode(this), DRActivateConstant.RESUME_INIT_SYNC);
        ((LogicObjectImpl)((Object)this.getClusterElementAccordingToMode())).changeElementForActiveVswitch(parameter);
    }

    protected boolean isSnapshotNeeded(DRActivateConstant state) throws RemoteException {
        return false;
    }

    protected class DRSyncPairActivateImpl
    extends DRActivateImpl
    implements InnerActivate {
        protected DRSyncPairActivateImpl(DRClusterLogicObject element) throws RemoteException {
            super((DRClusterLogicObjectImpl)element);
        }

        public void abortInitialSync() throws RemoteException, IllegalValueException {
        }

        public void startInitialSync() throws RemoteException, IllegalValueException {
        }

        protected void validAndActivateForPairs(ParameterList params) throws RemoteException, IllegalValueException {
        }

        public AlarmGenerator getAlarmGenerator() {
            return null;
        }

        public AlarmGenerator getClusterAlarmGenerator() {
            return DrClusterSyncPairAlarmGenerator.getInstance();
        }

        public void registerToPropagatedStateChange() throws RemoteException {
        }

        public void validAndActivateForChildren(ChangeConstant state) throws RemoteException, IllegalValueException {
        }

        public DRSyncPair returnSource() throws RemoteException {
            return DRSyncPairImpl.this;
        }

        protected void checkThatChildAndFatherAreMached() throws RemoteException, IllegalValueException {
            if (!((DRClusterPairImpl)this.getActiveElement()).getExposedVolume().getActiveVswitch().equals(this.getActiveVswitch())) {
                throw new IllegalValueException("Pair is not synchronized in the cluster, please perform cluster synchronization.");
            }
        }
    }
}

