/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.dr;

import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.DrAlarmMgrImpl;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.EventServiceImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SiteImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.VSwitchGroupImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAbstractConsistencyGroup;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterConsistencyGroupImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterExtendedPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterManager;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterSyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRAbstractConsistencyGroup;
import com.sanrad.nms.server.logic.dr.DRAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.dr.DRAsyncPair;
import com.sanrad.nms.server.logic.dr.DRAsyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRBlockingEvent;
import com.sanrad.nms.server.logic.dr.DRConsistencyGroup;
import com.sanrad.nms.server.logic.dr.DRConsistencyGroupImpl;
import com.sanrad.nms.server.logic.dr.DREvent;
import com.sanrad.nms.server.logic.dr.DRExtendedPair;
import com.sanrad.nms.server.logic.dr.DRExtendedPairImpl;
import com.sanrad.nms.server.logic.dr.DRLogicObject;
import com.sanrad.nms.server.logic.dr.DRLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRPair;
import com.sanrad.nms.server.logic.dr.DRPairImpl;
import com.sanrad.nms.server.logic.dr.DRPiT;
import com.sanrad.nms.server.logic.dr.DRPiTContainer;
import com.sanrad.nms.server.logic.dr.DRPiTImpl;
import com.sanrad.nms.server.logic.dr.DRPrimaryVolume;
import com.sanrad.nms.server.logic.dr.DRRoot;
import com.sanrad.nms.server.logic.dr.DRSecondaryVolume;
import com.sanrad.nms.server.logic.dr.DRSyncPair;
import com.sanrad.nms.server.logic.dr.DRSyncPairImpl;
import com.sanrad.nms.server.logic.lu.LU;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceImpl;
import com.sanrad.nms.server.logic.policies.PoliciesManager;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.volume.JournalVolume;
import com.sanrad.nms.server.logic.volume.JournalVolumeImpl;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.VolumeTreeImpl;
import com.sanrad.nms.server.logic.vswitch.PortalTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrLunFormat;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import com.sanrad.nms.server.util.types.constants.PolicyTypeConstant;
import com.sanrad.nms.server.util.types.constants.SDTakeOverStateConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.util.Queue;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class DRRootImpl
extends RemoteObjectImpl
implements DRRoot {
    private static DRRootImpl m_theInstance = null;
    private Object lock = new Object();
    private Thread m_queueConsumerThread = null;
    private Queue m_eventQueue = new Queue();
    private DRArrayList m_syncPairs = new DRArrayList();
    private DRArrayList m_consistencyGroups = new DRArrayList();
    private DRArrayList m_extendedPairs = new DRArrayList();
    private HashMap m_stubToRefMap = new HashMap();
    private int m_isDRDiscoveryCompletedCounter = 0;
    private boolean m_isDRDiscoveryCompleted = false;
    private HashSet m_clustersDiscoveredInDR = new HashSet();
    private Object m_replacingVolumeLock = new Object();

    private DRRootImpl() throws RemoteException {
        this.startQueueConsumerThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStubToRefMapping(String hashKey, DRLogicObjectImpl object) {
        HashMap hashMap = this.m_stubToRefMap;
        synchronized (hashMap) {
            this.m_stubToRefMap.put(hashKey, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStubToRefMapping(String hashKey) {
        HashMap hashMap = this.m_stubToRefMap;
        synchronized (hashMap) {
            this.m_stubToRefMap.remove(hashKey);
        }
    }

    public synchronized DRPairImpl getPairUseingVolume(VolumeNodeImpl vol) throws RemoteException {
        if (vol.getClassId().equals(ClassID.SNAPSHOT_VOLUME)) {
            return this.getPairUseingVolume((SnapshotVolumeImpl)vol);
        }
        ArrayList pairs = this.getAllPairs();
        for (int i = 0; i < pairs.size(); ++i) {
            DRPairImpl pair = (DRPairImpl)pairs.get(i);
            if ((pair.getLocalElement() == null || !vol.equals(((DRClusterPairImpl)pair.getLocalElement()).getPrimaryVolume()) && !vol.equals(((DRClusterPairImpl)pair.getLocalElement()).getSecondaryVolume())) && (pair.getRemoteElement() == null || !vol.equals(((DRClusterPairImpl)pair.getRemoteElement()).getPrimaryVolume()) && !vol.equals(((DRClusterPairImpl)pair.getRemoteElement()).getSecondaryVolume()))) continue;
            return pair;
        }
        return null;
    }

    public DRPairImpl getPairUseingVolume(SnapshotVolumeImpl sn) throws RemoteException {
        VolumeNodeImpl vol = (VolumeNodeImpl)sn.getSourceVolume();
        DRPairImpl pair = this.getPairUseingVolume(vol);
        if (pair != null && pair instanceof DRAsyncPairImpl) {
            DRAsyncPairImpl asyncPair = (DRAsyncPairImpl)pair;
            if (sn.equals(asyncPair.getLocalSnapshot()) || sn.equals(asyncPair.getRemoteSnapshot())) {
                return pair;
            }
            return null;
        }
        return null;
    }

    public DRPairImpl getPairUsingLocalCopy(VolumeNodeImpl vol) throws RemoteException {
        ArrayList pairs = this.getAsyncPairList();
        for (int i = 0; i < pairs.size(); ++i) {
            if (!vol.equals(((DRAsyncPairImpl)pairs.get(i)).findLocalCopyToPair())) continue;
            return (DRPairImpl)pairs.get(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRLogicObjectImpl getRefByStub(String hashKey) {
        HashMap hashMap = this.m_stubToRefMap;
        synchronized (hashMap) {
            return (DRLogicObjectImpl)this.m_stubToRefMap.get(hashKey);
        }
    }

    private void clearClusterFromElements(ArrayList list, ClusterImpl cluster, boolean fireEvent) throws RemoteException {
        if (list != null && cluster != null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                DRLogicObjectImpl currObject = (DRLogicObjectImpl)i.next();
                DRClusterLogicObjectImpl clusterObject = currObject.getClusterElement(cluster);
                if (clusterObject == null) continue;
                this.removeElement(clusterObject);
            }
        } else if (cluster == null) {
            logger.warning("attempt to clear " + list + " list from " + cluster + " cluster elements");
        }
    }

    private void clearClusterFromConsistencyGroup(DRAbstractConsistencyGroupImpl cg, ClusterImpl cluster, boolean fireEvent) throws RemoteException {
        DRClusterAbstractConsistencyGroupImpl clusterGroup = (DRClusterAbstractConsistencyGroupImpl)cg.getClusterElement(cluster);
        if (clusterGroup != null) {
            if (!cg.isPartial()) {
                cg.removeElement(clusterGroup);
            }
            if (cg.getPairsCount() > 0) {
                DRAsyncPair[] pairs = cg.getPairs();
                int i = pairs.length;
                while (i-- > 0) {
                    DRClusterAsyncPairImpl clusterPair = (DRClusterAsyncPairImpl)((DRAsyncPairImpl)pairs[i]).getClusterElement(cluster);
                    if (clusterPair == null) continue;
                    this.removeElement(clusterPair);
                }
            }
            if (!cg.isPartial()) {
                cg.setElement(clusterGroup);
            }
            this.removeElement(clusterGroup);
        }
    }

    private void clearCluster(ClusterImpl cluster, boolean fireEvent) throws RemoteException {
        ArrayList drObjectList = new ArrayList(this.m_consistencyGroups);
        int i = drObjectList.size();
        while (i-- > 0) {
            this.clearClusterFromConsistencyGroup((DRConsistencyGroupImpl)drObjectList.get(i), cluster, fireEvent);
        }
        drObjectList = new ArrayList(this.m_extendedPairs);
        i = drObjectList.size();
        while (i-- > 0) {
            this.clearClusterFromConsistencyGroup((DRExtendedPairImpl)drObjectList.get(i), cluster, fireEvent);
        }
        drObjectList = new ArrayList(this.m_syncPairs);
        this.clearClusterFromElements(drObjectList, cluster, fireEvent);
    }

    private void readCluster(ClusterImpl cluster) throws RemoteException {
        DRClusterManager drClusterManager = cluster.getDRManager();
        DRClusterAbstractConsistencyGroup[] consistencyGroups = drClusterManager.getConsistencyGroups();
        DRClusterAbstractConsistencyGroup[] extendedPairs = drClusterManager.getExtendedPairs();
        DRClusterPair[] syncPairs = drClusterManager.getSyncPairs();
        this.readGroups(consistencyGroups);
        this.readGroups(extendedPairs);
        this.readPairs(syncPairs);
    }

    private void checkAlarms() throws RemoteException {
        if (this.isDiscoverCompleted()) {
            ArrayList list = this.getDRObjects();
            for (int i = 0; i < list.size(); ++i) {
                this.checkAlarms((DRLogicObjectImpl)list.get(i), 1);
            }
        }
    }

    private void readGroups(DRClusterAbstractConsistencyGroup[] groups) throws RemoteException {
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                this.newElement((DRClusterAbstractConsistencyGroupImpl)groups[i]);
                DRClusterPair[] pairs = ((DRClusterAbstractConsistencyGroupImpl)groups[i]).getPairs();
                this.readPairs(pairs);
            }
        }
    }

    private void readPairs(DRClusterPair[] pairs) throws RemoteException {
        try {
            if (pairs != null) {
                for (int i = 0; i < pairs.length; ++i) {
                    this.newElement((DRClusterPairImpl)pairs[i]);
                }
            }
        }
        catch (IllegalStateException ise) {
            logger.error(ise);
        }
    }

    private void addToQueue(Object queueElement) {
        this.m_eventQueue.addElement(queueElement);
    }

    private void newElement(LogicObjectImpl element) throws RemoteException {
        try {
            ClassID classId = element.getClassId();
            Object drObject = null;
            if (classId.isDRGroup()) {
                this.newConsistencyGroup((DRClusterAbstractConsistencyGroupImpl)element);
            } else if (classId.equals(ClassID.ASYNC_PAIR)) {
                this.newAsyncPair((DRClusterAsyncPairImpl)element);
            } else if (classId.equals(ClassID.SYNC_PAIR)) {
                this.newSyncPair((DRClusterSyncPairImpl)element);
            } else if (classId.equals(ClassID.DR_ASYNC_PAIR_PIT) || classId.equals(ClassID.DR_CONSISTENCY_GROUP_PIT)) {
                this.newDRPiT((DRPiTImpl)element);
            }
        }
        catch (IllegalValueException ive) {
            logger.error(ive);
        }
        catch (IllegalStateException ise) {
            logger.error(ise);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void changeElement(DREvent drEvent) throws RemoteException, IllegalValueException {
        HashMap changedElements = drEvent.getParameterList();
        LogicObject element = drEvent.getElement();
        if (changedElements == null || changedElements.isEmpty()) return;
        if (element instanceof DRClusterLogicObjectImpl) {
            DRClusterLogicObjectImpl clusterDRObject = (DRClusterLogicObjectImpl)element;
            DRLogicObjectImpl matchingDRObject = this.findDRObjectWithIdenticalElement(clusterDRObject);
            if (matchingDRObject == null) return;
            this.drElementChanged(matchingDRObject, clusterDRObject, changedElements);
            boolean isActivateChanged = changedElements.containsKey(MasterParameterCode.DR_ACTIVATE.getParameterCode(matchingDRObject));
            if (DRRoleConstant.REMOTE.equals(clusterDRObject.getRole()) && !isActivateChanged) return;
        }
        ElementEventImpl elementEvent = new ElementEventImpl(this, element);
        elementEvent.setParameterList(drEvent.getParameterList());
        EventServiceImpl.getInstance().fireElementChanged(elementEvent);
    }

    private void checkAlarms(DRLogicObjectImpl element, VSwitch vswitch, int eventType) throws RemoteException {
        if (!this.isDiscoverCompleted()) {
            return;
        }
        if (3 == eventType) {
            element.setDeletionProcessCompleted();
        }
        if (!element.isInDeletionProcess() || 3 == eventType) {
            DrAlarmMgrImpl.getInstance().generateAlarms(eventType, element, vswitch);
        }
    }

    private void checkAlarms(DRLogicObjectImpl element, int eventType) throws RemoteException {
        VSwitch[] vswitches = element.getConnectedVSwitches();
        for (int i = 0; i < vswitches.length; ++i) {
            this.checkAlarms(element, vswitches[i], eventType);
        }
    }

    private void removeElement(LogicObjectImpl element) throws RemoteException {
        try {
            ClassID classId = element.getClassId();
            if (element instanceof DRClusterLogicObjectImpl) {
                if (this.findDRObjectWithIdenticalElement((DRClusterLogicObjectImpl)element) == null) {
                    return;
                }
                VSwitch[] vSwitches = element.getConnectedVSwitches();
                int i = vSwitches.length;
                while (i-- > 0) {
                    this.checkAlarms(this.findDRObjectWithIdenticalElement((DRClusterLogicObjectImpl)element), vSwitches[i], 3);
                }
            }
            if (classId.isDRGroup()) {
                this.removeDRClusterConsistencyGroup((DRClusterAbstractConsistencyGroupImpl)element);
            } else if (classId.equals(ClassID.ASYNC_PAIR)) {
                this.removeDRClusterAsyncPair((DRClusterAsyncPairImpl)element, false);
            } else if (classId.equals(ClassID.SYNC_PAIR)) {
                this.removeDRClusterSyncPair((DRClusterSyncPairImpl)element);
            } else if (classId.equals(ClassID.VSWITCH)) {
                VSwitch vswitch = (VSwitch)((Object)element);
                this.removeInitiatorNameFromTargetsACL(vswitch);
            } else if (classId.equals(ClassID.CLUSTER)) {
                this.clearCluster((ClusterImpl)element, true);
                this.m_clustersDiscoveredInDR.remove(element);
            } else if (classId.equals(ClassID.SITE)) {
                SiteImpl site = (SiteImpl)element;
                ArrayList clusters = site.getClusters();
                int i = clusters.size();
                while (i-- > 0) {
                    this.clearCluster((ClusterImpl)clusters.get(i), true);
                    this.m_clustersDiscoveredInDR.remove(clusters.get(i));
                }
            } else if (classId.equals(ClassID.DR_ASYNC_PAIR_PIT) || classId.equals(ClassID.DR_CONSISTENCY_GROUP_PIT)) {
                this.removeDRPiT((DRPiTImpl)element);
            }
        }
        catch (IllegalValueException ive) {
            logger.error(ive);
        }
        catch (IllegalStateException ise) {
            logger.error(ise);
        }
    }

    public ArrayList getVSwitches() throws RemoteException {
        ArrayList<VSwitch> vSwitches = new ArrayList<VSwitch>();
        Cluster[] clusters = SystemRootImpl.getInstance().getAllClusters();
        if (clusters != null) {
            for (int i = 0; i < clusters.length; ++i) {
                ClusterImpl currCluster = (ClusterImpl)clusters[i];
                if (!currCluster.isDRInvolved()) continue;
                VSwitch[] currVSwitches = currCluster.getConnectedVSwitches();
                for (int j = 0; j < currVSwitches.length; ++j) {
                    if (vSwitches.contains(currVSwitches[j])) continue;
                    vSwitches.add(currVSwitches[j]);
                }
            }
        }
        return vSwitches;
    }

    private void startQueueConsumerThread() {
        this.m_queueConsumerThread = new Thread("DRRoot Queue/Consumer Thread - " + this.getClass()){

            public void run() {
                Thread thisThread = Thread.currentThread();
                while (DRRootImpl.this.m_queueConsumerThread == thisThread) {
                    DREvent drEvent = null;
                    try {
                        drEvent = (DREvent)DRRootImpl.this.m_eventQueue.removeHead();
                        SystemRootImpl.getInstance().getDRAndClustersSynchronizationLock().get_write_lock();
                        LogicObjectImpl element = (LogicObjectImpl)drEvent.getElement();
                        this.runEvent(element, drEvent);
                        if (drEvent instanceof DRBlockingEvent) {
                            ((DRBlockingEvent)drEvent).lockNotify();
                        }
                        SystemRootImpl.getInstance().getDRAndClustersSynchronizationLock().release_write_lock();
                    }
                    catch (Throwable e) {
                        logger.error(e);
                        if (drEvent instanceof DRBlockingEvent) {
                            ((DRBlockingEvent)drEvent).lockNotify();
                        }
                        SystemRootImpl.getInstance().getDRAndClustersSynchronizationLock().release_write_lock();
                    }
                }
            }

            private void runEvent(LogicObjectImpl element, DREvent drEvent) throws RemoteException {
                int eventType = drEvent.getType();
                switch (eventType) {
                    case 1: {
                        DRRootImpl.this.newElement(element);
                        break;
                    }
                    case 2: {
                        try {
                            DRRootImpl.this.changeElement(drEvent);
                        }
                        catch (RemoteException e) {
                            logger.error(e);
                        }
                        catch (IllegalValueException e) {
                            logger.error(e);
                        }
                        break;
                    }
                    case 3: {
                        DRRootImpl.this.removeElement(element);
                        break;
                    }
                    case 21: {
                        this.handleClusterDiscoveryStartEvent((ClusterImpl)element);
                        break;
                    }
                    case 5: {
                        this.handleClusterDiscoveryCompleteEvent((ClusterImpl)element);
                    }
                }
            }

            private void handleClusterDiscoveryStartEvent(ClusterImpl cluster) throws RemoteException {
                try {
                    if (DRRootImpl.this.isDiscoverCompleted()) {
                        DrAlarmMgrImpl.getInstance().takePendingAlarms();
                    }
                }
                catch (IllegalValueException ive) {
                    logger.error(ive);
                }
                DRRootImpl.this.m_isDRDiscoveryCompleted = false;
                DRRootImpl.this.m_isDRDiscoveryCompletedCounter++;
                DRRootImpl.this.m_clustersDiscoveredInDR.remove(cluster);
                EventServiceImpl.getInstance().fireDRDiscoveryStarted(new ElementEventImpl(DRRootImpl.this, DRRootImpl.this));
                DRRootImpl.this.clearCluster(cluster, false);
            }

            private void handleClusterDiscoveryCompleteEvent(ClusterImpl cluster) throws RemoteException {
                DRRootImpl.this.readCluster(cluster);
                Iterator i = DRRootImpl.this.getDRObjects().iterator();
                while (i.hasNext()) {
                    ((DRLogicObjectImpl)i.next()).updateCommKeyClassIDs();
                }
                DRRootImpl.this.m_isDRDiscoveryCompletedCounter--;
                DRRootImpl.this.m_clustersDiscoveredInDR.add(cluster);
                EventServiceImpl.getInstance().fireDRDiscoveryCompleted(new ElementEventImpl(DRRootImpl.this, DRRootImpl.this));
                if (SystemRootImpl.getInstance().isDiscoverCompleted() && DRRootImpl.this.m_clustersDiscoveredInDR.containsAll(SystemRootImpl.getInstance().getClustersRecursively())) {
                    DrAlarmMgrImpl.getInstance().generateAlarms(null);
                    DrAlarmMgrImpl.getInstance().clearPendingAlarms(null);
                    SystemRootImpl.getInstance().notifyDRDiscoveryCompleted();
                    DRRootImpl.this.m_isDRDiscoveryCompleted = true;
                    try {
                        DRRootImpl.this.updateTargetsACLWithRemoteInitiatorIdentities();
                    }
                    catch (IllegalValueException ive) {
                        logger.error(ive);
                    }
                }
            }
        };
        this.m_queueConsumerThread.start();
    }

    public static DRRootImpl getInstance() throws RemoteException {
        if (m_theInstance == null) {
            m_theInstance = new DRRootImpl();
        }
        return m_theInstance;
    }

    public DRConsistencyGroup[] getConsistencyGroups() throws RemoteException {
        DRConsistencyGroup[] groups = new DRConsistencyGroup[this.m_consistencyGroups.size()];
        return this.m_consistencyGroups.toArray(groups);
    }

    public DRExtendedPair[] getExtendedPairs() throws RemoteException {
        DRExtendedPair[] pairs = new DRExtendedPair[this.m_extendedPairs.size()];
        return this.m_extendedPairs.toArray(pairs);
    }

    /*
     * WARNING - void declaration
     */
    private DRAbstractConsistencyGroupImpl newConsistencyGroup(DRClusterAbstractConsistencyGroup group) throws RemoteException {
        void var2_3;
        DRAbstractConsistencyGroupImpl newGroup;
        ClassID classId = group.getClassId();
        if (this.findDRObjectContainingElement(this.getDRLogicObjectList(group.getClassId()), (DRClusterLogicObjectImpl)((Object)group)) != null) {
            return null;
        }
        if (classId.equals(ClassID.CONSISTENCY_GROUP)) {
            newGroup = new DRConsistencyGroupImpl((DRClusterConsistencyGroupImpl)group);
        } else if (classId.equals(ClassID.EXTENDED_PAIR)) {
            newGroup = new DRExtendedPairImpl((DRClusterExtendedPairImpl)group);
        } else {
            throw new IllegalArgumentException();
        }
        this.drElementCreated((DRLogicObjectImpl)var2_3);
        return var2_3;
    }

    private DRAbstractConsistencyGroupImpl removeDRClusterConsistencyGroup(DRClusterAbstractConsistencyGroupImpl group) throws RemoteException, IllegalValueException {
        DRAbstractConsistencyGroupImpl removedElement = null;
        ArrayList groupList = this.getDRLogicObjectList(group.getClassId());
        DRAbstractConsistencyGroupImpl matchingGroup = (DRAbstractConsistencyGroupImpl)this.findDRObjectContainingElement(groupList, group);
        if (matchingGroup != null && matchingGroup.hasElement(group)) {
            DRPiTImpl[] removedPits = matchingGroup.clearClusterPiTs((ClusterImpl)group.getCluster());
            int i = removedPits.length;
            while (i-- > 0) {
                ElementEventImpl elementEvent = new ElementEventImpl(this, removedPits[i]);
                EventServiceImpl.getInstance().fireElementRemove(elementEvent);
            }
            if (matchingGroup.isPartial()) {
                DRAsyncPairImpl matchingPair;
                removedElement = matchingGroup;
                this.drElementRemoved(matchingGroup);
                if (matchingGroup.getClassId().equals(ClassID.EXTENDED_PAIR) && (matchingPair = (DRAsyncPairImpl)((DRExtendedPairImpl)matchingGroup).getPair()) != null) {
                    this.drElementRemoved(matchingPair);
                }
            } else {
                DRAsyncPairImpl matchingPair;
                if (matchingGroup.getClassId().equals(ClassID.EXTENDED_PAIR) && (matchingPair = (DRAsyncPairImpl)((DRExtendedPairImpl)matchingGroup).getPair()) != null) {
                    matchingPair.removeElement(group.getRole());
                    this.drElementChanged(matchingPair);
                }
                matchingGroup.removeElement(group);
                this.drElementChanged(matchingGroup);
            }
        } else {
            logger.debug("attempt to remove non existing " + group.getClassId() + ": " + group);
        }
        return removedElement;
    }

    private DRAsyncPairImpl removeDRClusterAsyncPair(DRClusterAsyncPairImpl clusterPair, boolean isMergeDeletion) throws RemoteException {
        DRAsyncPairImpl removeElement = null;
        ArrayList groupList = this.getDRLogicObjectList(clusterPair.getGroupId().getClassID());
        DRAsyncPairImpl matchingPair = this.findPairContainingClusterPair(groupList, clusterPair);
        DRPiTImpl[] removedPits = matchingPair.clearClusterPiTs((ClusterImpl)clusterPair.getCluster());
        int i = removedPits.length;
        while (i-- > 0) {
            ElementEventImpl elementEvent = new ElementEventImpl(this, removedPits[i]);
            EventServiceImpl.getInstance().fireElementRemove(elementEvent);
        }
        DRAbstractConsistencyGroupImpl matchingGroup = matchingPair.getParentGroup();
        if (matchingPair == null || !matchingPair.hasElement(clusterPair)) {
            return null;
        }
        JournalVolume journalVolume = matchingPair.getJournalVolume(clusterPair.getRole());
        if (journalVolume != null) {
            ((JournalVolumeImpl)journalVolume).removeConnectedPair(matchingPair);
        }
        if (matchingPair.isPartial()) {
            this.drElementRemoved(matchingPair);
            removeElement = matchingPair;
            matchingGroup.removePair(matchingPair);
            if (matchingGroup.getClassId().equals(ClassID.EXTENDED_PAIR) && !isMergeDeletion) {
                this.drElementRemoved(matchingGroup);
            } else {
                this.drElementChanged(matchingGroup);
            }
        } else {
            matchingPair.removeElement(clusterPair);
            this.drElementChanged(matchingPair);
            ClassID classId = matchingGroup.getClassId();
            if (classId.equals(ClassID.CONSISTENCY_GROUP) || isMergeDeletion) {
                if (matchingGroup.getPairsCount() == 1) {
                    this.splitGroup(matchingGroup, clusterPair.getRole().equals(DRRoleConstant.LOCAL));
                }
            } else if (classId.equals(ClassID.EXTENDED_PAIR)) {
                matchingGroup.removeElement(clusterPair.getRole());
                this.drElementChanged(matchingGroup);
            }
        }
        return removeElement;
    }

    private DRSyncPairImpl removeDRClusterSyncPair(DRClusterSyncPairImpl pair) throws RemoteException {
        DRSyncPairImpl removeElement = null;
        DRSyncPairImpl matchingPair = (DRSyncPairImpl)this.findDRObjectContainingElement(this.m_syncPairs, pair);
        if (matchingPair != null && matchingPair.hasElement(pair)) {
            if (matchingPair.isPartial()) {
                removeElement = matchingPair;
                this.drElementRemoved(matchingPair);
            } else {
                matchingPair.removeElement(pair);
                this.drElementChanged(matchingPair);
            }
        } else {
            logger.warning("attempt to remove a non-existing Sync pair element " + pair + " from DR");
        }
        return removeElement;
    }

    private void removeDRPiT(DRPiTImpl pit) throws RemoteException {
        DRClusterLogicObjectImpl clusterParent = pit.getClusterObjectParent();
        ArrayList drObjectList = this.getDRLogicObjectList(clusterParent.getClassId());
        DRLogicObjectImpl parent = this.findDRObjectContainingElement(drObjectList, clusterParent);
        ((DRPiTContainer)((Object)parent)).removePiT(pit);
        ElementEventImpl elementEvent = new ElementEventImpl(this, pit);
        EventServiceImpl.getInstance().fireElementRemove(elementEvent);
    }

    private void splitGroup(DRAbstractConsistencyGroupImpl group, boolean isLocal) throws RemoteException {
    }

    private DRAsyncPairImpl newAsyncPair(DRClusterAsyncPair clusterPair) throws IllegalStateException, RemoteException, IllegalValueException {
        DRClusterAsyncPairImpl pair = (DRClusterAsyncPairImpl)clusterPair;
        if (this.findDRObjectContainingElement(this.getDRLogicObjectList(pair.getClassId()), pair) != null) {
            logger.warning(pair.getClassId() + " " + pair + " has already exist in DR pair");
            return null;
        }
        DRAbstractConsistencyGroupImpl groupIDMatchingGroup = null;
        DRAbstractConsistencyGroupImpl pairMatchingGroup = null;
        DRAsyncPairImpl matchingPair = null;
        ArrayList allGroups = this.getDRLogicObjectList(pair.getGroupId().getClassID());
        CommKeyClassId clusterGroupKey = pair.getGroupId();
        int i = allGroups.size();
        while (i-- > 0) {
            DRAbstractConsistencyGroupImpl group = (DRAbstractConsistencyGroupImpl)allGroups.get(i);
            if (group.containsDRClusterGroup(clusterGroupKey)) {
                groupIDMatchingGroup = group;
            }
            if (matchingPair != null || (matchingPair = (DRAsyncPairImpl)this.findEquivalentMatchingPair(group.getPairs(), pair)) == null) continue;
            pairMatchingGroup = group;
        }
        if (groupIDMatchingGroup != null) {
            DRAbstractConsistencyGroupImpl pairParentGroup = groupIDMatchingGroup;
            boolean parentGroupChanged = false;
            if (pairMatchingGroup != null && groupIDMatchingGroup != pairMatchingGroup) {
                this.drElementRemoved(groupIDMatchingGroup);
                this.mergeGroups(pairMatchingGroup, groupIDMatchingGroup);
                parentGroupChanged = true;
                DRAsyncPair[] pairsOfDepracatedGroups = groupIDMatchingGroup.getPairs();
                if (pairsOfDepracatedGroups != null) {
                    int i2 = pairsOfDepracatedGroups.length;
                    while (i2-- > 0) {
                        this.drElementChanged((DRAsyncPairImpl)pairsOfDepracatedGroups[i2]);
                    }
                }
                pairParentGroup = pairMatchingGroup;
            }
            DRRoleConstant role = pairParentGroup.getDRClusterGroup(clusterGroupKey).getRole();
            if (matchingPair != null) {
                matchingPair.setElement(pair, role);
                JournalVolume journalVolume = matchingPair.getJournalVolume(role);
                ((JournalVolumeImpl)journalVolume).addConnectedPair(matchingPair);
                this.drElementChanged(matchingPair);
                return matchingPair;
            }
            DRAsyncPairImpl newPair = new DRAsyncPairImpl(pair, role, pairParentGroup);
            pairParentGroup.addPair(newPair);
            parentGroupChanged = true;
            JournalVolume journalVolume = newPair.getJournalVolume(role);
            ((JournalVolumeImpl)journalVolume).addConnectedPair(newPair);
            this.drElementCreated(newPair);
            if (parentGroupChanged) {
                this.drElementChanged(pairParentGroup);
            }
        } else {
            throw new IllegalStateException("DR Async pair " + pair + " has no group in DRRootImpl!");
        }
        return null;
    }

    private DRSyncPairImpl newSyncPair(DRClusterSyncPairImpl pair) throws RemoteException {
        if (this.findDRObjectContainingElement(this.getDRLogicObjectList(pair.getClassId()), pair) != null) {
            logger.warning(pair.getClassId() + " " + pair + " has already exist in DR pair");
            return null;
        }
        DRPair[] syncPairs = new DRSyncPair[this.m_syncPairs.size()];
        this.m_syncPairs.toArray(syncPairs);
        DRSyncPairImpl matchingPair = (DRSyncPairImpl)this.findEquivalentMatchingPair(syncPairs, pair);
        if (matchingPair != null) {
            matchingPair.setElement(pair);
            this.drElementChanged(matchingPair);
            return null;
        }
        matchingPair = new DRSyncPairImpl(pair);
        this.drElementCreated(matchingPair);
        return matchingPair;
    }

    private void newDRPiT(DRPiTImpl pit) throws RemoteException {
        DRClusterLogicObjectImpl clusterParent = pit.getClusterObjectParent();
        ArrayList drObjectList = this.getDRLogicObjectList(clusterParent.getClassId());
        DRLogicObjectImpl parent = this.findDRObjectContainingElement(drObjectList, clusterParent);
        ((DRPiTContainer)((Object)parent)).addPiT(pit);
        pit.setDRObjectParent(parent);
        ElementEventImpl elementEvent = new ElementEventImpl(this, pit);
        elementEvent.setParameterList(pit.getClientParameterList());
        EventServiceImpl.getInstance().fireElementCreate(elementEvent);
    }

    public void createInCluster(ConfigElementData ced, VolumeNodeImpl volume) throws RemoteException {
        Vector<VSwitch> vSwitches = new Vector<VSwitch>(Arrays.asList(volume.getConnectedVSwitches()));
        ClusterImpl cluster = (ClusterImpl)volume.getCluster();
        cluster.createElement(ced, "", vSwitches);
    }

    public void createInCluster(ConfigElementData ced, Cluster cluster) throws RemoteException {
        Vector<Object> vSwitches = new Vector<Object>(Arrays.asList(cluster.getVSwitches().toArray()));
        ((ClusterImpl)cluster).createElement(ced, "", vSwitches);
    }

    public void createInCluster(ConfigElementDataList cedList, Vector vswitches, Cluster cluster) throws RemoteException {
        ((ClusterImpl)cluster).createElement(cedList, "", cluster.getVSwitches());
    }

    private GeneralSCSIDeviceImpl getISCSIDisk(Cluster remoteCluster, String targetName, LU lun) throws RemoteException {
        GeneralSCSIDeviceImpl iSCSIDisk = (GeneralSCSIDeviceImpl)((ClusterImpl)remoteCluster).getStoragePool().getSCSIDeviceByEntityNameLunAndSerialNumber(targetName, lun.getLUN().toString(), lun.getSerialNumber(), PhysicalStorageTypeConstant.PHYS_STOR_TYPE_DIRECT_ACCESS_DEVICE);
        if (iSCSIDisk != null) {
            return iSCSIDisk;
        }
        iSCSIDisk = (GeneralSCSIDeviceImpl)((ClusterImpl)remoteCluster).getStoragePool().getSCSIDeviceByEntityNameLunAndSerialNumber(targetName, lun.getLUN().toString(), null, PhysicalStorageTypeConstant.PHYS_STOR_TYPE_DIRECT_ACCESS_DEVICE);
        return iSCSIDisk;
    }

    public void createAsyncPair(DRPairInitialSyncTypeConstant initialSyncType, CommKeyClassId primaryId, CommKeyClassId secondaryId, String localTarget, Integer localLun, String remoteTarget, Integer remoteLun, CommKeyClassId primarySnapshotId, CommKeyClassId secondarySnapshotId, HashMap secondarySnapshotParams, CommKeyClassId primaryJournalId, CommKeyClassId secondaryJournalId, DRConsistencyGroup cg) throws RemoteException, IllegalValueException {
        this.createAsyncPair(ClassID.ASYNC_PAIR, initialSyncType, primaryId, secondaryId, localTarget, localLun, remoteTarget, remoteLun, primarySnapshotId, secondarySnapshotId, secondarySnapshotParams, primaryJournalId, secondaryJournalId, null, cg, null, null, null);
    }

    public void createAsyncPair(DRPairInitialSyncTypeConstant initialSyncType, CommKeyClassId primaryId, CommKeyClassId secondaryId, String localTarget, Integer localLun, String remoteTarget, Integer remoteLun, CommKeyClassId primarySnapshotId, CommKeyClassId secondarySnapshotId, HashMap secondarySnapshotParams, CommKeyClassId primaryJournalId, CommKeyClassId secondaryJournalId, String cgAlias, HashMap pitPolicy, HashMap transferPolicy, HashMap mergePolicy) throws RemoteException, IllegalValueException {
        this.createAsyncPair(ClassID.CONSISTENCY_GROUP, initialSyncType, primaryId, secondaryId, localTarget, localLun, remoteTarget, remoteLun, primarySnapshotId, secondarySnapshotId, secondarySnapshotParams, primaryJournalId, secondaryJournalId, cgAlias, null, pitPolicy, transferPolicy, mergePolicy);
    }

    public void createAsyncPair(DRPairInitialSyncTypeConstant initialSyncType, CommKeyClassId primaryId, CommKeyClassId secondaryId, String localTarget, Integer localLun, String remoteTarget, Integer remoteLun, CommKeyClassId primarySnapshotId, CommKeyClassId secondarySnapshotId, HashMap secondarySnapshotParams, CommKeyClassId primaryJournalId, CommKeyClassId secondaryJournalId, HashMap pitPolicy, HashMap transferPolicy, HashMap mergePolicy) throws RemoteException, IllegalValueException {
        this.createAsyncPair(ClassID.EXTENDED_PAIR, initialSyncType, primaryId, secondaryId, localTarget, localLun, remoteTarget, remoteLun, primarySnapshotId, secondarySnapshotId, secondarySnapshotParams, primaryJournalId, secondaryJournalId, null, null, pitPolicy, transferPolicy, mergePolicy);
    }

    private void createAsyncPair(ClassID classId, DRPairInitialSyncTypeConstant initialSyncType, CommKeyClassId primaryId, CommKeyClassId secondaryId, String localTarget, Integer localLun, String remoteTarget, Integer remoteLun, CommKeyClassId primarySnapshotId, CommKeyClassId secondarySnapshotId, HashMap secondarySnapshotParams, CommKeyClassId primaryJournalId, CommKeyClassId secondaryJournalId, String cgAlias, DRConsistencyGroup cg, HashMap pitPolicy, HashMap transferPolicy, HashMap mergePolicy) throws RemoteException, IllegalValueException {
        JournalVolume journal;
        VolumeTreeImpl volumeTree;
        Iterator iter;
        Vector journals;
        Cluster cluster;
        String exposedOnVSwitch;
        LU lu;
        this.validatePairCreation(primaryId, secondaryId, localTarget, localLun, remoteTarget, remoteLun, primaryJournalId, secondaryJournalId);
        VolumeNodeImpl primaryVolume = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(primaryId);
        VolumeNodeImpl secondaryVolume = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(secondaryId);
        if (primarySnapshotId != null && primaryVolume.getCluster().getConnectedVSwitchCounter() > primarySnapshotId.getCommKeys().length) {
            System.out.println("Primary Snapshot ID for pair <" + primaryVolume + "," + secondaryVolume + "> creation is not redundant:" + primarySnapshotId);
        }
        if (secondarySnapshotId != null && secondaryVolume.getCluster().getConnectedVSwitchCounter() > secondarySnapshotId.getCommKeys().length) {
            System.out.println("Secondary Snapshot ID for pair <" + primaryVolume + "," + secondaryVolume + "> creation is not redundant:" + secondarySnapshotId);
        }
        if (localTarget == null) {
            lu = primaryVolume.getParentLU();
            localLun = lu.getLUN();
            localTarget = lu.getParentTarget().getName();
        }
        if (remoteTarget == null) {
            lu = secondaryVolume.getParentLU();
            remoteLun = lu.getLUN();
            remoteTarget = lu.getParentTarget().getName();
        }
        if (primaryJournalId == null) {
            lu = primaryVolume.getParentLU();
            exposedOnVSwitch = lu.getParentTarget().getExposedOnVSwitch();
            cluster = primaryVolume.getCluster();
            journals = cluster.getStorage().getInteranlVolumesByType(ClassID.JOURNAL_VOLUME);
            iter = journals.iterator();
            while (iter.hasNext()) {
                volumeTree = (VolumeTreeImpl)iter.next();
                journal = (JournalVolume)volumeTree.getTreeRoot();
                if (!journal.getActiveOnVSwitch().getName().equals(exposedOnVSwitch)) continue;
                primaryJournalId = journal.getCommKeyClassId();
                break;
            }
        }
        if (secondaryJournalId == null) {
            lu = secondaryVolume.getParentLU();
            exposedOnVSwitch = lu.getParentTarget().getExposedOnVSwitch();
            cluster = secondaryVolume.getCluster();
            journals = cluster.getStorage().getInteranlVolumesByType(ClassID.JOURNAL_VOLUME);
            iter = journals.iterator();
            while (iter.hasNext()) {
                volumeTree = (VolumeTreeImpl)iter.next();
                journal = (JournalVolume)volumeTree.getTreeRoot();
                if (!journal.getActiveOnVSwitch().getName().equals(exposedOnVSwitch)) continue;
                secondaryJournalId = journal.getCommKeyClassId();
                break;
            }
        }
        this.createLocalAsyncPair(classId, initialSyncType, primaryId, secondaryId, remoteTarget, remoteLun, primarySnapshotId, primaryJournalId, cgAlias, cg, pitPolicy, transferPolicy, mergePolicy);
        this.createRemoteAsyncPair(classId, initialSyncType, primaryId, secondaryId, localTarget, localLun, remoteTarget, remoteLun, secondarySnapshotId, secondarySnapshotParams, secondaryJournalId, cgAlias, cg, pitPolicy, transferPolicy, mergePolicy);
    }

    private void createRemoteSnapshot(ConfigElementData element, HashMap params, Cluster remoteCluster) throws RemoteException, IllegalValueException {
        CommKeyClassId[] commKeyArray = (CommKeyClassId[])params.get(ClientParameterCode.VOLUME_CHILDREN);
        VolumeNodeImpl snapshotChild = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(commKeyArray[0]);
        if (snapshotChild.getParentVolume() != null) {
            throw new IllegalValueException("Snapshot volume child " + snapshotChild + " is already used by " + snapshotChild.getParentVolume());
        }
        ConfigElementData snapshotElement = new ConfigElementData(ClassID.SNAPSHOT_VOLUME);
        params = ClientParameterCode.transformToParameterCode(params);
        params.put(ParameterCode.VOLUME_ALIAS, new SrString((String)params.get(ParameterCode.VOLUME_ALIAS)));
        params.put(ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH, new SrInteger((Integer)params.get(ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH)));
        snapshotElement.addParameter(params);
        ((ClusterImpl)remoteCluster).prepareVSwitchIDs(snapshotElement, "", remoteCluster.getVSwitches());
        snapshotElement.addParameter(new Parameter(ParameterCode.SNAPSHOT_VOLUME_SOURCE, element.getValue(ParameterCode.DR_PAIR_SECONDARY_ID)));
        element.setValue(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID, snapshotElement);
    }

    public void createLocalAsyncPair(ClassID classId, DRPairInitialSyncTypeConstant initialSyncType, CommKeyClassId primaryId, CommKeyClassId secondaryId, String remoteTarget, Integer remoteLun, CommKeyClassId primarySnapshotId, CommKeyClassId primaryJournalId, String cgAlias, DRConsistencyGroup cg, HashMap pitPolicy, HashMap transferPolicy, HashMap mergePolicy) throws RemoteException, IllegalValueException {
        this.isCGAliasExsist(cgAlias);
        this.isCGInReplicationState(cg);
        VolumeNodeImpl localPrimary = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(primaryId);
        VolumeNodeImpl remoteSecondary = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(secondaryId);
        this.isVolumeAndClusterValidForPair(localPrimary);
        if (!DRPairInitialSyncTypeConstant.NONE.equals(initialSyncType) && primarySnapshotId == null) {
            throw new IllegalValueException("cannot create pair, there is no snapshot on the primary volume");
        }
        ConfigElementData localCED = new ConfigElementData(classId);
        if (cgAlias != null) {
            localCED.setValue(ParameterCode.DR_VIRT_GROUP_ALIAS, new SrString(cgAlias));
        } else if (cg != null) {
            CommKeyClassId localGroupId = ((DRConsistencyGroupImpl)this.getRefByStub(cg.hashKey())).getLocalElement().getCommKeyClassId();
            localCED.setValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID, localGroupId);
        }
        if (cg == null) {
            this.prepareElementPolicies(localCED, pitPolicy, transferPolicy, mergePolicy, (ClusterImpl)localPrimary.getCluster());
        }
        localCED.setValue(ParameterCode.DR_CONSISTENCY_GROUP_ROLE, DRRoleConstant.LOCAL);
        localCED.setValue(ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID, primaryJournalId);
        localCED.setValue(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, initialSyncType);
        this.preparePrimaryElementVolumes(localCED, localPrimary, remoteSecondary, remoteTarget, remoteLun);
        if (primarySnapshotId != null) {
            localCED.setValue(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID, primarySnapshotId);
        }
        this.createInCluster(localCED, localPrimary);
    }

    private void isVolumeAndClusterValidForPair(VolumeNodeImpl volume) throws RemoteException, IllegalValueException {
        SDTakeOverStateConstant takeOverState = volume.getCluster().getTakeoverState();
        if (takeOverState == null) {
            throw new IllegalValueException("The cluster currently does not have connected VSwitches");
        }
        if (takeOverState.equals(SDTakeOverStateConstant.SD_TAKE_OVER_STATE_UNDER_TAKE_OVER)) {
            throw new IllegalValueException("The cluster is under take over, you cannot create pair");
        }
        if (!volume.getClassId().equals(ClassID.JOURNAL_VOLUME)) {
            this.isVolumeValidForPair(volume);
        }
    }

    private void isVolumeValidForPair(VolumeNodeImpl volume) throws RemoteException, IllegalValueException {
        if (volume.isInvolvedInActiveCopy(volume.getActiveVswitch())) {
            throw new IllegalValueException("The volume is under copy operation, you cannot create pair");
        }
        if (volume.getParentVolume() != null) {
            throw new IllegalValueException("The volume has father, you cannot create pair");
        }
        if (!((VSwitchImpl)volume.getExposedOnVSwitch()).hasJournal()) {
            throw new IllegalValueException("The volume is not exposed on the active " + ClassID.VSWITCH + ", you cannot create pair");
        }
    }

    private void validatePairCreation(CommKeyClassId primaryId, CommKeyClassId secondaryId, String localTarget, Integer localLun, String remoteTarget, Integer remoteLun, CommKeyClassId inPrimaryJournalId, CommKeyClassId inSecondaryJournalId) throws RemoteException, IllegalValueException {
        TargetImpl ltarget;
        String msg;
        VolumeNodeImpl primaryVolume = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(primaryId);
        VolumeNodeImpl secondaryVolume = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(secondaryId);
        ClusterImpl localCluster = (ClusterImpl)primaryVolume.getCluster();
        ClusterImpl remoteCluster = (ClusterImpl)secondaryVolume.getCluster();
        LU localLU = primaryVolume.getParentLU();
        LU remoteLU = secondaryVolume.getParentLU();
        String localISCSIDiskMsg = this.validateISCSIDisk(localCluster, remoteTarget, remoteLU);
        if (localISCSIDiskMsg != null) {
            throw new IllegalValueException(localISCSIDiskMsg);
        }
        String remoteISCSIDiskMsg = this.validateISCSIDisk(remoteCluster, localTarget, localLU);
        if (remoteISCSIDiskMsg != null) {
            throw new IllegalValueException(remoteISCSIDiskMsg);
        }
        GeneralSCSIDeviceImpl localSecondaryDisk = this.getISCSIDisk(localCluster, remoteTarget, remoteLU);
        GeneralSCSIDeviceImpl remotePrimaryDisk = this.getISCSIDisk(remoteCluster, localTarget, localLU);
        if (primaryVolume.equals(localSecondaryDisk)) {
            StringBuffer msg2 = new StringBuffer();
            msg2.append("The pair cannot be created: the iSCSI ");
            msg2.append(primaryVolume.getClassId());
            msg2.append(' ');
            msg2.append(primaryVolume);
            msg2.append(" in the local site is connected to ");
            msg2.append(secondaryVolume.getClassId());
            msg2.append(' ');
            msg2.append(secondaryVolume);
            msg2.append(" in the remote site");
            throw new IllegalValueException(msg2.toString());
        }
        if (secondaryVolume.equals(remotePrimaryDisk)) {
            StringBuffer msg3 = new StringBuffer();
            msg3.append("The pair cannot be created: the iSCSI ");
            msg3.append(secondaryVolume.getClassId());
            msg3.append(' ');
            msg3.append(secondaryVolume);
            msg3.append(" in the remote site is connected to ");
            msg3.append(primaryVolume.getClassId());
            msg3.append(' ');
            msg3.append(primaryVolume);
            msg3.append(" in the local site");
            throw new IllegalValueException(msg3.toString());
        }
        if (localSecondaryDisk != null && localSecondaryDisk.isExposed()) {
            StringBuffer msg4 = new StringBuffer();
            msg4.append("The pair cannot be created: the secondary ");
            msg4.append(localSecondaryDisk.getClassId());
            msg4.append(' ');
            msg4.append(localSecondaryDisk);
            msg4.append(" in the local site is exposed on target ");
            msg4.append(localSecondaryDisk.getParentLU());
            throw new IllegalValueException(msg4.toString());
        }
        if (remotePrimaryDisk != null && remotePrimaryDisk.isExposed()) {
            StringBuffer msg5 = new StringBuffer();
            msg5.append("The pair cannot be created: the primary ");
            msg5.append(remotePrimaryDisk.getClassId());
            msg5.append(' ');
            msg5.append(remotePrimaryDisk);
            msg5.append(" in the remote site is exposed on target ");
            msg5.append(remotePrimaryDisk.getParentLU());
            throw new IllegalValueException(msg5.toString());
        }
        if (localSecondaryDisk != null && !localSecondaryDisk.getRootVolume().equals(localSecondaryDisk)) {
            StringBuffer msg6 = new StringBuffer();
            msg6.append("The pair cannot be created: the primary ");
            msg6.append(localSecondaryDisk);
            msg6.append(" is not root volume ");
            throw new IllegalValueException(msg6.toString());
        }
        if (remotePrimaryDisk != null && !remotePrimaryDisk.getRootVolume().equals(remotePrimaryDisk)) {
            StringBuffer msg7 = new StringBuffer();
            msg7.append("The pair cannot be created: the secondary ");
            msg7.append(remotePrimaryDisk);
            msg7.append(" is not root volume ");
            throw new IllegalValueException(msg7.toString());
        }
        if (inPrimaryJournalId != null && (msg = this.checkIfJournalAndTargetAreExposedOnTheSameVswitch(inPrimaryJournalId, ltarget = (TargetImpl)((ClusterImpl)primaryVolume.getCluster()).getTargetListMgr().getTargetByName(localTarget))) != null) {
            throw new IllegalValueException(msg);
        }
        if (inSecondaryJournalId != null && (msg = this.checkIfJournalAndTargetAreExposedOnTheSameVswitch(inSecondaryJournalId, ltarget = (TargetImpl)((ClusterImpl)secondaryVolume.getCluster()).getTargetListMgr().getTargetByName(remoteTarget))) != null) {
            throw new IllegalValueException(msg);
        }
    }

    private String checkIfJournalAndTargetAreExposedOnTheSameVswitch(CommKeyClassId inJournalId, TargetImpl target) throws RemoteException {
        String msg = null;
        JournalVolumeImpl journal = (JournalVolumeImpl)SystemRootImpl.getInstance().getRefByStub(inJournalId);
        String vswitchName = target.getExposedOnVSwitch();
        if (!vswitchName.equals(journal.getActiveOnVSwitch().getName())) {
            msg = ClassID.JOURNAL_VOLUME + " " + journal + " is  active on  " + ClassID.VSWITCH + " " + journal.getActiveOnVSwitch().getName() + " and " + target.getClassId() + " " + target + " exposed on " + ClassID.VSWITCH + " " + vswitchName;
        }
        return msg;
    }

    private String validateISCSIDisk(ClusterImpl localCluster, String remoteTarget, LU remoteLun) throws RemoteException, IllegalValueException {
        String lunStr = remoteLun.getLUN().toString();
        GeneralSCSIDeviceImpl matchingDisk = this.getISCSIDisk(localCluster, remoteTarget, remoteLun);
        GeneralSCSIDevice anyDisk = localCluster.getStoragePool().getSCSIDeviceByEntityNameAndLun(remoteTarget, lunStr, PhysicalStorageTypeConstant.PHYS_STOR_TYPE_DIRECT_ACCESS_DEVICE);
        if (matchingDisk == null && anyDisk != null) {
            StringBuffer msg = new StringBuffer();
            msg.append("Cannot create the element since it uses the target name ");
            msg.append(remoteTarget);
            msg.append(" and lun ");
            msg.append(lunStr);
            msg.append(" but diffrent serial number with the ");
            msg.append(anyDisk.getClassId());
            msg.append(' ');
            msg.append(anyDisk);
            msg.append(", please remove ");
            msg.append(anyDisk);
            msg.append(" in order to create the GDR pair.");
            return msg.toString();
        }
        return null;
    }

    private void isCGAliasExsist(String cgAlias) throws RemoteException, IllegalValueException {
        if (cgAlias == null) {
            return;
        }
        for (int i = 0; i < this.m_consistencyGroups.size(); ++i) {
            if (!cgAlias.equals(((DRConsistencyGroupImpl)this.m_consistencyGroups.get(i)).getAlias())) continue;
            throw new IllegalValueException("There is another cg with the same group name");
        }
    }

    private void isCGInReplicationState(DRConsistencyGroup cg) throws RemoteException, IllegalValueException {
        if (cg == null) {
            return;
        }
        DRConsistencyGroupImpl cgImpl = (DRConsistencyGroupImpl)this.getRefByStub(cg.hashKey());
        if (!cgImpl.getActiveElement().isParameterEqual(new Parameter(ParameterCode.DR_CONSISTENCY_GROUP_REPLICATION_STATE, DRReplicationStateConstant.INACTIVE), cgImpl.getActiveElement().getActiveVswitch()) || !cgImpl.getInactiveElement().isParameterEqual(new Parameter(ParameterCode.DR_CONSISTENCY_GROUP_REPLICATION_STATE, DRReplicationStateConstant.INACTIVE), cgImpl.getInactiveElement().getActiveVswitch())) {
            throw new IllegalValueException("The cg is in replication state you cannot add pair to it");
        }
    }

    public void createRemoteAsyncPair(ClassID classId, DRPairInitialSyncTypeConstant initialSyncType, CommKeyClassId primaryId, CommKeyClassId secondaryId, String localTarget, Integer localLun, String remoteTarget, Integer remoteLun, CommKeyClassId secondarySnapshotId, HashMap secondarySnapshotParams, CommKeyClassId secondaryJournalId, String cgAlias, DRConsistencyGroup cg, HashMap pitPolicy, HashMap transferPolicy, HashMap mergePolicy) throws RemoteException, IllegalValueException {
        VolumeNodeImpl localPrimary = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(primaryId);
        VolumeNodeImpl journal = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(secondaryJournalId);
        VolumeNodeImpl remoteSecondary = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(secondaryId);
        ClusterImpl remoteCluster = (ClusterImpl)journal.getCluster();
        if (remoteSecondary.getCluster().equals(remoteCluster)) {
            this.isVolumeAndClusterValidForPair(remoteSecondary);
        } else {
            this.isVolumeAndClusterValidForPair(journal);
        }
        Vector vswitches = remoteCluster.getVSwitches();
        ConfigElementData remoteCED = new ConfigElementData(classId);
        if (cgAlias != null) {
            remoteCED.setValue(ParameterCode.DR_VIRT_GROUP_ALIAS, new SrString(cgAlias));
        } else if (cg != null) {
            CommKeyClassId remoteGroupId = ((DRConsistencyGroupImpl)this.getRefByStub(cg.hashKey())).getRemoteElement().getCommKeyClassId();
            remoteCED.setValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID, remoteGroupId);
        }
        if (cg == null) {
            this.prepareElementPolicies(remoteCED, pitPolicy, transferPolicy, mergePolicy, remoteCluster);
        }
        remoteCED.setValue(ParameterCode.DR_CONSISTENCY_GROUP_ROLE, DRRoleConstant.REMOTE);
        remoteCED.setValue(ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID, secondaryJournalId);
        ConfigElementData elementVolume = null;
        this.prepareSecondaryElementVolumes(remoteCED, localTarget, localLun, remoteCluster, localPrimary);
        remoteCED.setValue(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, initialSyncType);
        if (!((Object)remoteCluster).equals(remoteSecondary.getCluster())) {
            this.localCopyAllowed(new HashSet(), remoteSecondary, remoteCluster);
            elementVolume = remoteSecondary.getDuplicationConfigElementData(new HashMap(), remoteCluster);
            remoteCED.setValue(ParameterCode.DR_PAIR_SECONDARY_ID, elementVolume);
            if (secondarySnapshotParams != null && !secondarySnapshotParams.isEmpty()) {
                this.createRemoteSnapshot(remoteCED, secondarySnapshotParams, remoteCluster);
            }
            ConfigElementDataList list = new ConfigElementDataList();
            ConfigElementData luElement = this.createLunElement(remoteTarget, remoteLun, elementVolume, remoteCluster);
            if (luElement != null) {
                list.addElement(luElement);
            }
            list.addElement(remoteCED);
            logger.debug("ready to send package " + list);
            this.createInCluster(list, vswitches, remoteCluster);
        } else {
            remoteCED.setValue(ParameterCode.DR_PAIR_SECONDARY_ID, secondaryId);
            if (secondarySnapshotId != null) {
                remoteCED.setValue(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID, secondarySnapshotId);
            }
            this.createInCluster(remoteCED, remoteSecondary);
        }
    }

    private ConfigElementData createLunElement(String remoteTarget, Integer remoteLun, ConfigElementData elementVolume, Cluster cluster) throws RemoteException, IllegalValueException {
        VolumeNode vol;
        LU parentLU;
        if (elementVolume.getCommKey() != null && (parentLU = (vol = (VolumeNode)cluster.getCommKeyRefMap().getRefByCommKeyClassID(elementVolume.getCommKeyClassId())).getParentLU()) != null) {
            if (parentLU.getLUN().equals(remoteLun)) {
                return null;
            }
            throw new IllegalValueException("Volume " + vol + " is already exposed on LUN " + parentLU);
        }
        ConfigElementData elementLu = new ConfigElementData(ClassID.LUN);
        elementLu.setValue(ParameterCode.LU_LUN_NUMBER, new SrGauge(remoteLun));
        elementLu.setValue(ParameterCode.LU_PARENT, ((StorageImpl)cluster.getStorage()).getTargetListMgr().getTargetByName(remoteTarget).getCommKeyClassId());
        elementLu.setValue(ParameterCode.LU_VOLUME_ID, elementVolume);
        return elementLu;
    }

    public void prepareElementPolicies(ConfigElementData element, HashMap pitPolicy, HashMap transferPolicy, HashMap mergePolicy, ClusterImpl cluster) throws RemoteException {
        if (pitPolicy != null) {
            PolicyTypeConstant pitType = (PolicyTypeConstant)pitPolicy.get(ClientParameterCode.DR_POLICY_METHOD);
            Long pitStartat = (Long)pitPolicy.get(ClientParameterCode.DR_POLICY_START_AT_DATE_AND_TIME);
            Long pitRunEvery = (Long)pitPolicy.get(ClientParameterCode.DR_POLICY_RUN_EVERY);
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_TYPE, pitType);
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_START_AT, new SrDateAndTime(pitStartat));
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_RUN_EVERY, new SrInteger(pitRunEvery.intValue()));
            HashMap pitIndicesParams = PoliciesManager.getInstance().getPolicyKeysParameterList(cluster, pitStartat, pitType, pitRunEvery);
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID, (CommKeyClassId)pitIndicesParams.get(ParameterCode.POLICY_ID));
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_PARAM_ID, (CommKeyClassId)pitIndicesParams.get(ParameterCode.POLICY_PARAM_ID));
        }
        if (transferPolicy != null) {
            PolicyTypeConstant transType = (PolicyTypeConstant)transferPolicy.get(ClientParameterCode.DR_POLICY_METHOD);
            Long transStartat = (Long)transferPolicy.get(ClientParameterCode.DR_POLICY_START_AT_DATE_AND_TIME);
            Long transRunevery = (Long)transferPolicy.get(ClientParameterCode.DR_POLICY_RUN_EVERY);
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_TYPE, transType);
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_START_AT, new SrDateAndTime(transStartat));
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_RUN_EVERY, new SrInteger(transRunevery.intValue()));
            HashMap transIndicesParams = PoliciesManager.getInstance().getPolicyKeysParameterList(cluster, transStartat, transType, transRunevery);
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID, (CommKeyClassId)transIndicesParams.get(ParameterCode.POLICY_ID));
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_PARAM_ID, (CommKeyClassId)transIndicesParams.get(ParameterCode.POLICY_PARAM_ID));
        }
        if (mergePolicy != null) {
            PolicyTypeConstant mergeType = (PolicyTypeConstant)mergePolicy.get(ClientParameterCode.DR_POLICY_METHOD);
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_TYPE, mergeType);
            HashMap mergeIndicesParams = PoliciesManager.getInstance().getPolicyKeysParameterList(cluster, new Long(0L), mergeType, new Long(0L));
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID, (CommKeyClassId)mergeIndicesParams.get(ParameterCode.POLICY_ID));
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_PARAM_ID, (CommKeyClassId)mergeIndicesParams.get(ParameterCode.POLICY_PARAM_ID));
        }
    }

    public void preparePrimaryElementVolumes(ConfigElementData element, VolumeNodeImpl localPrimary, VolumeNodeImpl remoteSecondary, String remoteTarget, Integer remoteLunNumber) throws RemoteException {
        LU remoteLun = remoteSecondary.getParentLU();
        element.setValue(ParameterCode.DR_PAIR_PRIMARY_ID, localPrimary.getCommKeyClassId());
        GeneralSCSIDeviceImpl iSCSIDisk1 = this.getISCSIDisk(localPrimary.getCluster(), remoteTarget, remoteLun);
        if (iSCSIDisk1 == null) {
            SrEntityNameFormat remoteTargetNameFormat = new SrEntityNameFormat(remoteTarget);
            element.setValue(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, remoteTargetNameFormat);
            SrLunFormat lun = GeneralSCSIDeviceImpl.parseSCSIDeviceLUN(remoteLunNumber);
            element.setValue(ParameterCode.PHYSICAL_STORAGE_LUN, lun);
        } else {
            CommKeyClassId configuredDiskID = iSCSIDisk1.getCommKeyClassId();
            element.setValue(ParameterCode.DR_PAIR_SECONDARY_ID, configuredDiskID);
            element.setValue(ParameterCode.DR_PAIR_LOCAL_SECONDARY_ID, configuredDiskID);
        }
        element.setValue(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE, new SrInteger(remoteSecondary.getBlockSize()));
        element.setValue(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM, new SrLunFormat(remoteSecondary.getNumberOfBlocks(null)));
    }

    public void prepareSecondaryElementVolumes(ConfigElementData element, String localTarget, Integer localLunNumber, Cluster remoteCluster, VolumeNodeImpl localPrimary) throws RemoteException {
        LU localLun = localPrimary.getParentLU();
        GeneralSCSIDeviceImpl iSCSIDisk2 = this.getISCSIDisk(remoteCluster, localTarget, localLun);
        if (iSCSIDisk2 == null) {
            SrEntityNameFormat localTargetNameFormat = new SrEntityNameFormat(localTarget);
            element.setValue(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, localTargetNameFormat);
            SrLunFormat lun = GeneralSCSIDeviceImpl.parseSCSIDeviceLUN(localLunNumber);
            element.setValue(ParameterCode.PHYSICAL_STORAGE_LUN, lun);
        } else {
            CommKeyClassId configuredDiskID = iSCSIDisk2.getCommKeyClassId();
            element.setValue(ParameterCode.DR_PAIR_PRIMARY_ID, configuredDiskID);
            element.setValue(ParameterCode.DR_PAIR_REMOTE_PRIMARY_ID, configuredDiskID);
        }
        element.setValue(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE, new SrInteger(localPrimary.getBlockSize()));
        element.setValue(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM, new SrLunFormat(localPrimary.getNumberOfBlocks(null)));
    }

    public void createSyncPair(DRPairInitialSyncTypeConstant initialSyncType, CommKeyClassId primaryId, CommKeyClassId secondaryId, String localTarget, Integer localLun, String remoteTarget, Integer remoteLun) throws RemoteException, IllegalValueException {
        LU lu;
        this.validatePairCreation(primaryId, secondaryId, localTarget, localLun, remoteTarget, remoteLun, null, null);
        if (localTarget == null) {
            VolumeNodeImpl primaryVolume = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(primaryId);
            lu = primaryVolume.getParentLU();
            localLun = lu.getLUN();
            localTarget = lu.getParentTarget().getName();
        }
        if (remoteTarget == null) {
            VolumeNodeImpl secondaryVolume = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(secondaryId);
            lu = secondaryVolume.getParentLU();
            remoteLun = lu.getLUN();
            remoteTarget = lu.getParentTarget().getName();
        }
        VolumeNodeImpl localPrimary = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(primaryId);
        VolumeNodeImpl remoteSecondary = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(secondaryId);
        this.createLocalSyncPair(initialSyncType, primaryId, remoteTarget, remoteLun, remoteSecondary);
        this.createRemoteSyncPair(initialSyncType, secondaryId, localTarget, localLun, localPrimary);
    }

    public void createLocalSyncPair(DRPairInitialSyncTypeConstant initialSyncType, CommKeyClassId primaryId, String remoteTarget, Integer remoteLun, VolumeNodeImpl remoteSecondary) throws RemoteException, IllegalValueException {
        VolumeNodeImpl localPrimary = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(primaryId);
        this.isVolumeAndClusterValidForPair(localPrimary);
        ConfigElementData _localCED = new ConfigElementData(ClassID.SYNC_PAIR);
        _localCED.setValue(ParameterCode.DR_SYNC_PAIR_ROLE, DRRoleConstant.LOCAL);
        _localCED.setValue(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, initialSyncType);
        this.preparePrimaryElementVolumes(_localCED, localPrimary, remoteSecondary, remoteTarget, remoteLun);
        this.createInCluster(_localCED, localPrimary);
    }

    protected void createRemoteSyncPair(DRPairInitialSyncTypeConstant initialSyncType, CommKeyClassId secondaryId, String localTarget, Integer localLun, VolumeNodeImpl localPrimary) throws RemoteException, IllegalValueException {
        VolumeNodeImpl remoteSecondary = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(secondaryId);
        this.isVolumeAndClusterValidForPair(remoteSecondary);
        ConfigElementData _remoteCED = new ConfigElementData(ClassID.SYNC_PAIR);
        _remoteCED.setValue(ParameterCode.DR_SYNC_PAIR_ROLE, DRRoleConstant.REMOTE);
        _remoteCED.setValue(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, initialSyncType);
        _remoteCED.setValue(ParameterCode.DR_PAIR_SECONDARY_ID, remoteSecondary.getCommKeyClassId());
        this.prepareSecondaryElementVolumes(_remoteCED, localTarget, localLun, remoteSecondary.getCluster(), localPrimary);
        this.createInCluster(_remoteCED, remoteSecondary);
    }

    public void localCopyAllowed(HashSet set, VolumeNodeImpl remoteSecondary, Cluster remoteCluster) throws RemoteException, IllegalValueException {
        GeneralSCSIDevice[] disks = remoteSecondary.getPhisycalDevicesOfVolume();
        logger.info("checking if local copy allowed on " + disks);
        for (int i = 0; i < disks.length; ++i) {
            if (((GeneralSCSIDeviceImpl)disks[i]).isDeviceSuitableForLocalCopy(set, remoteSecondary, remoteCluster)) continue;
            throw new IllegalValueException("cannot create this pair since the local copy is not suitable");
        }
    }

    private DRAbstractConsistencyGroupImpl findMatchingGroup(ArrayList list, DRClusterAbstractConsistencyGroupImpl group) throws RemoteException {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            DRAbstractConsistencyGroupImpl currGroup = (DRAbstractConsistencyGroupImpl)i.next();
            if (!currGroup.hasEquivalentElement(group)) continue;
            return currGroup;
        }
        return null;
    }

    private DRLogicObjectImpl findDRObjectContainingElement(ArrayList list, DRClusterLogicObjectImpl element) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            DRLogicObjectImpl currObject = (DRLogicObjectImpl)i.next();
            if (!currObject.hasElement(element)) continue;
            return currObject;
        }
        return null;
    }

    public DRLogicObjectImpl findDRObjectWithIdenticalElement(DRClusterLogicObjectImpl element) throws RemoteException {
        ClassID classId = element.getClassId();
        if (classId.equals(ClassID.CONSISTENCY_GROUP)) {
            return this.findDRObjectContainingElement(this.m_consistencyGroups, element);
        }
        if (classId.equals(ClassID.EXTENDED_PAIR)) {
            return this.findDRObjectContainingElement(this.m_extendedPairs, element);
        }
        if (classId.equals(ClassID.SYNC_PAIR)) {
            return this.findDRObjectContainingElement(this.m_syncPairs, element);
        }
        if (classId.equals(ClassID.ASYNC_PAIR)) {
            DRClusterAsyncPairImpl clusterPair = (DRClusterAsyncPairImpl)element;
            return this.findPairContainingClusterPair(this.getDRLogicObjectList(clusterPair.getGroupId().getClassID()), clusterPair);
        }
        return null;
    }

    private DRAbstractConsistencyGroupImpl findGroupWithIdenticalPair(DRClusterAsyncPairImpl pair) throws RemoteException {
        ArrayList groupList = this.getDRLogicObjectList(pair.getGroupId().getClassID());
        DRAbstractConsistencyGroupImpl cgWithIdenticalPair = this.findGroupWithIdenticalPair(groupList, pair);
        return cgWithIdenticalPair;
    }

    private DRAbstractConsistencyGroupImpl findGroupWithIdenticalPair(ArrayList drGroupList, DRClusterAsyncPairImpl pair) throws RemoteException {
        if (drGroupList != null && pair != null) {
            for (int i = 0; i < drGroupList.size(); ++i) {
                ArrayList<DRAsyncPair> pairList;
                DRPairImpl identicalPair;
                DRAbstractConsistencyGroupImpl currGroup = (DRAbstractConsistencyGroupImpl)drGroupList.get(i);
                DRAsyncPair[] currPairs = currGroup.getPairs();
                if (currPairs == null || (identicalPair = (DRPairImpl)this.findDRObjectContainingElement(pairList = new ArrayList<DRAsyncPair>(Arrays.asList(currPairs)), pair)) == null) continue;
                return currGroup;
            }
        }
        return null;
    }

    private DRAsyncPairImpl findPairContainingClusterPair(ArrayList drGroupList, DRClusterAsyncPairImpl pair) throws RemoteException {
        if (drGroupList != null && pair != null) {
            for (int i = 0; i < drGroupList.size(); ++i) {
                ArrayList<DRAsyncPair> pairList;
                DRAsyncPairImpl identicalPair;
                DRAbstractConsistencyGroupImpl currGroup = (DRAbstractConsistencyGroupImpl)drGroupList.get(i);
                DRAsyncPair[] currPairs = currGroup.getPairs();
                if (currPairs == null || (identicalPair = (DRAsyncPairImpl)this.findDRObjectContainingElement(pairList = new ArrayList<DRAsyncPair>(Arrays.asList(currPairs)), pair)) == null) continue;
                return identicalPair;
            }
        }
        return null;
    }

    private DRPairImpl findEquivalentMatchingPair(DRPair[] pairs, DRClusterPairImpl pair) throws RemoteException {
        if (pairs != null) {
            for (int i = 0; i < pairs.length; ++i) {
                DRPairImpl currPair = (DRPairImpl)pairs[i];
                if (!currPair.hasEquivalentElement(pair)) continue;
                return currPair;
            }
        }
        return null;
    }

    private ArrayList getDRLogicObjectList(ClassID classId) {
        if (classId.equals(ClassID.CONSISTENCY_GROUP)) {
            return this.m_consistencyGroups;
        }
        if (classId.equals(ClassID.EXTENDED_PAIR)) {
            return this.m_extendedPairs;
        }
        if (classId.equals(ClassID.SYNC_PAIR)) {
            return this.m_syncPairs;
        }
        if (classId.equals(ClassID.ASYNC_PAIR)) {
            try {
                return this.getAsyncPairList();
            }
            catch (RemoteException re) {
                logger.error(re);
            }
        }
        return null;
    }

    private ArrayList getAsyncPairList() throws RemoteException {
        ArrayList<DRAsyncPair> asyncPairList = new ArrayList<DRAsyncPair>();
        ArrayList extendedElementList = new ArrayList();
        extendedElementList.addAll(this.m_consistencyGroups);
        extendedElementList.addAll(this.m_extendedPairs);
        int size = extendedElementList.size();
        for (int i = 0; i < size; ++i) {
            DRAbstractConsistencyGroupImpl group = (DRAbstractConsistencyGroupImpl)extendedElementList.get(i);
            DRAsyncPair[] pairs = group.getPairs();
            if (pairs == null) continue;
            for (int j = 0; j < pairs.length; ++j) {
                asyncPairList.add(pairs[j]);
            }
        }
        return asyncPairList;
    }

    /*
     * WARNING - void declaration
     */
    private DRAbstractConsistencyGroupImpl createNewGroup(DRClusterAbstractConsistencyGroup group) throws RemoteException {
        void var3_4;
        DRAbstractConsistencyGroupImpl newGroup;
        ArrayList list = this.getDRLogicObjectList(group.getClassId());
        ClassID classId = group.getClassId();
        if (classId.equals(ClassID.CONSISTENCY_GROUP)) {
            newGroup = new DRConsistencyGroupImpl((DRClusterConsistencyGroupImpl)group);
        } else if (classId.equals(ClassID.EXTENDED_PAIR)) {
            newGroup = new DRExtendedPairImpl((DRClusterExtendedPairImpl)group);
        } else {
            throw new IllegalArgumentException();
        }
        list.add(var3_4);
        return var3_4;
    }

    private void mergeGroups(DRAbstractConsistencyGroupImpl mergeDestinationGroup, DRAbstractConsistencyGroupImpl depracatedGroup) throws IllegalStateException, RemoteException, IllegalValueException {
        DRAsyncPair[] newPairs = depracatedGroup.getPairs();
        if (newPairs != null) {
            for (int i = 0; i < newPairs.length; ++i) {
                mergeDestinationGroup.addPair(newPairs[i]);
                ((DRAsyncPairImpl)newPairs[i]).setConsistencyGroup(mergeDestinationGroup);
            }
        }
        DRPiT[] pits = depracatedGroup.getPiTs();
        for (int i = 0; i < pits.length; ++i) {
            mergeDestinationGroup.addPiT((DRPiTImpl)pits[i]);
            ((DRPiTImpl)pits[i]).setDRObjectParent(mergeDestinationGroup);
        }
        if (depracatedGroup.isPartial() && mergeDestinationGroup.isPartial()) {
            mergeDestinationGroup.setElement(depracatedGroup.getPartialElement());
        } else {
            DRClusterLogicObjectImpl destLocalElement = mergeDestinationGroup.getLocalElement();
            DRClusterLogicObjectImpl depracatedLocalElement = depracatedGroup.getLocalElement();
            if (destLocalElement != null && depracatedLocalElement != null && destLocalElement.canMerge(depracatedLocalElement)) {
                destLocalElement.merge(depracatedLocalElement);
            } else if (destLocalElement == null && depracatedLocalElement != null) {
                mergeDestinationGroup.setElement(depracatedLocalElement);
            }
            DRClusterLogicObjectImpl destRemoteElement = mergeDestinationGroup.getRemoteElement();
            DRClusterLogicObjectImpl depracatedRemoteElement = depracatedGroup.getRemoteElement();
            if (destRemoteElement != null && depracatedRemoteElement != null && destRemoteElement.canMerge(depracatedRemoteElement)) {
                destRemoteElement.merge(depracatedRemoteElement);
            } else if (destRemoteElement == null && depracatedRemoteElement != null) {
                mergeDestinationGroup.setElement(depracatedRemoteElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void invokeAndWait(RemoteObjectImpl element, int eventType) throws RemoteException {
        Object object = this.lock;
        synchronized (object) {
            void var4_4;
            DRBlockingEvent event;
            if (element instanceof LogicObjectImpl) {
                event = new DRBlockingEvent((Object)this, (LogicObjectImpl)element, eventType);
            } else if (element instanceof ElementEventImpl) {
                event = new DRBlockingEvent((Object)this, (ElementEventImpl)element, eventType);
            } else {
                throw new IllegalStateException("Undefined type for event arriving to DRRoot");
            }
            this.addToQueue(var4_4);
            var4_4.waitOnLock();
        }
    }

    public DRSyncPair[] getSyncPairs() throws RemoteException {
        DRSyncPair[] syncPairs = new DRSyncPair[this.m_syncPairs.size()];
        this.m_syncPairs.toArray(syncPairs);
        return syncPairs;
    }

    public void vswitchGroupRemove(VSwitchGroupImpl vSwitchGroup) throws RemoteException, IllegalValueException {
        block4: {
            Vector clusterVswitches;
            block3: {
                clusterVswitches = null;
                if (!vSwitchGroup.getClassId().equals(ClassID.CLUSTER)) break block3;
                clusterVswitches = ((ClusterImpl)vSwitchGroup).getVSwitches();
                for (int index = 0; index < clusterVswitches.size(); ++index) {
                    this.removeInitiatorNameFromTargetsACL((VSwitch)clusterVswitches.elementAt(index));
                }
                break block4;
            }
            if (!vSwitchGroup.getClassId().equals(ClassID.SITE)) break block4;
            for (int index1 = 0; index1 < clusterVswitches.size(); ++index1) {
                clusterVswitches = ((ClusterImpl)clusterVswitches.get(index1)).getVSwitches();
                for (int index2 = 0; index2 < clusterVswitches.size(); ++index2) {
                    this.removeInitiatorNameFromTargetsACL((VSwitch)clusterVswitches.elementAt(index2));
                }
            }
        }
    }

    private void updateTargetsACLWithRemoteInitiatorIdentities() throws RemoteException, IllegalValueException {
        HashMap map = this.collectSinglePairForEachClusterCouple();
        this.updateClusterCouplesWithDRIdentityAndNames(map);
    }

    private HashMap collectSinglePairForEachClusterCouple() throws RemoteException, IllegalValueException {
        HashMap map = new HashMap();
        int index = 0;
        DRSyncPair[] synchPairs = this.getSyncPairs();
        for (index = 0; index < synchPairs.length; ++index) {
            DRSyncPairImpl syncPairImpl = (DRSyncPairImpl)synchPairs[index];
            this.setClusterCoupleWithItsPair(map, syncPairImpl);
        }
        DRExtendedPair[] extendedPairs = this.getExtendedPairs();
        for (index = 0; index < extendedPairs.length; ++index) {
            DRExtendedPairImpl extendedPairImpl = (DRExtendedPairImpl)extendedPairs[index];
            this.setClusterCoupleWithItsPair(map, (DRAsyncPairImpl)extendedPairImpl.getPair());
        }
        DRConsistencyGroup[] consistencyGroup = this.getConsistencyGroups();
        for (index = 0; index < consistencyGroup.length; ++index) {
            DRConsistencyGroupImpl consistencyGroupImpl = (DRConsistencyGroupImpl)consistencyGroup[index];
            DRAsyncPair[] asyncPairs = consistencyGroupImpl.getPairs();
            for (int index1 = 0; index1 < asyncPairs.length; ++index1) {
                this.setClusterCoupleWithItsPair(map, (DRAsyncPairImpl)asyncPairs[index1]);
            }
        }
        return map;
    }

    private void setClusterCoupleWithItsPair(HashMap map, DRPairImpl pairElement) throws RemoteException, IllegalValueException {
        if (this.isDiscoverCompleted() && pairElement.isComplete()) {
            DRClusterPairImpl localClusterPairElement = (DRClusterPairImpl)pairElement.getLocalElement();
            ClusterImpl localCluster = (ClusterImpl)localClusterPairElement.getCluster();
            DRClusterPairImpl remoteClusterPairElement = (DRClusterPairImpl)pairElement.getRemoteElement();
            ClusterImpl remoteCluster = (ClusterImpl)remoteClusterPairElement.getCluster();
            ClusterImpl[] keyMap = new ClusterImpl[]{localCluster, remoteCluster};
            map.put(keyMap, pairElement);
        }
    }

    private void updateClusterCouplesWithDRIdentityAndNames(HashMap map) throws RemoteException, IllegalValueException {
        Set key = map.keySet();
        HashMap accumalator = new HashMap();
        Iterator i = key.iterator();
        while (i.hasNext()) {
            DRPairImpl pairElement = (DRPairImpl)map.get(i.next());
            this.updateTargetsACLWithRemoteInitiatorIdentitiesByPair(pairElement, accumalator);
        }
    }

    private void updateTargetsACLWithRemoteInitiatorIdentitiesByPair(DRPairImpl pairElement, HashMap accumaltor) throws RemoteException, IllegalValueException {
        if (this.isDiscoverCompleted() && pairElement.isComplete()) {
            DRClusterPairImpl localClusterPairElement = (DRClusterPairImpl)pairElement.getLocalElement();
            ClusterImpl localCluster = (ClusterImpl)localClusterPairElement.getCluster();
            DRClusterPairImpl remoteClusterPairElement = (DRClusterPairImpl)pairElement.getRemoteElement();
            ClusterImpl remoteCluster = (ClusterImpl)remoteClusterPairElement.getCluster();
            DRPrimaryVolume primaryVolume = pairElement.getPrimaryVolume();
            VolumeNode primaryVolumeNode = primaryVolume.getLocalVolume();
            LU primaryVolumeParentLU = primaryVolumeNode.getParentLU();
            Target primaryVolumeExsposedOnTarget = primaryVolumeParentLU.getParentTarget();
            ArrayList initiatorNamesOnRemoteCluster = remoteCluster.getLocalInitiatorNames();
            if ((initiatorNamesOnRemoteCluster = this.addInitiatorNamesForAccumaltor(localCluster, initiatorNamesOnRemoteCluster, accumaltor)) != null && !initiatorNamesOnRemoteCluster.isEmpty()) {
                localCluster.updateTargetACLWithRemoteInitiatorNames(primaryVolumeExsposedOnTarget, initiatorNamesOnRemoteCluster, initiatorNamesOnRemoteCluster);
            }
            DRSecondaryVolume secondaryVolume = pairElement.getSecondaryVolume();
            VolumeNode secondaryVolumeNode = secondaryVolume.getRemoteVolume();
            LU secondaryVolumeParentLU = secondaryVolumeNode.getParentLU();
            Target secondaryVolumeExsposedOnTarget = secondaryVolumeParentLU.getParentTarget();
            ArrayList initiatorNamesOnLocalCluster = localCluster.getLocalInitiatorNames();
            if ((initiatorNamesOnLocalCluster = this.addInitiatorNamesForAccumaltor(remoteCluster, initiatorNamesOnLocalCluster, accumaltor)) != null && !initiatorNamesOnLocalCluster.isEmpty()) {
                remoteCluster.updateTargetACLWithRemoteInitiatorNames(secondaryVolumeExsposedOnTarget, initiatorNamesOnLocalCluster, initiatorNamesOnLocalCluster);
            }
        }
    }

    private ArrayList addInitiatorNamesForAccumaltor(Cluster cluster, ArrayList initiatorNames, HashMap accumaltor) {
        ArrayList existInitiatores = (ArrayList)accumaltor.get(cluster);
        if (existInitiatores == null) {
            accumaltor.put(cluster, initiatorNames);
            return initiatorNames;
        }
        ArrayList<String> newInitiatorsNames = new ArrayList<String>();
        Iterator iter = initiatorNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (existInitiatores.contains(name)) continue;
            newInitiatorsNames.add(name);
        }
        existInitiatores.addAll(newInitiatorsNames);
        return newInitiatorsNames;
    }

    private void updateTargetsPortalsBetweenSites(DRPairImpl pairElement) throws RemoteException, IllegalValueException {
        if (this.isDiscoverCompleted()) {
            DRClusterPairImpl localClusterPairElement = (DRClusterPairImpl)pairElement.getLocalElement();
            ClusterImpl localCluster = (ClusterImpl)localClusterPairElement.getCluster();
            DRClusterPairImpl remoteClusterPairElement = (DRClusterPairImpl)pairElement.getRemoteElement();
            ClusterImpl remoteCluster = (ClusterImpl)remoteClusterPairElement.getCluster();
            this.updateTargetsPortalsBetweenClusters(localCluster, remoteCluster);
            this.updateTargetsPortalsBetweenClusters(remoteCluster, localCluster);
        }
    }

    private void updateTargetsPortalsBetweenClusters(ClusterImpl fromCluster, ClusterImpl toCluster) throws RemoteException, IllegalValueException {
        ArrayList fromClusterPortals = fromCluster.getAllClusterTargetPortals();
        for (int index = 0; index < fromClusterPortals.size(); ++index) {
            PortalTableRowImpl portal = (PortalTableRowImpl)fromClusterPortals.get(index);
            portal.synchronizeNewElementOnRemoteCluster(toCluster);
        }
    }

    private void removeInitiatorNameFromTargetsACL(VSwitch vswitch) throws RemoteException, IllegalValueException {
        ArrayList<String> removedInitiatorNames = new ArrayList<String>(1);
        removedInitiatorNames.add(vswitch.getISCSIInitiators()[0].getName());
        ClusterImpl vswitchCluster = (ClusterImpl)vswitch.getCluster();
        int index = 0;
        DRSyncPair[] synchPairs = this.getSyncPairs();
        for (index = 0; index < synchPairs.length; ++index) {
            DRSyncPairImpl syncPairImpl = (DRSyncPairImpl)synchPairs[index];
            this.removeInitiatorNamesFromPairTargetsACL(syncPairImpl, vswitchCluster, removedInitiatorNames);
        }
        DRExtendedPair[] extendedPairs = this.getExtendedPairs();
        for (index = 0; index < extendedPairs.length; ++index) {
            DRExtendedPairImpl extendedPairImpl = (DRExtendedPairImpl)extendedPairs[index];
            this.removeInitiatorNamesFromPairTargetsACL((DRAsyncPairImpl)extendedPairImpl.getPair(), vswitchCluster, removedInitiatorNames);
        }
        DRConsistencyGroup[] consistencyGroup = this.getConsistencyGroups();
        for (index = 0; index < consistencyGroup.length; ++index) {
            DRConsistencyGroupImpl consistencyGroupImpl = (DRConsistencyGroupImpl)consistencyGroup[index];
            DRAsyncPair[] asyncPairs = consistencyGroupImpl.getPairs();
            for (int index1 = 0; index1 < asyncPairs.length; ++index1) {
                this.removeInitiatorNamesFromPairTargetsACL((DRAsyncPairImpl)asyncPairs[index1], vswitchCluster, removedInitiatorNames);
            }
        }
    }

    private void removeInitiatorNamesFromPairTargetsACL(DRPairImpl pairElement, ClusterImpl changedCluster, ArrayList initiatorNames) throws RemoteException, IllegalValueException {
        DRClusterPairImpl localClusterPairElement = (DRClusterPairImpl)pairElement.getLocalElement();
        ClusterImpl localCluster = (ClusterImpl)localClusterPairElement.getCluster();
        DRClusterPairImpl remoteClusterPairElement = (DRClusterPairImpl)pairElement.getRemoteElement();
        ClusterImpl remoteCluster = (ClusterImpl)remoteClusterPairElement.getCluster();
        DRPrimaryVolume primaryVolume = pairElement.getPrimaryVolume();
        VolumeNode primaryVolumeNode = primaryVolume.getLocalVolume();
        LU primaryVolumeParentLU = primaryVolumeNode.getParentLU();
        Target primaryVolumeExsposedOnTarget = primaryVolumeParentLU.getParentTarget();
        DRSecondaryVolume secondaryVolume = pairElement.getSecondaryVolume();
        VolumeNode secondaryVolumeNode = secondaryVolume.getRemoteVolume();
        LU secondaryVolumeParentLU = secondaryVolumeNode.getParentLU();
        Target secondaryVolumeExsposedOnTarget = secondaryVolumeParentLU.getParentTarget();
        if (changedCluster.equals(localCluster)) {
            remoteCluster.removeInitiatorNamesFromTargetACL(secondaryVolumeExsposedOnTarget, initiatorNames);
        }
        if (changedCluster.equals(remoteCluster)) {
            localCluster.removeInitiatorNamesFromTargetACL(primaryVolumeExsposedOnTarget, initiatorNames);
        }
    }

    public ArrayList getDRObjects() throws RemoteException {
        ArrayList drObjects = new ArrayList();
        if (!this.m_consistencyGroups.isEmpty()) {
            drObjects.addAll(this.getPairsOfAllGroupsInList(this.m_consistencyGroups));
        }
        if (!this.m_extendedPairs.isEmpty()) {
            drObjects.addAll(this.getPairsOfAllGroupsInList(this.m_extendedPairs));
        }
        drObjects.addAll(this.m_consistencyGroups);
        drObjects.addAll(this.m_extendedPairs);
        drObjects.addAll(this.m_syncPairs);
        return drObjects;
    }

    public ArrayList getActivateDRObjects() throws RemoteException {
        ArrayList drObjects = new ArrayList();
        drObjects.addAll(this.m_consistencyGroups);
        drObjects.addAll(this.m_extendedPairs);
        drObjects.addAll(this.m_syncPairs);
        return drObjects;
    }

    private ArrayList getAllPairs() throws RemoteException {
        ArrayList pairs = new ArrayList();
        pairs.addAll(this.getPairsOfAllGroupsInList(this.m_consistencyGroups));
        pairs.addAll(this.getPairsOfAllGroupsInList(this.m_extendedPairs));
        pairs.addAll(this.m_syncPairs);
        return pairs;
    }

    private ArrayList getPairsOfAllGroupsInList(ArrayList groupList) throws RemoteException {
        ArrayList pairs = new ArrayList();
        if (groupList != null) {
            for (int i = 0; i < groupList.size(); ++i) {
                DRAbstractConsistencyGroup currGroup = (DRAbstractConsistencyGroup)groupList.get(i);
                ArrayList currPairs = this.getPairsOf(currGroup);
                if (currPairs == null) continue;
                pairs.addAll(currPairs);
            }
        }
        return pairs;
    }

    private ArrayList getPairsOf(DRAbstractConsistencyGroup group) throws RemoteException {
        DRAsyncPair[] pairs = group.getPairs();
        if (pairs != null) {
            ArrayList<DRAsyncPair> pairsList = new ArrayList<DRAsyncPair>(Arrays.asList(pairs));
            return pairsList;
        }
        return null;
    }

    public synchronized AlarmSeverity getPropagatedState() throws RemoteException {
        AlarmSeverity alarmSeverity = AlarmSeverity.OK;
        for (int i = 0; i < this.getDRObjects().size(); ++i) {
            if (alarmSeverity.isMoreSevereThan(((DRLogicObjectImpl)this.getDRObjects().get(i)).getPropagatedState())) continue;
            alarmSeverity = ((DRLogicObjectImpl)this.getDRObjects().get(i)).getPropagatedState();
        }
        return alarmSeverity;
    }

    private void drElementRemoved(DRLogicObjectImpl element) throws RemoteException {
        this.checkAlarms(element, 3);
        this.checkAlarms(element, null, 3);
        ClassID classId = element.getClassId();
        this.removeStubToRefMapping(element.hashKey());
        ElementEventImpl elementEvent = new ElementEventImpl(this, element);
        EventServiceImpl.getInstance().fireElementRemove(elementEvent);
        if (!classId.equals(ClassID.ASYNC_PAIR)) {
            this.getDRLogicObjectList(element.getClassId()).remove(element);
            SystemRootImpl.getInstance().removePropagationStateDependentObjectAndListener(element);
        }
    }

    private void drElementCreated(DRLogicObjectImpl element) throws RemoteException {
        this.setStubToRefMapping(element.hashKey(), element);
        ElementEventImpl elementEvent = new ElementEventImpl(this, element);
        try {
            elementEvent.setParameterList(element.getClientParameterList());
        }
        catch (IllegalValueException ive) {
            logger.error(ive.getMessage());
        }
        EventServiceImpl.getInstance().fireElementCreate(elementEvent);
        element.registerToPropagatedStateChange();
        ClassID classId = element.getClassId();
        if (!classId.equals(ClassID.ASYNC_PAIR)) {
            this.getDRLogicObjectList(element.getClassId()).add(element);
            SystemRootImpl.getInstance().addPropagationStateDependentObjectAndListener(element);
        }
        this.checkAlarms(element, 1);
    }

    private void drElementChanged(DRLogicObjectImpl element) throws RemoteException {
        try {
            this.drElementChanged(element, null, null);
        }
        catch (IllegalValueException e) {
            logger.error(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drElementChanged(DRLogicObjectImpl element, DRClusterLogicObjectImpl clusterDRObject, HashMap changedValues) throws RemoteException, IllegalValueException {
        DRInitialSyncStateConstant isyncState;
        ClassID classId = element.getClassId();
        DRClusterLogicObjectImpl activeElement = element.getActiveElement();
        if (!ClassID.ASYNC_PAIR.equals(classId)) {
            SrBITSConstant replicationState;
            if (activeElement != null && this.isDiscoverCompleted() && ((replicationState = (SrBITSConstant)activeElement.getSrValueOf(MasterParameterCode.DR_REPLICATION_STATE)).contains(DRReplicationStateConstant.PLANNED_FAILOVER) || replicationState.contains(DRReplicationStateConstant.FALLBACK))) {
                DRInitialSyncStateConstant isyncState2 = (DRInitialSyncStateConstant)activeElement.getSrValueOf(MasterParameterCode.DR_INITIAL_SYNC_STATE);
                if (element instanceof DRAbstractConsistencyGroupImpl) {
                    long activePendingPiTs = ((DRClusterAbstractConsistencyGroupImpl)activeElement).getPendingPiTs();
                    DRClusterAbstractConsistencyGroupImpl inactiveElement = (DRClusterAbstractConsistencyGroupImpl)element.getInactiveElement();
                    if (!(activePendingPiTs != 0L || inactiveElement != null && inactiveElement.getPendingPiTs() != 0L || DRInitialSyncStateConstant.OK.equals(isyncState2))) {
                        // empty if block
                    }
                } else if (ClassID.SYNC_PAIR.equals(classId) && !DRInitialSyncStateConstant.OK.equals(isyncState2)) {
                    // empty if block
                }
            }
        } else if (element.getLocalElement() != null && DRInitialSyncStateConstant.IN_PROGRESS.equals(isyncState = (DRInitialSyncStateConstant)element.getLocalElement().getSrValueOf(MasterParameterCode.DR_INITIAL_SYNC_STATE)) && ((DRAsyncPairImpl)element).findLocalCopyToPair() != null) {
            ((DRAsyncPairImpl)element).getLocalSnapshot().offlineCopy(((DRAsyncPairImpl)element).findLocalCopyToPair().getCommKeyClassId());
        }
        if (classId.isDRPairClassId() && !element.isPartial()) {
            this.updateTargetsPortalsBetweenSites((DRPairImpl)element);
            this.updateTargetsACLWithRemoteInitiatorIdentitiesByPair((DRPairImpl)element, new HashMap());
        }
        if (!element.isInDeletionProcess()) {
            ElementEventImpl elementEvent = new ElementEventImpl(this, element);
            elementEvent.setParameterList(element.getClientParameterList());
            if (clusterDRObject == null || clusterDRObject.equals(activeElement) || activeElement == null || activeElement != clusterDRObject && this.isInactiveSideValues(changedValues)) {
                EventServiceImpl.getInstance().fireElementChanged(elementEvent, true);
            } else {
                ClientParameterCode modeCode = MasterParameterCode.DR_MODE.getClientParameterCode(clusterDRObject);
                DRModeConstant changedMode = (DRModeConstant)changedValues.get(modeCode);
                if (changedValues != null && changedMode != null) {
                    EventServiceImpl.getInstance().fireElementChanged(elementEvent, true);
                }
            }
        }
        if (changedValues == null || changedValues.size() > 1 || !changedValues.containsKey(ClientParameterCode.DR_PAIR_ONLINE_INIT_SYNC_DATA_TRANSFFERED)) {
            this.checkAlarms(element, 2);
            if (ClassID.ASYNC_PAIR.equals(classId)) {
                DRAsyncPairImpl asyncPair = (DRAsyncPairImpl)element;
                DRAbstractConsistencyGroupImpl cg = asyncPair.getCg();
                this.checkAlarms(cg, 2);
            }
        }
    }

    private boolean isInactiveSideValues(HashMap parameterList) {
        return parameterList.containsKey(ClientParameterCode.DR_CONSISTENCY_GROUP_LAST_PIT_MERGE) || parameterList.containsKey(ClientParameterCode.DR_ASYNC_PAIR_LAST_PIT_MERGE);
    }

    public DRPairImpl getPairContainsISCSIDisk(VolumeNode volume) throws RemoteException {
        ArrayList pairs = this.getAllPairs();
        int size = pairs.size();
        if (pairs != null && size > 0) {
            for (int i = 0; i < size; ++i) {
                DRPairImpl currPair = (DRPairImpl)pairs.get(i);
                if (!currPair.containsISCSIDisk(volume)) continue;
                return currPair;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyVolumeReplaced(VolumeNodeImpl oldVolume, VolumeNodeImpl newVolume) throws RemoteException {
        Object object = this.m_replacingVolumeLock;
        synchronized (object) {
            ArrayList allPairs = this.getAllPairs();
            Iterator i = allPairs.iterator();
            while (i.hasNext()) {
                DRPairImpl pair = (DRPairImpl)i.next();
                boolean isVolumeReplaced = pair.notifyVolumeReplaced(oldVolume, newVolume);
                if (!isVolumeReplaced) continue;
                this.drElementChanged(pair);
            }
            DRPairImpl drPair = this.getPairUseingVolume(newVolume);
            if (drPair != null) {
                if (drPair.isPartial()) {
                    DRClusterPairImpl elementInPair = (DRClusterPairImpl)drPair.getPartialElement();
                    DRPair[] allPairsArray = allPairs.toArray(new DRPairImpl[allPairs.size()]);
                    DRPairImpl equPair = this.findEquivalentMatchingPair(allPairsArray, elementInPair);
                    if (equPair != null && equPair.isPartial() && equPair.getElement(elementInPair.getRole()) == null) {
                        DRClusterPairImpl elementInEquPair = (DRClusterPairImpl)equPair.getPartialElement();
                        if (elementInEquPair.getClassId().equals(ClassID.ASYNC_PAIR)) {
                            this.removeDRClusterAsyncPair((DRClusterAsyncPairImpl)elementInEquPair, true);
                        } else {
                            this.removeElement(elementInEquPair);
                        }
                        this.newElement(elementInEquPair);
                    }
                }
                this.drElementChanged(drPair);
            }
        }
    }

    public boolean isDiscoverCompleted() throws RemoteException {
        return this.m_isDRDiscoveryCompleted;
    }

    public boolean isAliasExist(String alias) throws RemoteException {
        DRConsistencyGroup[] groups = this.getConsistencyGroups();
        for (int i = 0; i < groups.length; ++i) {
            String currAlias = ((DRConsistencyGroupImpl)groups[i]).getAlias();
            if (!currAlias.equals(alias)) continue;
            return true;
        }
        return false;
    }

    public DRLogicObjectImpl getDRObject(DRLogicObject element) throws RemoteException {
        if (element != null) {
            return this.getRefByStub(element.hashKey());
        }
        return null;
    }

    private static class DRArrayList
    extends ArrayList {
        private DRArrayList() {
        }

        public boolean remove(Object obj) {
            Iterator e = this.iterator();
            if (obj == null) {
                while (e.hasNext()) {
                    if (e.next() != null) continue;
                    e.remove();
                    return true;
                }
            } else {
                while (e.hasNext()) {
                    if (obj != e.next()) continue;
                    e.remove();
                    return true;
                }
            }
            return false;
        }
    }
}

