/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.dr;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRLogicObject;
import com.sanrad.nms.server.logic.dr.DRPiT;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrDouble;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.constants.DRPiTStateConstant;
import java.rmi.RemoteException;
import java.util.HashMap;

public class DRPiTImpl
extends LogicObjectImpl
implements DRPiT {
    private static ParameterCode[] parameterCodeList = new ParameterCode[]{ParameterCode.DR_PIT_PARENT_ID, ParameterCode.DR_PIT_DATE, ParameterCode.DR_PIT_STATE, ParameterCode.DR_PIT_TOTAL_DATA, ParameterCode.DR_PIT_PENDING_DATA, ParameterCode.DR_PIT_LAST_UPDATE, ParameterCode.DR_PIT_TRANSFER_RATE, ParameterCode.VSWITCH_ID};
    private DRLogicObject m_drObjectParent;

    public DRPiTImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
        super(cluster, classId, parameterCodeList);
    }

    DRClusterLogicObjectImpl getClusterObjectParent() throws RemoteException {
        return (DRClusterLogicObjectImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(this.getCommKeyClassIdValueOf(ParameterCode.DR_PIT_PARENT_ID));
    }

    public HashMap getClientParameterList() throws RemoteException {
        HashMap params = super.getClientParameterList();
        params.put(ClientParameterCode.DR_PIT_PARENT, this.m_drObjectParent);
        params.put(ClientParameterCode.DR_PIT_CLUSTER, this.cluster);
        return params;
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        DRPiTStateConstant pitState = (DRPiTStateConstant)parameterList.get(ParameterCode.DR_PIT_STATE);
        SrTimeTicks prevLastUpdate = (SrTimeTicks)this.getSrValueOf(ParameterCode.DR_PIT_LAST_UPDATE);
        SrGauge prevPendingData = (SrGauge)this.getSrValueOf(ParameterCode.DR_PIT_PENDING_DATA);
        SrGauge pendingData = (SrGauge)parameterList.get(ParameterCode.DR_PIT_PENDING_DATA);
        if (prevLastUpdate != null && prevPendingData != null && pendingData != null && !DRPiTStateConstant.FORMING.equals(pitState)) {
            SrTimeTicks lastUpdate = (SrTimeTicks)parameterList.get(ParameterCode.DR_PIT_LAST_UPDATE);
            long transferredData = prevPendingData.longValue() - pendingData.longValue();
            long timePassed = lastUpdate.longValue() - prevLastUpdate.longValue();
            if (timePassed < 30000L && timePassed > 0L) {
                double rate = (double)transferredData / (double)(timePassed / 100L);
                parameterList.put(ParameterCode.DR_PIT_TRANSFER_RATE, new SrDouble(rate));
            } else {
                parameterList.put(ParameterCode.DR_PIT_TRANSFER_RATE, new SrDouble(-1.0));
            }
        } else {
            parameterList.put(ParameterCode.DR_PIT_TRANSFER_RATE, new SrDouble(-1.0));
        }
        return super.setParameterList(parameterList);
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        return null;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public Long getDateAndTime() throws RemoteException {
        return (Long)this.getValueOf(ParameterCode.DR_PIT_DATE);
    }

    public Long getTotalDataMBytes() throws RemoteException {
        return (Long)this.getValueOf(ParameterCode.DR_PIT_TOTAL_DATA);
    }

    public Long getPendingDataMBytes() throws RemoteException {
        return (Long)this.getValueOf(ParameterCode.DR_PIT_PENDING_DATA);
    }

    public DRPiTStateConstant getState() throws RemoteException {
        return (DRPiTStateConstant)this.getValueOf(ParameterCode.DR_PIT_STATE);
    }

    public DRLogicObject getDRObjectParent() throws RemoteException {
        return this.m_drObjectParent;
    }

    public void setDRObjectParent(DRLogicObject drLogicObject) {
        this.m_drObjectParent = drLogicObject;
    }
}

