/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.dr;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.event.PropagatedStateEvent;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObject;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRLogicObject;
import com.sanrad.nms.server.logic.dr.InnerActivate;
import com.sanrad.nms.server.logic.validation.Validator;
import com.sanrad.nms.server.logic.validation.dr.DRValidationKey;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.MasterParameter;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterList;
import com.sanrad.nms.server.util.Parameters;
import com.sanrad.nms.server.util.types.constants.ChangeConstant;
import com.sanrad.nms.server.util.types.constants.DRActivateConstant;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.util.Util;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;

public abstract class DRLogicObjectImpl
extends GeneralLogicObjectImpl
implements DRLogicObject {
    private DRClusterLogicObjectImpl m_localElement = null;
    private DRClusterLogicObjectImpl m_remoteElement = null;
    private CommKeyClassId m_localCommKey = null;
    private CommKeyClassId m_remoteCommKey = null;
    private static final HashMap s_ruleForMode = new HashMap();

    protected DRLogicObjectImpl(DRClusterLogicObjectImpl element, DRRoleConstant role) throws RemoteException {
        super(element.getClassId());
        this.setElement(element, role);
    }

    protected DRLogicObjectImpl(DRClusterLogicObjectImpl element) throws RemoteException {
        this(element, element.getRole());
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        if (this.isInDeletionProcess()) {
            return "Object " + this + " is in deletion process and cannot perform operation";
        }
        return null;
    }

    public void deleteElement() throws RemoteException, IllegalValueException {
        String msg = this.canBeDeleted();
        if (msg != null) {
            logger.debug(msg);
            throw new IllegalValueException(msg);
        }
        if (!this.isInDeletionProcess()) {
            DRClusterLogicObjectImpl remoteElement;
            this.setInDeletionProcess();
            DRClusterLogicObjectImpl localElement = this.getLocalElement();
            if (localElement != null) {
                localElement.deleteElement();
            }
            if ((remoteElement = this.getRemoteElement()) != null) {
                remoteElement.deleteElement();
            }
        } else {
            logger.debug("Delete in process for " + this.getClassId() + " " + this.toString());
        }
    }

    public void changeElement(ClientParameterCode code, Object value) throws RemoteException, IllegalValueException {
        DRClusterLogicObjectImpl remoteElement;
        DRClusterLogicObjectImpl localElement = this.getLocalElement();
        if (value instanceof ChangeConstant) {
            this.validAndActivate((ChangeConstant)value);
        }
        if (localElement != null) {
            localElement.changeElement(code, value);
        }
        if ((remoteElement = this.getRemoteElement()) != null) {
            remoteElement.changeElement(code, value);
        }
    }

    public void changeElement(HashMap parameterList) throws RemoteException, IllegalValueException {
        DRClusterLogicObjectImpl remoteElement;
        DRClusterLogicObjectImpl localElement = this.getLocalElement();
        Iterator iter = parameterList.keySet().iterator();
        while (iter.hasNext()) {
            Object code = iter.next();
            Object value = parameterList.get(code);
            if (!(value instanceof ChangeConstant)) continue;
            this.validAndActivate((ChangeConstant)value);
        }
        if (localElement != null) {
            localElement.changeElement(parameterList);
        }
        if ((remoteElement = this.getRemoteElement()) != null) {
            remoteElement.changeElement(parameterList);
        }
    }

    protected boolean equalsByCommKey(DRLogicObject other) throws RemoteException {
        boolean isLocalEquals = false;
        boolean isRemoteEquals = false;
        if (this.m_localCommKey != null) {
            isLocalEquals = this.m_localCommKey.equals(other.getLocalCommKey());
        }
        if (this.m_remoteCommKey != null) {
            isRemoteEquals = this.m_remoteCommKey.equals(other.getRemoteCommKey());
        }
        return isLocalEquals || isRemoteEquals;
    }

    public boolean isPartial() {
        return !this.isComplete() && !this.isEmpty();
    }

    public boolean isRedundant() throws RemoteException {
        return this.m_localElement != null && this.m_remoteElement != null;
    }

    protected boolean isComplete() {
        return this.m_localElement != null && this.m_remoteElement != null;
    }

    public boolean isEmpty() {
        return this.m_localElement == null && this.m_remoteElement == null;
    }

    public DRClusterLogicObjectImpl getPartialElement() {
        if (!this.isPartial()) {
            return null;
        }
        if (this.m_localElement != null) {
            return this.m_localElement;
        }
        return this.m_remoteElement;
    }

    public boolean hasElement(DRClusterLogicObjectImpl element) {
        if (this.m_localElement != null && this.m_localElement.equals(element)) {
            return true;
        }
        return this.m_remoteElement != null && this.m_remoteElement.equals(element);
    }

    public void removeElement(DRClusterLogicObjectImpl element) {
        if (element.equals(this.m_localElement)) {
            this.m_localElement = null;
        } else if (element.equals(this.m_remoteElement)) {
            this.m_remoteElement = null;
        } else {
            logger.warning("element to be removed does not exist in DR object");
        }
    }

    public void removeElement(DRRoleConstant role) {
        if (role.equals(DRRoleConstant.LOCAL)) {
            this.m_localElement = null;
        } else {
            this.m_remoteElement = null;
        }
    }

    public void setElement(DRClusterLogicObjectImpl element, DRRoleConstant role) throws RemoteException {
        if (role.equals(DRRoleConstant.LOCAL)) {
            if (this.m_localElement == null) {
                this.m_localElement = element;
            } else {
                logger.warning("DR local element " + element + " already exists!");
            }
        } else if (role.equals(DRRoleConstant.REMOTE)) {
            if (this.m_remoteElement == null) {
                this.m_remoteElement = element;
            } else {
                logger.warning("DR remote element " + element + " already exists!");
            }
        } else {
            logger.error("Role of " + element + " is " + role);
            throw new IllegalArgumentException("Role of " + element + " is " + role);
        }
        this.updateCommKeyClassIDs();
    }

    public void updateCommKeyClassIDs() throws RemoteException {
        if (this.m_localElement != null) {
            this.m_localCommKey = this.m_localElement.getCommKeyClassId();
        }
        if (this.m_remoteElement != null) {
            this.m_remoteCommKey = this.m_remoteElement.getCommKeyClassId();
        }
    }

    public void setElement(DRClusterLogicObjectImpl element) throws RemoteException {
        this.setElement(element, element.getRole());
    }

    public DRClusterLogicObjectImpl getLocalElement() {
        return this.m_localElement;
    }

    public DRClusterLogicObjectImpl getRemoteElement() {
        return this.m_remoteElement;
    }

    private DRClusterLogicObjectImpl getActiveElement(DRModeConstant localMode, DRModeConstant remoteMode) throws RemoteException {
        boolean isPlannedFailover = false;
        if (this.m_localElement != null && this.m_remoteElement != null) {
            SrBITSConstant localReplicationState = (SrBITSConstant)this.m_localElement.getSrValueOf(MasterParameterCode.DR_REPLICATION_STATE);
            SrBITSConstant remoteReplicationState = (SrBITSConstant)this.m_remoteElement.getSrValueOf(MasterParameterCode.DR_REPLICATION_STATE);
            if (localReplicationState.contains(DRReplicationStateConstant.PLANNED_FAILOVER) || remoteReplicationState.contains(DRReplicationStateConstant.PLANNED_FAILOVER)) {
                isPlannedFailover = true;
            }
        }
        if (!isPlannedFailover && (DRModeConstant.SWITCHED.equals(localMode) || DRModeConstant.SWITCHED.equals(remoteMode))) {
            return this.m_remoteElement;
        }
        return this.m_localElement;
    }

    public DRClusterLogicObjectImpl getActiveElement() throws RemoteException {
        DRModeConstant localMode = this.m_localElement != null ? this.m_localElement.getMode() : null;
        DRModeConstant remoteMode = this.m_remoteElement != null ? this.m_remoteElement.getMode() : null;
        return this.getActiveElement(localMode, remoteMode);
    }

    public DRClusterLogicObjectImpl getInactiveElement() throws RemoteException {
        SrBITSConstant replicationState;
        DRModeConstant localMode = this.m_localElement != null ? this.m_localElement.getMode() : null;
        DRModeConstant remoteMode = this.m_remoteElement != null ? this.m_remoteElement.getMode() : null;
        boolean isPlannedFailover = false;
        if (this.m_localElement != null && (replicationState = (SrBITSConstant)this.m_localElement.getSrValueOf(MasterParameterCode.DR_REPLICATION_STATE)) != null && replicationState.contains(DRReplicationStateConstant.PLANNED_FAILOVER)) {
            isPlannedFailover = true;
        }
        if (!isPlannedFailover && (DRModeConstant.SWITCHED.equals(localMode) || DRModeConstant.SWITCHED.equals(remoteMode))) {
            return this.m_localElement;
        }
        return this.m_remoteElement;
    }

    public DRClusterLogicObjectImpl getElement(DRRoleConstant role) {
        if (role != null) {
            if (role.equals(DRRoleConstant.LOCAL)) {
                return this.m_localElement;
            }
            if (role.equals(DRRoleConstant.REMOTE)) {
                return this.m_remoteElement;
            }
        }
        return null;
    }

    public HashMap checkConsistencyBetweenVSwitches() throws RemoteException {
        HashMap remote = null;
        HashMap local = null;
        HashMap result = null;
        if (this.m_localElement != null) {
            local = new HashMap(this.m_localElement.getParameters(this.m_localElement.getActiveVswitch()));
            if (this.m_remoteElement != null) {
                remote = new HashMap(this.m_remoteElement.getParameters(this.m_remoteElement.getActiveVswitch()));
                result = new HashMap();
                Iterator iter = local.keySet().iterator();
                while (iter.hasNext()) {
                    Object code = iter.next();
                    if (!((ParameterCode)code).isCodeRelevantForConsistencyCheck() || local.get(code).equals(remote.get(code))) continue;
                    result.put(code, new Object[]{local.get(code), remote.get(code)});
                }
            }
            return result;
        }
        return null;
    }

    public VSwitch[] getConnectedVSwitches() throws RemoteException {
        VSwitch[] localVswitches = null;
        VSwitch[] remoteVswitches = null;
        if (this.m_localElement != null) {
            localVswitches = new VSwitch[this.m_localElement.getConnectedVSwitches().length];
            localVswitches = this.m_localElement.getConnectedVSwitches();
            if (this.m_remoteElement == null) {
                return localVswitches;
            }
        } else {
            return this.m_remoteElement.getConnectedVSwitches();
        }
        remoteVswitches = new VSwitch[this.m_remoteElement.getConnectedVSwitches().length];
        remoteVswitches = this.m_remoteElement.getConnectedVSwitches();
        VSwitch[] vswitches = new VSwitch[localVswitches.length + remoteVswitches.length];
        for (int i = 0; i < localVswitches.length; ++i) {
            vswitches[i] = localVswitches[i];
        }
        for (int j = localVswitches.length; j < localVswitches.length + remoteVswitches.length; ++j) {
            vswitches[j] = remoteVswitches[j - localVswitches.length];
        }
        return vswitches;
    }

    public void sendToNeighbers(MasterParameterCode param) throws RemoteException {
        MasterParameter paramLocal = new MasterParameter(param, this.m_localElement.getSrArrayValueOf(this.m_localElement.getActiveVswitch(), param.getParameterCode(this)));
        ParameterList paramsLocal = new ParameterList(paramLocal);
        this.m_localElement.changeElementInInactiveVswitch(paramsLocal);
        MasterParameter paramRemote = new MasterParameter(param, this.m_remoteElement.getSrArrayValueOf(this.m_remoteElement.getActiveVswitch(), param.getParameterCode(this)));
        ParameterList paramsRemote = new ParameterList(paramRemote);
        this.m_remoteElement.changeElementInInactiveVswitch(paramsRemote);
    }

    public void sendToRemote(MasterParameterCode activateParameterCode) throws RemoteException {
        MasterParameter paramLocal = new MasterParameter(activateParameterCode, this.m_localElement.getSrArrayValueOf(this.m_localElement.getActiveVswitch(), activateParameterCode.getParameterCode(this)));
        ParameterList paramsLocal = new ParameterList(paramLocal);
        this.m_remoteElement.changeElementForActiveVswitch(paramsLocal);
    }

    public HashMap getClientParameterList() throws RemoteException, IllegalValueException {
        String msg = this.isValid(null);
        if (msg != null) {
            throw new IllegalValueException(msg);
        }
        HashMap parameterList = null;
        Cluster localCluster = this.m_localElement != null ? this.m_localElement.getCluster() : null;
        Cluster remoteCluster = this.m_remoteElement != null ? this.m_remoteElement.getCluster() : null;
        DRClusterLogicObjectImpl activeElement = this.getActiveElement();
        DRClusterLogicObjectImpl inactiveElement = this.getInactiveElement();
        if (activeElement != null) {
            parameterList = activeElement.getClientParameterList();
        }
        if (inactiveElement != null && parameterList == null) {
            parameterList = inactiveElement.getClientParameterList();
        }
        if (parameterList != null) {
            parameterList.put(ClientParameterCode.DR_LOCAL_CLUSTER, localCluster);
            parameterList.put(ClientParameterCode.DR_REMOTE_CLUSTER, remoteCluster);
            parameterList.put(ClientParameterCode.PROPAGATION_STATE, this.getPropagatedState());
            this.updateModeAndReplicationStateForClient(parameterList);
            return ElementEventImpl.convertParameterList(parameterList, this);
        }
        throw new IllegalValueException("DR element doesn't contain any cluster elements");
    }

    public Cluster[] getAllClusters() throws RemoteException {
        Cluster[] clusters = new Cluster[]{this.getLocalElement().getCluster(), this.getRemoteElement().getCluster()};
        return clusters;
    }

    public String toString() {
        return this.debugString();
    }

    public String debugString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Local:{");
        if (this.m_localElement != null) {
            sb.append(this.m_localElement.toString());
        }
        sb.append('}');
        sb.append(" , Remote:{");
        if (this.m_remoteElement != null) {
            sb.append(this.m_remoteElement.toString());
        }
        sb.append('}');
        return sb.toString();
    }

    public Cluster getCluster() throws RemoteException {
        return null;
    }

    public DRClusterLogicObjectImpl getClusterElement(Cluster cluster) throws RemoteException {
        if (this.m_localElement != null && this.m_localElement.getCluster().equals(cluster)) {
            return this.m_localElement;
        }
        if (this.m_remoteElement != null && this.m_remoteElement.getCluster().equals(cluster)) {
            return this.m_remoteElement;
        }
        return null;
    }

    public VSwitch getActiveVswitch() throws RemoteException {
        if (this.getActiveElement() != null) {
            return this.getActiveElement().getActiveVswitch();
        }
        return null;
    }

    public VSwitch getInactiveVSwitch() throws RemoteException {
        throw new UnsupportedOperationException("There is no meaning to this function in DR");
    }

    public boolean isParameterCodeExsist(ParameterCode code) {
        if (this.getLocalElement() == null) {
            return this.getRemoteElement().isParameterCodeExsist(code);
        }
        return this.getLocalElement().isParameterCodeExsist(code);
    }

    public boolean isParameterEqual(Parameters param, VSwitch vswitch) {
        return false;
    }

    public DRModeConstant getMode() throws RemoteException {
        if (this.getLocalElement() != null) {
            return this.getLocalElement().getMode();
        }
        return this.getRemoteElement().getMode();
    }

    public void setInDeletionProcess() {
        super.setInDeletionProcess();
        Thread inDeletionTimer = new Thread("inDeletionTimer-" + this.getClass()){

            public void run() {
                try {
                    1.sleep(5000L);
                    DRLogicObjectImpl.this.clearInDeletionProcess();
                }
                catch (InterruptedException e) {
                    logger.error(e);
                }
            }
        };
        inDeletionTimer.start();
    }

    public DRClusterLogicObject getClusterElementAccordingToMode() throws RemoteException {
        DRModeConstant remoteMode;
        DRModeConstant localMode = this.m_localElement != null ? this.m_localElement.getMode() : null;
        DRModeConstant dRModeConstant = remoteMode = this.m_remoteElement != null ? this.m_remoteElement.getMode() : null;
        if (DRModeConstant.SWITCHED.equals(localMode) || DRModeConstant.SWITCHED.equals(remoteMode)) {
            return this.m_remoteElement;
        }
        return this.m_localElement;
    }

    public DRClusterLogicObject getOppositeClusterElementAccordingToMode() throws RemoteException {
        if (this.getMode().equals(DRModeConstant.NORMAL)) {
            return this.getRemoteElement();
        }
        return this.getLocalElement();
    }

    protected DRClusterLogicObjectImpl getNotNullElement() {
        if (this.getLocalElement() != null) {
            return this.getLocalElement();
        }
        return this.getRemoteElement();
    }

    public void validAndActivate(ChangeConstant state) throws RemoteException, IllegalValueException {
        if (!DRActivateConstant.ABORT_REPLICATE.equals(state) && !DRActivateConstant.DISASTER_FAILOVER.equals(state) && state instanceof DRActivateConstant) {
            if (this.isPartial()) {
                throw new IllegalValueException("You cannot activate " + state + " because part of " + this.getClassId() + " " + this + " is not available");
            }
            this.checkThatChildAndFatherAreMached();
            if (this.getLocalElement().getActiveVswitch() != null && this.getRemoteElement().getActiveVswitch() != null) {
                VSwitchImpl localActiveVSwitch = (VSwitchImpl)this.getLocalElement().getActiveVswitch();
                VSwitchImpl remoteActiveVSwitch = (VSwitchImpl)this.getRemoteElement().getActiveVswitch();
                if (localActiveVSwitch != null && !localActiveVSwitch.hasPortalTarget() || remoteActiveVSwitch != null && !remoteActiveVSwitch.hasPortalTarget()) {
                    throw new IllegalValueException("you cannot activate the command since the remote portal are not defined");
                }
            }
            this.checkIfAllPairsAreNonFunctional();
            String valid = this.isValid(null);
            if (valid != null) {
                throw new IllegalValueException(valid);
            }
        }
        ParameterList params = DRValidationKey.createDRKey(state, this.getMode());
        if (this instanceof InnerActivate) {
            Validator.getInstance().isValidAccordingToAlarm((GeneralLogicObjectImpl)((Object)((InnerActivate)((Object)this)).returnSource()), params);
        } else {
            Validator.getInstance().isValidAccordingToAlarm(this, params);
        }
        if (this.m_localElement != null) {
            this.m_localElement.validAndActivate(params);
        }
        if (this.m_remoteElement != null) {
            this.m_remoteElement.validAndActivate(params);
        }
        if (this.m_localElement != null && this.m_remoteElement != null && this.m_localElement.getMode() != null && !this.m_localElement.getMode().equals(this.m_remoteElement.getMode()) && this.isPlanedFailOverOrFallBack()) {
            if (state.equals(DRActivateConstant.ABORT_REPLICATE)) {
                this.getInactiveElement().changeElementForActiveVswitch(new MasterParameter(MasterParameterCode.DR_ACTIVATE.getParameterCode(this.getInactiveElement()), DRActivateConstant.ABORT_REPLICATE));
            } else if (state instanceof DRActivateConstant) {
                throw new IllegalValueException("cannot activate the command since the system is still in the middle of the switch action");
            }
        }
        this.validAndActivateForChildren(state);
        this.validAndActivateForFather(params);
    }

    protected abstract void checkThatChildAndFatherAreMached() throws RemoteException, IllegalValueException;

    protected void validAndActivateForFather(ParameterList params) throws RemoteException, IllegalValueException {
    }

    protected boolean isElementInDisaster() throws RemoteException {
        if (this.getLocalElement() != null && this.getRemoteElement() != null) {
            return !this.getActiveElement().getMode().equals(this.getInactiveElement().getMode());
        }
        return false;
    }

    private boolean isPlanedFailOverOrFallBack() throws RemoteException {
        SrBITSConstant replicationState;
        if (this.m_localElement != null && (replicationState = (SrBITSConstant)this.m_localElement.getSrValueOf(MasterParameterCode.DR_REPLICATION_STATE)) != null && (replicationState.contains(DRReplicationStateConstant.FALLBACK) || replicationState.contains(DRReplicationStateConstant.PLANNED_FAILOVER))) {
            return true;
        }
        return this.m_remoteElement != null && (replicationState = (SrBITSConstant)this.m_remoteElement.getSrValueOf(MasterParameterCode.DR_REPLICATION_STATE)) != null && (replicationState.contains(DRReplicationStateConstant.FALLBACK) || replicationState.contains(DRReplicationStateConstant.PLANNED_FAILOVER));
    }

    protected void checkIfAllPairsAreNonFunctional() throws RemoteException, IllegalValueException {
    }

    protected String canBeDeleted() throws RemoteException {
        try {
            Validator.getInstance().isValidAccordingToAlarm(this, null);
        }
        catch (IllegalValueException e) {
            return e.getMessage();
        }
        return null;
    }

    public boolean isChangeInModeChangedActiveElement(DRClusterLogicObjectImpl changedElement, DRModeConstant newMode) throws RemoteException {
        DRModeConstant remoteMode;
        if (!newMode.equals(changedElement.getMode())) {
            return false;
        }
        DRModeConstant localMode = this.m_localElement != null ? this.m_localElement.getMode() : null;
        DRModeConstant dRModeConstant = remoteMode = this.m_remoteElement != null ? this.m_remoteElement.getMode() : null;
        if (DRRoleConstant.LOCAL.equals(changedElement.getRole())) {
            if (localMode != null) {
                localMode = DRModeConstant.NORMAL.equals(localMode) ? DRModeConstant.SWITCHED : DRModeConstant.NORMAL;
            }
        } else if (remoteMode != null) {
            remoteMode = DRModeConstant.NORMAL.equals(remoteMode) ? DRModeConstant.SWITCHED : DRModeConstant.NORMAL;
        }
        DRClusterLogicObjectImpl active = this.getActiveElement();
        DRClusterLogicObjectImpl oldActive = this.getActiveElement(localMode, remoteMode);
        return active != null && !active.equals(oldActive) || active == null && oldActive != null;
    }

    public CommKeyClassId getLocalCommKey() throws RemoteException {
        if (this.getLocalElement() != null) {
            return this.getLocalElement().getCommKeyClassId();
        }
        return this.m_localCommKey;
    }

    public CommKeyClassId getRemoteCommKey() throws RemoteException {
        if (this.getRemoteElement() != null) {
            return this.getRemoteElement().getCommKeyClassId();
        }
        return this.m_remoteCommKey;
    }

    public abstract void validAndActivateForChildren(ChangeConstant var1) throws RemoteException, IllegalValueException;

    public abstract AlarmGenerator getClusterAlarmGenerator() throws RemoteException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setStateSeverity(AlarmSeverity newState) throws RemoteException {
        Object object = SystemRootImpl.getInstance().getAlarmsUpdateLock();
        synchronized (object) {
            return super.setStateSeverity(newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlarmSeverity getPropagatedState() throws RemoteException {
        Object object = SystemRootImpl.getInstance().getAlarmsUpdateLock();
        synchronized (object) {
            return super.getPropagatedState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlarmSeverity getPropagatedAcknowledgeState() throws RemoteException {
        Object object = SystemRootImpl.getInstance().getAlarmsUpdateLock();
        synchronized (object) {
            return super.getPropagatedAcknowledgeState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAcknowledgeStateSeverity(AlarmSeverity newAckState) throws RemoteException {
        Object object = SystemRootImpl.getInstance().getAlarmsUpdateLock();
        synchronized (object) {
            super.setAcknowledgeStateSeverity(newAckState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropagatedState(AlarmSeverity newPropagatedState) throws RemoteException {
        Object object = SystemRootImpl.getInstance().getAlarmsUpdateLock();
        synchronized (object) {
            super.setPropagatedState(newPropagatedState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagatedStateChanged(PropagatedStateEvent pse) {
        Object object = SystemRootImpl.getInstance().getAlarmsUpdateLock();
        synchronized (object) {
            super.propagatedStateChanged(pse);
        }
    }

    public boolean equalsByCommKey(Object obj) {
        if (obj instanceof DRLogicObject) {
            DRLogicObject element = (DRLogicObject)obj;
            try {
                if (this.getLocalCommKey() == null || element.getLocalCommKey() == null) {
                    if (this.equalsRemoteClusterElement(element)) {
                        logger.warning("Should appear only after rediscover");
                    }
                    return this.equalsRemoteClusterElement(element);
                }
                if (this.getRemoteCommKey() == null || element.getRemoteCommKey() == null) {
                    if (this.equalsLocalClusterElement(element)) {
                        logger.warning("Should appear only after rediscover");
                    }
                    return this.equalsLocalClusterElement(element);
                }
                if (this.equalsLocalClusterElement(element) && this.equalsRemoteClusterElement(element)) {
                    logger.warning("Should appear only after rediscover");
                }
                return this.equalsLocalClusterElement(element) && this.equalsRemoteClusterElement(element);
            }
            catch (RemoteException e) {
                return false;
            }
        }
        return false;
    }

    private boolean equalsLocalClusterElement(DRLogicObject element) throws RemoteException {
        if (this.getLocalCommKey() != null && element.getLocalCommKey() != null) {
            return this.getLocalCommKey().equals(element.getLocalCommKey());
        }
        return false;
    }

    private boolean equalsRemoteClusterElement(DRLogicObject element) throws RemoteException {
        if (this.getRemoteCommKey() != null && element.getRemoteCommKey() != null) {
            return this.getRemoteCommKey().equals(element.getRemoteCommKey());
        }
        return false;
    }

    public void refreshFields(ClientParameterCode[] codes) throws RemoteException {
        if (this.m_localElement != null) {
            this.m_localElement.refreshFields(codes);
        }
        if (this.m_remoteElement != null) {
            this.m_remoteElement.refreshFields(codes);
        }
    }

    private void updateModeAndReplicationStateForClient(HashMap parameterList) throws RemoteException {
        ClientParameterCode mode = ClientParameterCode.getClientParameterCode(MasterParameterCode.DR_MODE.getParameterCode(this));
        ClientParameterCode replicationState = ClientParameterCode.getClientParameterCode(MasterParameterCode.DR_REPLICATION_STATE.getParameterCode(this));
        if (this.getLocalElement() == null) {
            parameterList.put(mode, this.getRemoteElement().getMode());
            parameterList.put(replicationState, this.getRemoteElement().getReplicationState());
        } else if (this.getRemoteElement() == null) {
            parameterList.put(mode, this.getLocalElement().getMode());
            parameterList.put(replicationState, this.getLocalElement().getReplicationState());
        } else {
            KeyForMode key = new KeyForMode(this.getLocalElement().getMode(), this.getLocalElement().getFailOverState(), this.getRemoteElement().getMode(), this.getRemoteElement().getFailOverState());
            if (s_ruleForMode.get(key) == null) {
                logger.error("The mode and the replication state are not valid: replication state local" + this.getLocalElement().getReplicationState() + " mode state local: " + this.getLocalElement().getMode() + " replication state remote " + this.getRemoteElement().getReplicationState() + " mode state remote: " + this.getRemoteElement().getMode());
            } else {
                DRRoleConstant role = (DRRoleConstant)s_ruleForMode.get(key);
                if (role.equals(DRRoleConstant.LOCAL)) {
                    parameterList.put(mode, this.getLocalElement().getMode());
                    parameterList.put(replicationState, this.getLocalElement().getReplicationState());
                } else {
                    parameterList.put(mode, this.getRemoteElement().getMode());
                    parameterList.put(replicationState, this.getRemoteElement().getReplicationState());
                }
                if (!this.getLocalElement().getMode().equals(this.getRemoteElement().getMode())) {
                    parameterList.put(ClientParameterCode.DR_AMBIGUITY, Boolean.TRUE);
                    logger.warning("The mode of the local site is not equal to the remote site, DR element " + this.getClassId() + " " + this + " might be in the middle of Fail over/Fail back " + " local mode: " + this.getLocalElement().getMode() + " remote mode: " + this.getRemoteElement().getMode() + " local state: " + this.getLocalElement().getReplicationState() + " remote state: " + this.getRemoteElement().getReplicationState() + " local cluster " + this.getLocalElement().getCluster() + " with its active " + ClassID.VSWITCH + " " + this.getLocalElement().getActiveVswitch() + " remote cluster " + this.getRemoteElement().getCluster() + " with its active " + ClassID.VSWITCH + " " + this.getRemoteElement().getActiveVswitch());
                }
            }
        }
    }

    static {
        s_ruleForMode.put(new KeyForMode(DRModeConstant.NORMAL, null, DRModeConstant.NORMAL, null), DRRoleConstant.LOCAL);
        s_ruleForMode.put(new KeyForMode(DRModeConstant.NORMAL, DRReplicationStateConstant.PLANNED_FAILOVER, DRModeConstant.NORMAL, DRReplicationStateConstant.PLANNED_FAILOVER), DRRoleConstant.LOCAL);
        s_ruleForMode.put(new KeyForMode(DRModeConstant.SWITCHED, null, DRModeConstant.SWITCHED, null), DRRoleConstant.REMOTE);
        s_ruleForMode.put(new KeyForMode(DRModeConstant.SWITCHED, DRReplicationStateConstant.FALLBACK, DRModeConstant.SWITCHED, DRReplicationStateConstant.FALLBACK), DRRoleConstant.REMOTE);
        s_ruleForMode.put(new KeyForMode(DRModeConstant.NORMAL, null, DRModeConstant.NORMAL, DRReplicationStateConstant.PLANNED_FAILOVER), DRRoleConstant.LOCAL);
        s_ruleForMode.put(new KeyForMode(DRModeConstant.SWITCHED, DRReplicationStateConstant.FALLBACK, DRModeConstant.SWITCHED, null), DRRoleConstant.REMOTE);
        s_ruleForMode.put(new KeyForMode(DRModeConstant.NORMAL, DRReplicationStateConstant.PLANNED_FAILOVER, DRModeConstant.NORMAL, null), DRRoleConstant.LOCAL);
        s_ruleForMode.put(new KeyForMode(DRModeConstant.SWITCHED, null, DRModeConstant.SWITCHED, DRReplicationStateConstant.FALLBACK), DRRoleConstant.REMOTE);
        s_ruleForMode.put(new KeyForMode(DRModeConstant.SWITCHED, null, DRModeConstant.NORMAL, DRReplicationStateConstant.PLANNED_FAILOVER), DRRoleConstant.REMOTE);
        s_ruleForMode.put(new KeyForMode(DRModeConstant.SWITCHED, DRReplicationStateConstant.FALLBACK, DRModeConstant.NORMAL, null), DRRoleConstant.LOCAL);
        s_ruleForMode.put(new KeyForMode(DRModeConstant.NORMAL, null, DRModeConstant.SWITCHED, null), DRRoleConstant.REMOTE);
        s_ruleForMode.put(new KeyForMode(DRModeConstant.SWITCHED, null, DRModeConstant.NORMAL, null), DRRoleConstant.LOCAL);
        s_ruleForMode.put(new KeyForMode(DRModeConstant.NORMAL, DRReplicationStateConstant.PLANNED_FAILOVER, DRModeConstant.SWITCHED, null), DRRoleConstant.LOCAL);
        s_ruleForMode.put(new KeyForMode(DRModeConstant.NORMAL, null, DRModeConstant.SWITCHED, DRReplicationStateConstant.FALLBACK), DRRoleConstant.REMOTE);
    }

    private static class KeyForMode {
        private DRModeConstant m_localMode;
        private DRModeConstant m_remoteMode;
        private DRReplicationStateConstant m_localState;
        private DRReplicationStateConstant m_remoteState;

        private KeyForMode(DRModeConstant localMode, DRReplicationStateConstant localState, DRModeConstant remoteMode, DRReplicationStateConstant remoteState) {
            if (localMode == null || remoteMode == null) {
                throw new NullPointerException();
            }
            this.m_localMode = localMode;
            this.m_remoteMode = remoteMode;
            this.m_localState = localState;
            this.m_remoteState = remoteState;
        }

        public boolean equals(Object obj) {
            if (obj instanceof KeyForMode) {
                KeyForMode key = (KeyForMode)obj;
                if (!this.getLocalMode().equals(key.getLocalMode()) || !this.getRemoteMode().equals(key.getRemoteMode())) {
                    return false;
                }
                return Util.equalsWithNull(this.getLocalReplicationState(), key.getLocalReplicationState()) && Util.equalsWithNull(this.getRemoteReplicationState(), key.getRemoteReplicationState());
            }
            return false;
        }

        public int hashCode() {
            int code = this.getLocalMode().intValue() + this.getRemoteMode().intValue() * 10;
            if (this.getLocalReplicationState() != null) {
                code += this.getLocalReplicationState().intVal() * 100;
            }
            if (this.getRemoteReplicationState() != null) {
                code += this.getRemoteReplicationState().intVal() * 1000;
            }
            return code;
        }

        public DRModeConstant getLocalMode() {
            return this.m_localMode;
        }

        public DRModeConstant getRemoteMode() {
            return this.m_remoteMode;
        }

        public DRReplicationStateConstant getLocalReplicationState() {
            return this.m_localState;
        }

        public DRReplicationStateConstant getRemoteReplicationState() {
            return this.m_remoteState;
        }
    }
}

