/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.dr;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.dr.DRExtendedPairAlarmGenerator;
import com.sanrad.nms.server.alarm.dr.DrClusterExtendedPairAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterExtendedPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.dr.DRAsyncPair;
import com.sanrad.nms.server.logic.dr.DRAsyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRExtendedPair;
import com.sanrad.nms.server.util.ParameterList;
import java.rmi.RemoteException;
import java.util.HashMap;

public class DRExtendedPairImpl
extends DRAbstractConsistencyGroupImpl
implements DRExtendedPair {
    private DRAsyncPair m_pair = null;

    public DRExtendedPairImpl(DRClusterExtendedPairImpl element) throws RemoteException {
        super(element);
    }

    public void addPair(DRAsyncPair newPair) {
        if (this.m_pair == null) {
            this.m_pair = newPair;
        } else if (this.m_pair != newPair) {
            logger.warning("attempt to add an Async Pair " + newPair + " different  than the current extended pair " + this.m_pair);
        }
    }

    public void removePair(DRAsyncPairImpl pair) {
        if (pair.equals(this.m_pair)) {
            this.m_pair = null;
        }
    }

    public boolean hasNoPairs() {
        return this.m_pair == null;
    }

    public DRAsyncPair getPair() throws RemoteException {
        return this.m_pair;
    }

    public DRAsyncPair[] getPairs() {
        if (this.m_pair != null) {
            return new DRAsyncPair[]{this.m_pair};
        }
        return null;
    }

    public int getPendingData() {
        return 0;
    }

    public int getPendingPiTs() {
        return 0;
    }

    public int getOnlineInitSyncDataTransferred() {
        return 0;
    }

    public AlarmGenerator getAlarmGenerator() {
        return DRExtendedPairAlarmGenerator.getInstance();
    }

    public void startInitialSync() throws RemoteException, IllegalValueException {
        this.getPair().startInitialSync();
    }

    public void abortInitialSync() throws RemoteException, IllegalValueException {
        this.getPair().abortInitialSync();
    }

    protected void validAndActivateForPairs(ParameterList params) throws RemoteException, IllegalValueException {
        ((DRClusterLogicObjectImpl)((Object)this.getPair())).validAndActivate(params);
    }

    public HashMap getClientParameterList() throws RemoteException, IllegalValueException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.DR_EXTENDED_PAIR_PAIR, this.getPair());
        return parameterList;
    }

    public AlarmGenerator getClusterAlarmGenerator() {
        return DrClusterExtendedPairAlarmGenerator.getInstance();
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    public int getPairsCount() {
        if (this.m_pair == null) {
            return 0;
        }
        return 1;
    }

    public String toString() {
        try {
            if (this.getPair() != null) {
                return this.getPair().toString();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return super.toString();
    }

    public void deleteElement() throws RemoteException, IllegalValueException {
        if (this.m_pair != null) {
            this.m_pair.deleteElement();
        }
    }
}

