/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.dr;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.dr.DRConsistencyGroupAlarmGenerator;
import com.sanrad.nms.server.alarm.dr.DrClusterConsistencyGroupAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.GeneralAliasObject;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterConsistencyGroupImpl;
import com.sanrad.nms.server.logic.dr.DRAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.dr.DRAsyncPair;
import com.sanrad.nms.server.logic.dr.DRAsyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRConsistencyGroup;
import com.sanrad.nms.server.logic.dr.DRPairImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;

public class DRConsistencyGroupImpl
extends DRAbstractConsistencyGroupImpl
implements DRConsistencyGroup,
GeneralAliasObject {
    private ArrayList m_pairs = null;

    public DRConsistencyGroupImpl(DRClusterConsistencyGroupImpl element) throws RemoteException {
        super(element);
    }

    public void addPair(DRAsyncPair newPair) throws RemoteException, IllegalValueException {
        if (this.m_pairs == null) {
            this.m_pairs = new ArrayList();
        }
        this.m_pairs.add(newPair);
    }

    public void removePair(DRAsyncPairImpl pair) {
        this.m_pairs.remove(pair);
        if (this.m_pairs.size() == 0) {
            this.m_pairs = null;
        }
    }

    public DRAsyncPair[] getPairs() throws RemoteException {
        if (this.m_pairs == null) {
            return null;
        }
        DRAsyncPair[] pairsArray = new DRAsyncPair[this.m_pairs.size()];
        return this.m_pairs.toArray(pairsArray);
    }

    public boolean hasNoPairs() {
        return this.m_pairs == null;
    }

    public int getPendingData() {
        return 0;
    }

    public int getPendingPiTs() {
        return 0;
    }

    public int getOnlineInitSyncDataTransferred() {
        return 0;
    }

    public AlarmGenerator getAlarmGenerator() {
        return DRConsistencyGroupAlarmGenerator.getInstance();
    }

    public void startInitialSync() throws RemoteException, IllegalValueException {
        for (int i = 0; i < this.getPairs().length; ++i) {
            ((DRPairImpl)((Object)this.getPairs()[i])).startInitialSync();
        }
    }

    public void abortInitialSync() throws RemoteException, IllegalValueException {
        for (int i = 0; i < this.getPairs().length; ++i) {
            ((DRAsyncPairImpl)this.getPairs()[i]).abortInitialSync();
        }
    }

    public HashMap getClientParameterList() throws RemoteException, IllegalValueException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.DR_CONSISTENCY_GROUP_PAIRS, this.getPairs());
        return parameterList;
    }

    public AlarmGenerator getClusterAlarmGenerator() {
        return DrClusterConsistencyGroupAlarmGenerator.getInstance();
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    public String getAlias() throws RemoteException {
        if (this.getLocalElement() != null) {
            return ((DRClusterConsistencyGroupImpl)this.getLocalElement()).getAlias();
        }
        return ((DRClusterConsistencyGroupImpl)this.getRemoteElement()).getAlias();
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        if (this.getLocalElement() != null) {
            return ((DRClusterConsistencyGroupImpl)this.getLocalElement()).getAlias();
        }
        return ((DRClusterConsistencyGroupImpl)this.getRemoteElement()).getAlias();
    }

    public String[] checkAliasConsistencyBetweenVSwitches() throws RemoteException {
        String alias2;
        String alias1;
        String[] string = null;
        if (this.getLocalElement() != null && this.getRemoteElement() != null && !(alias1 = ((DRClusterConsistencyGroupImpl)this.getLocalElement()).getAlias()).equals(alias2 = ((DRClusterConsistencyGroupImpl)this.getLocalElement()).getAlias())) {
            string = new String[]{alias1, alias2};
        }
        return string;
    }

    public CommKey[] getCommKeys() throws RemoteException {
        return null;
    }

    public CommKeyClassId getCommKeyClassId() throws RemoteException {
        return null;
    }

    public String toString() {
        try {
            return this.getAlias();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getPairsCount() {
        if (this.m_pairs == null) {
            return 0;
        }
        return this.m_pairs.size();
    }

    protected void checkIfAllPairsAreNonFunctional() throws RemoteException, IllegalValueException {
        DRAsyncPair[] pairs = this.getPairs();
        for (int i = 0; i < pairs.length; ++i) {
            if (!pairs[i].checkNonFunctionalOfVolumes()) continue;
            return;
        }
        throw new IllegalValueException("Can't activate the command since all the pairs are non functional");
    }

    protected void checkThatChildAndFatherAreMached() throws RemoteException, IllegalValueException {
    }
}

