/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.dr;

import com.sanrad.nms.server.logic.CommKeyRefMap;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRActivate;
import com.sanrad.nms.server.logic.dr.DRLogicObjectImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.MasterParameter;
import com.sanrad.nms.server.util.types.constants.DRActivateConstant;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import java.rmi.RemoteException;

public abstract class DRActivateImpl
extends DRLogicObjectImpl
implements DRActivate {
    protected DRActivateImpl(DRClusterLogicObjectImpl element) throws RemoteException {
        super(element);
    }

    public void plannedFailover() throws RemoteException, IllegalValueException {
        this.validAndActivate(DRActivateConstant.PLANNED_FAILOVER);
        this.getLocalElement().changeElementForActiveVswitch(new MasterParameter(this.getLocalElement().getActivateParameterCode(), DRActivateConstant.PLANNED_FAILOVER));
    }

    public void disasterOccured() throws RemoteException, IllegalValueException {
        DRClusterLogicObjectImpl localElement = this.getLocalElement();
        DRClusterLogicObjectImpl remoteElement = this.getRemoteElement();
        if (remoteElement == null) {
            return;
        }
        try {
            this.validAndActivate(DRActivateConstant.DISASTER_FAILOVER);
        }
        catch (IllegalValueException e) {
            if (localElement != null) {
                Cluster localCluster = localElement.getCluster();
                localCluster.deleteElement();
            }
            return;
        }
        catch (UnsupportedOperationException e) {
            if (localElement != null) {
                Cluster localCluster = localElement.getCluster();
                localCluster.deleteElement();
            }
            return;
        }
        if (this.getRemoteElement().getMode().equals(DRModeConstant.NORMAL)) {
            this.getRemoteElement().changeElementForActiveVswitch(new MasterParameter(this.getRemoteElement().getActivateParameterCode(), DRActivateConstant.DISASTER_FAILOVER));
        }
        if (localElement != null) {
            Cluster localCluster = localElement.getCluster();
            localCluster.deleteElement();
        }
        logger.debug("disaster fail over has occured");
    }

    public void fallback() throws RemoteException, IllegalValueException {
        this.validAndActivate(DRActivateConstant.FALLBACK);
        this.getRemoteElement().changeElementForActiveVswitch(new MasterParameter(this.getRemoteElement().getActivateParameterCode(), DRActivateConstant.FALLBACK));
    }

    public void activateAndSwitch(DRActivateConstant state) throws RemoteException, IllegalValueException {
    }

    public void startReplicate() throws RemoteException, IllegalValueException {
        this.validAndActivate(DRActivateConstant.START_REPLICATE);
        logger.debug("start replicate has occured");
        ((LogicObjectImpl)((Object)this.getClusterElementAccordingToMode())).changeElementForActiveVswitch(new MasterParameter(((DRClusterLogicObjectImpl)this.getClusterElementAccordingToMode()).getActivateParameterCode(), DRActivateConstant.START_REPLICATE));
    }

    public void abortReplicate() throws RemoteException, IllegalValueException {
        try {
            this.validAndActivate(DRActivateConstant.ABORT_REPLICATE);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        catch (IllegalValueException ive) {
            return;
        }
        logger.debug("abort replicate has occured");
        ((LogicObjectImpl)((Object)this.getClusterElementAccordingToMode())).changeElementForActiveVswitch(new MasterParameter(((DRClusterLogicObjectImpl)this.getClusterElementAccordingToMode()).getActivateParameterCode(), DRActivateConstant.ABORT_REPLICATE));
    }

    public Cluster getCluster() throws RemoteException {
        return null;
    }

    public CommKeyRefMap getCommKeyRefMap() throws RemoteException {
        return null;
    }

    public VSwitch[] getConnectedVSwitchesList() throws RemoteException {
        return null;
    }
}

