/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.dr;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRAbstractConsistencyGroup;
import com.sanrad.nms.server.logic.dr.DRActivateImpl;
import com.sanrad.nms.server.logic.dr.DRAsyncElement;
import com.sanrad.nms.server.logic.dr.DRAsyncPair;
import com.sanrad.nms.server.logic.dr.DRAsyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRPairImpl;
import com.sanrad.nms.server.logic.dr.DRPiT;
import com.sanrad.nms.server.logic.dr.DRPiTContainer;
import com.sanrad.nms.server.logic.dr.DRPiTImpl;
import com.sanrad.nms.server.logic.dr.PairEqualityState;
import com.sanrad.nms.server.logic.policies.Policy;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.MasterParameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.ChangeConstant;
import com.sanrad.nms.server.util.types.constants.DRActivateConstant;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public abstract class DRAbstractConsistencyGroupImpl
extends DRActivateImpl
implements DRAbstractConsistencyGroup,
DRAsyncElement,
DRPiTContainer {
    private ArrayList m_pits = new ArrayList();

    protected DRAbstractConsistencyGroupImpl(DRClusterAbstractConsistencyGroupImpl element) throws RemoteException {
        super(element);
    }

    public static boolean equivalent(DRClusterAbstractConsistencyGroupImpl group1, DRClusterAbstractConsistencyGroupImpl group2) throws RemoteException {
        DRClusterAsyncPair[] group1Pairs = group1.getPairs();
        DRClusterAsyncPair[] group2Pairs = group2.getPairs();
        if (group1Pairs == null || group2Pairs == null || group1Pairs.length == 0 || group2Pairs.length == 0) {
            return false;
        }
        boolean foundEquivalentPair = false;
        for (int i = 0; i < group1Pairs.length; ++i) {
            boolean foundNearlyEquivalentPairs = false;
            for (int j = 0; j < group2Pairs.length; ++j) {
                PairEqualityState state = DRPairImpl.equivalent(group1Pairs[i], group2Pairs[j]);
                if (state.isEquivalent()) {
                    foundEquivalentPair = true;
                    break;
                }
                if (state.isUnEquivalentVolPair()) continue;
                foundNearlyEquivalentPairs = true;
                break;
            }
            if (foundNearlyEquivalentPairs || foundEquivalentPair) continue;
            return false;
        }
        return foundEquivalentPair;
    }

    public DRPiT[] getPiTs() throws RemoteException {
        return this.m_pits.toArray(new DRPiT[this.m_pits.size()]);
    }

    public void refreshPiTs() throws RemoteException {
        DRClusterAbstractConsistencyGroupImpl remoteGroup;
        DRClusterAbstractConsistencyGroupImpl localGroup = (DRClusterAbstractConsistencyGroupImpl)this.getLocalElement();
        if (localGroup != null) {
            localGroup.refreshPiTs(this.getClusterPiTs((ClusterImpl)localGroup.getCluster()));
        }
        if ((remoteGroup = (DRClusterAbstractConsistencyGroupImpl)this.getRemoteElement()) != null) {
            remoteGroup.refreshPiTs(this.getClusterPiTs((ClusterImpl)remoteGroup.getCluster()));
        }
    }

    public Policy getPitPolicy() throws RemoteException {
        DRClusterAbstractConsistencyGroupImpl localGroup = (DRClusterAbstractConsistencyGroupImpl)this.getLocalElement();
        if (localGroup != null) {
            return localGroup.getPiTPolicy(null);
        }
        DRClusterAbstractConsistencyGroupImpl remoteGroup = (DRClusterAbstractConsistencyGroupImpl)this.getRemoteElement();
        if (remoteGroup != null) {
            return remoteGroup.getPiTPolicy(null);
        }
        return null;
    }

    public Policy getTransferPolicy() throws RemoteException {
        DRClusterAbstractConsistencyGroupImpl localGroup = (DRClusterAbstractConsistencyGroupImpl)this.getLocalElement();
        if (localGroup != null) {
            return localGroup.getTransferPolicy(null);
        }
        DRClusterAbstractConsistencyGroupImpl remoteGroup = (DRClusterAbstractConsistencyGroupImpl)this.getRemoteElement();
        if (remoteGroup != null) {
            return remoteGroup.getTransferPolicy(null);
        }
        return null;
    }

    public Policy getMergePolicy() throws RemoteException {
        DRClusterAbstractConsistencyGroupImpl localGroup = (DRClusterAbstractConsistencyGroupImpl)this.getLocalElement();
        if (localGroup != null) {
            return localGroup.getMergePolicy(null);
        }
        DRClusterAbstractConsistencyGroupImpl remoteGroup = (DRClusterAbstractConsistencyGroupImpl)this.getRemoteElement();
        if (remoteGroup != null) {
            return remoteGroup.getMergePolicy(null);
        }
        return null;
    }

    public boolean hasEquivalentElement(DRClusterAbstractConsistencyGroupImpl element) throws RemoteException {
        DRClusterAbstractConsistencyGroupImpl localElement = (DRClusterAbstractConsistencyGroupImpl)this.getLocalElement();
        DRClusterAbstractConsistencyGroupImpl remoteElement = (DRClusterAbstractConsistencyGroupImpl)this.getRemoteElement();
        if (this.isComplete()) {
            return false;
        }
        boolean isLocal = element.isLocal();
        if (isLocal && remoteElement != null) {
            return DRAbstractConsistencyGroupImpl.equivalent(remoteElement, element);
        }
        if (!isLocal && localElement != null) {
            return DRAbstractConsistencyGroupImpl.equivalent(localElement, element);
        }
        return false;
    }

    public void forceReplicate() throws RemoteException, IllegalValueException {
        this.getLocalElement().changeElementForActiveVswitch(new MasterParameter(this.getLocalElement().getActivateParameterCode(), DRActivateConstant.FORCE_REPLICATION));
    }

    public DRClusterAbstractConsistencyGroupImpl getDRClusterGroup(CommKeyClassId clusterGroupKey) throws RemoteException {
        DRClusterAbstractConsistencyGroupImpl localGroup = (DRClusterAbstractConsistencyGroupImpl)this.getLocalElement();
        DRClusterAbstractConsistencyGroupImpl remoteGroup = (DRClusterAbstractConsistencyGroupImpl)this.getRemoteElement();
        if (localGroup != null && localGroup.getCommKeyClassId().equals(clusterGroupKey)) {
            return localGroup;
        }
        if (remoteGroup != null && remoteGroup.getCommKeyClassId().equals(clusterGroupKey)) {
            return remoteGroup;
        }
        return null;
    }

    public boolean containsDRClusterGroup(CommKeyClassId clusterGroupKey) throws RemoteException {
        return this.getDRClusterGroup(clusterGroupKey) != null;
    }

    public void validAndActivateForChildren(ChangeConstant state) throws RemoteException, IllegalValueException {
        DRAsyncPair[] pairs = this.getPairs();
        int i = pairs.length;
        while (i-- > 0) {
            ((DRAsyncPairImpl)pairs[i]).validAndActivate(state);
        }
    }

    public boolean comparePolicies() throws RemoteException {
        if (this.getLocalElement() == null || this.getRemoteElement() == null) {
            return false;
        }
        if (((DRClusterAbstractConsistencyGroupImpl)this.getLocalElement()).getPiTPolicy(this.getLocalElement().getActiveVswitch()) == null) {
            return false;
        }
        DRClusterLogicObjectImpl localElement = this.getLocalElement();
        DRClusterLogicObjectImpl remoteElement = this.getRemoteElement();
        VSwitch localActiveVSwitch = localElement.getActiveVswitch();
        VSwitch remoteActiveVSwitch = remoteElement.getActiveVswitch();
        Policy localElementMergePolicy = ((DRClusterAbstractConsistencyGroupImpl)localElement).getMergePolicy(localActiveVSwitch);
        Policy remoteElementMergePolicy = ((DRClusterAbstractConsistencyGroupImpl)remoteElement).getMergePolicy(remoteActiveVSwitch);
        Policy localElementPiTPolicy = ((DRClusterAbstractConsistencyGroupImpl)localElement).getPiTPolicy(localActiveVSwitch);
        Policy remoteElementPiTPolicy = ((DRClusterAbstractConsistencyGroupImpl)remoteElement).getPiTPolicy(remoteActiveVSwitch);
        Policy localElementTransferPolicy = ((DRClusterAbstractConsistencyGroupImpl)localElement).getTransferPolicy(localActiveVSwitch);
        Policy remoteElementTransferPolicy = ((DRClusterAbstractConsistencyGroupImpl)remoteElement).getTransferPolicy(remoteActiveVSwitch);
        if (localElementMergePolicy == null || localElementPiTPolicy == null || localElementTransferPolicy == null || remoteElementMergePolicy == null || remoteElementPiTPolicy == null || remoteElementTransferPolicy == null) {
            return false;
        }
        return localElementMergePolicy.equals(remoteElementMergePolicy) && localElementPiTPolicy.getValue().equals(remoteElementPiTPolicy.getValue()) && localElementTransferPolicy.getValue().equals(remoteElementTransferPolicy.getValue());
    }

    public HashMap getClientParameterList() throws RemoteException, IllegalValueException {
        Object pits;
        HashMap parameterList = super.getClientParameterList();
        DRClusterAbstractConsistencyGroupImpl activeCG = (DRClusterAbstractConsistencyGroupImpl)this.getActiveElement();
        DRClusterAbstractConsistencyGroupImpl inactiveCG = (DRClusterAbstractConsistencyGroupImpl)this.getInactiveElement();
        if (activeCG != null) {
            pits = activeCG.getValueOf(ParameterCode.DR_CONSISTENCY_GROUP_PENDING_PITS);
            Object data = activeCG.getValueOf(ParameterCode.DR_CONSISTENCY_GROUP_PENDING_DATA);
            parameterList.put(ClientParameterCode.DR_CONSISTENCY_GROUP_NOT_REPLICATED_PITS, pits);
            parameterList.put(ClientParameterCode.DR_CONSISTENCY_GROUP_NOT_REPLICATED_DATA, data);
            parameterList.remove(ClientParameterCode.DR_CONSISTENCY_GROUP_LAST_PIT_MERGE);
        }
        if (inactiveCG != null) {
            pits = inactiveCG.getValueOf(ParameterCode.DR_CONSISTENCY_GROUP_PENDING_PITS);
            parameterList.put(ClientParameterCode.DR_CONSISTENCY_GROUP_NOT_MERGED_PITS, pits);
            Object lastMerge = inactiveCG.getValueOf(ParameterCode.DR_CONSISTENCY_GROUP_LAST_PIT_MERGE);
            parameterList.put(ClientParameterCode.DR_CONSISTENCY_GROUP_LAST_PIT_MERGE, lastMerge);
        }
        return parameterList;
    }

    protected void checkIfAllPairsAreNonFunctional() throws RemoteException, IllegalValueException {
        DRAsyncPair[] pairs = this.getPairs();
        for (int i = 0; i < pairs.length; ++i) {
            if (!pairs[i].checkNonFunctionalOfVolumes()) continue;
            return;
        }
        throw new IllegalValueException("Can't activate the command since all the pairs are non functional");
    }

    public DRInitialSyncStateConstant calculateInitialSyncState() throws RemoteException {
        return null;
    }

    public void addPiT(DRPiTImpl pit) {
        if (!this.m_pits.contains(pit)) {
            this.m_pits.add(pit);
        }
    }

    public void removePiT(DRPiTImpl pit) {
        this.m_pits.remove(pit);
    }

    public DRPiTImpl[] clearClusterPiTs(ClusterImpl cluster) {
        ArrayList<DRPiTImpl> removedPits = new ArrayList<DRPiTImpl>();
        Iterator i = this.m_pits.iterator();
        while (i.hasNext()) {
            DRPiTImpl pit = (DRPiTImpl)i.next();
            try {
                if (!pit.getCluster().equals(cluster)) continue;
                removedPits.add(pit);
                i.remove();
            }
            catch (RemoteException e) {
                logger.error(e);
            }
        }
        return removedPits.toArray(new DRPiTImpl[removedPits.size()]);
    }

    public DRPiTImpl[] getClusterPiTs(ClusterImpl cluster) {
        ArrayList<DRPiTImpl> pitList = new ArrayList<DRPiTImpl>();
        Iterator i = this.m_pits.iterator();
        while (i.hasNext()) {
            DRPiTImpl pit = (DRPiTImpl)i.next();
            try {
                if (!pit.getCluster().equals(cluster)) continue;
                pitList.add(pit);
            }
            catch (RemoteException e) {
                logger.error(e);
            }
        }
        return pitList.toArray(new DRPiTImpl[pitList.size()]);
    }

    protected void checkThatChildAndFatherAreMached() throws RemoteException, IllegalValueException {
    }

    public abstract boolean hasNoPairs();

    public abstract void addPair(DRAsyncPair var1) throws RemoteException, IllegalValueException;

    public abstract void removePair(DRAsyncPairImpl var1);

    public abstract int getPairsCount();
}

