/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster.dr;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterSyncPair;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import java.rmi.RemoteException;
import java.util.HashMap;

public class DRClusterSyncPairImpl
extends DRClusterPairImpl
implements DRClusterSyncPair {
    public DRClusterSyncPairImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.SYNC_PAIR);
        this.addParameterCode(ParameterCode.DR_SYNC_PAIR_ACTIVATE);
        this.addParameterCode(ParameterCode.DR_SYNC_PAIR_REPLICATION_STATE);
        this.addParameterCode(ParameterCode.DR_SYNC_PAIR_ROLE);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        DRRoleConstant role = (DRRoleConstant)changedValues.get(ParameterCode.DR_SYNC_PAIR_ROLE);
        if (role != null) {
            this.setRole(role);
        }
        return changedValues;
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        return null;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    public ParameterCode getActivateParameterCode() {
        return ParameterCode.DR_SYNC_PAIR_ACTIVATE;
    }

    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public void deleteElement() throws RemoteException, IllegalValueException {
        ConfigElementData ced = new ConfigElementData(this.getCommKeys(), this.getClassId());
        if (DRRoleConstant.REMOTE.equals(this.getRole())) {
            ced.setValue(ParameterCode.DR_PAIR_PRIMARY_ID, this.getPrimaryVolumeId());
        } else if (DRRoleConstant.LOCAL.equals(this.getRole())) {
            ced.setValue(ParameterCode.DR_PAIR_SECONDARY_ID, this.getSecondaryVolumeId());
        }
        super.deleteElement(ced);
    }
}

