/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster.dr;

import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterPair;
import com.sanrad.nms.server.logic.lu.LU;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.nms.server.util.types.constants.DRVolumeTypeConstant;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;

public abstract class DRClusterPairImpl
extends DRClusterLogicObjectImpl
implements DRClusterPair {
    protected DRRoleConstant m_role;
    private static ParameterCode[] m_parameterCodeList = new ParameterCode[]{ParameterCode.DR_PAIR_PRIMARY_ID, ParameterCode.DR_PAIR_SECONDARY_ID, ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, ParameterCode.DR_PAIR_MODE, ParameterCode.DR_PAIR_STATE, ParameterCode.DR_PAIR_INITIAL_SYNC_STATE, ParameterCode.DR_PAIR_ONLINE_INIT_SYNC_DATA_TRANSFFERED};

    protected DRClusterPairImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
        super(cluster, classId, m_parameterCodeList);
    }

    protected DRClusterPairImpl(ClusterImpl cluster, ClassID classId, List parameterCodeList) throws RemoteException {
        super(cluster, classId, parameterCodeList);
    }

    public void setRole(DRRoleConstant role) {
        this.m_role = role;
    }

    public boolean isLocal() {
        return this.getRole().equals(DRRoleConstant.LOCAL);
    }

    public DRRoleConstant getRole() {
        return this.m_role;
    }

    public VolumeNode getPrimaryVolume() throws RemoteException {
        CommKeyClassId primaryId = this.getPrimaryVolumeId();
        if (primaryId == null) {
            return null;
        }
        return (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(primaryId);
    }

    public VolumeNode getPrimaryVolume(VSwitch vSwitch) throws RemoteException {
        CommKeyClassId primaryId = this.getPrimaryVolumeId(vSwitch);
        if (primaryId == null) {
            return null;
        }
        return (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(primaryId);
    }

    public boolean isIllegalVolPair() throws RemoteException {
        if (this.getPrimaryVolume(this.getActiveVswitch()) == null || this.getSecondaryVolume(this.getActiveVswitch()) == null) {
            return false;
        }
        return !this.getPrimaryVolume(this.getActiveVswitch()).equals(this.getPrimaryVolume(this.getInactiveVSwitch())) && this.getSecondaryVolume(this.getActiveVswitch()).equals(this.getSecondaryVolume(this.getInactiveVSwitch()));
    }

    public VolumeNode getSecondaryVolume() throws RemoteException {
        CommKeyClassId secondaryId = this.getSecondaryVolumeId();
        if (secondaryId == null) {
            return null;
        }
        return (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(secondaryId);
    }

    public VolumeNode getSecondaryVolume(VSwitch vSwitch) throws RemoteException {
        CommKeyClassId secondaryId = this.getSecondaryVolumeId(vSwitch);
        if (secondaryId == null) {
            return null;
        }
        return (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(secondaryId);
    }

    public DRPairInitialSyncTypeConstant getInitialSyncType() throws RemoteException {
        return (DRPairInitialSyncTypeConstant)this.getSrValueOf(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE);
    }

    public DRPairInitialSyncTypeConstant getInitialSyncType(VSwitch vSwitch) throws RemoteException {
        return (DRPairInitialSyncTypeConstant)this.getSrValueOf(vSwitch, ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, vSwitch == null);
    }

    public DRInitialSyncStateConstant getInitialSyncState() throws RemoteException {
        return (DRInitialSyncStateConstant)this.getSrValueOf(ParameterCode.DR_PAIR_INITIAL_SYNC_STATE);
    }

    public DRInitialSyncStateConstant getInitialSyncState(VSwitch vSwitch) throws RemoteException {
        return (DRInitialSyncStateConstant)this.getSrValueOf(vSwitch, ParameterCode.DR_PAIR_INITIAL_SYNC_STATE, vSwitch == null);
    }

    public LU getLUOfExposedVolume() throws RemoteException {
        VolumeNode secondaryVol;
        DRRoleConstant role = this.getRole();
        if (DRRoleConstant.LOCAL.equals(role)) {
            VolumeNode primaryVol = this.getPrimaryVolume();
            if (primaryVol.isExposed()) {
                return primaryVol.getParentLU();
            }
        } else if (DRRoleConstant.REMOTE.equals(role) && (secondaryVol = this.getSecondaryVolume()).isExposed()) {
            return secondaryVol.getParentLU();
        }
        return null;
    }

    public CommKeyClassId getPrimaryVolumeId(VSwitch vSwitch) throws RemoteException {
        return (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.DR_PAIR_PRIMARY_ID, vSwitch == null);
    }

    public CommKeyClassId getPrimaryVolumeId() throws RemoteException {
        return this.getCommKeyClassIdValueOf(ParameterCode.DR_PAIR_PRIMARY_ID);
    }

    public CommKeyClassId getSecondaryVolumeId(VSwitch vSwitch) throws RemoteException {
        return (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.DR_PAIR_SECONDARY_ID, vSwitch == null);
    }

    public CommKeyClassId getSecondaryVolumeId() throws RemoteException {
        return this.getCommKeyClassIdValueOf(ParameterCode.DR_PAIR_SECONDARY_ID);
    }

    public VolumeNode getVolume(DRVolumeTypeConstant volumeType) throws RemoteException {
        if (volumeType.equals(DRVolumeTypeConstant.PRIMARY)) {
            return this.getPrimaryVolume();
        }
        return this.getSecondaryVolume();
    }

    private boolean isSamePairObject(VolumeNodeImpl primary, VolumeNodeImpl secondary) throws RemoteException {
        VSwitch vSwitch = this.getActiveVswitch();
        CommKeyClassId currentPrimaryId = this.getPrimaryVolumeId(vSwitch);
        CommKeyClassId currentSecondaryId = this.getSecondaryVolumeId(vSwitch);
        VolumeNodeImpl currentPrimary = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(currentPrimaryId);
        VolumeNodeImpl currentSecondary = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(currentSecondaryId);
        return currentPrimary.equals(primary) && currentSecondary.equals(secondary) || currentPrimary.equals(secondary) && currentSecondary.equals(primary);
    }

    public boolean isInternalDR() throws RemoteException {
        return this.getPrimaryVolume().getParentLU() == null && this.getSecondaryVolume().getParentLU() == null;
    }

    public VolumeNodeImpl getInternalVolume() throws RemoteException {
        return (VolumeNodeImpl)(this.isLocal() ? this.getSecondaryVolume() : this.getPrimaryVolume());
    }

    public VolumeNodeImpl getExposedVolume() throws RemoteException {
        return (VolumeNodeImpl)(this.isLocal() ? this.getPrimaryVolume() : this.getSecondaryVolume());
    }

    public boolean equalsInCluster(HashMap parameterList) throws RemoteException {
        CommKeyClassId primaryID = (CommKeyClassId)parameterList.get(ParameterCode.DR_PAIR_PRIMARY_ID);
        CommKeyClassId secondaryID = (CommKeyClassId)parameterList.get(ParameterCode.DR_PAIR_SECONDARY_ID);
        VolumeNodeImpl primaryVolume = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(primaryID);
        VolumeNodeImpl secondaryVolume = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(secondaryID);
        return this.isSamePairObject(primaryVolume, secondaryVolume);
    }

    public VSwitch getDominentVswitch() throws RemoteException {
        VSwitch[] vSwitches = this.getConnectedVSwitches();
        VSwitch result = null;
        if (vSwitches.length > 0) {
            if (vSwitches.length == 1) {
                return vSwitches[0];
            }
            if (DRModeConstant.NORMAL.equals(this.getSrValueOf(vSwitches[0], ParameterCode.DR_PAIR_MODE))) {
                if (this.getRole().equals(DRRoleConstant.LOCAL) && this.getPrimaryVolume() != null) {
                    result = this.getPrimaryVolume().getActiveVswitch();
                }
                if (this.getRole().equals(DRRoleConstant.REMOTE) && this.getSecondaryVolume() != null) {
                    result = this.getSecondaryVolume().getActiveVswitch();
                }
            } else if (DRModeConstant.SWITCHED.equals(this.getSrValueOf(vSwitches[0], ParameterCode.DR_PAIR_MODE))) {
                if (this.getRole().equals(DRRoleConstant.REMOTE) && this.getSecondaryVolume() != null) {
                    result = this.getSecondaryVolume().getActiveVswitch();
                }
                if (this.getRole().equals(DRRoleConstant.LOCAL) && this.getPrimaryVolume() != null) {
                    result = this.getPrimaryVolume().getActiveVswitch();
                }
            }
        }
        if (result != null && this.getConnectedVSwitchesAsVector().contains(result) && result.isConnected()) {
            return result;
        }
        return super.getDominentVswitch();
    }

    public HashMap getClientParameterList() throws RemoteException {
        VSwitch vs = this.getActiveVswitch();
        if (vs != null) {
            HashMap parameterList = this.getParameters(vs);
            return ElementEventImpl.convertParameterList(parameterList, this);
        }
        return super.getClientParameterList();
    }

    public String toString() {
        VolumeNode pri = null;
        VolumeNode sec = null;
        try {
            if (this.getConnectedVSwitches().length > 0) {
                pri = this.getPrimaryVolume();
                sec = this.getSecondaryVolume();
            }
        }
        catch (RemoteException re) {
            logger.error(re);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" ");
        if (pri != null) {
            sb.append(pri);
        }
        sb.append(" - ");
        if (sec != null) {
            sb.append(sec);
        }
        sb.append(' ');
        return sb.toString();
    }

    public void refreshInitialSyncProgress() throws RemoteException {
        this.refreshFields(new ParameterCode[]{ParameterCode.DR_PAIR_ONLINE_INIT_SYNC_DATA_TRANSFFERED});
    }

    public DRPairInitialSyncTypeConstant getInitalSyncType() throws RemoteException {
        return (DRPairInitialSyncTypeConstant)this.getSrValueOf(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap params = super.setParameterList(parameterList);
        VolumeNodeImpl primaryVolume = (VolumeNodeImpl)this.getPrimaryVolume();
        VolumeNodeImpl secondaryVolume = (VolumeNodeImpl)this.getSecondaryVolume();
        if (primaryVolume != null) {
            primaryVolume.addMergeListener(this);
        }
        if (secondaryVolume != null) {
            secondaryVolume.addMergeListener(this);
        }
        return params;
    }

    protected void notifyChildElementsWillBeMerged(LogicObjectImpl childElement, LogicObjectImpl mantainedElement) throws RemoteException {
        DRClusterPairImpl mantainedPair = this.cluster.getDRManager().getPair((VolumeNodeImpl)mantainedElement);
        if (mantainedPair == null) {
            return;
        }
        VolumeNode primVolume = this.getPrimaryVolume();
        VolumeNode secVolume = this.getSecondaryVolume();
        VolumeNode mantainedPairPrimVolume = mantainedPair.getPrimaryVolume();
        VolumeNode mantainedPairSecVolume = mantainedPair.getSecondaryVolume();
        if (primVolume == null || secVolume == null || mantainedPairPrimVolume == null || mantainedPairSecVolume == null) {
            return;
        }
        if (primVolume.equals(childElement) && secVolume.equals(mantainedPairSecVolume) || secVolume.equals(childElement) && primVolume.equals(mantainedPairPrimVolume)) {
            mantainedPair.merge(this);
        }
    }
}

