/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster.dr;

import com.sanrad.log.Log;
import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.event.SrCreateElementEvent;
import com.sanrad.nms.server.event.SrRemoveElementEvent;
import com.sanrad.nms.server.logic.AlreadyKnownByVSwitch;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAbstractConsistencyGroup;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterConsistencyGroup;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterConsistencyGroupImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterExtendedPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterExtendedPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterSyncPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterSyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.dr.DRPiTImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class DRClusterManager {
    protected static Log m_logger = LogMgr.getServerLog();
    private ClusterImpl m_cluster = null;
    private ArrayList m_syncPairs = new ArrayList();
    private HashMap m_groupsWithPairs = new HashMap();
    private HashMap m_emptyGroups = new HashMap();
    private ArrayList m_consistencyGroupsWithPairs = new ArrayList();
    private ArrayList m_emptyConsistencyGroups = new ArrayList();
    private ArrayList m_extendedPairsWithPairs = new ArrayList();
    private ArrayList m_emptyExtendedPairs = new ArrayList();
    private ArrayList m_pendingPairs = new ArrayList();
    private static final int CREATE_EVENT_TYPE = 1;
    private static final int CHANGE_EVENT_TYPE = 2;
    private static final int REMOVE_EVENT_TYPE = 3;

    public DRClusterManager(ClusterImpl cluster) {
        this.m_cluster = cluster;
        this.m_groupsWithPairs.put(ClassID.CONSISTENCY_GROUP, this.m_consistencyGroupsWithPairs);
        this.m_groupsWithPairs.put(ClassID.EXTENDED_PAIR, this.m_extendedPairsWithPairs);
        this.m_emptyGroups.put(ClassID.CONSISTENCY_GROUP, this.m_emptyConsistencyGroups);
        this.m_emptyGroups.put(ClassID.EXTENDED_PAIR, this.m_emptyExtendedPairs);
    }

    public void discoveryStarted() {
        this.m_consistencyGroupsWithPairs.clear();
        this.m_emptyConsistencyGroups.clear();
        this.m_extendedPairsWithPairs.clear();
        this.m_emptyExtendedPairs.clear();
        this.m_pendingPairs.clear();
        this.m_syncPairs.clear();
    }

    public LogicObjectImpl newElement(ClassID classId, CommKey[] commKeys, HashMap parameterList) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        DRClusterLogicObjectImpl element = null;
        if (classId.isDRGroup()) {
            element = this.newConsistencyGroup(parameterList, commKeys, classId);
        } else if (classId.equals(ClassID.ASYNC_PAIR)) {
            element = this.newAsyncPair(parameterList, commKeys, classId);
        } else if (classId.equals(ClassID.SYNC_PAIR)) {
            element = this.newSyncPair(parameterList, commKeys, classId);
        } else if (classId.equals(ClassID.DR_CONSISTENCY_GROUP_PIT) || classId.equals(ClassID.DR_ASYNC_PAIR_PIT)) {
            DRPiTImpl pit = new DRPiTImpl(this.m_cluster, classId);
            pit.setParameterList(parameterList);
            return pit;
        }
        return element;
    }

    public void removeElement(LogicObjectImpl element, VSwitch vSwitch) throws RemoteException {
        try {
            ClassID classId = element.getClassId();
            if (classId.isDRGroup()) {
                this.removeConsistencyGroup((DRClusterAbstractConsistencyGroupImpl)element);
            } else if (classId.equals(ClassID.ASYNC_PAIR)) {
                this.removeAsyncPair((DRClusterAsyncPairImpl)element, vSwitch);
            } else if (classId.equals(ClassID.SYNC_PAIR)) {
                this.removeSyncPair((DRClusterSyncPairImpl)element, vSwitch);
            }
        }
        catch (IllegalValueException ive) {
            m_logger.error(ive + " exception caught in DRClusterManager::removeElement(" + element + ", " + vSwitch + ")");
        }
    }

    public void bruteForceRemoveElement(DRClusterLogicObjectImpl element) throws RemoteException {
        ArrayList list = this.getElementList(element);
        if (list != null) {
            this.m_cluster.getCommKeyRefMap().removeCommKeyClassIdAndRef(element.getCommKeyClassId());
            list.remove(element);
        }
    }

    private ArrayList getElementList(DRClusterLogicObjectImpl element) {
        if (element != null) {
            if (this.m_consistencyGroupsWithPairs.contains(element)) {
                return this.m_consistencyGroupsWithPairs;
            }
            if (this.m_extendedPairsWithPairs.contains(element)) {
                return this.m_extendedPairsWithPairs;
            }
            if (this.m_emptyConsistencyGroups.contains(element)) {
                return this.m_emptyConsistencyGroups;
            }
            if (this.m_emptyExtendedPairs.contains(element)) {
                return this.m_emptyExtendedPairs;
            }
            if (this.m_syncPairs.contains(element)) {
                return this.m_syncPairs;
            }
            if (this.m_pendingPairs.contains(element)) {
                return this.m_pendingPairs;
            }
        }
        return null;
    }

    private ArrayList getGroupList(DRGroupListType groupType, ClassID classId) {
        if (groupType.equals(DRGroupListType.WITH_PAIRS)) {
            return (ArrayList)this.m_groupsWithPairs.get(classId);
        }
        return (ArrayList)this.m_emptyGroups.get(classId);
    }

    private DRClusterAsyncPair[] getPendingPairs() {
        if (this.m_pendingPairs == null) {
            return null;
        }
        DRClusterAsyncPair[] pairsArray = new DRClusterAsyncPair[this.m_pendingPairs.size()];
        return this.m_pendingPairs.toArray(pairsArray);
    }

    public boolean isDRExist() {
        return !this.m_consistencyGroupsWithPairs.isEmpty() || !this.m_extendedPairsWithPairs.isEmpty() || !this.m_emptyConsistencyGroups.isEmpty() || !this.m_emptyExtendedPairs.isEmpty() || !this.m_syncPairs.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private DRClusterAbstractConsistencyGroup[] createArrayOfGroups(ClassID classId, int size) {
        void var3_3;
        DRClusterAbstractConsistencyGroup[] groups;
        if (classId.equals(ClassID.CONSISTENCY_GROUP)) {
            groups = new DRClusterConsistencyGroup[size];
        } else if (classId.equals(ClassID.EXTENDED_PAIR)) {
            groups = new DRClusterExtendedPair[size];
        } else {
            throw new IllegalArgumentException("Wrong ClassID " + classId);
        }
        return var3_3;
    }

    public DRClusterConsistencyGroup[] getConsistencyGroups() throws RemoteException {
        ArrayList all = new ArrayList();
        all.addAll(this.m_consistencyGroupsWithPairs);
        all.addAll(this.m_emptyConsistencyGroups);
        return all.toArray(new DRClusterConsistencyGroup[all.size()]);
    }

    public DRClusterExtendedPair[] getExtendedPairs() throws RemoteException {
        ArrayList all = new ArrayList();
        all.addAll(this.m_extendedPairsWithPairs);
        all.addAll(this.m_emptyExtendedPairs);
        return all.toArray(new DRClusterExtendedPair[all.size()]);
    }

    public DRClusterSyncPair[] getSyncPairs() throws RemoteException {
        DRClusterSyncPair[] syncPairs = new DRClusterSyncPair[this.m_syncPairs.size()];
        this.m_syncPairs.toArray(syncPairs);
        return syncPairs;
    }

    public DRClusterPairImpl[] getAllPairs() throws RemoteException {
        ArrayList<DRClusterAsyncPair> all = new ArrayList<DRClusterAsyncPair>();
        all.addAll(this.m_syncPairs);
        Iterator i = this.m_consistencyGroupsWithPairs.iterator();
        while (i.hasNext()) {
            DRClusterConsistencyGroupImpl cg = (DRClusterConsistencyGroupImpl)i.next();
            all.addAll(Arrays.asList(cg.getPairs()));
        }
        i = this.m_extendedPairsWithPairs.iterator();
        while (i.hasNext()) {
            DRClusterExtendedPairImpl exPair = (DRClusterExtendedPairImpl)i.next();
            all.add(exPair.getPair());
        }
        return all.toArray(new DRClusterPairImpl[all.size()]);
    }

    public DRClusterPairImpl getPair(VolumeNodeImpl volume) throws RemoteException {
        DRClusterPairImpl[] pairs = this.getAllPairs();
        int i = pairs.length;
        while (i-- > 0) {
            if (!volume.equals(pairs[i].getPrimaryVolume()) && !volume.equals(pairs[i].getSecondaryVolume())) continue;
            return pairs[i];
        }
        return null;
    }

    private DRClusterAbstractConsistencyGroupImpl newConsistencyGroup(HashMap parameterList, CommKey[] commKeys, ClassID classId) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        DRClusterAbstractConsistencyGroupImpl newGroup = null;
        CommKeyClassId groupId = new CommKeyClassId(commKeys, classId);
        DRClusterAsyncPairImpl matchingPair = this.findPairInListByGroupId(this.getPendingPairs(), groupId);
        if (matchingPair != null) {
            newGroup = this.createAndAddConsistencyGroup(DRGroupListType.WITH_PAIRS, parameterList, commKeys, classId);
            newGroup.addPair(matchingPair);
            DRRoleConstant groupRole = (DRRoleConstant)parameterList.get(ParameterCode.DR_CONSISTENCY_GROUP_ROLE);
            matchingPair.setRole(groupRole);
            this.m_pendingPairs.remove(matchingPair);
            return newGroup;
        }
        VSwitch vSwitch = (VSwitch)this.m_cluster.getCommKeyRefMap().getRefByCommKeyClassID((CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID));
        newGroup = this.findGroupInListByGroupId(DRGroupListType.WITH_PAIRS, groupId, classId, vSwitch);
        if (newGroup != null) {
            throw new AlreadyKnownByVSwitch(newGroup);
        }
        newGroup = this.findGroupInListByGroupAttributes(DRGroupListType.EMPTY, parameterList, classId);
        if (newGroup != null) {
            throw new AlreadyKnownByVSwitch(newGroup);
        }
        newGroup = this.createAndAddConsistencyGroup(DRGroupListType.EMPTY, parameterList, commKeys, classId);
        return newGroup;
    }

    private DRClusterAsyncPairImpl newAsyncPair(HashMap parameterList, CommKey[] commKeys, ClassID classId) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        DRClusterAsyncPairImpl matchingPair = null;
        DRClusterAbstractConsistencyGroupImpl matchingGroup = null;
        CommKeyClassId groupId = (CommKeyClassId)parameterList.get(ParameterCode.DR_ASYNC_PAIR_GROUP_ID);
        ClassID groupClass = groupId.getClassID();
        matchingPair = (DRClusterAsyncPairImpl)this.findPairInGroupByPairAttributes(DRGroupListType.WITH_PAIRS, parameterList, groupClass);
        if (matchingPair != null) {
            matchingGroup = (DRClusterAbstractConsistencyGroupImpl)this.m_cluster.getCommKeyRefMap().getRefByCommKeyClassID(matchingPair.getGroupId());
            DRClusterAbstractConsistencyGroupImpl newPairGroup = (DRClusterAbstractConsistencyGroupImpl)this.m_cluster.getCommKeyRefMap().getRefByCommKeyClassID(groupId);
            if (newPairGroup != null && matchingGroup != newPairGroup) {
                this.mergeGroups(matchingGroup, newPairGroup);
            }
            throw new AlreadyKnownByVSwitch(matchingPair);
        }
        matchingPair = (DRClusterAsyncPairImpl)this.findPairInListByPairAttributes(this.getPendingPairs(), parameterList);
        if (matchingPair != null) {
            matchingGroup = this.findGroupInListByGroupId(DRGroupListType.WITH_PAIRS, groupId, groupClass, null);
            if (matchingGroup == null) {
                matchingGroup = this.findGroupInListByGroupId(DRGroupListType.EMPTY, groupId, groupClass, null);
            }
            if (matchingGroup != null) {
                this.recreateElement(matchingPair, matchingPair.getActiveVswitch(), matchingPair.getCommKeyClassId());
                if (matchingGroup.isEmpty()) {
                    this.addItemToGroupList(DRGroupListType.WITH_PAIRS, matchingGroup);
                    this.removeItemFromGroupList(DRGroupListType.EMPTY, matchingGroup);
                }
                matchingPair = this.CreateAndAddPairToGroup(parameterList, commKeys, matchingGroup);
                return matchingPair;
            }
            throw new AlreadyKnownByVSwitch(matchingPair);
        }
        matchingGroup = this.findGroupInListByGroupId(DRGroupListType.EMPTY, groupId, groupClass, null);
        if (matchingGroup != null) {
            matchingPair = this.CreateAndAddPairToGroup(parameterList, commKeys, matchingGroup);
            this.addItemToGroupList(DRGroupListType.WITH_PAIRS, matchingGroup);
            this.removeItemFromGroupList(DRGroupListType.EMPTY, matchingGroup);
            return matchingPair;
        }
        matchingGroup = this.findGroupInListByGroupId(DRGroupListType.WITH_PAIRS, groupId, groupClass, null);
        if (matchingGroup != null) {
            matchingPair = this.createAsyncPair(parameterList, commKeys);
            matchingGroup.addPair(matchingPair);
            matchingPair.setRole(matchingGroup.getRole());
            return matchingPair;
        }
        matchingPair = this.createAsyncPair(parameterList, commKeys);
        this.m_pendingPairs.add(matchingPair);
        return matchingPair;
    }

    private DRClusterSyncPairImpl newSyncPair(HashMap parameterList, CommKey[] commKeys, ClassID classId) throws RemoteException, IllegalValueException, AlreadyKnownByVSwitch {
        DRClusterPair[] syncPairs = new DRClusterSyncPair[this.m_syncPairs.size()];
        this.m_syncPairs.toArray(syncPairs);
        DRClusterSyncPairImpl matchingPair = (DRClusterSyncPairImpl)this.findPairInListByPairAttributes(syncPairs, parameterList);
        if (matchingPair != null) {
            throw new AlreadyKnownByVSwitch(matchingPair);
        }
        matchingPair = this.createSyncPair(parameterList, commKeys);
        this.m_syncPairs.add(matchingPair);
        return matchingPair;
    }

    private DRClusterAbstractConsistencyGroupImpl removeConsistencyGroup(DRClusterAbstractConsistencyGroupImpl group) throws RemoteException, IllegalValueException {
        if (group.getConnectedVSwitchCounter() == 1) {
            ArrayList groupList;
            ClassID classId = group.getClassId();
            if (group.isEmpty()) {
                groupList = this.getGroupList(DRGroupListType.EMPTY, classId);
            } else {
                DRClusterAsyncPairImpl pair;
                groupList = this.getGroupList(DRGroupListType.WITH_PAIRS, classId);
                if (classId.equals(ClassID.EXTENDED_PAIR) && (pair = (DRClusterAsyncPairImpl)((DRClusterExtendedPairImpl)group).getPair()) != null) {
                    this.m_cluster.getCommKeyRefMap().removeCommKeyClassIdAndRef(pair.getCommKeyClassId());
                }
            }
            groupList.remove(group);
        } else {
            this.rematchEmptyGroupWithNoPairs(group);
        }
        return group;
    }

    private DRClusterAsyncPairImpl removeAsyncPair(DRClusterAsyncPairImpl pair, VSwitch vSwitch) throws RemoteException, IllegalValueException {
        if (pair.getConnectedVSwitchCounter() == 1) {
            if (this.m_pendingPairs.contains(pair)) {
                this.m_pendingPairs.remove(pair);
            } else {
                CommKeyClassId groupId = pair.getGroupId();
                DRClusterAbstractConsistencyGroupImpl pairGroup = (DRClusterAbstractConsistencyGroupImpl)this.m_cluster.getCommKeyRefMap().getRefByCommKeyClassID(groupId);
                if (pairGroup != null) {
                    if (pairGroup.getClassId().equals(ClassID.CONSISTENCY_GROUP)) {
                        ((DRClusterConsistencyGroupImpl)pairGroup).removePair(pair);
                        DRClusterAsyncPair[] pairs = pairGroup.getPairs();
                        if (pairs == null || pairs.length == 0) {
                            this.m_consistencyGroupsWithPairs.remove(pairGroup);
                            this.m_emptyConsistencyGroups.add(pairGroup);
                            DRClusterAbstractConsistencyGroupImpl groupMatch = this.findGroupInListByGroupAttributes(DRGroupListType.EMPTY, pairGroup, pairGroup.getClassId());
                            if (pair.isMerged()) {
                                SrRemoveElementEvent removeEvent = this.prepareRemoveElementEvent(pairGroup);
                                this.m_cluster.elementEvent(removeEvent, true, true);
                                SrCreateElementEvent recreateEvent = this.prepareCreateElementEvent(pairGroup);
                                this.m_cluster.elementEvent(recreateEvent, true, true);
                            } else {
                                if (groupMatch != null && !groupMatch.equals(pairGroup)) {
                                    groupMatch.deleteElement();
                                }
                                pairGroup.deleteElement();
                            }
                        }
                    } else {
                        this.m_extendedPairsWithPairs.remove(pairGroup);
                        if (pair.isMerged()) {
                            this.m_emptyExtendedPairs.add(pairGroup);
                            SrRemoveElementEvent removeEvent = this.prepareRemoveElementEvent(pairGroup);
                            this.m_cluster.elementEvent(removeEvent, true, true);
                            SrCreateElementEvent recreateEvent = this.prepareCreateElementEvent(pairGroup);
                            this.m_cluster.elementEvent(recreateEvent, true, true);
                        } else {
                            this.m_cluster.getCommKeyRefMap().removeCommKeyClassIdAndRef(pairGroup.getCommKeyClassId());
                        }
                    }
                } else {
                    m_logger.warning("pair " + pair + " is not pending has no group object reference!");
                }
            }
            pair.clearMergeNotifiers();
        } else if (!this.m_pendingPairs.contains(pair)) {
            CommKeyClassId groupId = pair.getGroupId();
            if (groupId != null) {
                DRClusterAbstractConsistencyGroupImpl pairGroup = (DRClusterAbstractConsistencyGroupImpl)this.m_cluster.getCommKeyRefMap().getRefByCommKeyClassID(groupId);
                if (pairGroup.getClassId().equals(ClassID.CONSISTENCY_GROUP)) {
                    VSwitch vSwitchToRemain = this.m_cluster.getOtherVSwitch(vSwitch);
                    CommKey[] commKeysToRemain = pairGroup.getCommKeysOfVSwitch(vSwitchToRemain);
                    this.splitGroupWithOnePair(pairGroup, commKeysToRemain, pairGroup.getClassId(), vSwitchToRemain);
                } else if (pairGroup.getConnectedVSwitchCounter() == 2) {
                    HashMap parameters = pairGroup.getParameterListValues(vSwitch);
                    parameters.put(ParameterCode.VSWITCH_ID, vSwitch.getCommKeyClassId());
                    ConfigElementData data = new ConfigElementData(pairGroup.getCommKeys(), pairGroup.getClassId(), parameters);
                    SrRemoveElementEvent removeEvent = new SrRemoveElementEvent((Object)this, data);
                    this.m_cluster.elementEvent(removeEvent, true);
                }
            } else {
                m_logger.warning("pair " + pair + " that is not pending has no group object reference!");
            }
        }
        return pair;
    }

    private SrCreateElementEvent prepareCreateElementEvent(LogicObjectImpl element) throws RemoteException {
        ConfigElementDataList dataList = this.prepareConfigElementDataListForEvent(element, 1);
        return new SrCreateElementEvent((Object)this, dataList);
    }

    private SrRemoveElementEvent prepareRemoveElementEvent(LogicObjectImpl element) throws RemoteException {
        ConfigElementDataList dataList = this.prepareConfigElementDataListForEvent(element, 3);
        return new SrRemoveElementEvent((Object)this, dataList);
    }

    private ConfigElementDataList prepareConfigElementDataListForEvent(LogicObjectImpl element, int eventType) throws RemoteException {
        Vector vswitchesList = element.getVSwitches();
        ConfigElementDataList dataList = new ConfigElementDataList();
        Iterator i = vswitchesList.iterator();
        while (i.hasNext()) {
            VSwitch vs = (VSwitch)i.next();
            CommKeyClassId elementSpecificKey = CommKeyUtil.getSpecificCommKeyClassId(element.getCommKeyClassId(), vs.getCommKeyClassId());
            ConfigElementData data = new ConfigElementData(elementSpecificKey);
            HashMap parameters = null;
            switch (eventType) {
                case 3: {
                    parameters = new HashMap();
                    break;
                }
                case 1: {
                    parameters = element.getParameterListValues(vs);
                    parameters.put(ParameterCode.VSWITCH_ID, vs.getCommKeyClassId());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported event type: " + eventType);
                }
            }
            parameters.put(ParameterCode.VSWITCH_ID, vs.getCommKeyClassId());
            data.addParameter(parameters);
        }
        return dataList;
    }

    private DRClusterSyncPairImpl removeSyncPair(DRClusterSyncPairImpl pair, VSwitch vSwitch) throws RemoteException {
        if (pair.getConnectedVSwitchCounter() == 1) {
            pair.clearMergeNotifiers();
            return this.m_syncPairs.remove(pair) ? pair : null;
        }
        return null;
    }

    public DRClusterAbstractConsistencyGroupImpl rematchEmptyGroupWithNoPairs(DRClusterAbstractConsistencyGroupImpl group) throws RemoteException, IllegalValueException {
        DRClusterAbstractConsistencyGroupImpl matchingGroup;
        if (group.getConnectedVSwitchCounter() == 1 && group.isEmpty() && (matchingGroup = this.findGroupInListByGroupAttributes(DRGroupListType.EMPTY, group, group.getClassId())) != null && matchingGroup.isEmpty()) {
            this.mergeGroups(matchingGroup, group);
            return matchingGroup;
        }
        return null;
    }

    private DRClusterAsyncPairImpl findPairInListByGroupId(DRClusterAsyncPair[] pairs, CommKeyClassId groupId) throws RemoteException {
        if (pairs != null) {
            for (int i = 0; i < pairs.length; ++i) {
                DRClusterAsyncPairImpl currPair = (DRClusterAsyncPairImpl)pairs[i];
                if (!currPair.matchToGroupID(groupId)) continue;
                return currPair;
            }
        }
        return null;
    }

    private DRClusterAbstractConsistencyGroupImpl findGroupInListByGroupId(DRGroupListType groupType, CommKeyClassId groupId, ClassID classId, VSwitch groupVSwitch) throws RemoteException {
        DRClusterAsyncPairImpl selectedPair = this.findPairInGroupByGroupId(groupType, groupId, classId);
        if (selectedPair != null) {
            VSwitch vSwitchToLookFor = groupVSwitch != null ? this.m_cluster.getOtherVSwitch(groupVSwitch) : null;
            CommKeyClassId selectedPairGroupId = selectedPair.getGroupId(vSwitchToLookFor);
            return (DRClusterAbstractConsistencyGroupImpl)this.m_cluster.getCommKeyRefMap().getRefByCommKeyClassID(selectedPairGroupId);
        }
        DRClusterAbstractConsistencyGroupImpl selectedGroup = this.findGroupMatchToGroupId(groupType, groupId, classId);
        return selectedGroup;
    }

    private DRClusterAbstractConsistencyGroupImpl findGroupMatchToGroupId(DRGroupListType groupType, CommKeyClassId groupId, ClassID classId) throws RemoteException {
        ArrayList groups = this.getGroupList(groupType, classId);
        if (groups != null) {
            for (int i = 0; i < groups.size(); ++i) {
                DRClusterAbstractConsistencyGroupImpl currGroup = (DRClusterAbstractConsistencyGroupImpl)groups.get(i);
                CommKeyClassId currGroupId = currGroup.getCommKeyClassId();
                if (!currGroupId.equals(groupId)) continue;
                return currGroup;
            }
        }
        return null;
    }

    private DRClusterAsyncPairImpl findPairInGroupByGroupId(DRGroupListType groupType, CommKeyClassId groupId, ClassID classId) throws RemoteException {
        ArrayList groups = this.getGroupList(groupType, classId);
        for (int i = 0; i < groups.size(); ++i) {
            DRClusterAsyncPairImpl selectedPair;
            DRClusterAbstractConsistencyGroupImpl currGroup = (DRClusterAbstractConsistencyGroupImpl)groups.get(i);
            DRClusterAsyncPair[] pairs = currGroup.getPairs();
            if (pairs == null || (selectedPair = this.findPairInListByGroupId(pairs, groupId)) == null) continue;
            return selectedPair;
        }
        return null;
    }

    private DRClusterAbstractConsistencyGroupImpl findGroupInListByGroupAttributes(DRGroupListType groupType, HashMap parameterList, ClassID classId) throws RemoteException {
        ArrayList groups = this.getGroupList(groupType, classId);
        if (groups != null) {
            for (int i = 0; i < groups.size(); ++i) {
                DRClusterAbstractConsistencyGroupImpl currGroup = (DRClusterAbstractConsistencyGroupImpl)groups.get(i);
                if (!currGroup.getClassId().equals(classId) || !currGroup.equalsInCluster(parameterList)) continue;
                if (classId.equals(ClassID.EXTENDED_PAIR)) {
                    return currGroup;
                }
                SrString alias = (SrString)parameterList.get(ParameterCode.DR_VIRT_GROUP_ALIAS);
                if (!((DRClusterConsistencyGroupImpl)currGroup).isSameAlias(alias)) continue;
                return currGroup;
            }
        }
        return null;
    }

    private DRClusterAbstractConsistencyGroupImpl findGroupInListByGroupAttributes(DRGroupListType groupType, DRClusterAbstractConsistencyGroupImpl group, ClassID classId) throws RemoteException {
        VSwitch vSwitch = group.getActiveVswitch();
        HashMap parameterList = group.getParameterListValues(vSwitch);
        parameterList.put(ParameterCode.VSWITCH_ID, vSwitch.getCommKeyClassId());
        return this.findGroupInListByGroupAttributes(groupType, parameterList, classId);
    }

    private DRClusterPairImpl findPairInListByPairAttributes(DRClusterPair[] pairs, HashMap parameterList) throws RemoteException {
        if (pairs != null) {
            for (int i = 0; i < pairs.length; ++i) {
                DRClusterPairImpl currPair = (DRClusterPairImpl)pairs[i];
                if (!currPair.equalsInCluster(parameterList)) continue;
                return currPair;
            }
        }
        return null;
    }

    private DRClusterPairImpl findPairInGroupByPairAttributes(DRGroupListType groupType, HashMap parameterList, ClassID classId) throws RemoteException {
        ArrayList groups = this.getGroupList(groupType, classId);
        if (groups != null) {
            for (int i = 0; i < groups.size(); ++i) {
                DRClusterPairImpl currPair = this.findPairInListByPairAttributes(((DRClusterAbstractConsistencyGroupImpl)groups.get(i)).getPairs(), parameterList);
                if (currPair == null) continue;
                return currPair;
            }
        }
        return null;
    }

    private DRClusterAbstractConsistencyGroupImpl createAndAddConsistencyGroup(DRGroupListType groupType, HashMap parameterList, CommKey[] commKeys, ClassID classId) throws RemoteException, IllegalValueException {
        ArrayList groupList = this.getGroupList(groupType, classId);
        DRClusterAbstractConsistencyGroupImpl newGroup = this.createGroupObject(classId);
        groupList.add(newGroup);
        newGroup.setParameterList(parameterList);
        return newGroup;
    }

    private DRClusterAbstractConsistencyGroupImpl createGroupObject(ClassID classId) throws RemoteException {
        DRClusterAbstractConsistencyGroupImpl newObject = null;
        if (classId.equals(ClassID.CONSISTENCY_GROUP)) {
            newObject = new DRClusterConsistencyGroupImpl(this.m_cluster);
        } else if (classId.equals(ClassID.EXTENDED_PAIR)) {
            newObject = new DRClusterExtendedPairImpl(this.m_cluster);
        } else {
            throw new IllegalArgumentException();
        }
        return newObject;
    }

    private DRClusterAsyncPairImpl createAsyncPair(HashMap parameterList, CommKey[] commKeys) throws RemoteException, IllegalValueException {
        DRClusterAsyncPairImpl newPair = new DRClusterAsyncPairImpl(this.m_cluster);
        newPair.setParameterList(parameterList);
        return newPair;
    }

    private DRClusterSyncPairImpl createSyncPair(HashMap parameterList, CommKey[] commKeys) throws RemoteException, IllegalValueException {
        DRClusterSyncPairImpl newPair = new DRClusterSyncPairImpl(this.m_cluster);
        newPair.setParameterList(parameterList);
        return newPair;
    }

    private void addItemToGroupList(DRGroupListType listType, DRClusterAbstractConsistencyGroupImpl group) throws RemoteException {
        ArrayList list = this.getGroupList(listType, group.getClassId());
        list.add(group);
    }

    private void removeItemFromGroupList(DRGroupListType listType, DRClusterAbstractConsistencyGroupImpl group) throws RemoteException {
        ArrayList list = this.getGroupList(listType, group.getClassId());
        list.remove(group);
    }

    private boolean splitGroupWithOnePair(DRClusterAbstractConsistencyGroupImpl group, CommKey[] remainingKeys, ClassID classId, VSwitch remainingVSwitch) throws RemoteException {
        DRClusterAsyncPair[] pairs = group.getPairs();
        if (pairs != null && pairs.length == 1) {
            return this.splitGroup(group, remainingKeys, classId, remainingVSwitch);
        }
        return false;
    }

    private boolean splitGroup(DRClusterAbstractConsistencyGroupImpl group, CommKey[] remainingKeys, ClassID classId, VSwitch remainingVSwitch) throws RemoteException {
        int numOfGroupVSwitches = group.getConnectedVSwitchCounter();
        if (numOfGroupVSwitches > 1) {
            VSwitch splitVswitch = this.m_cluster.getOtherVSwitch(remainingVSwitch);
            CommKey[] splitKeys = CommKeyUtil.getAllButThisCommKey(group.getCommKeys(), remainingKeys);
            this.recreateElement(group, splitVswitch, new CommKeyClassId(splitKeys, classId));
            return true;
        }
        return false;
    }

    private void mergeGroups(DRClusterAbstractConsistencyGroupImpl mergeIntoGroup, DRClusterAbstractConsistencyGroupImpl depracatedGroup) throws RemoteException, IllegalValueException {
        DRClusterAsyncPair[] newPairs = depracatedGroup.getPairs();
        if (newPairs != null) {
            for (int i = 0; i < newPairs.length; ++i) {
                mergeIntoGroup.addPair(newPairs[i]);
            }
        }
        VSwitch vSwitchToRemain = mergeIntoGroup.getConnectedVSwitches()[0];
        VSwitch vSwitch = this.m_cluster.getOtherVSwitch(vSwitchToRemain);
        this.recreateElement(depracatedGroup, vSwitch, depracatedGroup.getCommKeyClassId());
    }

    private void recreateElement(DRClusterLogicObjectImpl element, VSwitch vSwitch, CommKeyClassId commKeyClassId) throws RemoteException {
        HashMap parameters = element.getParameterListValues(vSwitch);
        parameters.put(ParameterCode.VSWITCH_ID, vSwitch.getCommKeyClassId());
        ConfigElementData data = new ConfigElementData(commKeyClassId.getCommKeys(), commKeyClassId.getClassID(), parameters);
        this.recreateElement(data);
    }

    private void recreateElement(ConfigElementData ced) throws RemoteException {
        SrRemoveElementEvent removeEvent = new SrRemoveElementEvent((Object)this, ced);
        SrCreateElementEvent createEvent = new SrCreateElementEvent((Object)this, ced);
        this.m_cluster.elementEvent(createEvent, true);
        this.m_cluster.elementEvent(removeEvent, true);
    }

    public void removeEmptyGroupsWithNoPairs() throws RemoteException, IllegalValueException {
        DRClusterConsistencyGroup[] groups = this.getConsistencyGroups();
        int groupsLength = groups.length;
        for (int i = 0; i < groupsLength; ++i) {
            if (!((DRClusterAbstractConsistencyGroupImpl)((Object)groups[i])).hasNoPairs()) continue;
            DRAbstractConsistencyGroupImpl currDRGroup = (DRAbstractConsistencyGroupImpl)DRRootImpl.getInstance().findDRObjectWithIdenticalElement((DRClusterConsistencyGroupImpl)groups[i]);
            if (currDRGroup != null) {
                if (currDRGroup.isInDeletionProcess()) continue;
                groups[i].deleteElement();
                continue;
            }
            groups[i].deleteElement();
        }
    }

    private DRClusterAsyncPairImpl CreateAndAddPairToGroup(HashMap parameterList, CommKey[] commKeys, DRClusterAbstractConsistencyGroupImpl group) throws RemoteException, IllegalValueException {
        CommKeyClassId groupId = (CommKeyClassId)parameterList.get(ParameterCode.DR_ASYNC_PAIR_GROUP_ID);
        ClassID groupClass = groupId.getClassID();
        CommKeyClassId vSwitchId = (CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID);
        VSwitch vSwitch = (VSwitch)this.m_cluster.getCommKeyRefMap().getRefByCommKeyClassID(vSwitchId);
        this.splitGroup(group, groupId.getCommKeys(), groupClass, vSwitch);
        DRClusterAsyncPairImpl pair = this.createAsyncPair(parameterList, commKeys);
        group.addPair(pair);
        pair.setRole(group.getRole());
        return pair;
    }

    private static class DRGroupListType {
        public static final DRGroupListType WITH_PAIRS = new DRGroupListType();
        public static final DRGroupListType EMPTY = new DRGroupListType();
        public static final DRGroupListType ALL = new DRGroupListType();

        private DRGroupListType() {
        }
    }
}

