/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster.dr;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObject;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.validation.Validator;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.MasterParameter;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterList;
import com.sanrad.nms.server.util.types.constants.DRActivateConstant;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;

public abstract class DRClusterLogicObjectImpl
extends LogicObjectImpl
implements DRClusterLogicObject {
    public boolean inSwitchProcess = false;

    protected DRClusterLogicObjectImpl(ClusterImpl cluster, ClassID classId, ParameterCode[] parameterCodeList) throws RemoteException {
        super(cluster, classId, parameterCodeList);
    }

    protected DRClusterLogicObjectImpl(ClusterImpl cluster, ClassID classId, List parameterCodeList) throws RemoteException {
        super(cluster, classId, parameterCodeList);
    }

    protected String canBeDeleted() throws RemoteException {
        if (!this.getSrValueOf(MasterParameterCode.DR_REPLICATION_STATE.getParameterCode(this)).equals(DRReplicationStateConstant.INACTIVE)) {
            HashMap<ParameterCode, DRActivateConstant> map = new HashMap<ParameterCode, DRActivateConstant>();
            map.put(MasterParameterCode.DR_ACTIVATE.getParameterCode(this), DRActivateConstant.ABORT_REPLICATE);
            try {
                this.changeElement(map);
            }
            catch (IllegalValueException e) {
                return e.getMessage();
            }
        }
        return null;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        return null;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public void validAndActivate(ParameterList params) throws RemoteException, IllegalValueException {
        if (this.isLocal()) {
            Validator.getInstance().isValidAccordingToAlarm(this, params);
        }
    }

    public MasterParameter getActivateParameter() throws RemoteException, IllegalValueException {
        ParameterCode activateParameterCode = this.getActivateParameterCode();
        return new MasterParameter(activateParameterCode, this.getSrValueOf(activateParameterCode));
    }

    public MasterParameter getActivateInitialSyncStateParameter() throws RemoteException, IllegalValueException {
        ParameterCode activateParameterCode = this.getActivateParameterCode();
        return new MasterParameter(activateParameterCode, this.getSrValueOf(activateParameterCode));
    }

    public AlarmGenerator getElarmGenerator() {
        return null;
    }

    public DRModeConstant getMode() throws RemoteException {
        return (DRModeConstant)this.getSrValueOf(MasterParameterCode.DR_MODE.getParameterCode(this));
    }

    public SrBITSConstant getReplicationState() throws RemoteException {
        return (SrBITSConstant)this.getSrValueOf(MasterParameterCode.DR_REPLICATION_STATE.getParameterCode(this));
    }

    public DRReplicationStateConstant getFailOverState() throws RemoteException {
        if (this.getReplicationState().contains(DRReplicationStateConstant.FALLBACK)) {
            return DRReplicationStateConstant.FALLBACK;
        }
        if (this.getReplicationState().contains(DRReplicationStateConstant.PLANNED_FAILOVER)) {
            return DRReplicationStateConstant.PLANNED_FAILOVER;
        }
        return null;
    }

    public abstract ParameterCode getActivateParameterCode() throws RemoteException, IllegalValueException;

    public abstract boolean isLocal() throws RemoteException;

    public abstract DRRoleConstant getRole() throws RemoteException;

    public boolean isDisasterOccured(MasterParameter param) throws RemoteException {
        ConfigElementData ced = this.buildCedForVswitch(this.getActiveVswitch(), new ParameterList(param));
        DataMgr.getInstance().readElement(ced);
        return !ced.getParametersList().get(param).equals(DRModeConstant.SWITCHED);
    }

    public DRRoleConstant getRoleAccordingToMode() throws RemoteException {
        if (this.getMode().equals(DRModeConstant.NORMAL)) {
            return DRRoleConstant.LOCAL;
        }
        if (this.getMode().equals(DRModeConstant.SWITCHED)) {
            return DRRoleConstant.REMOTE;
        }
        return null;
    }

    public GeneralLogicObject getDrSource() throws RemoteException {
        return DRRootImpl.getInstance().findDRObjectWithIdenticalElement(this);
    }
}

