/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster.dr;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterExtendedPair;
import com.sanrad.nms.server.util.ClassID;
import java.rmi.RemoteException;
import java.util.HashMap;

public class DRClusterExtendedPairImpl
extends DRClusterAbstractConsistencyGroupImpl
implements DRClusterExtendedPair {
    private DRClusterAsyncPair m_pair = null;

    public DRClusterExtendedPairImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.EXTENDED_PAIR);
    }

    public void addPairToGroup(DRClusterAsyncPair newPair) throws IllegalValueException {
        if (this.m_pair != null) {
            throw new IllegalValueException();
        }
        this.m_pair = newPair;
    }

    public DRClusterAsyncPair getPair() throws RemoteException {
        return this.m_pair;
    }

    public DRClusterAsyncPair[] getPairs() {
        if (this.m_pair != null) {
            return new DRClusterAsyncPair[]{(DRClusterAsyncPairImpl)this.m_pair};
        }
        return null;
    }

    public HashMap getClientParameterList() throws RemoteException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.DR_EXTENDED_PAIR_PAIR, this.getPair());
        return parameterList;
    }

    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public String toString() {
        try {
            DRClusterAsyncPair pair = this.getPair();
            if (pair != null) {
                return "ExtendedPair:" + pair.toString();
            }
        }
        catch (RemoteException e) {
            logger.error(e);
        }
        return super.toString();
    }
}

