/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster.dr;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.AliasObject;
import com.sanrad.nms.server.logic.AliasObjectImpl;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterConsistencyGroup;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;

public class DRClusterConsistencyGroupImpl
extends DRClusterAbstractConsistencyGroupImpl
implements DRClusterConsistencyGroup,
AliasObject {
    DRAliasConsistencyGroupImpl cg_alias = null;

    public DRClusterConsistencyGroupImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.CONSISTENCY_GROUP);
        this.addParameterCode(ParameterCode.DR_VIRT_GROUP_ALIAS);
        this.cg_alias = new DRAliasConsistencyGroupImpl((ClusterImpl)this.getCluster(), this.getClassId());
    }

    public void addPairToGroup(DRClusterAsyncPair newPair) {
        if (this.m_pairs == null) {
            this.m_pairs = new ArrayList();
        }
        this.m_pairs.add(newPair);
    }

    public DRClusterAsyncPair[] getPairs() {
        if (this.m_pairs == null) {
            return null;
        }
        DRClusterAsyncPair[] pairsArray = new DRClusterAsyncPair[this.m_pairs.size()];
        return this.m_pairs.toArray(pairsArray);
    }

    public void removePair(DRClusterAsyncPairImpl pair) {
        this.m_pairs.remove(pair);
    }

    public boolean isSameAlias(SrString alias) throws RemoteException {
        return this.checkConsistencyBetweenVSwitches() == null;
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        return this.cg_alias.isValid(parameterList);
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public HashMap getClientParameterList() throws RemoteException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.DR_CONSISTENCY_GROUP_PAIRS, this.getPairs());
        return parameterList;
    }

    public String toString() {
        try {
            SrType alias = this.getSrValueOf(ParameterCode.DR_VIRT_GROUP_ALIAS);
            if (alias != null) {
                return alias.toString();
            }
        }
        catch (RemoteException e) {
            logger.error(e);
        }
        return super.toString();
    }

    public String getAlias() throws RemoteException {
        return this.cg_alias.getAlias();
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        return this.cg_alias.getAlias(vSwitch);
    }

    public String[] checkAliasConsistencyBetweenVSwitches() throws RemoteException {
        return this.cg_alias.checkAliasConsistencyBetweenVSwitches();
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        this.cg_alias.setParameterList(parameterList);
        return super.setParameterList(parameterList);
    }

    private class DRAliasConsistencyGroupImpl
    extends AliasObjectImpl
    implements AliasObject {
        protected DRAliasConsistencyGroupImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
            super(cluster, classId, new ParameterCode[]{ParameterCode.DR_VIRT_GROUP_ALIAS});
        }

        protected String canBeDeleted() throws RemoteException {
            return "Can't remove alias";
        }

        protected String isValid(HashMap parameterList) throws RemoteException {
            Object alias = parameterList.get(ClientParameterCode.DR_CONSISTENCY_GROUP_ALIAS);
            if (alias != null && alias instanceof String) {
                String aliasValidator = this.isAliasValid((String)alias);
                if (aliasValidator != null) {
                    return aliasValidator;
                }
                if (DRRootImpl.getInstance().isAliasExist((String)alias)) {
                    return "a consistency group with this alias already exists";
                }
                parameterList.put(ClientParameterCode.DR_CONSISTENCY_GROUP_ALIAS, new SrString((String)alias));
            }
            return null;
        }

        public AlarmGenerator getAlarmGenerator() {
            return null;
        }

        public void registerToPropagatedStateChange() throws RemoteException {
        }

        public String getAlias() throws RemoteException {
            return (String)this.getValueOf(ParameterCode.DR_VIRT_GROUP_ALIAS);
        }

        public String getAlias(VSwitch vSwitch) throws RemoteException {
            return (String)this.getValueOf(vSwitch, ParameterCode.DR_VIRT_GROUP_ALIAS);
        }
    }
}

