/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster.dr;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterPairImpl;
import com.sanrad.nms.server.logic.dr.DRPiTImpl;
import com.sanrad.nms.server.logic.volume.JournalVolume;
import com.sanrad.nms.server.logic.volume.SnapshotVolume;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;

public class DRClusterAsyncPairImpl
extends DRClusterPairImpl
implements DRClusterAsyncPair {
    public DRClusterAsyncPairImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.ASYNC_PAIR);
        this.addParameterCode(ParameterCode.DR_ASYNC_PAIR_ACTIVATE);
        this.addParameterCode(ParameterCode.DR_ASYNC_PAIR_GROUP_ID);
        this.addParameterCode(ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID);
        this.addParameterCode(ParameterCode.DR_ASYNC_PAIR_PENDING_DATA);
        this.addParameterCode(ParameterCode.DR_ASYNC_PAIR_PENDING_PITS);
        this.addParameterCode(ParameterCode.DR_ASYNC_PAIR_REPLICATION_STATE);
        this.addParameterCode(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID);
        this.addParameterCode(ParameterCode.DR_ASYNC_PAIR_LAST_PIT_MERGE);
        this.addParameterCode(ParameterCode.DR_PIT_PARENT_LAST_UPDATE);
    }

    public boolean matchToGroupID(CommKeyClassId groupId) throws RemoteException {
        return this.getGroupId().equals(groupId);
    }

    public CommKeyClassId getGroupId(VSwitch vSwitch) throws RemoteException {
        return (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.DR_ASYNC_PAIR_GROUP_ID, vSwitch == null);
    }

    public JournalVolume getJournal() throws RemoteException {
        CommKeyClassId jourID = this.getCommKeyClassIdValueOf(ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID);
        return (JournalVolume)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(jourID);
    }

    public SnapshotVolume getSnapshot() throws RemoteException {
        CommKeyClassId snapID = this.getSnapshotId();
        if (snapID != null) {
            return (SnapshotVolume)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(snapID);
        }
        return null;
    }

    public CommKeyClassId getSnapshotId() throws RemoteException {
        return this.getCommKeyClassIdValueOf(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID);
    }

    public CommKeyClassId getGroupId() throws RemoteException {
        return this.getCommKeyClassIdValueOf(ParameterCode.DR_ASYNC_PAIR_GROUP_ID);
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        return null;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    public ParameterCode getActivateParameterCode() {
        return ParameterCode.DR_ASYNC_PAIR_ACTIVATE;
    }

    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public void deleteElement() throws RemoteException, IllegalValueException {
        ConfigElementData ced = new ConfigElementData(this.getCommKeys(), this.getClassId());
        ConfigElementDataList list = new ConfigElementDataList();
        ((ClusterImpl)this.getCluster()).prepareVSwitchIDs(ced, "prepare element for remove volume tree", this.getConnectedVSwitchesAsVector());
        list.addElement(ced);
        if (DRRoleConstant.REMOTE.equals(this.getRole())) {
            ced.setValue(ParameterCode.DR_PAIR_PRIMARY_ID, this.getPrimaryVolumeId());
            if (this.getSecondaryVolume().isProvisioned()) {
                SnapshotVolumeImpl sns = (SnapshotVolumeImpl)this.getSnapshot();
                if (sns != null) {
                    list.addAll((Collection)((VolumeNodeImpl)this.getSecondaryVolume()).removeVolumeTree(sns));
                } else {
                    list.addAll((Collection)((VolumeNodeImpl)this.getSecondaryVolume()).removeVolumeTree());
                }
            }
        } else if (DRRoleConstant.LOCAL.equals(this.getRole())) {
            ced.setValue(ParameterCode.DR_PAIR_SECONDARY_ID, this.getSecondaryVolumeId());
        }
        ced.setValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID, this.getGroupId());
        DataMgr.getInstance().removeElement(list);
    }

    public void refreshPiTs(DRPiTImpl[] currentPits) throws RemoteException {
        VSwitch[] vSwithces = this.getConnectedVSwitches();
        if (vSwithces != null && vSwithces.length > 0) {
            CommKeyClassId[] vSwitchesData = new CommKeyClassId[vSwithces.length];
            int i = vSwithces.length;
            while (i-- > 0) {
                vSwitchesData[i] = vSwithces[i].getCommKeyClassId();
            }
            CommKeyClassId[] pitKeyList = new CommKeyClassId[currentPits.length];
            int i2 = currentPits.length;
            while (i2-- > 0) {
                pitKeyList[i2] = currentPits[i2].getCommKeyClassId();
            }
            ConfigElementData element = new ConfigElementData(ClassID.DR_ASYNC_PAIR_PIT);
            element.setValue(ParameterCode.DR_PIT_PARENT_ID, this.getCommKeyClassId());
            element.addParameter(new Parameter(ParameterCode.DR_PIT_LIST, pitKeyList));
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchesData));
            DataMgr.getInstance().refreshTableFields(element);
        }
    }
}

