/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster.dr;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAbstractConsistencyGroup;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterActivateImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPair;
import com.sanrad.nms.server.logic.dr.DRPiTImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.policies.PoliciesManager;
import com.sanrad.nms.server.logic.policies.Policy;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public abstract class DRClusterAbstractConsistencyGroupImpl
extends DRClusterActivateImpl
implements DRClusterAbstractConsistencyGroup {
    ArrayList m_pairs = null;
    private static final ParameterCode[] paramList = new ParameterCode[]{ParameterCode.DR_CONSISTENCY_GROUP_ACTIVATE, ParameterCode.DR_VIRT_GROUP_STATE, ParameterCode.DR_CONSISTENCY_GROUP_INITIAL_SYNC_STATE, ParameterCode.DR_CONSISTENCY_GROUP_MODE, ParameterCode.DR_CONSISTENCY_GROUP_PENDING_DATA, ParameterCode.DR_CONSISTENCY_GROUP_PENDING_PITS, ParameterCode.DR_CONSISTENCY_GROUP_REPLICATION_STATE, ParameterCode.DR_CONSISTENCY_GROUP_ROLE, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_PARAM_ID, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_PARAM_ID, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_PARAM_ID, ParameterCode.DR_VIRT_GROUP_ELEMENTS_COUNT, ParameterCode.DR_CONSISTENCY_GROUP_NEXT_REPLICATION_SCHEDULE, ParameterCode.DR_CONSISTENCY_GROUP_LAST_PIT_MERGE, ParameterCode.DR_PIT_PARENT_LAST_UPDATE};
    private static int m_policiesIndex = 0;
    private static final int PIT = DRClusterAbstractConsistencyGroupImpl.increment();
    private static final int TRANSFER = DRClusterAbstractConsistencyGroupImpl.increment();
    public static final int MERGE = DRClusterAbstractConsistencyGroupImpl.increment();

    protected DRClusterAbstractConsistencyGroupImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
        super(cluster, classId, paramList);
    }

    private static int increment() {
        return m_policiesIndex++;
    }

    public boolean isEmpty() {
        DRClusterAsyncPair[] pairs = this.getPairs();
        return pairs == null || pairs.length == 0;
    }

    public boolean equalsInCluster(HashMap parameterList) throws RemoteException {
        DRRoleConstant newRole;
        CommKeyClassId newVSwitchId;
        int numOfVswitches = this.getConnectedVSwitchCounter();
        if (numOfVswitches != 1) {
            return false;
        }
        VSwitch vSwitch = this.getActiveVswitch();
        CommKeyClassId vSwitchId = vSwitch.getCommKeyClassId();
        if (vSwitchId.equals(newVSwitchId = (CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID))) {
            return false;
        }
        DRRoleConstant myRole = this.getRole();
        if (myRole != (newRole = (DRRoleConstant)parameterList.get(ParameterCode.DR_CONSISTENCY_GROUP_ROLE))) {
            return false;
        }
        Policy[] currPolicies = this.getPoliciesByParameters(vSwitch);
        Policy[] compareToPolicies = this.getPoliciesByParameterList(parameterList);
        return this.allPoliciesEqual(currPolicies, compareToPolicies);
    }

    private boolean allPoliciesEqual(Policy[] myPolicies, Policy[] otherPolicies) throws RemoteException {
        for (int i = 0; i < myPolicies.length; ++i) {
            Policy myCurrPolicy = myPolicies[i];
            Policy otherCurrPolicy = otherPolicies[i];
            if (this.policiesEqual(myCurrPolicy, otherCurrPolicy)) continue;
            return false;
        }
        return true;
    }

    private boolean policiesEqual(Policy pol1, Policy pol2) {
        if (pol1 != null && pol2 != null) {
            return pol1.equals(pol2);
        }
        return false;
    }

    public boolean isLocal() throws RemoteException {
        return this.getRole().equals(DRRoleConstant.LOCAL);
    }

    public DRRoleConstant getRole() throws RemoteException {
        return (DRRoleConstant)this.getSrValueOf(ParameterCode.DR_CONSISTENCY_GROUP_ROLE);
    }

    public long getPendingPiTs() throws RemoteException {
        BigInteger pendingPiTs = (BigInteger)this.getValueOf(ParameterCode.DR_CONSISTENCY_GROUP_PENDING_PITS);
        if (pendingPiTs != null) {
            return pendingPiTs.longValue();
        }
        return 0L;
    }

    public void addPair(DRClusterAsyncPair newPair) throws IllegalValueException {
        this.addPairToGroup(newPair);
    }

    public Policy getPiTPolicy(VSwitch vSwitch) throws RemoteException {
        if (vSwitch != null) {
            CommKeyClassId vSwitchId = vSwitch.getCommKeyClassId();
            CommKeyClassId pitStartKey = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID);
            CommKeyClassId pitParamsKey = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_PARAM_ID);
            if (pitStartKey != null && pitParamsKey != null) {
                return PoliciesManager.getInstance().getPolicy(vSwitchId, pitStartKey, pitParamsKey);
            }
        }
        return null;
    }

    public Policy getTransferPolicy(VSwitch vSwitch) throws RemoteException {
        if (vSwitch != null) {
            CommKeyClassId vSwitchId = vSwitch.getCommKeyClassId();
            CommKeyClassId transferStartKey = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID);
            CommKeyClassId transferParamsKey = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_PARAM_ID);
            if (transferStartKey != null && transferParamsKey != null) {
                return PoliciesManager.getInstance().getPolicy(vSwitchId, transferStartKey, transferParamsKey);
            }
        }
        return null;
    }

    public Policy getMergePolicy(VSwitch vSwitch) throws RemoteException {
        if (vSwitch != null) {
            CommKeyClassId vSwitchId = vSwitch.getCommKeyClassId();
            CommKeyClassId mergeStartKey = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID);
            CommKeyClassId mergeParamsKey = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_PARAM_ID);
            if (mergeStartKey != null && mergeParamsKey != null) {
                return PoliciesManager.getInstance().getPolicy(vSwitchId, mergeStartKey, mergeParamsKey);
            }
        }
        return null;
    }

    protected Policy[] getPoliciesByParameters(VSwitch vSwitch) throws RemoteException {
        return new Policy[]{this.getPiTPolicy(vSwitch), this.getTransferPolicy(vSwitch), this.getMergePolicy(vSwitch)};
    }

    protected Policy[] getPoliciesByParameterList(HashMap parameterList) throws RemoteException {
        CommKeyClassId vSwitchId = (CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID);
        CommKeyClassId pitStartKey = (CommKeyClassId)parameterList.get(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID);
        CommKeyClassId pitParamsKey = (CommKeyClassId)parameterList.get(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_PARAM_ID);
        CommKeyClassId transferStartKey = (CommKeyClassId)parameterList.get(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID);
        CommKeyClassId transferParamsKey = (CommKeyClassId)parameterList.get(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_PARAM_ID);
        CommKeyClassId mergeStartKey = (CommKeyClassId)parameterList.get(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID);
        CommKeyClassId mergeParamsKey = (CommKeyClassId)parameterList.get(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_PARAM_ID);
        return this.createPoliciesInArray(vSwitchId, pitStartKey, pitParamsKey, transferStartKey, transferParamsKey, mergeStartKey, mergeParamsKey);
    }

    private Policy[] createPoliciesInArray(CommKeyClassId vSwitchId, CommKeyClassId pitStartKey, CommKeyClassId pitParamsKey, CommKeyClassId transferStartKey, CommKeyClassId transferParamsKey, CommKeyClassId mergeStartKey, CommKeyClassId mergeParamsKey) throws RemoteException {
        Policy[] policies = new Policy[m_policiesIndex];
        policies[DRClusterAbstractConsistencyGroupImpl.PIT] = PoliciesManager.getInstance().getPolicy(vSwitchId, pitStartKey, pitParamsKey);
        policies[DRClusterAbstractConsistencyGroupImpl.TRANSFER] = PoliciesManager.getInstance().getPolicy(vSwitchId, transferStartKey, transferParamsKey);
        policies[DRClusterAbstractConsistencyGroupImpl.MERGE] = PoliciesManager.getInstance().getPolicy(vSwitchId, mergeStartKey, mergeParamsKey);
        return policies;
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public void changeElement(HashMap parameterList) throws RemoteException, IllegalValueException {
        Object ive = null;
        HashMap repPolicy = null;
        HashMap transferPolicy = null;
        HashMap mergePolicy = null;
        ConfigElementData ced = new ConfigElementData(this.getCommKeyClassId());
        String msg = this.isValid(parameterList);
        Iterator i = parameterList.keySet().iterator();
        while (i.hasNext()) {
            ClientParameterCode currParam = (ClientParameterCode)i.next();
            if (currParam.equals(ClientParameterCode.DR_CONSISTENCY_GROUP_REPLICATION_POLICY)) {
                repPolicy = (HashMap)parameterList.get(currParam);
                continue;
            }
            if (currParam.equals(ClientParameterCode.DR_CONSISTENCY_GROUP_TRANSFER_POLICY)) {
                transferPolicy = (HashMap)parameterList.get(currParam);
                continue;
            }
            if (currParam.equals(ClientParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY)) {
                mergePolicy = (HashMap)parameterList.get(currParam);
                continue;
            }
            if (msg == null) {
                ParameterCode currCode = currParam.getParameterCode();
                if (currCode == null) continue;
                Parameter currParameter = new Parameter(currCode, parameterList.get(currParam));
                ced.addParameter(currParameter);
                continue;
            }
            throw new IllegalValueException(msg);
        }
        DRRootImpl.getInstance().prepareElementPolicies(ced, repPolicy, transferPolicy, mergePolicy, (ClusterImpl)this.getCluster());
        if (!ced.getParametersList().isEmpty()) {
            DataMgr.getInstance().changeElement(ced);
        } else if (ive != null) {
            throw ive;
        }
    }

    public abstract DRClusterAsyncPair[] getPairs();

    public abstract void addPairToGroup(DRClusterAsyncPair var1) throws IllegalValueException;

    public HashMap getClientParameterList() throws RemoteException {
        HashMap parameterList = null;
        VSwitch vs = this.getActiveVswitch();
        if (vs != null) {
            parameterList = ElementEventImpl.convertParameterList(this.getParameters(vs), this);
            parameterList.put(ClientParameterCode.DR_CONSISTENCY_GROUP_REPLICATION_POLICY, this.getPiTPolicy(vs));
            parameterList.put(ClientParameterCode.DR_CONSISTENCY_GROUP_TRANSFER_POLICY, this.getTransferPolicy(vs));
            parameterList.put(ClientParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY, this.getMergePolicy(vs));
        } else {
            parameterList = super.getClientParameterList();
            logger.warning("No " + ClassID.VSWITCH + " found for " + this);
        }
        return parameterList;
    }

    public VSwitch getDominentVswitch() throws RemoteException {
        if (this.getPairs() == null || this.getPairs().length == 0 || this.getConnectedVSwitches().length == 1) {
            return super.getDominentVswitch();
        }
        return ((LogicObjectImpl)((Object)this.getPairs()[0])).getDominentVswitch();
    }

    public ParameterCode getActivateParameterCode() throws RemoteException, IllegalValueException {
        return ParameterCode.DR_CONSISTENCY_GROUP_ACTIVATE;
    }

    public boolean comparePolicies() throws RemoteException {
        Policy mergePolicy = this.getMergePolicy(this.getActiveVswitch());
        Policy transferPolicy = this.getTransferPolicy(this.getActiveVswitch());
        Policy pitPolicy = this.getPiTPolicy(this.getActiveVswitch());
        if (mergePolicy == null || pitPolicy == null || transferPolicy == null) {
            return false;
        }
        return mergePolicy.equals(this.getMergePolicy(this.getInactiveVSwitch())) && pitPolicy.equals(this.getPiTPolicy(this.getInactiveVSwitch())) && transferPolicy.equals(this.getMergePolicy(this.getInactiveVSwitch()));
    }

    public boolean isPairEquals(DRClusterAbstractConsistencyGroupImpl group) {
        if (this.hasNoPairs() || group.hasNoPairs()) {
            return false;
        }
        return Arrays.equals(this.getPairs(), group.getPairs());
    }

    public boolean hasNoPairs() {
        return this.m_pairs == null;
    }

    public void refreshPiTs(DRPiTImpl[] currentPits) throws RemoteException {
        VSwitch[] vSwithces = this.getConnectedVSwitches();
        if (vSwithces != null && vSwithces.length > 0) {
            CommKeyClassId[] vSwitchesData = new CommKeyClassId[vSwithces.length];
            int i = vSwithces.length;
            while (i-- > 0) {
                vSwitchesData[i] = vSwithces[i].getCommKeyClassId();
            }
            CommKeyClassId[] pitKeyList = new CommKeyClassId[currentPits.length];
            int i2 = currentPits.length;
            while (i2-- > 0) {
                pitKeyList[i2] = currentPits[i2].getCommKeyClassId();
            }
            ConfigElementData element = new ConfigElementData(ClassID.DR_CONSISTENCY_GROUP_PIT);
            element.setValue(ParameterCode.DR_PIT_PARENT_ID, this.getCommKeyClassId());
            element.addParameter(new Parameter(ParameterCode.DR_PIT_LIST, pitKeyList));
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchesData));
            DataMgr.getInstance().refreshTableFields(element);
        }
    }
}

