/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.DrAlarmMgrImpl;
import com.sanrad.nms.server.alarm.GeneralAlarmMgrImpl;
import com.sanrad.nms.server.alarm.cluster.ClusterAlarmGenerator;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.event.ErrorEvent;
import com.sanrad.nms.server.event.SnmpErrorEvent;
import com.sanrad.nms.server.event.SrChangeElementEvent;
import com.sanrad.nms.server.event.SrCheckListEvent;
import com.sanrad.nms.server.event.SrElementEvent;
import com.sanrad.nms.server.event.SrElementOperationErrorEvent;
import com.sanrad.nms.server.event.SrEvent;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.event.SrKillClusterThreadEvent;
import com.sanrad.nms.server.event.SrVSwitchMessageEvent;
import com.sanrad.nms.server.logic.AlreadyKnownByVSwitch;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.CommKeyRefMap;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.EventServiceImpl;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SiteImpl;
import com.sanrad.nms.server.logic.SitesSynchronizeable;
import com.sanrad.nms.server.logic.Synchronizeable;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.VSwitchGroupImpl;
import com.sanrad.nms.server.logic.acl.Acl;
import com.sanrad.nms.server.logic.acl.AclEntry;
import com.sanrad.nms.server.logic.acl.AclEntryImpl;
import com.sanrad.nms.server.logic.acl.AclImpl;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.nms.server.logic.acl.PolicyManager;
import com.sanrad.nms.server.logic.acl.PolicyManagerImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.EventQueueElement;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterManager;
import com.sanrad.nms.server.logic.dr.DREvent;
import com.sanrad.nms.server.logic.dr.DRLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.hardware.HardwareImpl;
import com.sanrad.nms.server.logic.identity.CHAPCredentials;
import com.sanrad.nms.server.logic.identity.CHAPCredentialsImpl;
import com.sanrad.nms.server.logic.identity.Credentials;
import com.sanrad.nms.server.logic.identity.CredentialsImpl;
import com.sanrad.nms.server.logic.identity.IdentitiesList;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.identity.IdentityName;
import com.sanrad.nms.server.logic.identity.IdentityNameImpl;
import com.sanrad.nms.server.logic.identity.IdentityValidator;
import com.sanrad.nms.server.logic.identity.SRPCredentials;
import com.sanrad.nms.server.logic.identity.SRPCredentialsImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiatorImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiator;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorStatistics;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorStatisticsImpl;
import com.sanrad.nms.server.logic.initiator.SCSIInitiatorPort;
import com.sanrad.nms.server.logic.initiator.SCSIInitiatorPortImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSIConnection;
import com.sanrad.nms.server.logic.iscsi.ISCSIConnectionImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSIInstance;
import com.sanrad.nms.server.logic.iscsi.ISCSIInstanceImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionStatistics;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionStatisticsImpl;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.lu.SCSILunImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SequentialAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.policies.PoliciesManager;
import com.sanrad.nms.server.logic.policies.PolicyParamTableEntryImpl;
import com.sanrad.nms.server.logic.policies.PolicyTableEntryImpl;
import com.sanrad.nms.server.logic.scsi.SCSIDeviceImpl;
import com.sanrad.nms.server.logic.scsi.SCSIISCSIDeviceMap;
import com.sanrad.nms.server.logic.srv.ExternalServerList;
import com.sanrad.nms.server.logic.srv.isns.ISNSServer;
import com.sanrad.nms.server.logic.srv.isns.ISNSServerImpl;
import com.sanrad.nms.server.logic.srv.isns.ISNSServerValidator;
import com.sanrad.nms.server.logic.srv.radius.RadiusServer;
import com.sanrad.nms.server.logic.srv.radius.RadiusServerImpl;
import com.sanrad.nms.server.logic.srv.radius.RadiusServerValidator;
import com.sanrad.nms.server.logic.statistics.StatisticsImpl;
import com.sanrad.nms.server.logic.storage.Storage;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.storage.StoragePool;
import com.sanrad.nms.server.logic.target.ISCSIRemotePortalDiscovery;
import com.sanrad.nms.server.logic.target.ISCSIRemotePortalDiscoveryImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTarget;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortal;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortalImpl;
import com.sanrad.nms.server.logic.target.ISCSITarget;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.target.RemoteTargetList;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.target.TargetList;
import com.sanrad.nms.server.logic.volume.MirrorVolumeImpl;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeManager;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManager;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManagerImpl;
import com.sanrad.nms.server.logic.vswitch.IPRouteTableRow;
import com.sanrad.nms.server.logic.vswitch.IPRouteTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.IPTableRow;
import com.sanrad.nms.server.logic.vswitch.IPTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRow;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.Manager;
import com.sanrad.nms.server.logic.vswitch.ManagerImpl;
import com.sanrad.nms.server.logic.vswitch.Neighbor;
import com.sanrad.nms.server.logic.vswitch.NeighborImpl;
import com.sanrad.nms.server.logic.vswitch.PortalTableRow;
import com.sanrad.nms.server.logic.vswitch.PortalTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.TableRow;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchConnectivityEvent;
import com.sanrad.nms.server.logic.vswitch.VSwitchConnectivityListener;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchValidator;
import com.sanrad.nms.server.logic.vswitch.ethernet.EthernetInterfaceTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.fc.FCInterfaceTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.fc.FCNode;
import com.sanrad.nms.server.logic.vswitch.fc.FCNodeImpl;
import com.sanrad.nms.server.logic.vswitch.pscsi.PSCSIInterfaceTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.EthernetStatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.ICMPStatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.IPStatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.InterfaceStatisticsTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.TCPConnectionStatisticsTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.TCPStatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.UDPListenerStatisticsTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.UDPStatisticsImpl;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.mgr.operation.ElementOperation;
import com.sanrad.nms.server.mgr.operation.ElementOperationList;
import com.sanrad.nms.server.mgr.volume.MirrVolConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.MasterParameter;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.VSwitchClusterMap;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrLong;
import com.sanrad.nms.server.util.types.SrNumber;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.nms.server.util.types.constants.IANAifTypeConstant;
import com.sanrad.nms.server.util.types.constants.IdentityPurposeConstant;
import com.sanrad.nms.server.util.types.constants.SDTakeOverStateConstant;
import com.sanrad.nms.server.util.types.constants.SessionDirectionConstant;
import com.sanrad.nms.server.util.types.constants.SnapshotActivateTypeConstants;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.util.Queue;
import java.lang.constant.Constable;
import java.math.BigInteger;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class ClusterImpl
extends VSwitchGroupImpl
implements Cluster,
VSwitchConnectivityListener {
    public static final int MAX_VSWITCHES_IN_CLUSTER = 2;
    private StorageImpl storage;
    private Vector m_vSwitches = new Vector();
    private boolean clusterDiscoveryCompleted = false;
    private ClusterThread queueConsumerThread = null;
    private Queue eventQueue = new Queue();
    private GeneralAlarmMgrImpl alarmMgr = AlarmMgrImpl.getInstance();
    private GeneralAlarmMgrImpl drAlarmMgr = DrAlarmMgrImpl.getInstance();
    private PolicyManagerImpl policyMgr = new PolicyManagerImpl();
    private Vector vSwitchConnectivityListeners = new Vector();
    private CopyOperationManagerImpl copyOperMgr = new CopyOperationManagerImpl(this);
    private IdentitiesList identities = new IdentitiesList();
    private ExternalServerList radiusServerList = new ExternalServerList();
    private ExternalServerList isnsServerList = new ExternalServerList();
    private CommKeyRefMap commKeyRefMap = new CommKeyRefMap();
    private boolean synchronizeClusterParametersDone = false;
    private HashMap pendingNewElements = new HashMap();
    private SCSIISCSIDeviceMap m_scsiDeviceIscsiNodeMap = new SCSIISCSIDeviceMap();
    private DRClusterManager drManager = new DRClusterManager(this);
    private Object m_queueConsumerThreadSyncLock = new Object();
    private boolean m_isStopThreadAlreadyAsked = false;

    public ClusterImpl() throws RemoteException {
        super(ClassID.CLUSTER);
        this.addParameterCode(ParameterCode.CLUSTER_ALIAS);
        this.addParameterCode(ParameterCode.CLUSTER_MODE);
        this.addParameterCode(ParameterCode.PARENT_SITE_ID);
        this.addParameterCode(ParameterCode.CLUSTER_STORAGE_COMPARISON);
        this.addParameterCode(ParameterCode.GENERAL_POLL_INTERVAL);
        this.addParameterCode(ParameterCode.VIRTUALIZATION_POLL_INTERVAL);
        this.addParameterCode(ParameterCode.ACL_POLL_INTERVAL);
        this.addParameterCode(ParameterCode.NET_POLL_INTERVAL);
        this.addParameterCode(ParameterCode.STATISTIC_POLL_INTERVAL);
        this.storage = new StorageImpl(this);
        this.startQueueConsumerThread();
        this.toStringValue = ClassID.CLUSTER.toString();
        this.cluster = this;
    }

    public DRClusterManager getDRManager() {
        return this.drManager;
    }

    public void addVSwitchConnectivityListener(VSwitchConnectivityListener listener) {
        this.vSwitchConnectivityListeners.add(listener);
    }

    public void removeVSwitchConnectivityListener(VSwitchConnectivityListener listener) {
        this.vSwitchConnectivityListeners.remove(listener);
    }

    private void fireVSwitchConnectivityChanged(VSwitchConnectivityEvent event) {
        Iterator itr = this.vSwitchConnectivityListeners.iterator();
        while (itr.hasNext()) {
            ((VSwitchConnectivityListener)itr.next()).vSwitchConnectivityChanged(event);
        }
    }

    public void vSwitchConnectivityChanged(VSwitchConnectivityEvent event) {
        this.fireVSwitchConnectivityChanged(event);
    }

    public Storage getStorage() throws RemoteException {
        return this.storage;
    }

    public CommKeyRefMap getCommKeyRefMap() {
        return this.commKeyRefMap;
    }

    public boolean isDiscoverCompleted() throws RemoteException {
        if (!this.isClusterDiscoveryCompleted()) {
            return false;
        }
        Enumeration e = this.m_vSwitches.elements();
        while (e.hasMoreElements()) {
            VSwitchImpl vSwitch = (VSwitchImpl)e.nextElement();
            if (vSwitch.isVirtualizationDiscoverCompleted() && vSwitch.isVSwitchDiscoverCompleted()) continue;
            return false;
        }
        return true;
    }

    public boolean isDiscoverOfOtherVSwitchesCompleted(VSwitch thisVSwitch) throws RemoteException {
        Enumeration e = this.m_vSwitches.elements();
        while (e.hasMoreElements()) {
            VSwitchImpl vSwitch = (VSwitchImpl)e.nextElement();
            if (thisVSwitch.equals(vSwitch) || vSwitch.isVirtualizationDiscoverCompleted() && vSwitch.isVSwitchDiscoverCompleted()) continue;
            return false;
        }
        return true;
    }

    public Vector getVSwitches() throws RemoteException {
        return this.m_vSwitches;
    }

    public VSwitch getMyNeighbor(String myIp) throws RemoteException {
        Enumeration e = this.m_vSwitches.elements();
        while (e.hasMoreElements()) {
            VSwitch vSwitch = (VSwitch)e.nextElement();
            Vector neighbors = vSwitch.getNeighborTable();
            Enumeration n = neighbors.elements();
            while (n.hasMoreElements()) {
                Neighbor neighbor = (Neighbor)n.nextElement();
                if (!neighbor.getIPAddress().equals(myIp)) continue;
                return vSwitch;
            }
        }
        return null;
    }

    public Vector getNeighbors() throws RemoteException {
        Vector neighbors = new Vector();
        Enumeration e = this.m_vSwitches.elements();
        while (e.hasMoreElements()) {
            VSwitch vSwitch = (VSwitch)e.nextElement();
            neighbors.addAll(vSwitch.getNeighborTable());
        }
        return neighbors;
    }

    public Vector getTargetsExposedOnVSwitch(VSwitch vSwitch) throws RemoteException {
        return this.getTargetListMgr().getTargetsExposedOnVSwitch(vSwitch.getName());
    }

    public Vector getOtherVSwitchTargetsExposedOnVSwitch(VSwitch exposedOnVSwitch) throws RemoteException {
        VSwitch other = this.getOtherVSwitch(exposedOnVSwitch);
        if (other == null) {
            return this.getTargetsExposedOnVSwitch(exposedOnVSwitch);
        }
        return this.getTargetListMgr().getTargetsExposedOnVSwitch(other, exposedOnVSwitch.getName());
    }

    public VSwitch getOtherVSwitch(VSwitch vSwitch) throws RemoteException {
        VSwitch vSwitchObj;
        CommKeyClassId vSwitchCommKeyClassId;
        if (vSwitch != null && (vSwitchCommKeyClassId = vSwitch.getCommKeyClassId()) != null && (vSwitchObj = (VSwitch)SystemRootImpl.getInstance().getRefByStub(vSwitchCommKeyClassId)) != null) {
            Iterator i = this.getVSwitches().iterator();
            while (i.hasNext()) {
                VSwitch otherVSwitch = (VSwitch)i.next();
                if (otherVSwitch.equals(vSwitchObj)) continue;
                return otherVSwitch;
            }
        }
        return null;
    }

    public boolean isVSwitchNameExistOnOtherVSwitch(String name, String myIpAddress) {
        try {
            Enumeration e = this.m_vSwitches.elements();
            while (e.hasMoreElements()) {
                VSwitch vSwitch = (VSwitch)e.nextElement();
                if (myIpAddress.equals(vSwitch.getMgmIPAddr()) || !vSwitch.getName().equals(name)) continue;
                return true;
            }
        }
        catch (RemoteException re) {
            logger.error(re);
        }
        return false;
    }

    public boolean isContainVSwitch(String vSwitchIp) throws RemoteException {
        Enumeration e = this.m_vSwitches.elements();
        while (e.hasMoreElements()) {
            VSwitch vSwitch = (VSwitch)e.nextElement();
            if (vSwitch.getMgmIPAddr().equals(vSwitchIp)) {
                return true;
            }
            Enumeration n = vSwitch.getNeighborTable().elements();
            while (n.hasMoreElements()) {
                Neighbor neighbor = (Neighbor)n.nextElement();
                if (!neighbor.getIPAddress().equals(vSwitchIp)) continue;
                return true;
            }
        }
        return false;
    }

    public ISCSISessionImpl getISCSISessionActiveForRemoteInitiator(String iscsiRemoteInitiatorName) throws RemoteException {
        Enumeration e = this.m_vSwitches.elements();
        while (e.hasMoreElements()) {
            VSwitch vSwitch = (VSwitch)e.nextElement();
            Enumeration n = vSwitch.getISCSISessionsTable().elements();
            while (n.hasMoreElements()) {
                ISCSISessionImpl session = (ISCSISessionImpl)n.nextElement();
                if (!session.getInitiatorName().equals(iscsiRemoteInitiatorName)) continue;
                return session;
            }
        }
        return null;
    }

    public boolean isVSwitchNameExist(String name) {
        try {
            Enumeration e = this.m_vSwitches.elements();
            while (e.hasMoreElements()) {
                VSwitch vSwitch = (VSwitch)e.nextElement();
                if (!vSwitch.getName().equals(name)) continue;
                return true;
            }
        }
        catch (RemoteException re) {
            logger.error(re);
        }
        return false;
    }

    public Vector getOtherVSwitches(Vector vSwitches) {
        Vector<VSwitch> otherVSwitches = new Vector<VSwitch>();
        Enumeration v = vSwitches.elements();
        while (v.hasMoreElements()) {
            VSwitch vSwitch = (VSwitch)v.nextElement();
            Enumeration e = this.m_vSwitches.elements();
            while (e.hasMoreElements()) {
                VSwitch next = (VSwitch)e.nextElement();
                if (next.equals(vSwitch)) continue;
                otherVSwitches.addElement(next);
            }
        }
        return otherVSwitches;
    }

    private VSwitchImpl getVSwitch(ClassID classId, CommKey[] commKeys, HashMap parameterList) throws RemoteException {
        CommKeyClassId vSwitchCommKeyClassId = null;
        if (classId.equals(ClassID.VSWITCH)) {
            vSwitchCommKeyClassId = new CommKeyClassId(commKeys, classId);
        } else {
            Object vSwitchObj = parameterList.get(ParameterCode.VSWITCH_ID);
            if (vSwitchObj instanceof CommKeyClassId) {
                vSwitchCommKeyClassId = (CommKeyClassId)vSwitchObj;
            } else if (vSwitchObj != null) {
                vSwitchCommKeyClassId = ((CommKeyClassId[])vSwitchObj)[0];
                logger.debug("ParameterCode.VSWITCH_ID shouldn't be an array");
            }
        }
        if (vSwitchCommKeyClassId != null) {
            VSwitchImpl vSwitch = (VSwitchImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(vSwitchCommKeyClassId);
            return vSwitch;
        }
        logger.debug("No " + ClassID.VSWITCH + " found for " + classId + " with commkeys " + commKeys[0]);
        return null;
    }

    public boolean isOtherVSwitchTakenOver(VSwitch vSwitch) throws RemoteException {
        VSwitchImpl otherVSwitch = (VSwitchImpl)this.getOtherVSwitch(vSwitch);
        return otherVSwitch != null && otherVSwitch.isUnderTakeover();
    }

    public VSwitch getVSwitchUnderTakeover() throws RemoteException {
        Enumeration e = this.m_vSwitches.elements();
        while (e.hasMoreElements()) {
            VSwitchImpl vSwitch = (VSwitchImpl)e.nextElement();
            if (!vSwitch.isUnderTakeover()) continue;
            return vSwitch;
        }
        return null;
    }

    public VSwitch getVSwitchByName(String name) throws RemoteException {
        String neighborName;
        Vector neighbors;
        VSwitchImpl vSwitch;
        VSwitchImpl vSwitchNeighbor;
        Enumeration e = this.m_vSwitches.elements();
        while (e.hasMoreElements()) {
            VSwitch vSwitch2 = (VSwitch)e.nextElement();
            if (!vSwitch2.getName().equals(name)) continue;
            return vSwitch2;
        }
        if (this.m_vSwitches.size() > 1 && this.getConnectedVSwitchCounter() > 0 && (vSwitchNeighbor = (VSwitchImpl)this.getMyNeighbor((vSwitch = (VSwitchImpl)this.getConnectedVSwitches()[0]).getMgmIPAddr())) != null && (neighbors = vSwitchNeighbor.getNeighborTable()) != null && !neighbors.isEmpty() && (neighborName = ((Neighbor)neighbors.firstElement()).getName()).equals(name)) {
            return vSwitch;
        }
        return null;
    }

    public VSwitch getVSwitchByIPAddress(String ipAddr) throws RemoteException {
        if (this.m_vSwitches != null) {
            Iterator iter = this.m_vSwitches.iterator();
            while (iter.hasNext()) {
                VSwitch vSwitch = (VSwitch)iter.next();
                if (!vSwitch.getMgmIPAddr().equals(ipAddr)) continue;
                return vSwitch;
            }
        }
        return null;
    }

    public void createIdentity(String alias, String description) throws RemoteException, IllegalValueException {
        IdentityValidator identityValidator = new IdentityValidator(this, alias, description);
        if (!identityValidator.isValid()) {
            throw new IllegalValueException(identityValidator.getErrorMsg());
        }
        this.createIdentity(alias, description, null, null, null, null);
    }

    public void createIdentity(String alias, String description, Vector vSwitches, IdentityPurposeConstant purpose) throws RemoteException, IllegalValueException {
        this.createIdentity(alias, description, vSwitches, purpose, null, null);
    }

    private void createIdentity(String alias, String description, Vector vSwitches, IdentityPurposeConstant purpose, ArrayList identityNames, Target targetForACL) throws RemoteException, IllegalValueException {
        boolean setUniqueAlias;
        ConfigElementData element = new ConfigElementData(ClassID.IDENTITY);
        Parameter identityPurpose = new Parameter(ParameterCode.IDENTITY_PURPOSE, purpose == null ? IdentityPurposeConstant.UNKNOWN : purpose);
        element.addParameter(identityPurpose);
        IdentityPurposeConstant setPurpose = (IdentityPurposeConstant)identityPurpose.getValue();
        String setAlias = alias;
        boolean bl = setUniqueAlias = !setPurpose.equals(IdentityPurposeConstant.REMOTE_TARGET) && !setPurpose.equals(IdentityPurposeConstant.LOCAL_TARGET) && !setPurpose.equals(IdentityPurposeConstant.UNKNOWN);
        if (setUniqueAlias && (vSwitches == null || vSwitches.containsAll(this.m_vSwitches))) {
            StringBuffer sb = new StringBuffer(setAlias);
            String currTime = String.valueOf(System.currentTimeMillis());
            sb.append(currTime);
            setAlias = sb.toString();
        }
        Parameter identityAlias = new Parameter(ParameterCode.IDENTITY_ALIAS, new SrString(setAlias));
        element.addParameter(identityAlias);
        Parameter identityDescription = new Parameter(ParameterCode.IDENTITY_DESCRIPTION, new SrString(description));
        element.addParameter(identityDescription);
        if (identityNames != null) {
            if (setPurpose.equals(IdentityPurposeConstant.REMOTE_INITIATOR_DR)) {
                if (this.getIdentitiesList().isDrIdentityOnPendingCreateForInitiatorNames(identityNames)) {
                    return;
                }
                this.getIdentitiesList().addDrIdentityPendingCreateForInitiatorNames(setAlias, identityNames);
            }
            SrString[] names = new SrString[identityNames.size()];
            for (int index = 0; index < identityNames.size(); ++index) {
                String nameStr = (String)identityNames.get(index);
                names[index] = new SrString(nameStr);
            }
            Parameter identityNamesParameter = new Parameter(ParameterCode.IDENTITY_NAMES, names);
            element.addParameter(identityNamesParameter);
        }
        if (targetForACL != null) {
            Parameter targetForACLParameter = new Parameter(ParameterCode.ACL_ENTRY_TARGET_PARENT, targetForACL.getCommKeyClassId());
            element.addParameter(targetForACLParameter);
        }
        this.createElement(element, ClassID.IDENTITY, setAlias, vSwitches);
    }

    public void createRadiusServer(String serverIp, String port, String key) throws RemoteException, IllegalValueException {
        RadiusServerValidator radiusServerValidator = new RadiusServerValidator(this, serverIp, port, key);
        if (!radiusServerValidator.isValid()) {
            throw new IllegalValueException(radiusServerValidator.getErrorMsg());
        }
        this.createRadiusServer(serverIp, port, key, null);
    }

    public void createRadiusServer(String serverIp, String port, String key, Vector vSwitches) throws RemoteException, IllegalValueException {
        ConfigElementData element = new ConfigElementData(ClassID.RADIUS_SERVER);
        Parameter serverIpParam = new Parameter(ParameterCode.RADIUS_SERVER_IP_ADDRESS, new SrIpAddress(serverIp));
        element.addParameter(serverIpParam);
        Parameter serverPortParam = new Parameter(ParameterCode.RADIUS_SERVER_PORT, new SrInteger(port));
        element.addParameter(serverPortParam);
        Parameter serverKeyParam = new Parameter(ParameterCode.RADIUS_SERVER_KEY, new SrString(key));
        element.addParameter(serverKeyParam);
        this.createElement(element, ClassID.RADIUS_SERVER, serverIp, vSwitches);
    }

    public void createISNSServer(String serverIp) throws RemoteException, IllegalValueException {
        ISNSServerValidator isnsServerValidator = new ISNSServerValidator(this, serverIp);
        if (!isnsServerValidator.isValid()) {
            throw new IllegalValueException(isnsServerValidator.getErrorMsg());
        }
        this.createISNSServer(serverIp, null);
    }

    public void createISNSServer(String serverIp, Vector vSwitches) throws RemoteException, IllegalValueException {
        ConfigElementData element = new ConfigElementData(ClassID.ISNS_SERVER);
        Parameter serverIpParam = new Parameter(ParameterCode.ISNS_SERVER_IP_ADDRESS, new SrIpAddress(serverIp));
        element.addParameter(serverIpParam);
        this.createElement(element, ClassID.ISNS_SERVER, serverIp, vSwitches);
    }

    public void addVSwitch(VSwitch vSwitch) throws RemoteException, IllegalValueException {
        this.addVSwitch(vSwitch.getMgmIPAddr(), vSwitch.getMgmMask(), vSwitch.getSnmpPort(), vSwitch.getTrapPort(), vSwitch.getReadCommunity(), vSwitch.getWriteCommunity(), vSwitch.getTimeout(), vSwitch.getNumberOfRetries(), vSwitch.getSnmpVersion());
    }

    public void addVSwitch(String ipAddr, String mask, int snmpPort, int trapPort, String readCommunity, String writeCommunity, long timeout, int numberOfRetries, SnmpVersion snmpVersion) throws RemoteException, IllegalValueException {
        if (this.getVSwitchesCount() < 2) {
            VSwitchValidator validator = new VSwitchValidator(this, ipAddr, mask, readCommunity, writeCommunity);
            if (!validator.isValid()) {
                throw new IllegalValueException(validator.getErrorMsg());
            }
            VSwitch vSwitch = this.getVSwitchByIPAddress(ipAddr);
            if (vSwitch == null) {
                if (this.isSingleVSwitchMode() && this.getVSwitchesCount() > 0) {
                    this.changeSingleVSwitchMode(false);
                }
                ConfigElementData element = new ConfigElementData(ClassID.VSWITCH);
                element.addParameter(new Parameter(ParameterCode.VSWITCH_GROUP_ID, new SrInteger(this.getVSwitchGroupId())));
                element.addParameter(new Parameter(ParameterCode.VSWITCH_IP_ADDRESS, new SrIpAddress(ipAddr)));
                element.addParameter(new Parameter(ParameterCode.VSWITCH_IP_MASK, new SrIpAddress(mask)));
                element.addParameter(new Parameter(ParameterCode.VSWITCH_READ_COMMUNITY, new SrString(readCommunity)));
                element.addParameter(new Parameter(ParameterCode.VSWITCH_WRITE_COMMUNITY, new SrString(writeCommunity)));
                element.addParameter(new Parameter(ParameterCode.VSWITCH_SNMP_UDP_PORT, new SrInteger(snmpPort)));
                element.addParameter(new Parameter(ParameterCode.VSWITCH_TRAP_UDP_PORT, new SrInteger(trapPort)));
                element.addParameter(new Parameter(ParameterCode.VSWITCH_SNMP_VERSION, snmpVersion));
                element.addParameter(new Parameter(ParameterCode.VSWITCH_MAX_RETRIES, new SrInteger(numberOfRetries)));
                element.addParameter(new Parameter(ParameterCode.VSWITCH_TIMEOUT, new SrLong(timeout)));
                Parameter pollInterval = null;
                SrNumber pollIntervalValue = null;
                pollInterval = this.getParameter((VSwitch)null, ParameterCode.GENERAL_POLL_INTERVAL);
                if (pollInterval != null && (pollIntervalValue = (SrNumber)pollInterval.getValue()) != null) {
                    element.addParameter(new Parameter(ParameterCode.GENERAL_POLL_INTERVAL, pollIntervalValue));
                }
                if ((pollInterval = this.getParameter((VSwitch)null, ParameterCode.VIRTUALIZATION_POLL_INTERVAL)) != null && (pollIntervalValue = (SrNumber)pollInterval.getValue()) != null) {
                    element.addParameter(new Parameter(ParameterCode.VIRTUALIZATION_POLL_INTERVAL, pollIntervalValue));
                }
                if ((pollInterval = this.getParameter((VSwitch)null, ParameterCode.ACL_POLL_INTERVAL)) != null && (pollIntervalValue = (SrNumber)pollInterval.getValue()) != null) {
                    element.addParameter(new Parameter(ParameterCode.ACL_POLL_INTERVAL, pollIntervalValue));
                }
                if ((pollInterval = this.getParameter((VSwitch)null, ParameterCode.NET_POLL_INTERVAL)) != null && (pollIntervalValue = (SrNumber)pollInterval.getValue()) != null) {
                    element.addParameter(new Parameter(ParameterCode.NET_POLL_INTERVAL, pollIntervalValue));
                }
                if ((pollInterval = this.getParameter((VSwitch)null, ParameterCode.STATISTIC_POLL_INTERVAL)) != null && (pollIntervalValue = (SrNumber)pollInterval.getValue()) != null) {
                    element.addParameter(new Parameter(ParameterCode.STATISTIC_POLL_INTERVAL, pollIntervalValue));
                }
                this.createElement(element, ClassID.VSWITCH, ipAddr, new Vector());
            }
        } else {
            String msg = "You cannot manage more than 2 " + ClassID.VSWITCH + "es within a cluster";
            logger.debug(msg);
            throw new IllegalValueException(msg);
        }
    }

    private void synchronizeClusterParameters() throws RemoteException {
        VSwitchImpl vSwitch2;
        VSwitchImpl vSwitch1;
        if (!this.synchronizeClusterParametersDone && this.m_vSwitches.size() > 1 && (vSwitch1 = (VSwitchImpl)this.m_vSwitches.elementAt(0)).isNeighborOf(vSwitch2 = (VSwitchImpl)this.m_vSwitches.elementAt(1)) && vSwitch2.isNeighborOf(vSwitch1)) {
            Integer keepAliveInterval1 = vSwitch1.getKeepAliveInterval();
            Integer suspiciousInterval1 = vSwitch1.getSuspiciousInterval();
            Integer faultyInterval1 = vSwitch1.getFaultyInterval();
            Boolean failoverEnable1 = vSwitch1.isFailoverEnable();
            Integer keepAliveInterval2 = vSwitch2.getKeepAliveInterval();
            Integer suspiciousInterval2 = vSwitch2.getSuspiciousInterval();
            Integer faultyInterval2 = vSwitch2.getFaultyInterval();
            Boolean failoverEnable2 = vSwitch2.isFailoverEnable();
            HashMap<ClientParameterCode, Boolean> parameterList1 = new HashMap<ClientParameterCode, Boolean>();
            HashMap<ClientParameterCode, Constable> parameterList2 = new HashMap<ClientParameterCode, Constable>();
            if (keepAliveInterval1 != null && keepAliveInterval2 != null && keepAliveInterval1.compareTo(keepAliveInterval2) != 0) {
                StringBuffer debugMsg = new StringBuffer("Keep-Alive-Interval ");
                debugMsg.append(keepAliveInterval1);
                debugMsg.append(" in " + ClassID.VSWITCH + " ");
                debugMsg.append(vSwitch1);
                debugMsg.append(" is different than in " + ClassID.VSWITCH + " ");
                debugMsg.append(vSwitch2);
                debugMsg.append(" (");
                debugMsg.append(keepAliveInterval2);
                debugMsg.append(")");
                logger.debug(debugMsg.toString());
                parameterList2.put(ClientParameterCode.KEEP_ALIVE, keepAliveInterval1);
            }
            if (suspiciousInterval1 != null && suspiciousInterval2 != null && suspiciousInterval1.compareTo(suspiciousInterval2) != 0) {
                logger.debug("Suspicious-Interval " + suspiciousInterval1 + " in " + ClassID.VSWITCH + " " + vSwitch1 + " is different than in " + ClassID.VSWITCH + " " + vSwitch2 + " (" + suspiciousInterval2 + ")");
                parameterList2.put(ClientParameterCode.SUSPICIOUS_INTERVAL, suspiciousInterval1);
            }
            if (faultyInterval1 != null && faultyInterval2 != null && faultyInterval1.compareTo(faultyInterval2) != 0) {
                logger.debug("Faulty-Interval " + faultyInterval1 + " in " + ClassID.VSWITCH + " " + vSwitch1 + " is different than in " + ClassID.VSWITCH + " " + vSwitch2 + " (" + faultyInterval2 + ")");
                parameterList2.put(ClientParameterCode.FAULTY_INTERVAL, faultyInterval1);
            }
            if (failoverEnable1 != null && failoverEnable2 != null && !failoverEnable1.equals(failoverEnable2)) {
                logger.debug("Failover Enable " + failoverEnable1 + " in " + ClassID.VSWITCH + " " + vSwitch1 + " is different than in " + ClassID.VSWITCH + " " + vSwitch2 + " (" + failoverEnable2 + ")");
                if (!failoverEnable2.booleanValue()) {
                    parameterList2.put(ClientParameterCode.FAILOVER_ENABLE, Boolean.TRUE);
                } else {
                    parameterList1.put(ClientParameterCode.FAILOVER_ENABLE, Boolean.TRUE);
                }
            }
            if (!parameterList2.isEmpty()) {
                logger.debug("Cluster parameters are being synchronized from " + ClassID.VSWITCH + " " + vSwitch1 + " to " + ClassID.VSWITCH + " " + vSwitch2);
                try {
                    this.synchronizeClusterParametersDone = true;
                    vSwitch2.changeElement(parameterList2);
                }
                catch (IllegalValueException ive) {
                    logger.warning(ive.getMessage());
                }
            }
            if (!parameterList1.isEmpty()) {
                logger.debug("Cluster parameters are being synchronized from " + ClassID.VSWITCH + " " + vSwitch2 + " to " + ClassID.VSWITCH + " " + vSwitch1);
                try {
                    this.synchronizeClusterParametersDone = true;
                    vSwitch1.changeElement(parameterList1);
                }
                catch (IllegalValueException ive) {
                    logger.warning(ive.getMessage());
                }
            }
        }
    }

    public VSwitch newVSwitch(HashMap parameterList) throws RemoteException, IllegalValueException {
        VSwitchImpl vSwitch = new VSwitchImpl(this);
        vSwitch.setParameterList(parameterList);
        this.m_vSwitches.addElement(vSwitch);
        Cluster cluster = vSwitch.getWatingMovingCluster();
        if (cluster != null) {
            if (cluster.equals(this)) {
                logger.debug("Shouldn't be here!!! ClusterImpl::newVSwitch(HashMap)");
                logger.error("Cluster " + cluster + " is waiting to " + ClassID.VSWITCH + " " + vSwitch + ", whereas it is added to cluster " + this);
            }
            vSwitch.setWatingMovingCluster(null);
        }
        CommKeyClassId clusterCommKeyClassId = new CommKeyClassId(this.getCommKeys(), this.getClassId());
        VSwitchClusterMap.getInstance().add((CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID), clusterCommKeyClassId);
        return vSwitch;
    }

    public FCNode newFCNode(HashMap parameterList) throws RemoteException, IllegalValueException {
        FCNodeImpl fcNode = new FCNodeImpl(this);
        fcNode.setParameterList(parameterList);
        return fcNode;
    }

    private TableRow newTableRow(TableRowImpl row, HashMap parameterList) throws RemoteException, IllegalValueException {
        row.setParameterList(parameterList);
        return row;
    }

    public IPTableRow newIPTableRow(HashMap parameterList) throws RemoteException, IllegalValueException {
        return (IPTableRow)this.newTableRow(new IPTableRowImpl(this), parameterList);
    }

    public InterfaceTableRow newInterfaceRow(HashMap parameterList) throws RemoteException, IllegalValueException {
        IANAifTypeConstant type = (IANAifTypeConstant)parameterList.get(ParameterCode.IF_TYPE);
        InterfaceTableRowImpl interfaceTableRow = null;
        interfaceTableRow = type.equals(IANAifTypeConstant.IANA_IF_TYPE_FC) ? new FCInterfaceTableRowImpl(this) : (type.equals(IANAifTypeConstant.IANA_IF_TYPE_PARALLEL_SCSI) ? new PSCSIInterfaceTableRowImpl(this) : (type.equals(IANAifTypeConstant.IANA_IF_TYPE_ETHERNET) ? new EthernetInterfaceTableRowImpl(this) : new InterfaceTableRowImpl(this)));
        return (InterfaceTableRow)this.newTableRow(interfaceTableRow, parameterList);
    }

    public ISCSIInstance newISCSIInstance(HashMap parameterList) throws RemoteException, IllegalValueException {
        ISCSIInstanceImpl iscsiInstanceImpl = new ISCSIInstanceImpl(this, ClassID.ISCSI_INSTANCE);
        return (ISCSIInstance)((Object)this.newTableRow(iscsiInstanceImpl, parameterList));
    }

    public ISCSIInitiator newISCSIInitiator(HashMap parameterList) throws RemoteException, IllegalValueException {
        ISCSIInitiatorImpl iscsiInitiatorImpl = new ISCSIInitiatorImpl(this);
        iscsiInitiatorImpl.setParameterList(parameterList);
        VSwitchImpl vSwitch = (VSwitchImpl)iscsiInitiatorImpl.getParentVSwitch();
        vSwitch.addISCSIInitiator(iscsiInitiatorImpl);
        return iscsiInitiatorImpl;
    }

    public SCSIInitiatorPort newSCSIInitiatorPort(HashMap parameterList) throws RemoteException, IllegalValueException {
        SCSIInitiatorPortImpl initiatorPort = new SCSIInitiatorPortImpl(this.cluster);
        initiatorPort.setParameterList(parameterList);
        ISCSIInitiator initiator = initiatorPort.getInitiator();
        if (initiator != null) {
            ((ISCSIInitiatorImpl)initiator).addSCSIPort(initiatorPort);
        }
        return initiatorPort;
    }

    public ISCSISession newISCSISession(HashMap parameterList) throws RemoteException, IllegalValueException {
        IdentityImpl identity;
        SessionDirectionConstant sessionDirection = (SessionDirectionConstant)parameterList.get(ParameterCode.ISCSI_SESSION_DIRECTION);
        CommKeyClassId vSwitchCommKeyClassId = (CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID);
        VSwitch vSwitch = (VSwitch)this.getCommKeyRefMap().getRefByCommKeyClassID(vSwitchCommKeyClassId);
        if (sessionDirection.equals(SessionDirectionConstant.IN_BOUND)) {
            SrString remoteInitiatorName = (SrString)parameterList.get(ParameterCode.ISCSI_SESSION_INITIATOR_NAME);
            if (((VSwitchImpl)vSwitch).isRemoteInitiatorKnownByVSwitch(remoteInitiatorName.toString()) == null) {
                return null;
            }
        } else {
            SrString remoteTargetName = (SrString)parameterList.get(ParameterCode.ISCSI_SESSION_TARGET_NAME);
            ISCSIRemoteTarget remoteTarget = ((ClusterImpl)this.getCluster()).getRemoteTargetListMgr().getRemoteTargetByName(remoteTargetName.toString());
            if (remoteTarget == null) {
                logger.warning("Couldn't create an outbound session element: ISCSIRemoteTarget element is null");
                return null;
            }
        }
        ISCSISessionImpl iscsiSessionImpl = new ISCSISessionImpl(this, ClassID.ISCSI_SESSION);
        ISCSISession session = (ISCSISession)((Object)this.newTableRow(iscsiSessionImpl, parameterList));
        if (!iscsiSessionImpl.addToInitiatorAndTarget()) {
            return null;
        }
        String identityAlias = "N/A";
        CommKeyClassId identityCommKeyClassId = (CommKeyClassId)parameterList.get(ParameterCode.ISCSI_SESSION_AUTH_IDENTITY);
        if (identityCommKeyClassId != null && (identity = (IdentityImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(identityCommKeyClassId)) != null) {
            identityAlias = identity.getAlias();
        }
        iscsiSessionImpl.setIdentityAlias(identityAlias);
        return session;
    }

    private ISCSIConnection newISCSIConnection(HashMap parameterList) throws RemoteException, IllegalValueException {
        CommKeyClassId sessionParent = (CommKeyClassId)parameterList.get(ParameterCode.ISCSI_SESSION_ID);
        ISCSISessionImpl iscsiSessionImpl = (ISCSISessionImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(sessionParent);
        if (iscsiSessionImpl == null) {
            logger.warning("Couldn't create an iSCSI connection element: ISCSISessionImpl parent element is null.");
            return null;
        }
        ISCSIConnectionImpl iscsiConnectionImpl = new ISCSIConnectionImpl(this, ClassID.ISCSI_CONNECTION);
        iscsiConnectionImpl.setParameterList(parameterList);
        iscsiSessionImpl.addConnection(iscsiConnectionImpl);
        return iscsiConnectionImpl;
    }

    private ISCSISessionStatistics newISCSISessionStatistics(HashMap parameterList) throws RemoteException, IllegalValueException {
        CommKeyClassId sessionParent = (CommKeyClassId)parameterList.get(ParameterCode.ISCSI_SESSION_ID);
        if (sessionParent == null) {
            logger.warning("Couldn't create an iSCSI Session Statistics element: ISCSISessionImpl parent element is null.");
            return null;
        }
        ISCSISessionStatisticsImpl iscsiSessionStatisticsImpl = new ISCSISessionStatisticsImpl(this.cluster);
        return (ISCSISessionStatistics)this.newTableRow(iscsiSessionStatisticsImpl, parameterList);
    }

    private ISCSIRemoteInitiator newISCSIRemoteInitiator(HashMap parameterList) throws RemoteException, IllegalValueException, AlreadyKnownByVSwitch {
        ISCSIRemoteInitiatorImpl iscsiRemoteInitiatorImpl = new ISCSIRemoteInitiatorImpl(this);
        ISCSIRemoteInitiator initiator = (ISCSIRemoteInitiator)((Object)this.newTableRow(iscsiRemoteInitiatorImpl, parameterList));
        CommKeyClassId scsiTargetId = (CommKeyClassId)parameterList.get(ParameterCode.SCSI_TARGET_ID);
        CommKeyClassId iscsiTargetId = this.cluster.getISCSIId(scsiTargetId);
        ISCSITarget target = (ISCSITarget)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(iscsiTargetId);
        ((ISCSITargetImpl)target).addRemoteInitiator(initiator);
        return initiator;
    }

    private ISCSIRemoteInitiatorStatistics newISCSIRemoteInitiatorStatistics(HashMap parameterList) throws RemoteException, IllegalValueException {
        ISCSIRemoteInitiatorStatisticsImpl iscsiRemoteInitiatorStatisticsImpl = new ISCSIRemoteInitiatorStatisticsImpl(this.cluster);
        ISCSIRemoteInitiatorStatistics initiatorStatistics = (ISCSIRemoteInitiatorStatistics)this.newTableRow(iscsiRemoteInitiatorStatisticsImpl, parameterList);
        return initiatorStatistics;
    }

    public PortalTableRow newPortalRow(HashMap parameterList) throws RemoteException, IllegalValueException {
        return (PortalTableRow)this.newTableRow(new PortalTableRowImpl(this), parameterList);
    }

    public IPRouteTableRow newIPRouteRow(HashMap parameterList) throws RemoteException, IllegalValueException {
        return (IPRouteTableRow)this.newTableRow(new IPRouteTableRowImpl(this), parameterList);
    }

    public Manager newManager(HashMap parameterList) throws RemoteException, IllegalValueException {
        return (Manager)this.newTableRow(new ManagerImpl(this), parameterList);
    }

    public void removeNeighbor(String neighborIp) throws RemoteException {
        Enumeration e = this.m_vSwitches.elements();
        while (e.hasMoreElements()) {
            VSwitchImpl vSwitch = (VSwitchImpl)e.nextElement();
            vSwitch.removeNeighbor(neighborIp);
        }
    }

    private Neighbor newNeighbor(HashMap parameterList) throws RemoteException, IllegalValueException {
        SrIpAddress neighborIpValue = (SrIpAddress)parameterList.get(ParameterCode.NEIGHBOR_IP_ADDRESS);
        String neighborIp = neighborIpValue.toDisplayString();
        CommKeyClassId vSwitchCommKeyClassId = (CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID);
        VSwitch vSwitch = (VSwitch)this.getCommKeyRefMap().getRefByCommKeyClassID(vSwitchCommKeyClassId);
        if (this.getVSwitchByIPAddress(neighborIp) == null) {
            try {
                SrInteger snmpPort = (SrInteger)parameterList.get(ParameterCode.NEIGHBOR_PORT);
                SrInteger numberOfRetries = (SrInteger)parameterList.get(ParameterCode.NEIGHBOR_RETRIES);
                SrInteger timeout = (SrInteger)parameterList.get(ParameterCode.NEIGHBOR_TIMEOUT);
                this.addVSwitch(neighborIp, vSwitch.getMgmMask(), snmpPort.intValue(), vSwitch.getTrapPort(), vSwitch.getReadCommunity(), vSwitch.getWriteCommunity(), timeout.intValue(), numberOfRetries.intValue(), vSwitch.getSnmpVersion());
            }
            catch (IllegalValueException ive) {
                ((VSwitchImpl)vSwitch).setNeighborInvalid(neighborIp);
                ClusterImpl cluster = (ClusterImpl)SystemRootImpl.getInstance().getClusterOfVSwitch(neighborIp);
                if (cluster == null) {
                    logger.warning("Failed to create neighbor " + ive.getMessage());
                }
                return null;
            }
        }
        ((VSwitchImpl)vSwitch).setNeighborInvalid(null);
        Neighbor neighbor = (Neighbor)this.newTableRow(new NeighborImpl(this), parameterList);
        return neighbor;
    }

    private Identity newIdentity(HashMap parameterList) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        Object knownIdentity;
        String alias = (String)((SrString)parameterList.get(ParameterCode.IDENTITY_ALIAS)).value();
        IdentityPurposeConstant identityPurpose = (IdentityPurposeConstant)parameterList.get(ParameterCode.IDENTITY_PURPOSE);
        boolean isLocalInitiatorIdentity = identityPurpose.equals(IdentityPurposeConstant.LOCAL_INITIATOR);
        if (!isLocalInitiatorIdentity && (knownIdentity = this.identities.getIdentityByAlias(alias)) != null) {
            throw new AlreadyKnownByVSwitch((Identity)knownIdentity);
        }
        IdentityImpl identity = new IdentityImpl(this, ClassID.IDENTITY);
        identity.setParameterList(parameterList);
        if (isLocalInitiatorIdentity) {
            CommKeyClassId vSwitchCommKeyClassId = (CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID);
            VSwitch vSwitch = (VSwitch)this.getCommKeyRefMap().getRefByCommKeyClassID(vSwitchCommKeyClassId);
            this.identities.addIdentity(identity, vSwitch.getName());
        } else {
            this.identities.addIdentity(identity);
        }
        return identity;
    }

    private RadiusServer newRadiusServer(HashMap parameterList) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        SrIpAddress ip = (SrIpAddress)parameterList.get(ParameterCode.RADIUS_SERVER_IP_ADDRESS);
        String ipAddress = ip.toDisplayString();
        Object knownIdentity = this.radiusServerList.getExternalServerByIP(ipAddress);
        if (knownIdentity != null) {
            throw new AlreadyKnownByVSwitch((RadiusServer)knownIdentity);
        }
        RadiusServerImpl radiusServer = new RadiusServerImpl(this);
        radiusServer.setParameterList(parameterList);
        this.radiusServerList.addExternalServer(radiusServer);
        return radiusServer;
    }

    private ISNSServer newISNSServer(HashMap parameterList) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        InetAddress ipAddress = (InetAddress)((SrIpAddress)parameterList.get(ParameterCode.ISNS_SERVER_IP_ADDRESS)).value();
        Object knownIdentity = this.isnsServerList.getExternalServerByIP(ipAddress.getHostAddress());
        if (knownIdentity != null) {
            throw new AlreadyKnownByVSwitch((ISNSServer)knownIdentity);
        }
        ISNSServerImpl isnsServer = new ISNSServerImpl(this, ClassID.ISNS_SERVER);
        isnsServer.setParameterList(parameterList);
        this.isnsServerList.addExternalServer(isnsServer);
        return isnsServer;
    }

    private AclEntry newAclEntry(HashMap parameterList) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        CommKeyClassId identCommKeyClassId = (CommKeyClassId)parameterList.get(ParameterCode.ACL_ENTRY_IDENTITY);
        IdentityImpl identity = (IdentityImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(identCommKeyClassId);
        CommKeyClassId targetCommKeyClassId = (CommKeyClassId)parameterList.get(ParameterCode.ACL_ENTRY_TARGET_PARENT);
        TargetImpl targetParent = (TargetImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(targetCommKeyClassId);
        if (targetParent != null && identity != null) {
            Integer permissionVal = (Integer)((SrInteger)parameterList.get(ParameterCode.ACL_ENTRY_ACCESS)).value();
            Permission permission = Permission.getPermission(permissionVal);
            Integer positionVal = (Integer)((SrInteger)parameterList.get(ParameterCode.ACL_ENTRY_POSITION)).value();
            int position = positionVal;
            AclImpl acl = (AclImpl)targetParent.getAclForTarget();
            if (acl != null) {
                logger.debug(acl.toDisplayString());
                AclEntry knownEntry = acl.getEntry(identity, permission, position, this.isDiscoverCompleted());
                StringBuffer sb = new StringBuffer("@@@@ entry - ");
                sb.append(identity.getAlias());
                sb.append(", ");
                sb.append(permission.toString());
                sb.append(", ");
                sb.append(position);
                sb.append("- ");
                if (knownEntry != null) {
                    sb.append("Already Known !");
                    logger.debug(sb.toString());
                    if (!identity.isOfRemoteInitiatorDR()) {
                        acl.setHighestPostionIfHighest(knownEntry.getPosition());
                    }
                    throw new AlreadyKnownByVSwitch(knownEntry);
                }
                sb.append("is NEW !!");
                logger.debug(sb.toString());
                AclEntryImpl entry = new AclEntryImpl(this, ClassID.ACL_ENTRY, acl);
                entry.setParameterList(parameterList);
                acl.addAclEntry(entry);
                return entry;
            }
        } else {
            if (targetParent == null) {
                logger.error("targetParent " + targetCommKeyClassId + " is null in ClusterImpl::newAclEntry()");
            }
            if (identity == null) {
                logger.error("identity " + identCommKeyClassId + " is null in ClusterImpl::newAclEntry()");
            }
        }
        return null;
    }

    private IdentityName newIdentityName(HashMap parameterList) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        CommKeyClassId parent = (CommKeyClassId)parameterList.get(ParameterCode.IDENTITY_NAME_PARENT);
        String name = (String)((SrString)parameterList.get(ParameterCode.IDENTITY_NAME_VALUE)).value();
        IdentityImpl identityParent = (IdentityImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(parent);
        Object knownIdentityName = identityParent.isNameExist(name);
        if (knownIdentityName != null) {
            throw new AlreadyKnownByVSwitch((IdentityName)knownIdentityName);
        }
        IdentityNameImpl identityName = null;
        if (identityParent != null) {
            identityName = new IdentityNameImpl(this, ClassID.IDENTITY_NAME);
            identityName.setParameterList(parameterList);
            identityParent.addName(identityName);
        }
        return identityName;
    }

    private SRPCredentials newSrpCredentials(HashMap parameterList) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        CommKeyClassId parent = (CommKeyClassId)parameterList.get(ParameterCode.CREDENTIALS_PARENT);
        String userName = (String)((SrString)parameterList.get(ParameterCode.SRP_CREDENTIALS_USER_NAME)).value();
        Object ref = this.getCommKeyRefMap().getRefByCommKeyClassID(parent);
        if (ref == null) {
            String msg = "Found SRP credentials with no identity matching !";
            logger.warning(msg);
            logger.debug(msg + ", user name: " + userName);
            throw new IllegalValueException(msg);
        }
        IdentityImpl identityParent = (IdentityImpl)ref;
        Object knownIdentityCred = identityParent.isCredentialExist(ClassID.SRP_CREDENTIALS, userName);
        if (knownIdentityCred != null) {
            throw new AlreadyKnownByVSwitch((Credentials)knownIdentityCred);
        }
        SRPCredentialsImpl srpCred = new SRPCredentialsImpl(this, ClassID.SRP_CREDENTIALS);
        srpCred.setParameterList(parameterList);
        identityParent.addCredentials(srpCred);
        this.setCredentialsWithLocalTarget(srpCred);
        return srpCred;
    }

    private CHAPCredentials newChapCredentials(HashMap parameterList) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        Object ref;
        CommKeyClassId parent = (CommKeyClassId)parameterList.get(ParameterCode.CREDENTIALS_PARENT);
        Object userParameter = parameterList.get(ParameterCode.CHAP_CREDENTIALS_USER_NAME);
        String userName = "";
        if (userParameter != null) {
            userName = (String)((SrString)userParameter).value();
        }
        if ((ref = this.getCommKeyRefMap().getRefByCommKeyClassID(parent)) == null) {
            String msg = "Found CHAP credentials with no identity matching !";
            logger.warning(msg);
            logger.debug(msg + ", user name: " + userName);
            return null;
        }
        IdentityImpl identityParent = (IdentityImpl)ref;
        Object knownIdentityCred = identityParent.isCredentialExist(ClassID.CHAP_CREDENTIALS, userName);
        if (knownIdentityCred != null) {
            throw new AlreadyKnownByVSwitch((Credentials)knownIdentityCred);
        }
        CHAPCredentialsImpl chapCred = new CHAPCredentialsImpl(this, ClassID.CHAP_CREDENTIALS);
        chapCred.setParameterList(parameterList);
        identityParent.addCredentials(chapCred);
        this.setCredentialsWithLocalTarget(chapCred);
        return chapCred;
    }

    private void setLocalTargetCredentials(ISCSITargetImpl localTarget) throws RemoteException {
        Vector allIdentities = this.identities.getAllIdentities();
        for (int i = 0; i < allIdentities.size(); ++i) {
            IdentityImpl identity = (IdentityImpl)allIdentities.get(i);
            if (!localTarget.getAlias().equals(identity.getAlias())) continue;
            Vector credentials = identity.getCredentials();
            if (!credentials.isEmpty()) {
                Credentials cred = (Credentials)credentials.elementAt(0);
                localTarget.setCredentials(cred);
                ((CredentialsImpl)cred).setISCSIDevice(localTarget);
                this.fireISCSITargetCredentialsChanged(localTarget);
                continue;
            }
            logger.warning("No credentials found for " + identity.getClassId() + " " + identity + " in cluster " + this);
        }
    }

    private void setCredentialsWithLocalTarget(Credentials cred) throws RemoteException {
        ISCSITargetImpl localTarget;
        IdentityImpl identity = (IdentityImpl)cred.getIdentityParent();
        if (identity.isOfLocalTarget() && (localTarget = (ISCSITargetImpl)this.getTargetListMgr().getTargetByAlias(identity.getAlias())) != null) {
            localTarget.setCredentials(cred);
            ((CredentialsImpl)cred).setISCSIDevice(localTarget);
            this.fireISCSITargetCredentialsChanged(localTarget);
        }
    }

    private void setRemoteTargetCHAPCredentials(ISCSIRemoteTargetImpl remoteTarget) throws RemoteException {
        Vector chapCredentials;
        IdentityImpl remoteTargetIdentity = (IdentityImpl)remoteTarget.getIdentity();
        if (remoteTargetIdentity != null && (chapCredentials = remoteTargetIdentity.getCHAPCredentials()) != null && chapCredentials.size() > 0) {
            CHAPCredentials chapCred = (CHAPCredentials)chapCredentials.elementAt(0);
            remoteTarget.setCHAPCredentials(chapCred);
            ((CHAPCredentialsImpl)chapCred).setISCSIDevice(remoteTarget);
            this.fireISCSIRemoteTargetCredentialsChanged(remoteTarget);
        }
    }

    private void setLocalInitiatorCredentials(ISCSIInitiatorImpl localInitiator) throws RemoteException {
        Vector allIdentities = this.identities.getAllIdentities();
        for (int i = 0; i < allIdentities.size(); ++i) {
            IdentityName identityFirstName;
            Vector identityNames;
            IdentityImpl identity = (IdentityImpl)allIdentities.get(i);
            if (!identity.isOfLocalInitiator() || (identityNames = identity.getIdentityNames()) == null || identityNames.size() <= 0 || !localInitiator.isMyIdentity((identityFirstName = (IdentityName)identity.getIdentityNames().elementAt(0)).getName())) continue;
            Vector chapCredentials = identity.getCHAPCredentials();
            Vector srpCredentials = identity.getSRPCredentials();
            CHAPCredentials chapCred = (CHAPCredentials)chapCredentials.elementAt(0);
            SRPCredentials srpCred = (SRPCredentials)srpCredentials.elementAt(0);
            localInitiator.setCHAPCredentials(chapCred);
            ((CHAPCredentialsImpl)chapCred).setISCSIDevice(localInitiator);
            localInitiator.setSRPCredentials(srpCred);
            ((SRPCredentialsImpl)srpCred).setISCSIDevice(localInitiator);
        }
    }

    public TableRow removeTabelRow(TableRow row) throws RemoteException {
        VSwitchImpl vSwitch = (VSwitchImpl)row.getParentVSwitch();
        vSwitch.removeTableRow(row);
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startQueueConsumerThread() {
        this.queueConsumerThread = new ClusterThread("Cluster Queue/Consumer Thread - " + this.toString()){

            private CommKeyClassId getCommKeyClassIDOfElement(Object eventElement, int eventType) {
                CommKeyClassId commKeyClassID = null;
                if (eventType == 1 || eventType == 2 || eventType == 4 || eventType == 3 || eventType == 8 || eventType == 9 || eventType == 10 || eventType == 15 || eventType == 11 || eventType == 18 || eventType == 12 || eventType == 13) {
                    ConfigElementData ced = (ConfigElementData)eventElement;
                    commKeyClassID = new CommKeyClassId(ced.getCommKey(), ced.getClassId());
                } else if (eventType == 7 || eventType == 6) {
                    commKeyClassID = ((SrVSwitchMessageEvent)eventElement).getVSwitchData();
                }
                return commKeyClassID;
            }

            private void runEvent(EventQueueElement eventQueueElement, Object eventElement, int eventType) throws RemoteException {
                if (eventType == 23) {
                    ClusterImpl.this.notifyClusterDBReadingCompleted();
                } else if (eventType == 16) {
                    SrCheckListEvent event = (SrCheckListEvent)eventQueueElement.getQueueElement();
                    ClusterImpl.this.checkForElementsDeletion(event);
                } else {
                    if (eventType == 17) {
                        ClusterImpl.this.rediscover();
                        return;
                    }
                    CommKeyClassId commKeyClassID = this.getCommKeyClassIDOfElement(eventElement, eventType);
                    if (commKeyClassID.getClassID().equals(ClassID.STORAGE_DOMAIN)) {
                        commKeyClassID = (CommKeyClassId)((ConfigElementData)eventElement).getValue(ParameterCode.VSWITCH_ID);
                    }
                    LogicObjectImpl element = (LogicObjectImpl)ClusterImpl.this.getCommKeyRefMap().getRefByCommKeyClassID(commKeyClassID);
                    if (eventType != 1 && eventType != 8 && eventType != 10 && eventType != 15 && eventType != 18 && element == null) {
                        StringBuffer debugMsg = new StringBuffer("Element for event type ");
                        debugMsg.append(eventType);
                        debugMsg.append(" is null - (");
                        debugMsg.append(commKeyClassID.getClassID());
                        debugMsg.append(" commkey is [");
                        if (commKeyClassID.getCommKeys() != null && commKeyClassID.getCommKeys().length > 0) {
                            debugMsg.append(commKeyClassID.getCommKeys()[0]);
                        }
                        debugMsg.append("] ");
                        debugMsg.append(eventQueueElement);
                        debugMsg.append(" was NOT re-added to queue");
                        logger.warning(debugMsg.toString());
                    } else {
                        try {
                            if (eventType == 7 || eventType == 6) {
                                switch (eventType) {
                                    case 7: {
                                        ClusterImpl.this.virtualizationDiscoverCompleted((VSwitchImpl)element);
                                        break;
                                    }
                                    case 6: {
                                        ClusterImpl.this.vSwitchDiscoverCompleted((VSwitchImpl)element);
                                    }
                                }
                            } else {
                                ConfigElementData ced = (ConfigElementData)eventElement;
                                VSwitchImpl vSwitch = ClusterImpl.this.getVSwitch(ced.getClassId(), ced.getCommKey(), ced.getParametersList());
                                switch (eventType) {
                                    case 1: 
                                    case 8: {
                                        if (ced.getClassId() == ClassID.ALARM_TYPE) break;
                                        element = (LogicObjectImpl)ClusterImpl.this.newElement(ced.getClassId(), ced.getCommKey(), ced.getParametersList());
                                        if (!(ced instanceof MirrVolConfigElementData) || !(element instanceof MirrorVolumeImpl)) break;
                                        ((MirrorVolumeImpl)element).setAutoSync(((MirrVolConfigElementData)ced).getAutoSync());
                                        break;
                                    }
                                    case 18: {
                                        if (element == null) {
                                            if (!ClusterImpl.this.isDiscoverCompleted()) break;
                                            element = (LogicObjectImpl)ClusterImpl.this.newElement(ced.getClassId(), ced.getCommKey(), ced.getParametersList());
                                            if (!(ced instanceof MirrVolConfigElementData) || !(element instanceof MirrorVolumeImpl)) break;
                                            ((MirrorVolumeImpl)element).setAutoSync(((MirrVolConfigElementData)ced).getAutoSync());
                                            break;
                                        }
                                    }
                                    case 2: 
                                    case 4: 
                                    case 9: {
                                        ClusterImpl.this.changeElement(element, ced.getParametersList());
                                        break;
                                    }
                                    case 3: {
                                        ClusterImpl.this.removeElementByEvent(element, ced.getParametersList());
                                        break;
                                    }
                                    case 10: {
                                        ClusterImpl.this.creationFailed(ced, vSwitch);
                                        break;
                                    }
                                    case 15: {
                                        ClusterImpl.this.operationFailed(ced, vSwitch);
                                        break;
                                    }
                                    case 11: {
                                        ClusterImpl.this.changeElementFailed(element, vSwitch, ced.getParametersList());
                                        break;
                                    }
                                    case 12: 
                                    case 13: {
                                        ClusterImpl.this.operationFailed(eventType, element, vSwitch, ced.getParametersList());
                                        break;
                                    }
                                    default: {
                                        logger.debug("Type " + eventType + " not found in " + this.getClass() + "::startQueueConsumerThread()");
                                    }
                                }
                                if (eventType == 8 || eventType == 9) {
                                    ParameterCode[] badValues = ((SrElementOperationErrorEvent)eventQueueElement.getQueueElement()).getErrorParams();
                                    element.setParametersBadValue(vSwitch, badValues);
                                }
                                if (ClusterImpl.this.isDiscoverCompleted() && element != null && (vSwitch != null || element.getClassId().equals(ClassID.CLUSTER) || element.getClassId().equals(ClassID.VSWITCH))) {
                                    if (element.getClassId().equals(ClassID.ACL_ENTRY)) {
                                        TargetImpl targetElement = (TargetImpl)((AclEntryImpl)element).getAclParent().getTargetParent();
                                        ClusterImpl.this.generateAlarms(eventType, targetElement, vSwitch);
                                    } else if (!element.getClassId().isDRClassId()) {
                                        ClusterImpl.this.generateAlarms(eventType, element, vSwitch);
                                    }
                                }
                            }
                        }
                        catch (IllegalValueException ive) {
                            logger.warning(ive.getMessage());
                        }
                    }
                }
            }

            public void run() {
                Thread thisThread = Thread.currentThread();
                while (!this.m_isLastConsumerThreadLoop) {
                    try {
                        EventQueueElement eventQueueElement = (EventQueueElement)ClusterImpl.this.eventQueue.removeHead();
                        this.processEvent(eventQueueElement);
                    }
                    catch (RemoteException re) {
                        logger.error(re);
                        SystemRootImpl.getInstance().getDRAndClustersSynchronizationLock().release_read_lock();
                    }
                    catch (Throwable th) {
                        logger.error(th);
                        SystemRootImpl.getInstance().getDRAndClustersSynchronizationLock().release_read_lock();
                    }
                }
            }

            protected void processEvent(EventQueueElement eventQueueElement) throws RemoteException, InterruptedException {
                SystemRootImpl.getInstance().getDRAndClustersSynchronizationLock().get_read_lock();
                logger.debug("Removed from Event Queue: " + eventQueueElement);
                EventObject eventObject = (EventObject)eventQueueElement.getQueueElement();
                int eventType = eventQueueElement.getType();
                if (eventObject instanceof ErrorEvent) {
                    ClusterImpl.this.handleErrorEvent((ErrorEvent)eventObject);
                } else if (eventObject instanceof SrEvent) {
                    if (eventType == 1 || eventType == 2 || eventType == 4 || eventType == 3 || eventType == 8 || eventType == 9 || eventType == 13 || eventType == 10 || eventType == 15 || eventType == 11 || eventType == 18 || eventType == 12) {
                        ConfigElementDataList cedList = ((SrElementEvent)eventObject).getElements();
                        Enumeration values = cedList.elements();
                        while (values.hasMoreElements()) {
                            ConfigElementData ced = (ConfigElementData)values.nextElement();
                            this.runEvent(eventQueueElement, ced, eventType);
                        }
                    } else if (eventType == 7 || eventType == 6) {
                        this.runEvent(eventQueueElement, (SrVSwitchMessageEvent)eventObject, eventType);
                    } else if (eventType == 23) {
                        this.runEvent(eventQueueElement, null, eventType);
                    } else if (eventType == 16) {
                        this.runEvent(eventQueueElement, null, eventType);
                    } else if (eventType == 22) {
                        this.m_isLastConsumerThreadLoop = true;
                        ClusterImpl.this.eventQueue.clearNoNotify();
                        ClusterImpl.this.notifyQueueConsumerThreadFinished();
                    } else {
                        logger.error("Undefined event type " + eventType + " before runEvent");
                    }
                } else if (eventObject instanceof DREvent) {
                    if (eventType == 3) {
                        LogicObjectImpl element = (LogicObjectImpl)((DREvent)eventObject).getElement();
                        VSwitchImpl vSwitch = (VSwitchImpl)element.getConnectedVSwitches()[0];
                        ClusterImpl.this.removeElement(element, vSwitch, vSwitch.getMgmIPAddr());
                    } else {
                        logger.warning("ClusterImpl::run(), DREvent " + eventObject + " was received with event type " + eventType);
                    }
                } else {
                    logger.warning("ClusterImpl::run(), cluster " + this + " received unrecognized event " + eventObject);
                }
                SystemRootImpl.getInstance().getDRAndClustersSynchronizationLock().release_read_lock();
            }
        };
        Object object = this.m_queueConsumerThreadSyncLock;
        synchronized (object) {
            this.queueConsumerThread.start();
        }
    }

    private void createElementCompleted(VSwitchImpl vSwitch, final LogicObjectImpl element, CommKey[] commKeys, ClassID classId) throws RemoteException {
        if (element != null) {
            element.setCommKeys(commKeys);
            this.getCommKeyRefMap().addCommKeyClassIdAndRef(commKeys, classId, (Object)element);
            if (element.getClassId().isDRClassId()) {
                if (this.isDiscoverCompleted()) {
                    DRClusterAsyncPair[] pairs;
                    boolean isAsyncPair = classId.equals(ClassID.ASYNC_PAIR);
                    boolean isAsyncPairWithExistingGroup = false;
                    if (isAsyncPair) {
                        DRClusterAsyncPairImpl asyncPair = (DRClusterAsyncPairImpl)element;
                        CommKeyClassId pairsGroupId = asyncPair.getGroupId(vSwitch);
                        DRClusterAbstractConsistencyGroupImpl pairGroup = (DRClusterAbstractConsistencyGroupImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(pairsGroupId);
                        if (pairGroup != null) {
                            isAsyncPairWithExistingGroup = true;
                        }
                    }
                    if (!isAsyncPair || isAsyncPairWithExistingGroup) {
                        this.invokeDREventAndWait(element, 1);
                    }
                    if (classId.isDRGroup() && (pairs = ((DRClusterAbstractConsistencyGroupImpl)element).getPairs()) != null) {
                        for (int i = 0; i < pairs.length; ++i) {
                            this.invokeDREventAndWait((DRClusterAsyncPairImpl)pairs[i], 1);
                        }
                    }
                }
            } else if (this.isDiscoverCompleted()) {
                ElementEventImpl elementEvent = new ElementEventImpl(element, element);
                EventServiceImpl.getInstance().fireElementCreate(elementEvent);
            }
            if (element.getClassId().equals(ClassID.LUN)) {
                ((LUImpl)element).readSCSILunElement();
            }
            StringBuffer debugMsg = new StringBuffer(classId.toString());
            debugMsg.append(" ");
            debugMsg.append(element);
            debugMsg.append(" was created");
            logger.info(debugMsg.toString());
            if (!this.isDiscoverCompleted()) {
                SystemRootImpl.setStatusInProcess(debugMsg.toString());
            }
            element.registerToPropagatedStateChange();
            if (classId.equals(ClassID.VSWITCH)) {
                if (this.isClusterDiscoveryCompleted()) {
                    Thread discoverCompletedThread = new Thread("Cluster inner rediscover Thread - " + this.toString()){

                        public void run() {
                            try {
                                while (!ClusterImpl.this.isDiscoverOfOtherVSwitchesCompleted((VSwitch)((Object)element))) {
                                    Thread.sleep(1L);
                                }
                                ClusterImpl.this.rediscover();
                            }
                            catch (InterruptedException ie) {
                                logger.error(ie);
                            }
                            catch (RemoteException re) {
                                logger.error(re);
                            }
                        }
                    };
                    discoverCompletedThread.start();
                }
            } else if (vSwitch != null) {
                vSwitch.setConnected(true);
            }
            if (classId.equals(ClassID.NEIGHBORE)) {
                this.synchronizeClusterParameters();
            }
        } else if (!classId.equals(ClassID.COPY_OPERATION)) {
            logger.error("Error in create new element " + classId + " in " + this.getClass() + "::newElement()");
        }
    }

    private void operationFailed(ConfigElementData ced, VSwitch vSwitch) throws RemoteException {
        StringBuffer msg = new StringBuffer("Operation failed for ");
        msg.append(this.getMsgForElement(ced, vSwitch));
        logger.warning(msg.toString());
        this.handleSyncConfigurationError(ced);
        if (vSwitch != null && vSwitch.isConnected() && this.isDiscoverCompleted()) {
            ElementEventImpl event = new ElementEventImpl(vSwitch, vSwitch);
            event.setErrorMesaage(msg.toString());
            event.setVSwitchIp(vSwitch.getMgmIPAddr());
            EventServiceImpl.getInstance().fireConfigurationError(event);
        }
    }

    private void creationFailed(ConfigElementData ced, VSwitch vSwitch) throws RemoteException {
        StringBuffer msg = new StringBuffer("Failed to create ");
        if (ced.getClassId().equals(ClassID.SNMP_MANAGER) && ced.getValue(ParameterCode.MANAGER_IP_ADDRESS) == null) {
            msg.append(ced.getClassId());
            msg.append(" on ");
            msg.append(ClassID.VSWITCH);
            msg.append(" ");
            msg.append(vSwitch);
        } else {
            msg.append(this.getMsgForElement(ced, vSwitch));
        }
        logger.warning(msg.toString());
        this.handleSyncConfigurationError(ced);
        if (vSwitch != null && vSwitch.isConnected() && this.isDiscoverCompleted()) {
            ElementEventImpl event = new ElementEventImpl(vSwitch, vSwitch);
            event.setErrorMesaage(msg.toString());
            event.setVSwitchIp(vSwitch.getMgmIPAddr());
            EventServiceImpl.getInstance().fireConfigurationError(event);
        }
    }

    private void operationFailed(int eventType, LogicObjectImpl element, VSwitch vSwitch, HashMap parameterList) throws RemoteException {
        StringBuffer msg = null;
        if (eventType == 13) {
            msg = new StringBuffer("Failed to read ");
        } else if (eventType == 12) {
            msg = new StringBuffer("Failed to remove ");
        } else {
            msg = new StringBuffer("Undefined \"Failed\" event type in operationFailed()");
            msg.append(eventType);
            logger.error(msg.toString());
            return;
        }
        msg.append(element.getClassId());
        if (eventType == 12) {
            element.clearDeletionStatus();
        }
        msg.append(" ");
        msg.append(element);
        msg.append(" on " + ClassID.VSWITCH + " ");
        msg.append(vSwitch);
        if (vSwitch != null) {
            ElementEventImpl event = new ElementEventImpl(vSwitch, vSwitch);
            event.setErrorMesaage(msg.toString());
            event.setVSwitchIp(vSwitch.getMgmIPAddr());
            if ((eventType != 13 || !element.getClassId().equals(ClassID.VSWITCH)) && vSwitch.isConnected() && this.isDiscoverCompleted()) {
                EventServiceImpl.getInstance().fireConfigurationError(event);
            }
        } else {
            msg.append(" (" + ClassID.VSWITCH + " probably was removed in the meantime)");
        }
        logger.warning(msg.toString());
    }

    private HardwareImpl createVSwitchHardware(HashMap parameterList) throws RemoteException, IllegalValueException {
        HardwareImpl hardware = new HardwareImpl(this.cluster);
        hardware.setParameterList(parameterList);
        return hardware;
    }

    private TCPStatisticsImpl createTCPStatistics(HashMap parameterList) throws RemoteException, IllegalValueException {
        TCPStatisticsImpl tcp = new TCPStatisticsImpl(this.cluster);
        tcp.setParameterList(parameterList);
        return tcp;
    }

    private EthernetStatisticsImpl createEthernetStatistics(HashMap parameterList) throws RemoteException, IllegalValueException {
        EthernetStatisticsImpl ethernet = new EthernetStatisticsImpl(this.cluster);
        ethernet.setParameterList(parameterList);
        return ethernet;
    }

    private UDPStatisticsImpl createUDPStatistics(HashMap parameterList) throws RemoteException, IllegalValueException {
        UDPStatisticsImpl udp = new UDPStatisticsImpl(this.cluster);
        udp.setParameterList(parameterList);
        return udp;
    }

    private ICMPStatisticsImpl createICMPStatistics(HashMap parameterList) throws RemoteException, IllegalValueException {
        ICMPStatisticsImpl icmp = new ICMPStatisticsImpl(this.cluster);
        icmp.setParameterList(parameterList);
        return icmp;
    }

    private IPStatisticsImpl newIPStatistics(HashMap parameterList) throws RemoteException, IllegalValueException {
        IPStatisticsImpl ip = new IPStatisticsImpl(this.cluster);
        ip.setParameterList(parameterList);
        return ip;
    }

    private InterfaceStatisticsTableRowImpl newInterfaceRowStatistics(HashMap parameterList) throws RemoteException, IllegalValueException {
        InterfaceStatisticsTableRowImpl interfaceRow = new InterfaceStatisticsTableRowImpl(this);
        return (InterfaceStatisticsTableRowImpl)this.newTableRow(interfaceRow, parameterList);
    }

    private UDPListenerStatisticsTableRowImpl newUDPListenerStatisticsRow(HashMap parameterList) throws RemoteException, IllegalValueException {
        UDPListenerStatisticsTableRowImpl udpListenerRow = new UDPListenerStatisticsTableRowImpl(this);
        return (UDPListenerStatisticsTableRowImpl)this.newTableRow(udpListenerRow, parameterList);
    }

    private TCPConnectionStatisticsTableRowImpl newTCPConnectionStatisticsRow(HashMap parameterList) throws RemoteException, IllegalValueException {
        TCPConnectionStatisticsTableRowImpl tcpConnectionRow = new TCPConnectionStatisticsTableRowImpl(this);
        return (TCPConnectionStatisticsTableRowImpl)this.newTableRow(tcpConnectionRow, parameterList);
    }

    private void changeElementFailed(LogicObjectImpl element, VSwitch vSwitch, HashMap parameterList) throws RemoteException {
        VSwitchImpl otherVSwitch;
        StringBuffer msg = new StringBuffer("Failed to change ");
        msg.append(element.getClassId());
        msg.append(" ");
        msg.append(element);
        msg.append(" on " + ClassID.VSWITCH + " ");
        msg.append(vSwitch);
        if (element.getClassId().equals(ClassID.ISCSI_TARGET) && parameterList.containsKey(ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON) && (otherVSwitch = (VSwitchImpl)this.getOtherVSwitch(vSwitch)) != null) {
            otherVSwitch.clearDeletionStatus();
        }
        this.handleSyncConfigurationError(element);
        if (vSwitch != null) {
            ElementEventImpl event = new ElementEventImpl(vSwitch, vSwitch);
            event.setErrorMesaage(msg.toString());
            event.setVSwitchIp(vSwitch.getMgmIPAddr());
            if (vSwitch.isConnected() && this.isDiscoverCompleted()) {
                EventServiceImpl.getInstance().fireConfigurationError(event);
            }
        } else {
            msg.append(" (" + ClassID.VSWITCH + " probably was removed in the meantime)");
        }
        logger.warning(msg.toString());
    }

    private LogicObject newElement(ClassID classId, CommKey[] commKeys, HashMap parameterList) throws RemoteException, IllegalValueException {
        LogicObject element;
        block155: {
            element = (LogicObject)this.getCommKeyRefMap().getRefByCommKeyClassID(commKeys, classId);
            if (element != null) {
                ConfigElementData changeCed = new ConfigElementData(commKeys, classId);
                changeCed.addParameter(parameterList);
                SrChangeElementEvent changeEvent = new SrChangeElementEvent((Object)this, changeCed);
                this.elementEvent(changeEvent);
                return null;
            }
            try {
                IdentityNameImpl name;
                IdentityImpl identityParent;
                if (classId.equals(ClassID.DIRECT_ACCESS_DEVICE)) {
                    element = this.storage.newDirectAccessDevice(parameterList);
                } else if (classId.equals(ClassID.SEQUENTIAL_ACCESS_DEVICE)) {
                    element = this.storage.newSequentialAccessDevice(parameterList);
                } else if (classId.equals(ClassID.GENERAL_SCSI_DEVICE)) {
                    element = this.storage.newGeneralSCSIDevice(parameterList);
                } else if (classId.equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
                    element = this.storage.newSubDirectAccessDevice(parameterList);
                } else if (classId.equals(ClassID.CONCAT_VOLUME)) {
                    element = this.storage.newConcatinationVolume(parameterList, commKeys);
                } else if (classId.equals(ClassID.CUBE_VOLUME)) {
                    element = this.storage.newCubeVolume(parameterList, commKeys);
                } else if (classId.equals(ClassID.MIRROR_VOLUME)) {
                    element = this.storage.newMirrorVolume(parameterList, commKeys);
                } else if (classId.equals(ClassID.STRIPE_VOLUME)) {
                    element = this.storage.newStripeVolume(parameterList, commKeys);
                } else if (classId.equals(ClassID.TRANSPARENT_VOLUME)) {
                    element = this.storage.newTransparentVolume(parameterList, commKeys);
                } else if (classId.equals(ClassID.ISCSI_TARGET)) {
                    element = this.storage.newISCSITarget(parameterList);
                } else if (classId.equals(ClassID.ISCSI_REMOTE_TARGET)) {
                    element = this.storage.newISCSIRemoteTarget(parameterList);
                } else if (classId.equals(ClassID.ISCSI_REMOTE_TARGET_PORTAL)) {
                    element = this.storage.newISCSIRemoteTargetPortal(parameterList);
                } else if (classId.equals(ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL)) {
                    element = this.storage.newISCSIRemotePortalDiscovery(parameterList);
                } else if (classId.equals(ClassID.SCSI_TARGET_PORT)) {
                    element = this.storage.newSCSITargetPort(parameterList);
                } else if (classId.equals(ClassID.LUN)) {
                    element = this.storage.newLU(parameterList);
                } else if (classId.equals(ClassID.SCSI_LUN)) {
                    element = this.storage.newSCSILun(parameterList);
                } else if (classId.equals(ClassID.VSWITCH)) {
                    element = this.newVSwitch(parameterList);
                } else if (classId.equals(ClassID.NETWORK_CONFIGURATION)) {
                    element = this.newIPTableRow(parameterList);
                } else if (classId.equals(ClassID.PORTAL)) {
                    element = this.newPortalRow(parameterList);
                } else if (classId.equals(ClassID.IP_ROUTE)) {
                    element = this.newIPRouteRow(parameterList);
                } else if (classId.equals(ClassID.NEIGHBORE)) {
                    element = this.newNeighbor(parameterList);
                } else if (classId.equals(ClassID.SNMP_MANAGER)) {
                    element = this.newManager(parameterList);
                } else if (classId.equals(ClassID.IDENTITY)) {
                    element = this.newIdentity(parameterList);
                } else if (classId.equals(ClassID.IDENTITY_NAME)) {
                    element = this.newIdentityName(parameterList);
                } else if (classId.equals(ClassID.SRP_CREDENTIALS)) {
                    element = this.newSrpCredentials(parameterList);
                } else if (classId.equals(ClassID.CHAP_CREDENTIALS)) {
                    element = this.newChapCredentials(parameterList);
                } else if (classId.equals(ClassID.ACL_ENTRY)) {
                    element = this.newAclEntry(parameterList);
                } else if (classId.equals(ClassID.COPY_OPERATION)) {
                    element = this.copyOperMgr.newCopyOper(parameterList);
                } else if (classId.equals(ClassID.RADIUS_SERVER)) {
                    element = this.newRadiusServer(parameterList);
                } else if (classId.equals(ClassID.ISNS_SERVER)) {
                    element = this.newISNSServer(parameterList);
                } else if (classId.equals(ClassID.LU_IDENTIFIER)) {
                    element = this.storage.newLUIdentifier(parameterList);
                } else if (classId.equals(ClassID.SNAPSHOT_VOLUME)) {
                    element = this.storage.newSnapshotVolume(parameterList, commKeys);
                } else if (classId.equals(ClassID.JOURNAL_VOLUME)) {
                    element = this.storage.newJournalVolume(parameterList, commKeys);
                } else if (classId.isDRClassId()) {
                    element = this.drManager.newElement(classId, commKeys, parameterList);
                } else if (classId.equals(ClassID.POLICY_PARAMS)) {
                    PoliciesManager.getInstance().newPolicyParams(new CommKeyClassId(commKeys, classId), parameterList);
                    element = new PolicyParamTableEntryImpl(this);
                    ((LogicObjectImpl)element).setParameterList(parameterList);
                } else if (classId.equals(ClassID.POLICY_START)) {
                    PoliciesManager.getInstance().newPolicyStart(new CommKeyClassId(commKeys, classId), parameterList);
                    element = new PolicyTableEntryImpl(this);
                    ((LogicObjectImpl)element).setParameterList(parameterList);
                } else if (classId.equals(ClassID.FC_NODE)) {
                    element = this.newFCNode(parameterList);
                } else if (classId.equals(ClassID.INTERFACE) || classId.equals(ClassID.ETHERNET_INTERFACE) || classId.equals(ClassID.FC_INTERFACE) || classId.equals(ClassID.PSCSI_INTERFACE)) {
                    element = this.newInterfaceRow(parameterList);
                } else if (classId.equals(ClassID.HARDWARE)) {
                    element = this.createVSwitchHardware(parameterList);
                } else if (classId.equals(ClassID.STATISTIC_TCP)) {
                    element = this.createTCPStatistics(parameterList);
                } else if (classId.equals(ClassID.STATISTIC_UDP)) {
                    element = this.createUDPStatistics(parameterList);
                } else if (classId.equals(ClassID.STATISTIC_ICMP)) {
                    element = this.createICMPStatistics(parameterList);
                } else if (classId.equals(ClassID.STATISTIC_IP)) {
                    element = this.newIPStatistics(parameterList);
                } else if (classId.equals(ClassID.STATISTIC_ETHERNET)) {
                    element = this.createEthernetStatistics(parameterList);
                } else if (classId.equals(ClassID.STATISTIC_INTERFACE)) {
                    element = this.newInterfaceRowStatistics(parameterList);
                } else if (classId.equals(ClassID.STATISTIC_UDP_LISTENER)) {
                    element = this.newUDPListenerStatisticsRow(parameterList);
                } else if (classId.equals(ClassID.STATISTIC_TCP_CONNECTION)) {
                    element = this.newTCPConnectionStatisticsRow(parameterList);
                } else if (classId.equals(ClassID.ISCSI_INSTANCE)) {
                    element = this.newISCSIInstance(parameterList);
                } else if (classId.equals(ClassID.ISCSI_SESSION)) {
                    element = this.newISCSISession(parameterList);
                } else if (classId.equals(ClassID.ISCSI_SESSION_STATISTICS)) {
                    element = this.newISCSISessionStatistics(parameterList);
                } else if (classId.equals(ClassID.ISCSI_CONNECTION)) {
                    element = this.newISCSIConnection(parameterList);
                } else if (classId.equals(ClassID.ISCSI_REMOTE_INITIATOR)) {
                    element = this.newISCSIRemoteInitiator(parameterList);
                } else if (classId.equals(ClassID.ISCSI_REMOTE_INITIATOR_STATISTICS)) {
                    element = this.newISCSIRemoteInitiatorStatistics(parameterList);
                } else if (classId.equals(ClassID.ISCSI_INITIATOR)) {
                    element = this.newISCSIInitiator(parameterList);
                } else if (classId.equals(ClassID.SCSI_INITIATOR_PORT)) {
                    element = this.newSCSIInitiatorPort(parameterList);
                } else {
                    logger.warning("Class id " + classId + " not found in " + this.getClass() + "::newElement()");
                    return null;
                }
                if (element == null) {
                    CommKeyClassId commKeyClassId = new CommKeyClassId(commKeys, classId);
                    this.pendingNewElements.put(commKeyClassId, parameterList);
                    return null;
                }
                VSwitchImpl vSwitch = this.getVSwitch(classId, commKeys, parameterList);
                this.createElementCompleted(vSwitch, (LogicObjectImpl)element, commKeys, classId);
                if (classId.equals(ClassID.DIRECT_ACCESS_DEVICE)) {
                    this.fireTotalCapacityChanged();
                } else if (classId.equals(ClassID.LUN)) {
                    this.fireAccessibleSpaceChanged();
                } else if (classId.equals(ClassID.SNAPSHOT_VOLUME)) {
                    VolumeNodeImpl snapshotSource = (VolumeNodeImpl)((SnapshotVolumeImpl)element).getSourceVolume(vSwitch);
                    this.checkSnapshotConsistencyWithSourceExposedOn(snapshotSource, vSwitch);
                } else if (classId.equals(ClassID.ISCSI_TARGET)) {
                    this.setLocalTargetCredentials((ISCSITargetImpl)element);
                    this.addSCSIiSCSIMap(vSwitch, (ISCSITargetImpl)element);
                } else if (classId.equals(ClassID.ISCSI_REMOTE_TARGET)) {
                    ISCSIRemoteTargetImpl elem = (ISCSIRemoteTargetImpl)element;
                    this.setRemoteTargetCHAPCredentials(elem);
                    if (SystemRootImpl.getInstance().isDiscoverCompleted()) {
                        this.setRemoteTargetAliasIfCreatedByVSwitch(elem, vSwitch);
                    }
                } else if (classId.equals(ClassID.ISCSI_REMOTE_TARGET_PORTAL)) {
                    ISCSIRemoteTargetPortalImpl elem = (ISCSIRemoteTargetPortalImpl)element;
                    ISCSIRemoteTargetImpl remoteTargetElem = (ISCSIRemoteTargetImpl)elem.getRemoteTarget();
                    remoteTargetElem.removePendingCreatedRemotePortalIfNeeded(elem, vSwitch.getCommKeyClassId());
                } else if (classId.equals(ClassID.ISCSI_INITIATOR)) {
                    this.setLocalInitiatorCredentials((ISCSIInitiatorImpl)element);
                    this.addSCSIiSCSIMap(vSwitch, (ISCSIInitiatorImpl)element);
                } else if (classId.equals(ClassID.IDENTITY_NAME) && (identityParent = (IdentityImpl)(name = (IdentityNameImpl)element).getIdentityParent()).isOfRemoteInitiatorDR()) {
                    String identityAlias = identityParent.getAlias();
                    this.getIdentitiesList().removeDrIdentityPendingCreateForInitiatorNames(identityAlias, name.getName());
                }
                if (SystemRootImpl.getInstance().isDiscoverCompleted() && element instanceof SitesSynchronizeable) {
                    this.synchronizeNewElementBetweenSites(element, vSwitch, false);
                }
            }
            catch (AlreadyKnownByVSwitch akbv) {
                CommKeyClassId fromVSwitch;
                DRLogicObjectImpl drElement;
                element = akbv.getElement();
                if (classId.equals(ClassID.COPY_OPERATION)) {
                    ((LogicObjectImpl)element).addCommKeys(commKeys);
                    this.getCommKeyRefMap().addCommKeyClassIdAndRef(commKeys, classId, (Object)element);
                    this.changeElement((LogicObjectImpl)element, parameterList);
                }
                ((LogicObjectImpl)element).setParameterList(parameterList);
                StringBuffer debugMsg = new StringBuffer(classId.toString());
                debugMsg.append(" ");
                debugMsg.append(element);
                debugMsg.append(" already known by " + ClassID.VSWITCH);
                logger.debug(debugMsg.toString());
                if (!this.isDiscoverCompleted()) {
                    SystemRootImpl.setStatusInProcess(debugMsg.toString());
                }
                VSwitchImpl vSwitch = this.getVSwitch(classId, commKeys, parameterList);
                if (!element.getClassId().equals(ClassID.VSWITCH) && vSwitch != null) {
                    vSwitch.setConnected(true);
                }
                ((LogicObjectImpl)element).addCommKeys(commKeys);
                this.getCommKeyRefMap().addCommKeyClassIdAndRef(commKeys, classId, (Object)element);
                if (classId.isDRElementClassId() && (drElement = DRRootImpl.getInstance().findDRObjectWithIdenticalElement((DRClusterLogicObjectImpl)element)) != null) {
                    this.generateAlarms(2, drElement, this.getVSwitch(parameterList));
                }
                if (classId.equals(ClassID.JOURNAL_VOLUME) && this.isDiscoverCompleted()) {
                    CommKeyClassId activeOn = (CommKeyClassId)parameterList.get(ParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID);
                    if (activeOn != null) {
                        VSwitch activeOnVSwitch = (VSwitch)this.getCommKeyRefMap().getRefByCommKeyClassID(activeOn);
                        ElementEventImpl elementEvent = new ElementEventImpl(this, element);
                        HashMap<ParameterCode, VSwitch> map = new HashMap<ParameterCode, VSwitch>();
                        map.put(ParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID, activeOnVSwitch);
                        elementEvent.setParameterList(map);
                        EventServiceImpl.getInstance().fireElementChanged(elementEvent);
                    }
                } else if (classId.equals(ClassID.SNAPSHOT_VOLUME) && this.isDiscoverCompleted()) {
                    CommKeyClassId newVSwitchId = (CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID);
                    VSwitch existingVSwitch = this.getOtherVSwitch((VSwitch)this.getCommKeyRefMap().getRefByCommKeyClassID(newVSwitchId));
                    SnapshotActivateTypeConstants activateConstant = (SnapshotActivateTypeConstants)((Parameter)((SnapshotVolumeImpl)element).getParameters(existingVSwitch).get(ParameterCode.SNAPSHOT_ACTIVATE)).getValue();
                    if (activateConstant.equals(SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE)) {
                        ConfigElementData ced = new ConfigElementData(element.getCommKeyClassId());
                        ced.setValue(ParameterCode.SNAPSHOT_ACTIVATE, activateConstant);
                        ced.setValue(ParameterCode.VSWITCH_ID, newVSwitchId);
                        DataMgr.getInstance().changeElement(ced);
                    }
                } else if (classId.equals(ClassID.LUN)) {
                    ((LUImpl)element).synchronizeSerialNumber();
                    ((LUImpl)element).readSCSILunElement();
                } else if (classId.equals(ClassID.ISCSI_REMOTE_TARGET) && this.isDiscoverCompleted()) {
                    fromVSwitch = (CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID);
                    VSwitchImpl vswitch = (VSwitchImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(fromVSwitch);
                    this.setRemoteTargetAliasIfCreatedByVSwitch((ISCSIRemoteTargetImpl)element, vswitch);
                    this.fireISCSIRemoteTargetChanged((ISCSIRemoteTargetImpl)element);
                    ISCSIInitiator initiator = ((ISCSIRemoteTargetImpl)element).getInitiator(vswitch);
                    if (initiator == null) {
                        logger.error("ERROR! ClusterImpl = " + this.getAlias() + "; New remote target , AlreadyKnownByVSwitch = " + ((ISCSIRemoteTargetImpl)element).getName() + "; Parent Initiator in null!!!");
                    } else {
                        this.fireISCSIInitiatorChangedDueToRemoteTargetRemove((ISCSIInitiatorImpl)initiator);
                    }
                } else if (classId.equals(ClassID.ISCSI_REMOTE_TARGET_PORTAL)) {
                    ISCSIRemoteTargetPortalImpl elem = (ISCSIRemoteTargetPortalImpl)element;
                    ISCSIRemoteTargetImpl remoteTargetElem = (ISCSIRemoteTargetImpl)elem.getRemoteTarget();
                    remoteTargetElem.removePendingCreatedRemotePortalIfNeeded(elem, this.getVSwitch(parameterList).getCommKeyClassId());
                    this.fireISCSIRemoteTargetPortalChanged(elem);
                } else if (classId.equals(ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL) && this.isDiscoverCompleted()) {
                    fromVSwitch = (CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID);
                    VSwitchImpl vswitch = (VSwitchImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(fromVSwitch);
                    ISCSIInitiator initiator = vswitch.getISCSIInitiators()[0];
                    HashMap<ParameterCode, HashMap> map = new HashMap<ParameterCode, HashMap>();
                    map.put(ParameterCode.REMOTE_PORTAL_DISC_LAST_FAILURE, ((ISCSIRemotePortalDiscovery)element).getLastFailureType());
                    map.put(ParameterCode.REMOTE_PORTAL_DISC_LAST_DISCOVERY_SUCCESS_TIME, ((ISCSIRemotePortalDiscovery)element).getLastSuccessfulDiscovery());
                    map.put(ParameterCode.REMOTE_PORTAL_DISC_NEXT_PLANNED_DISCOVERY, ((ISCSIRemotePortalDiscovery)element).getNextPlannedDiscovery());
                    EventServiceImpl.getInstance().fireElementChanged(this, element, map);
                    this.fireISCSIInitiatorChangedDueToRemotePortalChange((ISCSIInitiatorImpl)initiator);
                } else if (classId.equals(ClassID.ISCSI_TARGET) || classId.equals(ClassID.ISCSI_INITIATOR)) {
                    this.addSCSIiSCSIMap(vSwitch, (SCSIDeviceImpl)element);
                }
                if (element instanceof Synchronizeable) {
                    LogMgr.getServerLog().debug("Element Synchronizeable create" + element.toString());
                    if (((SynchronizeableImpl)element).isSynchronizePending()) {
                        LogMgr.getServerLog().debug("Element Synchronizeable is Pending" + element.toString());
                        ((SynchronizeableImpl)element).syncDataWasChanged();
                    }
                }
                if (!SystemRootImpl.getInstance().isDiscoverCompleted() || !(element instanceof SitesSynchronizeable)) break block155;
                this.synchronizeNewElementBetweenSites(element, vSwitch, true);
            }
        }
        if (element != null) {
            ((LogicObjectImpl)element).clearDeletionStatus();
        }
        return element;
    }

    private void synchronizeNewElementBetweenSites(LogicObject element, VSwitch vSwitch, boolean isBecauseOfAlreadyKnownCase) throws RemoteException {
        if (isBecauseOfAlreadyKnownCase && element instanceof ISCSITargetImpl) {
            return;
        }
        ArrayList clustersInOtherSites = SystemRootImpl.getInstance().getClustersInOtherSites(this.getParentSite());
        for (int index2 = 0; index2 < clustersInOtherSites.size(); ++index2) {
            ClusterImpl remoteCluster = (ClusterImpl)clustersInOtherSites.get(index2);
            if (element instanceof ISCSIRemoteTargetImpl) {
                VSwitch[] createOnVSwitches = new VSwitch[]{vSwitch};
                ((ISCSIRemoteTargetImpl)element).synchronizeNewElementOnRemoteCluster(remoteCluster, createOnVSwitches);
                continue;
            }
            ((SitesSynchronizeable)((Object)element)).synchronizeNewElementOnRemoteCluster(remoteCluster);
        }
    }

    public void newElement(ConfigElementDataList cedList) {
        throw new UnsupportedOperationException();
    }

    public StoragePool getStoragePool() {
        return this.storage.getStoragePool();
    }

    public TargetList getTargetListMgr() {
        return this.storage.getTargetListMgr();
    }

    public RemoteTargetList getRemoteTargetListMgr() {
        return this.storage.getRemoteTargetListMgr();
    }

    public IdentitiesList getIdentitiesList() {
        return this.identities;
    }

    public Vector getAllIdentities() throws RemoteException {
        return this.identities.getAllIdentities();
    }

    public ExternalServerList getRadiusServersList() throws RemoteException {
        return this.radiusServerList;
    }

    public ExternalServerList getISNSServersList() throws RemoteException {
        return this.isnsServerList;
    }

    public Vector getAllRadiusServers() throws RemoteException {
        return this.radiusServerList.getAllServers();
    }

    public Vector getAllISNSServers() throws RemoteException {
        return this.isnsServerList.getAllServers();
    }

    public VolumeManager getVolumeMgr() {
        return this.storage.getVolumeMgr();
    }

    private void changeElement(LogicObjectImpl element, HashMap parameterList) throws RemoteException, IllegalValueException {
        SrString userName;
        ElementEventImpl elementEvent;
        String ip;
        VSwitch neighborVSwitch;
        NeighborImpl neighbor;
        Object lastUpdate = parameterList.get(ParameterCode.LAST_UPDATE);
        VSwitchImpl vSwitch = this.getVSwitch(element.getClassId(), element.getCommKeys(), parameterList);
        if (lastUpdate != null && !element.isNewer((SrTimeTicks)lastUpdate, vSwitch)) {
            return;
        }
        ClassID classId = element.getClassId();
        if (classId.equals(ClassID.VSWITCH)) {
            Object coldStart = parameterList.get(ParameterCode.VSWITCH_COLD_START);
            if (coldStart != null) {
                this.rediscover();
                return;
            }
            if (parameterList.containsKey(ParameterCode.VSWITCH_TAKE_OVER_STATE) && vSwitch != null) {
                vSwitch.readIPsState();
            }
        }
        HashMap changedValues = element.setParameterList(parameterList);
        if (classId.equals(ClassID.NEIGHBORE) && this.isDiscoverCompleted() && ((neighbor = (NeighborImpl)element).isDead() || neighbor.isAlive()) && (neighborVSwitch = this.getVSwitchByIPAddress(ip = neighbor.getIPAddress())) != null) {
            neighborVSwitch.getDateAndTime();
        }
        if (classId.isDRClassId()) {
            if (element instanceof DRClusterLogicObjectImpl) {
                SrBITSConstant replicationState = (SrBITSConstant)element.getSrValueOf(MasterParameterCode.DR_REPLICATION_STATE);
                if (DRRoleConstant.REMOTE.equals(((DRClusterLogicObjectImpl)element).getRole()) && element.getActiveVswitch().equals(vSwitch) && !element.getClassId().equals(ClassID.ASYNC_PAIR)) {
                    if (replicationState.contains(DRReplicationStateConstant.FALLBACK)) {
                        if (!((DRClusterLogicObjectImpl)element).inSwitchProcess && (element.getClassId().equals(ClassID.SYNC_PAIR) || parameterList.containsKey(ParameterCode.DR_CONSISTENCY_GROUP_PENDING_PITS) && ((SrGauge)parameterList.get(ParameterCode.DR_CONSISTENCY_GROUP_PENDING_PITS)).equals(0)) && element.isParameterEqual(new MasterParameter(MasterParameterCode.DR_INITIAL_SYNC_STATE.getParameterCode(element), DRInitialSyncStateConstant.OK), element.getActiveVswitch())) {
                            ((DRClusterLogicObjectImpl)element).inSwitchProcess = true;
                        }
                    } else {
                        ((DRClusterLogicObjectImpl)element).inSwitchProcess = false;
                    }
                }
            }
            elementEvent = new ElementEventImpl(element, element);
            if (vSwitch != null) {
                elementEvent.setVSwitchIp(vSwitch.getMgmIPAddr());
            }
            elementEvent.setParameterList(changedValues);
            if (!changedValues.isEmpty() && this.isDiscoverCompleted()) {
                this.invokeDREventAndWait(elementEvent, 2);
            }
            if (classId.equals(ClassID.CONSISTENCY_GROUP) && element.getConnectedVSwitches().length == 1 && changedValues.containsKey(ParameterCode.DR_VIRT_GROUP_ALIAS) && ((DRClusterAbstractConsistencyGroupImpl)element).isEmpty()) {
                this.drManager.rematchEmptyGroupWithNoPairs((DRClusterAbstractConsistencyGroupImpl)element);
            }
            return;
        }
        if (classId.equals(ClassID.POLICY_START) || classId.equals(ClassID.POLICY_PARAMS)) {
            PoliciesManager.getInstance().changePolicyElement(element);
        } else if (classId.equals(ClassID.IDENTITY) && this.isDiscoverCompleted()) {
            IdentityImpl identity = (IdentityImpl)element;
            this.identities.changeEntryKey(identity);
        } else if (classId.equals(ClassID.IDENTITY_NAME) && this.isDiscoverCompleted()) {
            IdentityNameImpl identityName = (IdentityNameImpl)element;
            Identity identity = identityName.getIdentityParent();
            boolean isLocalInitiatorIdentity = identity.getAlias().startsWith("SELF");
            if (isLocalInitiatorIdentity) {
                this.identities.changeEntryKey(identity, identityName.getName());
            }
        } else if (classId.equals(ClassID.ISCSI_TARGET)) {
            if (changedValues.containsKey(ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON)) {
                VSwitchImpl otherVSwitch = (VSwitchImpl)this.getOtherVSwitch(vSwitch);
                if (otherVSwitch != null && otherVSwitch.isDeletionPending()) {
                    otherVSwitch.deleteElement();
                }
                Vector allSnapshotSources = ((TargetImpl)element).getAllSnapshotVolumeSources();
                Enumeration e = allSnapshotSources.elements();
                while (e.hasMoreElements()) {
                    VolumeNodeImpl sourceVolume = (VolumeNodeImpl)e.nextElement();
                    this.generateAlarms(2, sourceVolume, vSwitch);
                }
            }
        } else if (classId.equals(ClassID.CHAP_CREDENTIALS)) {
            CHAPCredentialsImpl chapCredElement;
            IdentityImpl identityParent;
            userName = (SrString)changedValues.get(ParameterCode.CHAP_CREDENTIALS_USER_NAME);
            if (userName != null && this.isDiscoverCompleted() && !(identityParent = (IdentityImpl)(chapCredElement = (CHAPCredentialsImpl)element).getIdentityParent()).isPurposeUnknown()) {
                Synchronizeable deviceToChange = ((CHAPCredentialsImpl)element).getISCSIDevice();
                ParameterCode codeToChange = ParameterCode.ISCSI_TARGET_USER_NAME;
                if (deviceToChange.getClassId().equals(ClassID.ISCSI_REMOTE_TARGET)) {
                    codeToChange = ParameterCode.ISCSI_REMOTE_TARGET_CHAP_USER_NAME;
                } else if (deviceToChange.getClassId().equals(ClassID.ISCSI_INITIATOR)) {
                    codeToChange = ParameterCode.ISCSI_INITIATOR_CHAP_USER_NAME;
                }
                ElementEventImpl elementEvent2 = new ElementEventImpl(this, deviceToChange);
                HashMap<ParameterCode, SrString> map = new HashMap<ParameterCode, SrString>();
                map.put(codeToChange, userName);
                elementEvent2.setParameterList(map);
                EventServiceImpl.getInstance().fireElementChanged(elementEvent2);
            }
        } else if (classId.equals(ClassID.SRP_CREDENTIALS)) {
            userName = (SrString)changedValues.get(ParameterCode.SRP_CREDENTIALS_USER_NAME);
            if (userName != null) {
                ElementEventImpl elementEvent3 = new ElementEventImpl(this, (SRPCredentialsImpl)element);
                HashMap<ParameterCode, SrString> map = new HashMap<ParameterCode, SrString>();
                map.put(ParameterCode.ISCSI_INITIATOR_SRP_USER_NAME, userName);
                elementEvent3.setParameterList(map);
                EventServiceImpl.getInstance().fireElementChanged(elementEvent3);
            }
        } else if (classId.isVolumeNode()) {
            SnapshotActivateTypeConstants activate;
            VolumeImpl parent;
            CommKeyClassId parentVol = (CommKeyClassId)changedValues.get(ParameterCode.VIRTUAL_VOLUME_PARENT);
            if (parentVol != null && this.isDiscoverCompleted() && (parent = (VolumeImpl)SystemRootImpl.getInstance().getRefByStub(parentVol)) != null) {
                this.generateAlarms(2, parent, vSwitch);
            }
            if (classId.equals(ClassID.SNAPSHOT_VOLUME) && changedValues.containsKey(ParameterCode.SNAPSHOT_ACTIVATE) && (activate = (SnapshotActivateTypeConstants)changedValues.get(ParameterCode.SNAPSHOT_ACTIVATE)) != null && activate.equals(SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE)) {
                ((SnapshotVolumeImpl)element).syncDataWasChanged();
            }
            if (classId.isSCSIDevice()) {
                this.getStoragePool().storageChanged((GeneralSCSIDeviceImpl)element);
            }
        } else if (classId.isInterface() && changedValues.containsKey(ParameterCode.IF_OPER_STAT)) {
            this.generateAlarms(2, vSwitch, vSwitch);
        }
        if (!changedValues.isEmpty() || element.getClassId().isStatisticsClassId()) {
            if (element.getClassId().equals(ClassID.COPY_OPERATION) && ((CopyOperationImpl)element).getCopyType().isRestore()) {
                this.generateAlarms(2, (VolumeNodeImpl)((CopyOperationImpl)element).getCopySrcNode(), vSwitch);
                this.generateAlarms(2, (VolumeNodeImpl)((CopyOperationImpl)element).getCopyDstNode(), vSwitch);
            }
            elementEvent = new ElementEventImpl(element, element);
            if (vSwitch != null) {
                elementEvent.setVSwitchIp(vSwitch.getMgmIPAddr());
            }
            elementEvent.setParameterList(changedValues);
            if (element.getClassId().isStatisticsClassId()) {
                HashMap clientRatesMap = ((StatisticsImpl)element).getClientRates();
                elementEvent.getParameterList().putAll(clientRatesMap);
            }
            if (this.isDiscoverCompleted()) {
                EventServiceImpl.getInstance().fireElementChanged(elementEvent);
            }
            StringBuffer debugMsg = new StringBuffer(element.getClassId().toString());
            debugMsg.append(" ");
            debugMsg.append(element);
            Iterator i = parameterList.keySet().iterator();
            while (i.hasNext()) {
                ParameterCode code = (ParameterCode)i.next();
                if (code.equals(ParameterCode.VSWITCH_ID)) continue;
                debugMsg.append(" [");
                debugMsg.append(code);
                debugMsg.append(" (");
                debugMsg.append(parameterList.get(code));
                debugMsg.append(")];");
            }
            debugMsg.append(" was changed on " + ClassID.VSWITCH + " ");
            if (vSwitch != null) {
                debugMsg.append(vSwitch.getMgmIPAddr());
            }
            logger.info(debugMsg.toString());
        }
        if (element.getClassId().equals(ClassID.VSWITCH)) {
            ((VSwitchImpl)element).setConnected(true);
            if (changedValues.containsKey(ParameterCode.VSWITCH_SWITCH_ID)) {
                ((VSwitchImpl)element).addNeighborIfPending();
                ((VSwitchImpl)element).changeRemotetargetPortalsIfNeeded();
            }
        } else if (vSwitch != null) {
            if (element.getClassId().equals(ClassID.VSWITCH) && (changedValues.containsKey(ParameterCode.VSWITCH_TRAP_UDP_PORT) || changedValues.containsKey(ParameterCode.VSWITCH_READ_COMMUNITY) || changedValues.containsKey(ParameterCode.VSWITCH_WRITE_COMMUNITY))) {
                return;
            }
            vSwitch.setConnected(true);
        }
        if (changedValues.containsKey(ParameterCode.VIRTUAL_VOLUME_ACTUAL_NUM_OF_BLOCKS)) {
            this.fireAccessibleSpaceChanged();
        }
        if (!changedValues.isEmpty() && SystemRootImpl.getInstance().isDiscoverCompleted() && element instanceof SitesSynchronizeable) {
            ArrayList clustersInOtherSites = SystemRootImpl.getInstance().getClustersInOtherSites(this.getParentSite());
            for (int index2 = 0; index2 < clustersInOtherSites.size(); ++index2) {
                ClusterImpl remoteCluster = (ClusterImpl)clustersInOtherSites.get(index2);
                ((SitesSynchronizeable)((Object)element)).synchronizeChangeElementOnRemoteCluster(remoteCluster, changedValues);
            }
        }
    }

    private void addToQueue(Object queueElement) {
        logger.debug("Added to Event Queue: " + queueElement);
        this.eventQueue.addElement(queueElement);
    }

    private void addToHeadOFQueue(Object queueElement) {
        logger.debug("Added to Event to head of Queue: " + queueElement);
        this.eventQueue.addElementToHead(queueElement);
    }

    public void elementEvent(EventObject e) {
        this.elementEvent(e, false);
    }

    public void elementEvent(EventObject e, boolean isPrioritized) {
        this.elementEvent(e, isPrioritized, false);
    }

    public void elementEvent(EventObject e, boolean isPrioritized, boolean synchronous) {
        logger.debug(e + " was received to cluster");
        EventQueueElement eventQueueElement = null;
        if (e instanceof SrEvent) {
            eventQueueElement = new EventQueueElement((Object)e, ((SrEvent)e).getType(), ((SrEvent)e).getEventTypeName());
        } else if (e instanceof DREvent) {
            eventQueueElement = new EventQueueElement((Object)e, ((DREvent)e).getType(), "");
        } else if (e instanceof ErrorEvent) {
            eventQueueElement = new EventQueueElement((Object)e, null, null);
        } else {
            logger.warning("elementEvent: cluster " + this + " received unrecognized event " + e);
        }
        if (eventQueueElement != null) {
            if (synchronous) {
                try {
                    this.queueConsumerThread.processEvent(eventQueueElement);
                }
                catch (RemoteException re) {
                    logger.error(re);
                }
                catch (InterruptedException ie) {
                    logger.error("Cluster and DRRoot might lost synchronization due to InterruptedException", ie);
                }
            } else if (isPrioritized) {
                this.addToHeadOFQueue(eventQueueElement);
            } else {
                this.addToQueue(eventQueueElement);
            }
        }
        try {
            if (!this.isDiscoverCompleted()) {
                SystemRootImpl.addToStatusMessage(".");
            }
        }
        catch (RemoteException re) {
            logger.error(re);
        }
    }

    public static boolean debugAlertOnEvent(EventObject e, ClassID classId, int srEventType) {
        ConfigElementDataList elements;
        SrElementEvent srEvt;
        boolean alert = false;
        if (e instanceof SrElementEvent && (srEvt = (SrElementEvent)e).getType() == srEventType && (elements = srEvt.getElements()) != null && !elements.isEmpty() && (classId == null || elements.getConfigElementDataAt(0).getClassId().equals(classId))) {
            alert = true;
        }
        if (alert) {
            Thread.dumpStack();
        }
        return alert;
    }

    public void changeElement(ConfigElementData ced) {
        throw new UnsupportedOperationException();
    }

    public void changeElement(ConfigElementDataList cedList) {
        throw new UnsupportedOperationException();
    }

    public void readElement(ConfigElementData ced) {
        throw new UnsupportedOperationException();
    }

    public void readElement(ConfigElementDataList ced) {
        throw new UnsupportedOperationException();
    }

    private void removeElementByEvent(LogicObject element, HashMap parameterList) throws RemoteException {
        if (element == null) {
            return;
        }
        ClassID classId = element.getClassId();
        VSwitchImpl vSwitch = this.getVSwitch(classId, element.getCommKeys(), parameterList);
        this.removeElement(element, vSwitch, vSwitch.getMgmIPAddr());
        if (classId.equals(ClassID.VSWITCH)) {
            VSwitchClusterMap.getInstance().remove((CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID));
        }
    }

    public void removeElement(LogicObject element, VSwitch vSwitch) {
        try {
            this.removeElement(element, (VSwitchImpl)vSwitch, vSwitch.getMgmIPAddr());
        }
        catch (RemoteException re) {
            logger.error(re);
        }
    }

    private void removeElement(LogicObject element, VSwitchImpl vSwitch, String vSwitchIp) throws RemoteException {
        Credentials cred;
        ClusterImpl remoteCluster;
        int index2;
        ArrayList clustersInOtherSites;
        if (element == null) {
            return;
        }
        ((LogicObjectImpl)element).setDeletionProcessStarted();
        ClassID classId = element.getClassId();
        VolumeNodeImpl snapshotSource = null;
        DirectAccessDeviceImpl parentDisk = null;
        if (SystemRootImpl.getInstance().isDiscoverCompleted() && element instanceof SitesSynchronizeable) {
            clustersInOtherSites = SystemRootImpl.getInstance().getClustersInOtherSites(this.getParentSite());
            for (index2 = 0; index2 < clustersInOtherSites.size(); ++index2) {
                remoteCluster = (ClusterImpl)clustersInOtherSites.get(index2);
                ((SitesSynchronizeable)((Object)element)).synchronizePreRemoveElementOnRemoteCluster(remoteCluster);
            }
        }
        if (classId.equals(ClassID.DIRECT_ACCESS_DEVICE)) {
            element = this.storage.removeDirectAccessDevice((DirectAccessDeviceImpl)element);
        } else if (classId.equals(ClassID.SEQUENTIAL_ACCESS_DEVICE)) {
            element = this.storage.removeSequentialAccessDevice((SequentialAccessDeviceImpl)element);
        } else if (classId.equals(ClassID.GENERAL_SCSI_DEVICE)) {
            element = this.storage.removeGeneralSCSIDevice((GeneralSCSIDeviceImpl)element);
        } else if (classId.isVolume()) {
            if (classId.equals(ClassID.SNAPSHOT_VOLUME)) {
                snapshotSource = (VolumeNodeImpl)((SnapshotVolumeImpl)element).getSourceVolume();
            }
            element = this.storage.removeVolume((VolumeImpl)element, vSwitch);
        } else if (classId.equals(ClassID.ISCSI_TARGET)) {
            element = this.storage.removeTarget((TargetImpl)element);
            ((PolicyManagerImpl)this.getPolicyManager()).removeAcl((Target)element);
            cred = ((ISCSITargetImpl)element).getCredentials();
            if (cred != null) {
                IdentityImpl identity = (IdentityImpl)cred.getIdentityParent();
                if (identity != null) {
                    identity.removeCredentials(cred);
                    this.getCommKeyRefMap().removeCommKeyClassIdAndRef(identity.getCommKeyClassId());
                }
                this.getCommKeyRefMap().removeCommKeyClassIdAndRef(cred.getCommKeyClassId());
            } else {
                logger.warning("Credentials is null in removeElement " + element.getClassId() + " " + element);
            }
            CommKeyClassId iscsiTargetCommKeyClassId = element.getCommKeyClassId();
            this.m_scsiDeviceIscsiNodeMap.removeEntryFromMap(iscsiTargetCommKeyClassId);
        } else if (classId.equals(ClassID.ISCSI_INITIATOR)) {
            CommKeyClassId iscsiInitiatorCommKeyClassId = element.getCommKeyClassId();
            this.m_scsiDeviceIscsiNodeMap.removeEntryFromMap(iscsiInitiatorCommKeyClassId);
        } else if (classId.equals(ClassID.ISCSI_REMOTE_TARGET)) {
            ISCSIRemoteTargetImpl elem = (ISCSIRemoteTargetImpl)(element = this.storage.removeRemoteTarget((ISCSIRemoteTargetImpl)element));
            if (elem.getConnectedVSwitchCounter() == 1) {
                ISCSIInitiator[] initiatorsImpl = elem.getAllConnectedInitiators();
                for (int index = 0; index < initiatorsImpl.length; ++index) {
                    ISCSIInitiatorImpl initiatorImpl = (ISCSIInitiatorImpl)initiatorsImpl[index];
                    initiatorImpl.removeRemoteTarget(elem);
                    this.fireISCSIInitiatorChangedDueToRemoteTargetRemove(initiatorImpl);
                }
            } else {
                ISCSIInitiatorImpl initiator = (ISCSIInitiatorImpl)vSwitch.getISCSIInitiators()[0];
                initiator.removeRemoteTarget(elem);
                this.fireISCSIInitiatorChangedDueToRemoteTargetRemove(initiator);
            }
            CHAPCredentials chapCred = ((ISCSIRemoteTargetImpl)element).getCHAPCredentials();
            if (chapCred != null) {
                IdentityImpl identity = (IdentityImpl)chapCred.getIdentityParent();
                if (identity != null) {
                    identity.removeCredentials(chapCred);
                    this.removeElement(chapCred, vSwitch, vSwitchIp);
                    this.removeElement(identity, vSwitch, vSwitchIp);
                }
            } else {
                logger.warning("Credentials is null in removeElement " + element.getClassId() + " " + element);
            }
            ISCSIRemoteTargetPortal[] portals = ((ISCSIRemoteTargetImpl)element).getISCSIPortals();
            for (int index = 0; index < portals.length; ++index) {
                ISCSIRemoteTargetPortal portal = portals[index];
                this.removeElement(portal, vSwitch, vSwitchIp);
            }
            ISCSISession[] sessions = ((ISCSIRemoteTargetImpl)element).getISCSISessions();
            for (int index = 0; index < sessions.length; ++index) {
                ISCSISession session = sessions[index];
                this.removeElement(session, vSwitch, vSwitchIp);
            }
        } else if (classId.equals(ClassID.ISCSI_REMOTE_TARGET_PORTAL)) {
            element = this.storage.removeRemoteTargetPortal((ISCSIRemoteTargetPortalImpl)element);
        } else if (classId.equals(ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL)) {
            ISCSIRemotePortalDiscoveryImpl remoteDiscoveryPortal = (ISCSIRemotePortalDiscoveryImpl)element;
            VSwitch[] connectedVSwitches = remoteDiscoveryPortal.getConnectedVSwitches();
            ISCSIInitiatorImpl connectedInitiator = null;
            if (connectedVSwitches.length == 1) {
                connectedInitiator = (ISCSIInitiatorImpl)connectedVSwitches[0].getISCSIInitiators()[0];
                connectedInitiator.removeRemoteDiscoveryPortal(remoteDiscoveryPortal);
            } else {
                connectedInitiator = (ISCSIInitiatorImpl)vSwitch.getISCSIInitiators()[0];
                connectedInitiator.removeRemoteDiscoveryPortal(remoteDiscoveryPortal);
            }
            this.fireISCSIInitiatorChangedDueToRemoteTargetRemove(connectedInitiator);
        } else if (classId.equals(ClassID.LUN)) {
            element = this.storage.removeLU((LUImpl)element);
        } else if (classId.equals(ClassID.SCSI_LUN)) {
            element = this.storage.removeSCSILun((SCSILunImpl)element);
        } else if (classId.equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            parentDisk = (DirectAccessDeviceImpl)((SubDirectAccessDeviceImpl)element).getDirectAccessDeviceParent();
            element = this.storage.removeSubDirectAccessDevice((SubDirectAccessDeviceImpl)element);
        } else if (classId.equals(ClassID.ISCSI_SESSION)) {
            ISCSISessionImpl iscsiSession = (ISCSISessionImpl)element;
            iscsiSession.removeFromAll();
            Vector connections = iscsiSession.getConnections();
            for (int i = 0; i < connections.size(); ++i) {
                ISCSIConnection connection = (ISCSIConnection)connections.elementAt(i);
                this.removeElement(connection, vSwitch);
            }
            element = this.removeTabelRow((TableRow)element);
            CommKeyClassId sessionStatisticsCommKeyClassId = new CommKeyClassId(iscsiSession.getCommKeys(), ClassID.ISCSI_SESSION_STATISTICS);
            ISCSISessionStatisticsImpl elementToRemove = (ISCSISessionStatisticsImpl)SystemRootImpl.getInstance().getRefByStub(sessionStatisticsCommKeyClassId);
            this.removeElement(elementToRemove, vSwitch);
        } else if (classId.equals(ClassID.ISCSI_CONNECTION)) {
            ISCSIConnection iscsiConnection = (ISCSIConnection)element;
            ISCSISession iscsiSession = iscsiConnection.getSessionParent();
            if (iscsiSession != null) {
                ((ISCSISessionImpl)iscsiSession).removeConnection(iscsiConnection);
            }
        } else if (classId.equals(ClassID.NETWORK_CONFIGURATION) || classId.equals(ClassID.INTERFACE) || classId.equals(ClassID.STATISTIC_INTERFACE) || classId.equals(ClassID.FC_INTERFACE) || classId.equals(ClassID.PSCSI_INTERFACE) || classId.equals(ClassID.ETHERNET_INTERFACE) || classId.equals(ClassID.PORTAL) || classId.equals(ClassID.IP_ROUTE) || classId.equals(ClassID.NEIGHBORE) || classId.equals(ClassID.ISCSI_SESSION_STATISTICS) || classId.equals(ClassID.ISCSI_INSTANCE) || classId.equals(ClassID.STATISTIC_UDP_LISTENER) || classId.equals(ClassID.STATISTIC_TCP_CONNECTION)) {
            element = this.removeTabelRow((TableRow)element);
        } else if (classId.equals(ClassID.VSWITCH)) {
            this.generateAlarms(3, (GeneralLogicObjectImpl)((Object)element), null);
            this.m_vSwitches.remove(element);
            if (!((VSwitchImpl)element).isDeletedFromDatabaseOnly()) {
                if (!this.m_vSwitches.isEmpty()) {
                    ((VSwitchImpl)this.m_vSwitches.firstElement()).setAllIPsActive();
                }
                this.removeNeighbor(((VSwitch)element).getMgmIPAddr());
            } else {
                VSwitchImpl vSwitchImpl = (VSwitchImpl)element;
                if (vSwitchImpl.isPendingMovingToCluster()) {
                    try {
                        ClusterImpl cluster = (ClusterImpl)vSwitchImpl.getWatingMovingCluster();
                        cluster.addVSwitch(vSwitchImpl);
                    }
                    catch (IllegalValueException ive) {
                        logger.warning(ive);
                    }
                }
            }
        } else if (classId.equals(ClassID.IDENTITY)) {
            element = this.identities.removeIdentity((Identity)element);
        } else if (classId.equals(ClassID.IDENTITY_NAME)) {
            IdentityName identityName = (IdentityName)element;
            Identity identity = identityName.getIdentityParent();
            ((IdentityImpl)identity).removeName(identityName);
        } else if (classId.equals(ClassID.SRP_CREDENTIALS) || classId.equals(ClassID.CHAP_CREDENTIALS)) {
            cred = (Credentials)element;
            Identity parent = cred.getIdentityParent();
            if (parent != null) {
                ((IdentityImpl)parent).removeCredentials(cred);
            }
        } else if (classId.equals(ClassID.RADIUS_SERVER)) {
            this.radiusServerList.removeExternalServer((RadiusServer)element);
        } else if (classId.equals(ClassID.ISNS_SERVER)) {
            this.isnsServerList.removeExternalServer((ISNSServer)element);
        } else if (!classId.equals(ClassID.ACL_ENTRY)) {
            if (classId.equals(ClassID.COPY_OPERATION)) {
                this.copyOperMgr.removeCopyOper((CopyOperationImpl)element);
            } else if (classId.isDRClassId()) {
                if (this.isDiscoverCompleted()) {
                    if (element.getConnectedVSwitchCounter() == 1) {
                        this.invokeDREventAndWait((LogicObjectImpl)element, 3);
                    } else {
                        DRLogicObjectImpl drElement = DRRootImpl.getInstance().findDRObjectWithIdenticalElement((DRClusterLogicObjectImpl)element);
                        DrAlarmMgrImpl.getInstance().generateAlarms(3, drElement, vSwitch);
                    }
                }
                this.drManager.removeElement((LogicObjectImpl)element, vSwitch);
            } else if (classId.isPolicyClassId()) {
                PoliciesManager.getInstance().removePolicyElement((LogicObjectImpl)element);
            } else {
                logger.warning("Class id " + classId + " not found in " + this.getClass() + "::removeElement()");
            }
        }
        if (element != null) {
            this.removeElementCompleted(element, vSwitch);
            ((GeneralLogicObjectImpl)((Object)element)).setDeletionProcessCompleted();
        } else {
            logger.error("Error in remove element " + classId);
        }
        if (classId.equals(ClassID.DIRECT_ACCESS_DEVICE)) {
            this.fireTotalCapacityChanged();
        } else if (classId.equals(ClassID.LUN)) {
            this.fireAccessibleSpaceChanged();
        } else if (classId.equals(ClassID.ISCSI_REMOTE_TARGET)) {
            ISCSIRemoteTargetImpl remoteTarget = (ISCSIRemoteTargetImpl)element;
            if (remoteTarget.getConnectedVSwitchCounter() == 1 && !remoteTarget.isInDeletionProcess()) {
                this.fireISCSIRemoteTargetChanged(remoteTarget);
            }
        } else if (classId.equals(ClassID.ISCSI_REMOTE_TARGET_PORTAL)) {
            ISCSIRemoteTargetPortalImpl remotePortal = (ISCSIRemoteTargetPortalImpl)element;
            if (remotePortal.getConnectedVSwitchCounter() == 1) {
                this.fireISCSIRemoteTargetPortalChanged(remotePortal);
                ISCSIRemoteTargetImpl remoteTarget = (ISCSIRemoteTargetImpl)remotePortal.getRemoteTarget();
                if (!remoteTarget.isInDeletionProcess()) {
                    this.fireISCSIRemoteTargetChanged(remoteTarget);
                }
            }
        } else if (classId.equals(ClassID.SNAPSHOT_VOLUME)) {
            try {
                this.checkSnapshotConsistencyWithSourceExposedOn(snapshotSource, vSwitch);
            }
            catch (IllegalValueException ive) {
                logger.debug(ive);
            }
        } else if (classId.equals(ClassID.SUB_DIRECT_ACCESS_DEVICE) && vSwitch != null) {
            this.generateAlarms(2, parentDisk, vSwitch);
        }
        if (SystemRootImpl.getInstance().isDiscoverCompleted() && element instanceof SitesSynchronizeable) {
            clustersInOtherSites = SystemRootImpl.getInstance().getClustersInOtherSites(this.getParentSite());
            for (index2 = 0; index2 < clustersInOtherSites.size(); ++index2) {
                remoteCluster = (ClusterImpl)clustersInOtherSites.get(index2);
                ((SitesSynchronizeable)((Object)element)).synchronizePostRemoveElementOnRemoteCluster(remoteCluster);
            }
        }
    }

    private void checkSnapshotConsistencyWithSourceExposedOn(VolumeNodeImpl snapshotSource, VSwitchImpl vSwitch) throws RemoteException, IllegalValueException {
        if (this.isDiscoverCompleted() && snapshotSource != null) {
            this.generateAlarms(2, snapshotSource, vSwitch);
        }
    }

    private void fireTotalCapacityChanged() throws RemoteException {
        if (this.isDiscoverCompleted()) {
            ElementEventImpl elementEvent = new ElementEventImpl(this, this);
            HashMap<ClientParameterCode, BigInteger> parameterList = new HashMap<ClientParameterCode, BigInteger>();
            parameterList.put(ClientParameterCode.CLUSTER_TOTAL_CAPACITY, this.getTotalCapacity());
            elementEvent.setParameterList(parameterList);
            EventServiceImpl.getInstance().fireElementChanged(elementEvent);
        }
    }

    private void fireAccessibleSpaceChanged() throws RemoteException {
        if (this.isDiscoverCompleted()) {
            ElementEventImpl elementEvent = new ElementEventImpl(this, this);
            HashMap<ClientParameterCode, BigInteger> parameterList = new HashMap<ClientParameterCode, BigInteger>();
            parameterList.put(ClientParameterCode.CLUSTER_ACCESSIBLE_SPACE, this.getAccessibleSpace());
            elementEvent.setParameterList(parameterList);
            EventServiceImpl.getInstance().fireElementChanged(elementEvent);
        }
    }

    private void fireISCSIInitiatorChangedDueToRemotePortalChange(ISCSIInitiatorImpl initiator) throws RemoteException {
        HashMap<ParameterCode, ISCSIRemotePortalDiscovery[]> map = new HashMap<ParameterCode, ISCSIRemotePortalDiscovery[]>();
        map.put(ParameterCode.ISCSI_INITIATOR_REMOTE_DISCOVERY_PORTALS, initiator.getISCSIRemoteDiscoveryPortals());
        EventServiceImpl.getInstance().fireElementChanged(this, initiator, map);
    }

    private void fireISCSIInitiatorChangedDueToRemoteTargetRemove(ISCSIInitiatorImpl initiator) throws RemoteException {
        HashMap<ParameterCode, ISCSIRemoteTarget[]> map = new HashMap<ParameterCode, ISCSIRemoteTarget[]>();
        map.put(ParameterCode.ISCSI_INITIATOR_REMOTE_TARGETS, initiator.getISCSIRemoteTargets());
        EventServiceImpl.getInstance().fireElementChanged(this, initiator, map);
    }

    private void fireISCSIRemoteTargetChanged(ISCSIRemoteTargetImpl remoteTarget) throws RemoteException {
        HashMap<ParameterCode, HashMap> map = new HashMap<ParameterCode, HashMap>();
        map.put(ParameterCode.SCSI_REMOTE_TARGET_LOGIN_STATUS, remoteTarget.getLoginStatus());
        map.put(ParameterCode.SCSI_REMOTE_TARGET_FAILURE_TYPE, remoteTarget.getFailureType());
        EventServiceImpl.getInstance().fireElementChanged(this, remoteTarget, map);
    }

    private void fireISCSIRemoteTargetPortalChanged(ISCSIRemoteTargetPortalImpl remotePortal) throws RemoteException {
        HashMap<ParameterCode, VSwitch[]> map = new HashMap<ParameterCode, VSwitch[]>();
        map.put(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_CONNECTED_VSWITCHES, remotePortal.getConnectedVSwitches());
        EventServiceImpl.getInstance().fireElementChanged(this, remotePortal, map);
    }

    private void fireISCSITargetCredentialsChanged(ISCSITargetImpl target) throws RemoteException {
        HashMap<ParameterCode, String> map = new HashMap<ParameterCode, String>();
        map.put(ParameterCode.ISCSI_TARGET_USER_NAME, target.getUserName());
        EventServiceImpl.getInstance().fireElementChanged(this, target, map);
    }

    private void fireISCSIRemoteTargetCredentialsChanged(ISCSIRemoteTargetImpl remoteTarget) throws RemoteException {
        HashMap<ParameterCode, String> map = new HashMap<ParameterCode, String>();
        map.put(ParameterCode.ISCSI_REMOTE_TARGET_CHAP_USER_NAME, remoteTarget.getCHAPUserName());
        EventServiceImpl.getInstance().fireElementChanged(this, remoteTarget, map);
    }

    private void removeElementCompleted(LogicObject element, VSwitchImpl vSwitch) throws RemoteException {
        AclEntryImpl entry;
        IdentityImpl identityParent;
        LUImpl lu0;
        LUImpl lu;
        boolean vSwitchDeletedFromDB;
        ClassID classId = element.getClassId();
        ElementEventImpl elementEvent = new ElementEventImpl(element, element);
        String vSwitchIp = null;
        if (vSwitch != null) {
            vSwitchIp = vSwitch.getMgmIPAddr();
        }
        elementEvent.setVSwitchIp(vSwitchIp);
        if (element != null && element.getConnectedVSwitchCounter() == 1) {
            this.generateAlarms(3, (GeneralLogicObjectImpl)((Object)element), null);
        }
        int vSwitchCount = 0;
        CommKey[] removedCommKey = null;
        if (!classId.equals(ClassID.VSWITCH) && vSwitch != null) {
            removedCommKey = ((LogicObjectImpl)element).removeFromVSwitch(vSwitch);
            vSwitchCount = ((LogicObjectImpl)element).getConnectedVSwitchCounter();
            vSwitch.setConnected(true);
        } else {
            removedCommKey = element.getCommKeys();
        }
        boolean bl = vSwitchDeletedFromDB = classId.equals(ClassID.VSWITCH) && ((VSwitchImpl)element).isDeletedFromDatabaseOnly();
        if (vSwitchCount == 0) {
            ((LogicObjectImpl)element).unregisterToPropagatedStateChange();
            this.removePropagationStateDependentObjectAndListener((LogicObjectImpl)element);
            if (classId.equals(ClassID.ACL_ENTRY)) {
                AclEntry entry2 = (AclEntry)element;
                Acl acl = entry2.getAclParent();
                ((AclImpl)acl).removeAclEntry(entry2);
            }
            if (!vSwitchDeletedFromDB && this.isDiscoverCompleted() && !classId.isDRClassId()) {
                EventServiceImpl.getInstance().fireElementRemove(elementEvent);
            }
        } else if (classId.isDRGroup()) {
            try {
                this.drManager.rematchEmptyGroupWithNoPairs((DRClusterAbstractConsistencyGroupImpl)element);
            }
            catch (IllegalValueException ive) {
                logger.error(ive);
            }
        }
        StringBuffer debugMsg = new StringBuffer(classId.toString());
        debugMsg.append(" ");
        debugMsg.append(element);
        debugMsg.append(" was removed");
        if (!classId.equals(ClassID.VSWITCH)) {
            debugMsg.append(" from " + ClassID.VSWITCH + " ");
            debugMsg.append(vSwitchIp);
        }
        logger.info(debugMsg.toString());
        if (removedCommKey != null) {
            this.getCommKeyRefMap().removeCommKeyClassIdAndRef(removedCommKey, classId);
            if (classId.equals(ClassID.VSWITCH)) {
                if (!vSwitchDeletedFromDB) {
                    Vector allRefs = this.getCommKeyRefMap().getAllRefs();
                    Enumeration e = allRefs.elements();
                    while (e.hasMoreElements()) {
                        LogicObjectImpl elementRef = (LogicObjectImpl)e.nextElement();
                        if (!elementRef.isKnownByVSwitch(vSwitch)) continue;
                        if (elementRef.getConnectedVSwitchCounter() == 1) {
                            this.removeElement(elementRef, null, vSwitch.getMgmIPAddr());
                        }
                        elementRef.removeFromVSwitch(vSwitch);
                    }
                } else {
                    this.clearPolicies();
                    this.getCommKeyRefMap().clear();
                }
            }
        }
        if (element.getClassId().equals(ClassID.LUN) && element.getConnectedVSwitchCounter() == 0 && (lu = (LUImpl)element).getLUN() != 0 && (lu0 = (LUImpl)((TargetImpl)lu.getParentTarget()).getLU(0)) != null && lu0.isDeletionPending()) {
            try {
                lu0.deleteElement();
            }
            catch (IllegalValueException ive) {
                logger.warning("When trying to re-delete lu0 of target " + lu.getParentTarget() + " " + ive.getMessage());
            }
        }
        if (classId.equals(ClassID.ACL_ENTRY) && (identityParent = (IdentityImpl)(entry = (AclEntryImpl)element).getIdentity()).isDeletionPending()) {
            try {
                identityParent.deleteElement();
            }
            catch (IllegalValueException ive) {
                logger.warning("When trying to re-delete identity " + identityParent.getAlias() + " " + ive.getMessage());
            }
        }
    }

    public void removeElement(ConfigElementData ced) {
        throw new UnsupportedOperationException();
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        this.toStringValue = this.getAlias();
        return changedValues;
    }

    private void setVSwitcNameIfDisconnected() throws RemoteException {
        Enumeration e = this.m_vSwitches.elements();
        while (e.hasMoreElements()) {
            Vector neighbors;
            VSwitch neighbor;
            VSwitch vSwitch = (VSwitch)e.nextElement();
            if (vSwitch.isConnected() || (neighbor = this.getMyNeighbor(vSwitch.getMgmIPAddr())) == null || (neighbors = neighbor.getNeighborTable()) == null || neighbors.isEmpty()) continue;
            String name = ((Neighbor)neighbors.firstElement()).getName();
            HashMap<ParameterCode, SrString> parameterList = new HashMap<ParameterCode, SrString>(1);
            parameterList.put(ParameterCode.VSWITCH_NAME, new SrString(name));
            try {
                ((VSwitchImpl)vSwitch).setParameterList(parameterList);
                if (!this.isDiscoverCompleted()) continue;
                ElementEventImpl elementEvent = new ElementEventImpl(vSwitch, vSwitch);
                elementEvent.setVSwitchIp(vSwitch.getMgmIPAddr());
                elementEvent.setParameterList(parameterList);
                EventServiceImpl.getInstance().fireElementChanged(elementEvent);
            }
            catch (IllegalValueException ive) {
                logger.warning(ive.getMessage());
            }
        }
    }

    private void generateAlarms(int eventType, GeneralLogicObjectImpl source, VSwitch vSwitch) throws RemoteException {
        if (source instanceof DRLogicObjectImpl) {
            this.drAlarmMgr.generateAlarms(null, eventType, source, vSwitch);
        } else {
            this.alarmMgr.generateAlarms(this, eventType, source, vSwitch);
        }
    }

    private void discoverCompleted() throws RemoteException {
        if (this.isDiscoverCompleted()) {
            VSwitchImpl vSwitch;
            if (this.m_vSwitches.size() == 1 && !(vSwitch = (VSwitchImpl)this.m_vSwitches.firstElement()).getNeighborTable().isEmpty() && vSwitch.isNeighborValid()) {
                return;
            }
            for (int i = 0; i < this.m_vSwitches.size(); ++i) {
                VSwitchImpl vSwitch2 = (VSwitchImpl)this.m_vSwitches.get(i);
                vSwitch2.changeRemotetargetPortalsIfNeeded();
            }
            this.setVSwitcNameIfDisconnected();
            this.setPendingNewElements();
            this.alarmMgr.generateAlarms(this);
            this.alarmMgr.clearPendingAlarms(this);
            try {
                ElementEventImpl elementEvent = new ElementEventImpl(this, this);
                EventServiceImpl.getInstance().fireDiscoverCompleted(elementEvent);
                logger.info(ClassID.VSWITCH + " & Virtualization discovery is completed for Cluster " + this.getAlias());
                SystemRootImpl.getInstance().notifyClusterDiscoveryCompleted(this);
                try {
                    this.drManager.removeEmptyGroupsWithNoPairs();
                }
                catch (IllegalValueException e) {
                    logger.error(e);
                }
                this.invokeDREventAndWait(this, 5);
            }
            catch (RemoteException re) {
                logger.error(re.getMessage() + " in " + this.getClass() + "::discoverCompleted()", re);
            }
            CommKeyClassId[] vSwitchList = new CommKeyClassId[this.m_vSwitches.size()];
            for (int i = 0; i < this.m_vSwitches.size(); ++i) {
                vSwitchList[i] = ((VSwitchImpl)this.m_vSwitches.elementAt(i)).getCommKeyClassId();
            }
            DataMgr.getInstance().startPollingProcess(vSwitchList);
        }
    }

    public void virtualizationDiscoverCompleted(VSwitchImpl vSwitch) {
        try {
            if (!vSwitch.isVirtualizationDiscoverCompleted()) {
                logger.debug("Virtualization discover completed - managed " + ClassID.VSWITCH + " ip is: " + vSwitch.getMgmIPAddr());
                vSwitch.setVirtualizationDiscoverCompleted(true);
                this.discoverCompleted();
            }
        }
        catch (RemoteException re) {
            logger.error(re);
        }
    }

    public void discover() {
        SystemRootImpl.setStatusInProcess("Discovering cluster " + this + "...");
        logger.info("Start Cluster " + this + " discovery");
        this.setClusterDiscoveryCompleted(false);
        DataMgr.getInstance().clusterDiscovery();
    }

    public boolean isDRInvolved() {
        return this.drManager.isDRExist();
    }

    private boolean isClusterDiscoveryCompleted() {
        return this.clusterDiscoveryCompleted;
    }

    private void setClusterDiscoveryCompleted(boolean state) {
        this.clusterDiscoveryCompleted = state;
    }

    public void manualDiscover() throws RemoteException {
        Enumeration e = this.m_vSwitches.elements();
        while (e.hasMoreElements()) {
            VSwitch vSwitch = (VSwitch)e.nextElement();
            if (!vSwitch.isConnected()) continue;
            vSwitch.manualDiscover();
        }
    }

    public void reset() throws RemoteException {
        logger.info("Start reset Cluster");
        Enumeration e = this.m_vSwitches.elements();
        while (e.hasMoreElements()) {
            VSwitch vSwitch = (VSwitch)e.nextElement();
            vSwitch.reset();
        }
    }

    public void rediscover() throws RemoteException {
        VSwitchImpl vSwitch;
        logger.info("Start " + ClassID.VSWITCH + " & Virtualization discovery...");
        SystemRootImpl.setStatusInProcess("Discovering " + ClassID.VSWITCH + " & Virtualization...");
        this.synchronizeClusterParametersDone = false;
        this.invokeDREventAndWait(this, 21);
        this.stopQueueConsumerThread();
        ElementEventImpl elementEvent = new ElementEventImpl(this, this);
        EventServiceImpl.getInstance().fireStartDiscovering(elementEvent);
        this.setStateSeverity(AlarmSeverity.OK);
        this.clearPropagationStateDependentObject();
        Enumeration e = this.m_vSwitches.elements();
        while (e.hasMoreElements()) {
            ((VSwitchImpl)e.nextElement()).clearPropagatedStateOf();
        }
        this.addPropagationStateDependentObject(this.m_vSwitches);
        this.clearPropagatedStateOf();
        this.drManager.discoveryStarted();
        this.clearPolicies();
        this.drAlarmMgr.takePendingAlarmList(null);
        this.alarmMgr.takePendingAlarmList(this);
        this.identities.removeAll();
        this.radiusServerList.clear();
        this.isnsServerList.clear();
        this.getCommKeyRefMap().clear();
        ((PolicyManagerImpl)this.getPolicyManager()).clear();
        this.storage.clear();
        this.copyOperMgr.clear();
        this.pendingNewElements.clear();
        this.m_scsiDeviceIscsiNodeMap.clearAllEntries();
        e = this.m_vSwitches.elements();
        while (e.hasMoreElements()) {
            vSwitch = (VSwitchImpl)e.nextElement();
            vSwitch.setVSwitchDiscoverCompleted(false);
            vSwitch.setVirtualizationDiscoverCompleted(false);
        }
        if (this.m_vSwitches.isEmpty()) {
            this.discoverCompleted();
        } else {
            e = this.m_vSwitches.elements();
            while (e.hasMoreElements()) {
                vSwitch = (VSwitchImpl)e.nextElement();
                vSwitch.rediscover();
            }
        }
        this.startQueueConsumerThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopQueueConsumerThread() {
        Object object = this.m_queueConsumerThreadSyncLock;
        synchronized (object) {
            Thread thisThread = Thread.currentThread();
            boolean isThisThreadQueueConsumerThread = this.queueConsumerThread == Thread.currentThread();
            try {
                if (!isThisThreadQueueConsumerThread) {
                    if (!this.m_isStopThreadAlreadyAsked) {
                        this.m_isStopThreadAlreadyAsked = true;
                        SrKillClusterThreadEvent killEvent = new SrKillClusterThreadEvent(this);
                        this.elementEvent(killEvent, true);
                    }
                    this.m_queueConsumerThreadSyncLock.wait();
                } else {
                    this.eventQueue.clear();
                    this.queueConsumerThread.stopThread();
                }
            }
            catch (InterruptedException e) {
                logger.debug(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyQueueConsumerThreadFinished() {
        Object object = this.m_queueConsumerThreadSyncLock;
        synchronized (object) {
            this.m_isStopThreadAlreadyAsked = false;
            this.m_queueConsumerThreadSyncLock.notifyAll();
        }
    }

    public Cluster getCluster() throws RemoteException {
        return this;
    }

    public void notifyClusterDBReadingCompleted() throws RemoteException {
        this.setClusterDiscoveryCompleted(true);
        if (this.m_vSwitches.isEmpty()) {
            logger.info("Cluster " + this + " discovery is completed - no " + ClassID.VSWITCH + " was found");
            SystemRootImpl.getInstance().notifyClusterDiscoveryCompleted(this);
            this.invokeDREventAndWait(this, 5);
        } else {
            logger.info("Cluster " + this + " discovery is completed");
            this.rediscover();
        }
    }

    private boolean isVSwitchesDiscoverCompleted() {
        Enumeration e = this.m_vSwitches.elements();
        while (e.hasMoreElements()) {
            VSwitchImpl vSwitch = (VSwitchImpl)e.nextElement();
            if (vSwitch.isVSwitchDiscoverCompleted()) continue;
            return false;
        }
        return true;
    }

    private void setManager(VSwitchImpl vSwitch) throws RemoteException {
        vSwitch.addManagerIfNoManagerIsDefinedYet();
    }

    public void setClusterNeighbors() throws RemoteException {
        if (this.isVSwitchesDiscoverCompleted()) {
            Enumeration e = this.m_vSwitches.elements();
            while (e.hasMoreElements()) {
                this.setNeighbors((VSwitchImpl)e.nextElement());
            }
        }
    }

    private void setNeighbors(VSwitchImpl vSwitch) throws RemoteException {
        if (vSwitch.isVSwitchDiscoverCompleted() && vSwitch.getNeighborTable().isEmpty()) {
            VSwitch neighbor = null;
            Enumeration v = this.m_vSwitches.elements();
            while (v.hasMoreElements() && (neighbor = (VSwitch)v.nextElement()).equals(vSwitch)) {
            }
            if (neighbor != null && !neighbor.equals(vSwitch)) {
                try {
                    vSwitch.addNeighbor(neighbor);
                }
                catch (IllegalValueException ive) {
                    logger.warning(ive.getMessage());
                }
            }
        }
    }

    public void vSwitchDiscoverCompleted(VSwitchImpl vSwitch) {
        try {
            if (!vSwitch.isVSwitchDiscoverCompleted()) {
                logger.debug(ClassID.VSWITCH + " discover completed - managed " + ClassID.VSWITCH + " ip is: " + vSwitch.getMgmIPAddr());
                vSwitch.setVSwitchDiscoverCompleted(true);
                this.setClusterNeighbors();
                this.setManager(vSwitch);
                this.discoverCompleted();
            }
        }
        catch (RemoteException re) {
            logger.debug(re);
        }
    }

    public void deleteElement() throws RemoteException, IllegalValueException {
        if (this.canBeDeleted() == null) {
            Vector vSwitches = new Vector(this.getVSwitches());
            Enumeration e = vSwitches.elements();
            while (e.hasMoreElements()) {
                VSwitchImpl vSwitch = (VSwitchImpl)e.nextElement();
                vSwitch.deleteFromDatabase();
            }
        }
        super.deleteElement();
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        CommKeyClassId parentSiteCommKeyClassId;
        String alias = (String)parameterList.get(ClientParameterCode.CLUSTER_ALIAS);
        if (alias != null) {
            if (alias.equals("")) {
                alias = "$cl$" + System.currentTimeMillis();
            }
            parameterList.put(ClientParameterCode.CLUSTER_ALIAS, new SrString(alias));
        }
        if ((parentSiteCommKeyClassId = (CommKeyClassId)parameterList.get(ClientParameterCode.PARENT_SITE)) != null) {
            SiteImpl dst = (SiteImpl)SystemRootImpl.getInstance().getRefByStub(parentSiteCommKeyClassId);
            if (dst.equals(this.getParentSite())) {
                return "You are trying to move " + ClassID.CLUSTER + " " + this + " to its parent site " + dst;
            }
            if (this.isInvolvedInDR()) {
                return ClassID.CLUSTER + " " + this + " involved in DR process. You cannot move it until you abort the DR process";
            }
        }
        return null;
    }

    private boolean isInvolvedInDR() {
        return false;
    }

    private void handleErrorEvent(ErrorEvent event) {
        switch (event.getErrorType()) {
            case 2: {
                this.handleSnmpError((SnmpErrorEvent)event);
                break;
            }
            case 1: {
                this.handleSnmpTimeoutError((SnmpErrorEvent)event);
                break;
            }
            case 3: {
                this.handleConfigurationError(event);
                break;
            }
            case 4: {
                this.handleFatalConfigurationError(event);
            }
        }
    }

    private void handleFatalConfigurationError(ErrorEvent e) {
        try {
            CommKeyClassId source = (CommKeyClassId)e.getSource();
            VSwitchImpl vSwitch = (VSwitchImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(source);
            logger.fatal("Snmp Configuration Error: " + e.getMessage());
            ElementEventImpl elementEvent = new ElementEventImpl(this, this);
            elementEvent.setErrorMesaage(e.getMessage());
            elementEvent.setVSwitchIp(vSwitch.getMgmIPAddr());
            EventServiceImpl.getInstance().fireFatalConfigurationError(elementEvent);
        }
        catch (RemoteException re) {
            logger.error(re.getMessage() + " in " + this.getClass() + "::fatalConfigurationError()", re);
        }
    }

    private void handleConfigurationError(ErrorEvent e) {
        try {
            CommKeyClassId source = (CommKeyClassId)e.getSource();
            VSwitchImpl vSwitch = (VSwitchImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(source);
            String ip = vSwitch.getMgmIPAddr();
            logger.error("Snmp Configuration Error on " + ClassID.VSWITCH + " " + ip + " " + e.getMessage());
            ElementEventImpl elementEvent = new ElementEventImpl(vSwitch, vSwitch);
            elementEvent.setErrorMesaage(e.getMessage());
            elementEvent.setVSwitchIp(ip);
            EventServiceImpl.getInstance().fireConfigurationError(elementEvent);
        }
        catch (RemoteException re) {
            logger.error(re.getMessage() + " in " + this.getClass() + "::configurationError()", re);
        }
    }

    private void handleSnmpError(SnmpErrorEvent e) {
        try {
            CommKeyClassId source = e.getVSwitchData();
            VSwitchImpl vSwitch = (VSwitchImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(source);
            String ip = vSwitch.getMgmIPAddr();
            logger.error("SNMP error on " + ClassID.VSWITCH + " " + ip + " " + e.getMessage());
        }
        catch (RemoteException re) {
            logger.error(re.getMessage() + " in " + this.getClass() + "::newSnmpError()", re);
        }
    }

    private void handleSnmpTimeoutError(SnmpErrorEvent e) {
        try {
            CommKeyClassId source = e.getVSwitchData();
            if (source == null) {
                return;
            }
            VSwitchImpl vSwitch = (VSwitchImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(source);
            String ip = vSwitch.getMgmIPAddr();
            vSwitch.setConnected(false);
            if (!this.isDiscoverCompleted()) {
                this.vSwitchDiscoverCompleted(vSwitch);
                this.virtualizationDiscoverCompleted(vSwitch);
            }
            if (!vSwitch.isInResetProcess()) {
                logger.error("Snmp timeout: " + ip);
            } else {
                logger.debug("Snmp timeout: " + ClassID.VSWITCH + " " + ip + " in reset process...");
            }
            this.handleSyncConfigurationError(e.getEventElement());
        }
        catch (RemoteException re) {
            logger.fatal(re.getMessage() + " in " + this.getClass() + "::newSnmpError()", re);
        }
    }

    public void deleteObjects(CommKey[] commKeys, ClassID classId) throws RemoteException, IllegalValueException {
        LogicObjectImpl logicObject = (LogicObjectImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(commKeys, classId);
        logicObject.deleteElement();
    }

    public void deleteObjects(CommKeyClassId[] commKeyClassId) throws RemoteException, IllegalValueException {
        CommKey[][] commKeys = new CommKey[commKeyClassId.length][];
        ClassID[] classId = new ClassID[commKeyClassId.length];
        for (int i = 0; i < commKeyClassId.length; ++i) {
            commKeys[i] = commKeyClassId[i].getCommKeys();
            classId[i] = commKeyClassId[i].getClassID();
        }
        StringBuffer errMsg = new StringBuffer("Deletion error:\n");
        boolean errOccured = false;
        for (int i = 0; i < classId.length; ++i) {
            LogicObjectImpl source;
            if (classId[i].equals(ClassID.CLUSTER)) {
                source = this;
            } else {
                source = (LogicObjectImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(commKeys[i], classId[i]);
                if (classId[i].equals(ClassID.IDENTITY) && ((PolicyManagerImpl)this.getPolicyManager()).isConnectedToTarget((Identity)((Object)source))) {
                    source.setDeletionPending();
                    ((PolicyManagerImpl)this.getPolicyManager()).deleteCorrespondingAclEntries((Identity)((Object)source));
                    continue;
                }
            }
            try {
                if (source != null) {
                    source.deleteElement();
                    continue;
                }
                errMsg.append("source is null.");
                errOccured = true;
                continue;
            }
            catch (IllegalValueException ive) {
                logger.warning(ive.getMessage());
                errMsg.append(ive.getMessage());
                errMsg.append(".\n");
                errOccured = true;
            }
        }
        if (errOccured) {
            throw new IllegalValueException(errMsg.toString());
        }
    }

    public void createElement(ConfigElementData element, ClassID classId, String details, Vector vSwitches) throws RemoteException {
        this.createElement(element, "Trying to create " + classId + " " + details, vSwitches);
    }

    public void createElement(ConfigElementData element, ClassID classId, String details) throws RemoteException {
        this.createElement(element, classId, details, this.getVSwitches());
    }

    public void createElement(ConfigElementDataList elementList, String details, Vector vSwitches) throws RemoteException {
        for (int i = 0; i < elementList.size(); ++i) {
            this.prepareVSwitchIDs(elementList.getConfigElementDataAt(i), details, vSwitches);
        }
        DataMgr.getInstance().createElement(elementList);
    }

    public int getVSwitchesCount() {
        return this.m_vSwitches.size();
    }

    public void createElement(ConfigElementData element, String details, Vector vSwitches) throws RemoteException {
        if (this.getConnectedVSwitchCounter() > 0 || element.getClassId().equals(ClassID.VSWITCH)) {
            this.prepareVSwitchIDs(element, details, vSwitches);
            DataMgr.getInstance().createElement(element);
        } else {
            this.handleSyncConfigurationError(element);
        }
    }

    public void prepareVSwitchIDs(ConfigElementData element, String details, Vector vSwitches) throws RemoteException {
        CommKeyClassId[] vSwitchestoSet = (CommKeyClassId[])element.getValue(ParameterCode.VSWITCH_ID);
        if (vSwitchestoSet == null || vSwitchestoSet.length == 0) {
            if (vSwitches == null) {
                vSwitches = new Vector<VSwitch>();
                Enumeration e = this.getVSwitches().elements();
                while (e.hasMoreElements()) {
                    VSwitch vSwitch = (VSwitch)e.nextElement();
                    if (!vSwitch.isConnected()) continue;
                    vSwitches.addElement(vSwitch);
                }
            }
            CommKeyClassId[] vSwitchCommKeyClassId = new CommKeyClassId[vSwitches.size()];
            int i = 0;
            Enumeration e = vSwitches.elements();
            while (e.hasMoreElements()) {
                VSwitch vSwitch = (VSwitch)e.nextElement();
                logger.debug(ClassID.VSWITCH + " " + vSwitch.getMgmIPAddr() + " - " + details);
                vSwitchCommKeyClassId[i++] = new CommKeyClassId(vSwitch.getCommKeys(), vSwitch.getClassId());
            }
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchCommKeyClassId));
        }
    }

    public void executeOperations(ElementOperationList operationsList, Vector vSwitchesToExcute) throws RemoteException {
        VSwitch vSwitch;
        Enumeration e;
        if (vSwitchesToExcute == null) {
            vSwitchesToExcute = new Vector<VSwitch>();
            e = this.getVSwitches().elements();
            while (e.hasMoreElements()) {
                vSwitch = (VSwitch)e.nextElement();
                if (!vSwitch.isConnected()) continue;
                vSwitchesToExcute.addElement(vSwitch);
            }
        } else {
            e = vSwitchesToExcute.elements();
            while (e.hasMoreElements()) {
                vSwitch = (VSwitch)e.nextElement();
                if (vSwitch.isConnected()) continue;
                vSwitchesToExcute.removeElement(vSwitch);
            }
        }
        if (!vSwitchesToExcute.isEmpty()) {
            e = operationsList.elements();
            while (e.hasMoreElements()) {
                ElementOperation operation = (ElementOperation)e.nextElement();
                HashMap parameterList = operation.getElement().getParametersList();
                Iterator iter = parameterList.keySet().iterator();
                while (iter.hasNext()) {
                    Object value = parameterList.get(iter.next());
                    if (!(value instanceof CommKeyClassId)) continue;
                    LogicObjectImpl element = (LogicObjectImpl)this.getCommKeyRefMap().getRefByCommKeyClassID((CommKeyClassId)value);
                    for (int j = 0; j < vSwitchesToExcute.size(); ++j) {
                        VSwitch vs = (VSwitch)vSwitchesToExcute.elementAt(j);
                        if (element.isKnownByVSwitch(vs)) continue;
                        vSwitchesToExcute.removeElement(vs);
                    }
                }
                CommKeyClassId[] vSwitchCommKeyClassId = new CommKeyClassId[vSwitchesToExcute.size()];
                int i = 0;
                Iterator iter2 = vSwitchesToExcute.iterator();
                while (iter2.hasNext()) {
                    VSwitch vSwitch2 = (VSwitch)iter2.next();
                    vSwitchCommKeyClassId[i++] = new CommKeyClassId(vSwitch2.getCommKeys(), vSwitch2.getClassId());
                }
                operation.getElement().addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchCommKeyClassId));
            }
            if (!operationsList.isEmpty()) {
                DataMgr.getInstance().executeOperations(operationsList);
            }
        }
    }

    public boolean isEmpty() throws RemoteException {
        return this.getVSwitchesCount() == 0;
    }

    public boolean isRedundant() throws RemoteException {
        return this.isEmpty() || this.isSingleVSwitchMode() || this.getVSwitchesCount() == 2;
    }

    public String[] getVSwitchesNamesAndIPs() throws RemoteException {
        String[] names = new String[this.getVSwitchesCount()];
        for (int i = 0; i < names.length; ++i) {
            VSwitch vSwitch = (VSwitch)this.getVSwitches().elementAt(i);
            names[i] = vSwitch.getName() + " (ip " + vSwitch.getMgmIPAddr() + ")";
        }
        return names;
    }

    public boolean areVSwitchesNeighbors() throws RemoteException {
        if (this.isEmpty() || this.isSingleVSwitchMode()) {
            return true;
        }
        if (this.isRedundant()) {
            VSwitchImpl secondVSwitch;
            VSwitchImpl firstVSwitch = (VSwitchImpl)this.m_vSwitches.elementAt(0);
            return firstVSwitch.isNeighborOf(secondVSwitch = (VSwitchImpl)this.m_vSwitches.elementAt(1)) && secondVSwitch.isNeighborOf(firstVSwitch);
        }
        return true;
    }

    public void createElement(ConfigElementData element, String details) throws RemoteException, IllegalValueException {
        this.createElement(element, details, this.getVSwitches());
    }

    public void clear() throws RemoteException {
        this.clearPolicies();
        SrEventHandler.getEventMgr().removeListener(this.drAlarmMgr);
        this.drAlarmMgr.clearPendingAlarms(null);
        this.radiusServerList.clear();
        this.isnsServerList.clear();
        ((PolicyManagerImpl)this.getPolicyManager()).clear();
        this.storage.clear();
        this.copyOperMgr.clear();
        this.pendingNewElements.clear();
        this.m_scsiDeviceIscsiNodeMap.clearAllEntries();
        this.identities.removeAll();
        Vector vswitches = this.getVSwitches();
        for (int i = 0; i < vswitches.size(); ++i) {
            ((VSwitchImpl)vswitches.get(i)).clear();
        }
    }

    public HashMap getClientParameterList() throws RemoteException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.CLUSTER_FAULTY_INTERVAL, this.getFaultyInterval());
        parameterList.put(ClientParameterCode.CLUSTER_KEEP_ALIVE, this.getKeepAlive());
        parameterList.put(ClientParameterCode.CLUSTER_SUSPICIOUS_INTERVAL, this.getSuspiciousInterval());
        parameterList.put(ClientParameterCode.CLUSTER_FAILOVER_ENABLE, this.isFailoverEnable());
        parameterList.put(ClientParameterCode.CLUSTER_TAKEOVER_STATE, this.getTakeoverState());
        return parameterList;
    }

    public BigInteger getAccessibleSpace() throws RemoteException {
        return this.getTargetListMgr().getAccessibleSpace();
    }

    public BigInteger getTotalCapacity() throws RemoteException {
        return this.getStoragePool().getTotalCapacity();
    }

    public Integer getKeepAlive() throws RemoteException {
        VSwitchImpl vSwitch = (VSwitchImpl)this.getAnyConnectedVSwitch();
        if (vSwitch != null) {
            return vSwitch.getKeepAliveInterval();
        }
        return null;
    }

    public Integer getSuspiciousInterval() throws RemoteException {
        VSwitchImpl vSwitch = (VSwitchImpl)this.getAnyConnectedVSwitch();
        if (vSwitch != null) {
            return vSwitch.getSuspiciousInterval();
        }
        return null;
    }

    public Integer getFaultyInterval() throws RemoteException {
        VSwitchImpl vSwitch = (VSwitchImpl)this.getAnyConnectedVSwitch();
        if (vSwitch != null) {
            return vSwitch.getFaultyInterval();
        }
        return null;
    }

    public Boolean isFailoverEnable() throws RemoteException {
        VSwitchImpl vSwitch = (VSwitchImpl)this.getAnyConnectedVSwitch();
        if (vSwitch != null) {
            return vSwitch.isFailoverEnable();
        }
        return null;
    }

    public SDTakeOverStateConstant getTakeoverState() throws RemoteException {
        VSwitchImpl vSwitch = (VSwitchImpl)this.getAnyConnectedVSwitch();
        if (vSwitch != null) {
            return vSwitch.getTakeOverState();
        }
        return null;
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public String getAlias() throws RemoteException {
        return (String)this.getValueOf(null, ParameterCode.CLUSTER_ALIAS);
    }

    public boolean isStorageComparison3() throws RemoteException {
        Integer storageComparison = (Integer)this.getValueOf(null, ParameterCode.CLUSTER_STORAGE_COMPARISON);
        if (storageComparison != null) {
            return storageComparison == 3;
        }
        return false;
    }

    public boolean isSingleVSwitchMode() throws RemoteException {
        Boolean mode = (Boolean)this.getValueOf(null, ParameterCode.CLUSTER_MODE);
        return mode;
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        int retVal = 0;
        this.radiusServerList.synchronize();
        this.isnsServerList.synchronize();
        int tmpRetVal = this.storage.synchronize();
        if (tmpRetVal > retVal) {
            retVal = tmpRetVal;
        }
        this.identities.synchronize();
        tmpRetVal = this.policyMgr.synchronize();
        if (tmpRetVal > retVal) {
            retVal = tmpRetVal;
        }
        return retVal;
    }

    public AlarmGenerator getAlarmGenerator() {
        return ClusterAlarmGenerator.getInstance();
    }

    public PolicyManager getPolicyManager() throws RemoteException {
        return this.policyMgr;
    }

    public CopyOperationManager getCopyOperManager() throws RemoteException {
        return this.copyOperMgr;
    }

    private void changeSingleVSwitchMode(boolean mode) throws RemoteException, IllegalValueException {
        this.changeElement(ClientParameterCode.CLUSTER_SINGLE_VSWITCH_MODE, new SrBoolean(mode));
    }

    public boolean isVSwitchManaged(String ip) throws RemoteException {
        Enumeration e = this.getVSwitches().elements();
        while (e.hasMoreElements()) {
            VSwitch vSwitch = (VSwitch)e.nextElement();
            if (!vSwitch.getMgmIPAddr().equals(ip)) continue;
            return true;
        }
        return false;
    }

    public void checkAndSetVSwitchSwitchIDConsistency(VSwitch invoker) throws RemoteException {
        if (this.getVSwitchesCount() > 1) {
            VSwitch other = this.getOtherVSwitch(invoker);
            Integer otherSwitchId = other.getSwitchID();
            Integer invokerSwitchId = invoker.getSwitchID();
            Integer invokerSwitchIdNewValue = null;
            Integer otherSwitchIdNewValue = null;
            if (otherSwitchId != null) {
                if (invokerSwitchId == -1) {
                    invokerSwitchIdNewValue = otherSwitchId == -1 ? new Integer(0) : this.getComplementarySwitchId(otherSwitchId);
                } else if (otherSwitchId == -1 || otherSwitchId.compareTo(invokerSwitchId) == 0) {
                    otherSwitchIdNewValue = this.getComplementarySwitchId(invokerSwitchId);
                }
            }
            try {
                if (invokerSwitchIdNewValue != null) {
                    invoker.changeElement(ClientParameterCode.VSWITCH_SWITCH_ID, invokerSwitchIdNewValue);
                }
                if (otherSwitchIdNewValue != null) {
                    other.changeElement(ClientParameterCode.VSWITCH_SWITCH_ID, otherSwitchIdNewValue);
                }
            }
            catch (IllegalValueException ive) {
                logger.warning(ive);
            }
        }
    }

    private Integer getComplementarySwitchId(Integer switchId) {
        return new Integer((switchId + 1) % 2);
    }

    private void handleSyncConfigurationError(LogicObjectImpl logicObject) throws RemoteException {
        SynchronizeableImpl syncElem;
        if (logicObject instanceof SynchronizeableImpl && (syncElem = (SynchronizeableImpl)logicObject).isSynchronizePending()) {
            syncElem.errorInSynchronizing();
        }
    }

    private void handleSyncConfigurationError(ConfigElementData element) throws RemoteException {
        CommKeyClassId operationInvoker;
        if (element != null && (operationInvoker = element.getOperationInvoker()) != null) {
            LogicObjectImpl logicObject = (LogicObjectImpl)SystemRootImpl.getInstance().getRefByStub(operationInvoker);
            this.handleSyncConfigurationError(logicObject);
        }
    }

    private StringBuffer getMsgForElement(ConfigElementData ced, VSwitch vSwitch) throws RemoteException {
        ClassID classId = ced.getClassId();
        HashMap parameterList = ced.getParametersList();
        StringBuffer msg = new StringBuffer(classId.toString());
        msg.append(" ");
        if (classId.equals(ClassID.CONCAT_VOLUME) || classId.equals(ClassID.CUBE_VOLUME) || classId.equals(ClassID.TRANSPARENT_VOLUME) || classId.equals(ClassID.MIRROR_VOLUME) || classId.equals(ClassID.STRIPE_VOLUME)) {
            VolumeNodeImpl vol;
            Object alias = parameterList.get(ParameterCode.VOLUME_ALIAS);
            if (alias == null && (vol = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(ced.getCommKey(), ced.getClassId())) != null) {
                alias = vol.getAlias();
            }
            msg.append(alias);
        } else if (classId.equals(ClassID.DIRECT_ACCESS_DEVICE)) {
            msg.append(parameterList.get(ParameterCode.PHYSICAL_STORAGE_ALIAS));
        } else if (classId.equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            msg.append(parameterList.get(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS));
        } else if (classId.equals(ClassID.ISCSI_TARGET)) {
            msg.append(parameterList.get(ParameterCode.ISCSI_TARGET_ALIAS));
        } else if (classId.equals(ClassID.LUN)) {
            msg.append(parameterList.get(ParameterCode.LU_LUN_NUMBER));
        } else if (classId.equals(ClassID.SCSI_LUN)) {
            msg.append(parameterList.get(ParameterCode.SCSI_LUN_LU_NUMBER));
        } else if (classId.equals(ClassID.VSWITCH)) {
            msg.append(parameterList.get(ParameterCode.VSWITCH_IP_ADDRESS));
        } else if (classId.equals(ClassID.NETWORK_CONFIGURATION)) {
            msg.append(parameterList.get(ParameterCode.NETWORK_CONFIG_IP_ADDRESS));
        } else if (classId.equals(ClassID.INTERFACE) || classId.equals(ClassID.FC_INTERFACE) || classId.equals(ClassID.PSCSI_INTERFACE) || classId.equals(ClassID.ETHERNET_INTERFACE)) {
            msg.append(parameterList.get(ParameterCode.IF_ALIAS));
        } else if (classId.equals(ClassID.PORTAL)) {
            msg.append(parameterList.get(ParameterCode.ISCSI_PORTAL_IP_ADDRESS));
            msg.append(":");
            msg.append(parameterList.get(ParameterCode.ISCSI_PORTAL_PORT));
        } else if (classId.equals(ClassID.IP_ROUTE)) {
            msg.append(parameterList.get(ParameterCode.IP_ROUTE_DESTINATION_IP));
        } else if (classId.equals(ClassID.NEIGHBORE)) {
            msg.append(parameterList.get(ParameterCode.NEIGHBOR_IP_ADDRESS));
        } else if (classId.equals(ClassID.SNMP_MANAGER)) {
            msg.append(parameterList.get(ParameterCode.MANAGER_IP_ADDRESS));
        } else if (classId.equals(ClassID.IDENTITY)) {
            msg.append(parameterList.get(ParameterCode.IDENTITY_ALIAS));
        } else if (classId.equals(ClassID.IDENTITY_NAME)) {
            msg.append(parameterList.get(ParameterCode.IDENTITY_NAME_VALUE));
        } else if (classId.equals(ClassID.SRP_CREDENTIALS)) {
            msg.append(parameterList.get(ParameterCode.CREDENTIALS_AUTH_METHOD));
        } else if (classId.equals(ClassID.CHAP_CREDENTIALS)) {
            msg.append(parameterList.get(ParameterCode.CREDENTIALS_AUTH_METHOD));
        } else if (classId.equals(ClassID.ACL_ENTRY)) {
            msg.append(parameterList.get(ParameterCode.ACL_ENTRY_ACCESS));
            msg.append(":");
            msg.append(parameterList.get(ParameterCode.ACL_ENTRY_IDENTITY));
        } else if (classId.equals(ClassID.COPY_OPERATION)) {
            msg.append(parameterList.get(ParameterCode.COPY_OPERATION_TYPE));
        } else if (classId.equals(ClassID.RADIUS_SERVER)) {
            msg.append("Radius Server-");
            msg.append(parameterList.get(ParameterCode.RADIUS_SERVER_IP_ADDRESS));
        } else if (classId.equals(ClassID.ISNS_SERVER)) {
            msg.append("ISNS Server-");
            msg.append(parameterList.get(ParameterCode.ISNS_SERVER_IP_ADDRESS));
        } else if (classId.equals(ClassID.SNAPSHOT_VOLUME)) {
            msg.append(parameterList.get(ParameterCode.VOLUME_ALIAS));
        } else {
            logger.warning("Undefined " + classId + " in getMsgForElement()");
            msg.append(classId);
        }
        msg.append(" on " + ClassID.VSWITCH + " ");
        msg.append(vSwitch);
        return msg;
    }

    public VSwitch getAnyConnectedVSwitch() throws RemoteException {
        Enumeration e = this.getVSwitches().elements();
        while (e.hasMoreElements()) {
            VSwitch vSwitch = (VSwitch)e.nextElement();
            if (!vSwitch.isConnected()) continue;
            return vSwitch;
        }
        return null;
    }

    public Identity getIdentityUsingRADIUS(RadiusServer radSrv) throws RemoteException {
        return this.identities.getIdentityUsingRADIUS(radSrv);
    }

    private void checkForElementsDeletion(SrCheckListEvent event) {
        try {
            CheckListConfigElementData checkListElement = event.getCheckListElement();
            CommKeyClassId vSwitchData = event.getVSwitchData();
            VSwitch vSwitch = (VSwitch)SystemRootImpl.getInstance().getRefByStub(vSwitchData);
            ClassID classId = checkListElement.getClassId();
            Vector elementsInMap = null;
            elementsInMap = checkListElement.isGeneralTableElementList() ? ((SiteImpl)this.getParentSite()).getListCommKeysSameTypeOf(classId, vSwitchData) : ((SiteImpl)this.getParentSite()).getListOfCommKeys(classId, vSwitchData);
            if (elementsInMap != null) {
                if (classId.equals(ClassID.ISCSI_REMOTE_TARGET)) {
                    Vector<CommKeyClassId> iscsiVec = new Vector<CommKeyClassId>();
                    Iterator iter = elementsInMap.iterator();
                    while (iter.hasNext()) {
                        CommKeyClassId scsi = (CommKeyClassId)iter.next();
                        CommKeyClassId iscsi = this.getISCSIId(scsi);
                        if (iscsi == null) continue;
                        iscsiVec.add(iscsi);
                    }
                    elementsInMap.clear();
                    elementsInMap.addAll(iscsiVec);
                }
                Vector elementsDataToRemove = DataMgr.getElementsToRemoveByCheckList(elementsInMap, checkListElement);
                CommKeyClassId elementData = null;
                for (int index = 0; index < elementsDataToRemove.size(); ++index) {
                    elementData = (CommKeyClassId)elementsDataToRemove.elementAt(index);
                    LogicObjectImpl elementToRemove = (LogicObjectImpl)SystemRootImpl.getInstance().getRefByStub(elementData);
                    if (elementToRemove == null) continue;
                    this.removeElement(elementToRemove, vSwitch);
                    this.generateAlarms(3, elementToRemove, vSwitch);
                }
            }
        }
        catch (RemoteException re) {
            logger.error(re);
        }
    }

    public SrInteger getIntervalValue(ParameterCode pollIntervalParam, VSwitch vSwitch) throws RemoteException {
        SrInteger interval = super.getIntervalValue(pollIntervalParam, vSwitch);
        if (interval == null) {
            interval = ((SiteImpl)this.getParentSite()).getIntervalValue(pollIntervalParam, vSwitch);
        }
        return interval;
    }

    public Vector getAllRemoteInitiators() {
        return null;
    }

    private void setPendingNewElements() {
        Iterator iter = this.pendingNewElements.keySet().iterator();
        while (iter.hasNext()) {
            CommKeyClassId key = (CommKeyClassId)iter.next();
            try {
                LogicObject element = this.newElement(key.getClassID(), key.getCommKeys(), (HashMap)this.pendingNewElements.get(key));
                if (element == null) {
                    logger.error("Failed to create " + key.getClassID() + " on second try");
                    continue;
                }
                logger.debug(key.getClassID() + " " + element + " was created on second try");
            }
            catch (RemoteException re) {
                logger.error(re);
            }
            catch (IllegalValueException ive) {
                logger.error(ive);
            }
        }
    }

    private void addSCSIiSCSIMap(VSwitchImpl vSwitch, SCSIDeviceImpl element) throws RemoteException {
        CommKeyClassId iscsiCommKeyClassId = CommKeyUtil.getSpecificCommKeyClassId(element.getCommKeyClassId(), vSwitch.getCommKeyClassId());
        CommKeyClassId scsiCommKeyClassId = element.getSCSIDeviceId(vSwitch);
        this.m_scsiDeviceIscsiNodeMap.addEntryToMap(scsiCommKeyClassId, iscsiCommKeyClassId);
    }

    public CommKeyClassId getISCSIId(CommKeyClassId scsiKey) throws RemoteException {
        return this.m_scsiDeviceIscsiNodeMap.getISCSIId(scsiKey);
    }

    public CommKeyClassId getSCSIId(CommKeyClassId iscsiKey) throws RemoteException {
        return this.m_scsiDeviceIscsiNodeMap.getSCSIId(iscsiKey);
    }

    public void moveToSite(CommKeyClassId destination) throws RemoteException, IllegalValueException {
        this.changeElement(ClientParameterCode.PARENT_SITE, destination);
    }

    public ArrayList getLocalInitiatorNames() throws RemoteException {
        Vector clusterVSwitches = this.getVSwitches();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int index1 = 0; index1 < clusterVSwitches.size(); ++index1) {
            VSwitch vswitch = (VSwitch)clusterVSwitches.elementAt(index1);
            ISCSIInitiator[] vswitchInitiators = vswitch.getISCSIInitiators();
            for (int index2 = 0; index2 < vswitchInitiators.length; ++index2) {
                ISCSIInitiator localInitiator = vswitchInitiators[index2];
                arrayList.add(localInitiator.getName());
            }
        }
        return arrayList;
    }

    public void updateTargetACLWithRemoteInitiatorNames(Target localTarget, ArrayList existedInitiatorNames, ArrayList addedRemoteInitiatorNames) throws RemoteException, IllegalValueException {
        TargetImpl localTargetImpl = (TargetImpl)localTarget;
        VSwitch[] targetConnectedVSwitches = localTarget.getConnectedVSwitchesList();
        Vector<VSwitch> vswitchesToUpdate = new Vector<VSwitch>(targetConnectedVSwitches.length);
        for (int index = 0; index < targetConnectedVSwitches.length; ++index) {
            vswitchesToUpdate.add(targetConnectedVSwitches[index]);
        }
        IdentityImpl knownIdentity = this.getIdentitiesList().getDRIdentityByRemoteInitiatorNames(existedInitiatorNames);
        if (knownIdentity == null) {
            String identityAliasPrefix = IdentityPurposeConstant.REMOTE_INITIATOR_DR.getDescriptionName();
            this.createIdentity(identityAliasPrefix, identityAliasPrefix, vswitchesToUpdate, IdentityPurposeConstant.REMOTE_INITIATOR_DR, existedInitiatorNames, localTarget);
        } else {
            AclImpl targetACL;
            IdentityImpl knownIdentityImpl = knownIdentity;
            if (!this.getIdentitiesList().isDrIdentityOnPendingCreateForInitiatorNames(existedInitiatorNames)) {
                knownIdentityImpl.createUnknownIdentityNames(existedInitiatorNames, vswitchesToUpdate);
            }
            if ((targetACL = (AclImpl)localTargetImpl.getAclForTarget()) != null && !targetACL.isTargetConnected(knownIdentityImpl)) {
                CommKeyClassId[] vsData = new CommKeyClassId[targetConnectedVSwitches.length];
                CommKeyClassId vswitchId = null;
                int i = targetConnectedVSwitches.length;
                while (i-- > 0) {
                    vswitchId = targetConnectedVSwitches[i].getCommKeyClassId();
                    if (!knownIdentityImpl.isKnownByVSwitch((VSwitch)this.getCommKeyRefMap().getRefByCommKeyClassID(vswitchId))) continue;
                    vsData[i] = vswitchId;
                }
                ConfigElementData identityElement = new ConfigElementData(knownIdentityImpl.getCommKeyClassId());
                identityElement.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vsData));
                DataMgr.getInstance().attachIdentityToTargetACL(identityElement, localTargetImpl.getCommKeyClassId());
            }
        }
    }

    public void removeInitiatorNamesFromTargetACL(Target localTarget, ArrayList remoteInitiatorNames) throws RemoteException, IllegalValueException {
        TargetImpl localTargetImpl = (TargetImpl)localTarget;
        Identity identity = localTargetImpl.getIdentityOfInitiatorNames(IdentityPurposeConstant.REMOTE_INITIATOR_DR, remoteInitiatorNames);
        ((IdentityImpl)identity).deleteNames(remoteInitiatorNames);
    }

    public void synchronizeForDRPurpose() throws RemoteException {
        ArrayList allTargetPortalsInCluster = this.getAllClusterTargetPortals();
        ArrayList clustersInOtherSites = SystemRootImpl.getInstance().getClustersInOtherSites(this.getParentSite());
        for (int index1 = 0; index1 < clustersInOtherSites.size(); ++index1) {
            Cluster remoteCluster = (Cluster)clustersInOtherSites.get(index1);
            for (int index2 = 0; index2 < allTargetPortalsInCluster.size(); ++index2) {
                PortalTableRowImpl portal = (PortalTableRowImpl)allTargetPortalsInCluster.get(index2);
                portal.synchronizeDiscoveryElementOnRemoteCluster(remoteCluster);
            }
        }
    }

    public ISCSIRemoteTarget findLocalTargetInRemoteCluster(Cluster remoteCluster, String targetName) throws RemoteException {
        boolean findForRemoteElement = false;
        ArrayList remoteTargets = this.findEquivalentTargetInRemoteCluster(remoteCluster, targetName, findForRemoteElement);
        if (remoteTargets.size() > 0) {
            return (ISCSIRemoteTarget)remoteTargets.get(0);
        }
        return null;
    }

    public ISCSITarget findEquivLocalTargetOfRemoteTargetInRemoteClusters(ArrayList clustersInOtherSites, String remoteTargetName) throws RemoteException {
        boolean findForRemoteElement = true;
        for (int index = 0; index < clustersInOtherSites.size(); ++index) {
            ClusterImpl remoteCluster = (ClusterImpl)clustersInOtherSites.get(index);
            ArrayList localTargets = this.findEquivalentTargetInRemoteCluster(remoteCluster, remoteTargetName, findForRemoteElement);
            if (localTargets.size() <= 0) continue;
            return (ISCSITarget)localTargets.get(0);
        }
        return null;
    }

    private ArrayList findEquivalentTargetInRemoteCluster(Cluster remoteCluster, String targetName, boolean findForRemoteElement) throws RemoteException {
        ArrayList<Target> equivalentTargetsInRemoteClusters = new ArrayList<Target>();
        Synchronizeable obj = null;
        obj = findForRemoteElement ? ((ClusterImpl)remoteCluster).getTargetListMgr().getTargetByName(targetName) : ((ClusterImpl)remoteCluster).getRemoteTargetListMgr().getRemoteTargetByName(targetName);
        if (obj != null) {
            equivalentTargetsInRemoteClusters.add((Target)obj);
        }
        return equivalentTargetsInRemoteClusters;
    }

    public ArrayList getAllClusterTargetPortals() throws RemoteException {
        ArrayList<PortalTableRowImpl> allTargetsPortals = new ArrayList<PortalTableRowImpl>();
        Vector localTargets = this.storage.getTargetList();
        for (int index1 = 0; index1 < localTargets.size(); ++index1) {
            ISCSITarget target = (ISCSITarget)localTargets.get(index1);
            VSwitch vswitch = ((ISCSITargetImpl)target).getExposedOnVSwitchObject();
            ArrayList targetPortals = this.getAllTargetPortals(vswitch);
            for (int index2 = 0; index2 < targetPortals.size(); ++index2) {
                PortalTableRowImpl portal = (PortalTableRowImpl)targetPortals.get(index2);
                if (allTargetsPortals.contains(portal)) continue;
                allTargetsPortals.add(portal);
            }
        }
        return allTargetsPortals;
    }

    public ArrayList getAllTargetPortals(VSwitch vswitch) throws RemoteException {
        ArrayList targetPortals = new ArrayList();
        if (vswitch != null) {
            Integer vswitchId = vswitch.getSwitchID();
            targetPortals.addAll(this.getVSwitchTargetPortals(vswitch, vswitchId));
        }
        return targetPortals;
    }

    private ArrayList getVSwitchTargetPortals(VSwitch vswitch, Integer vswitchId) throws RemoteException {
        ArrayList<PortalTableRowImpl> portals = new ArrayList<PortalTableRowImpl>();
        Vector vswitchPotals = vswitch.getPortalTable();
        for (int index = 0; index < vswitchPotals.size(); ++index) {
            PortalTableRowImpl portal = (PortalTableRowImpl)vswitchPotals.get(index);
            Integer tag = portal.getTag();
            if (tag == null || !portal.isTargetRole() || !portal.getTag().equals(vswitchId)) continue;
            portals.add(portal);
        }
        return portals;
    }

    private void setRemoteTargetAliasIfCreatedByVSwitch(ISCSIRemoteTargetImpl remoteTarget, VSwitchImpl vswitch) throws RemoteException {
        if (remoteTarget.getAlias(vswitch).startsWith("X")) {
            ISCSITarget localTarget = remoteTarget.getConfiguredAsLocalTargetOnSameCluster();
            ArrayList clustersInOtherSites = SystemRootImpl.getInstance().getClustersInOtherSites(this.getParentSite());
            if (localTarget != null || (localTarget = this.findEquivLocalTargetOfRemoteTargetInRemoteClusters(clustersInOtherSites, remoteTarget.getName())) != null) {
                HashMap<ClientParameterCode, String> changedValues = new HashMap<ClientParameterCode, String>();
                String localTargetAlias = localTarget.getAlias();
                changedValues.put(ClientParameterCode.ISCSI_REMOTE_TARGET_ALIAS, localTargetAlias);
                try {
                    remoteTarget.changeElement(changedValues);
                }
                catch (IllegalValueException ive) {
                    // empty catch block
                }
            }
        }
    }

    private void changeIdentityPurpose(Identity identity, IdentityPurposeConstant purpose) throws RemoteException {
        ConfigElementData element = new ConfigElementData(identity.getCommKeyClassId());
        Parameter identityPurpose = new Parameter(ParameterCode.IDENTITY_PURPOSE, IdentityPurposeConstant.UNKNOWN);
        element.addParameter(identityPurpose);
        DataMgr.getInstance().changeElement(element);
    }

    public void createRemoteDiscoveryPortal(String ipAddress, Integer port) throws RemoteException, IllegalValueException {
        Vector clusterVswitches = this.getVSwitches();
        for (int index = 0; index < clusterVswitches.size(); ++index) {
            VSwitch vswitch = (VSwitch)clusterVswitches.get(index);
            ISCSIInitiatorImpl vswitchInitiator = (ISCSIInitiatorImpl)vswitch.getISCSIInitiators()[0];
            vswitchInitiator.createRemoteDiscoveryPortal(ipAddress, port);
        }
    }

    private void invokeDREventAndWait(RemoteObjectImpl element, int eventType) throws RemoteException {
        if (Thread.currentThread() == this.queueConsumerThread) {
            SystemRootImpl.getInstance().getDRAndClustersSynchronizationLock().release_read_lock();
            DRRootImpl.getInstance().invokeAndWait(element, eventType);
            try {
                SystemRootImpl.getInstance().getDRAndClustersSynchronizationLock().get_read_lock();
            }
            catch (InterruptedException e) {
                logger.error(e);
            }
        } else {
            DRRootImpl.getInstance().invokeAndWait(element, eventType);
        }
    }

    public VSwitch[] getConnectedVSwitches() {
        ArrayList<VSwitch> connectedVSwitches = new ArrayList<VSwitch>();
        for (int i = 0; i < this.m_vSwitches.size(); ++i) {
            VSwitch currVSwitch = (VSwitch)this.m_vSwitches.elementAt(i);
            try {
                if (!currVSwitch.isConnected()) continue;
                connectedVSwitches.add(currVSwitch);
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        VSwitch[] vswitches = new VSwitch[connectedVSwitches.size()];
        return connectedVSwitches.toArray(vswitches);
    }

    public HashMap checkConsistencyBetweenVSwitches() throws RemoteException {
        VSwitch[] vSwitches = this.getConnectedVSwitches();
        if (vSwitches.length > 1) {
            // empty if block
        }
        return null;
    }

    public boolean isIPExistedAsISNSServer(String ip) throws RemoteException {
        Vector isnsServersTable = this.getAllISNSServers();
        for (int index = 0; index < isnsServersTable.size(); ++index) {
            ISNSServerImpl server = (ISNSServerImpl)isnsServersTable.get(index);
            if (!server.getServerIP().equals(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsRadiusServer(String ip) throws RemoteException {
        Vector radiusServersTable = this.getAllRadiusServers();
        for (int index = 0; index < radiusServersTable.size(); ++index) {
            RadiusServerImpl server = (RadiusServerImpl)radiusServersTable.get(index);
            if (!server.getServerIP().equals(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsLocalIP(String ip) throws RemoteException {
        Vector vswitches = this.getVSwitches();
        for (int index = 0; index < vswitches.size(); ++index) {
            VSwitchImpl vswitch = (VSwitchImpl)vswitches.get(index);
            if (!vswitch.isIPExistedAsLocalIP(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsRoutIP(String ip) throws RemoteException {
        Vector vswitches = this.getVSwitches();
        for (int index = 0; index < vswitches.size(); ++index) {
            VSwitchImpl vswitch = (VSwitchImpl)vswitches.get(index);
            if (!vswitch.isIPExistedAsRoutIP(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsLocalPortal(String ip) throws RemoteException {
        Vector vswitches = this.getVSwitches();
        for (int index = 0; index < vswitches.size(); ++index) {
            VSwitchImpl vswitch = (VSwitchImpl)vswitches.get(index);
            if (!vswitch.isIPExistedAsLocalPortal(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsLocalPortal(String ip, int port) throws RemoteException {
        Vector vswitches = this.getVSwitches();
        for (int index = 0; index < vswitches.size(); ++index) {
            VSwitchImpl vswitch = (VSwitchImpl)vswitches.get(index);
            if (!vswitch.isIPExistedAsLocalPortal(ip, port)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsSNMPManager(String ip) throws RemoteException {
        Vector vswitches = this.getVSwitches();
        for (int index = 0; index < vswitches.size(); ++index) {
            VSwitchImpl vswitch = (VSwitchImpl)vswitches.get(index);
            if (!vswitch.isIPExistedAsSNMPManager(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsNeighbor(String ip) throws RemoteException {
        Vector vswitches = this.getVSwitches();
        for (int index = 0; index < vswitches.size(); ++index) {
            VSwitchImpl vswitch = (VSwitchImpl)vswitches.get(index);
            if (!vswitch.isIPExistedAsNeighbor(ip)) continue;
            return true;
        }
        return false;
    }

    private void clearPolicies() throws RemoteException {
        Vector refs = this.commKeyRefMap.getAllRefs();
        int i = refs.size();
        while (i-- > 0) {
            LogicObjectImpl currObj = (LogicObjectImpl)refs.elementAt(i);
            if (!currObj.getClassId().isPolicyClassId()) continue;
            PoliciesManager.getInstance().removePolicyElement(currObj);
        }
    }

    private abstract class ClusterThread
    extends Thread {
        boolean m_isLastConsumerThreadLoop = false;

        ClusterThread(String name) {
            super(name);
        }

        void stopThread() {
            this.m_isLastConsumerThreadLoop = true;
        }

        protected abstract void processEvent(EventQueueElement var1) throws RemoteException, InterruptedException;
    }
}

