/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.acl;

import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.acl.AclImpl;
import com.sanrad.nms.server.logic.acl.PolicyManager;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.target.Target;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class PolicyManagerImpl
extends RemoteObjectImpl
implements PolicyManager {
    private Hashtable aclMap = new Hashtable();

    public void clear() {
        this.aclMap.clear();
    }

    public void removeAcl(Target target) throws RemoteException {
        if (this.checkForTargetExistance(target)) {
            this.aclMap.remove(target);
            logger.debug("Removed an ACL for target - " + target.getAlias());
        } else {
            logger.error("Cannot removed an ACL for non existed target " + target.getAlias());
        }
    }

    public Hashtable getAllAcl() throws RemoteException {
        return this.aclMap;
    }

    public boolean isConnectedToTarget(Identity identity) throws RemoteException {
        Enumeration elements = this.aclMap.elements();
        while (elements.hasMoreElements()) {
            AclImpl acl = (AclImpl)elements.nextElement();
            if (!acl.isTargetConnected(identity)) continue;
            return true;
        }
        return false;
    }

    public void deleteCorrespondingAclEntries(Identity identity) throws RemoteException, IllegalValueException {
        Enumeration elements = this.aclMap.elements();
        while (elements.hasMoreElements()) {
            AclImpl acl = (AclImpl)elements.nextElement();
            acl.deleteCorrespondingAclEntries(identity);
        }
    }

    public void newTarget(Target target) throws RemoteException {
        if (!this.checkForTargetExistance(target)) {
            this.aclMap.put(target, new AclImpl(target));
            logger.debug("create a new ACL for target - " + target.getAlias());
        } else {
            logger.error("Failed to create new ACL for target!!!!");
        }
    }

    private boolean checkForTargetExistance(Target target) throws RemoteException {
        Set keys = this.aclMap.keySet();
        String targetName = target.getName();
        if (targetName == null) {
            logger.error("Trying to create new ACL for target with no name!!!!");
            return true;
        }
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Target targetFromMap = (Target)iter.next();
            if (!targetFromMap.getName().equals(targetName)) continue;
            logger.error("Trying to create new ACL for already existed target: " + targetName);
            return true;
        }
        return false;
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        int result = 0;
        Enumeration e = this.getAllAcl().keys();
        while (e.hasMoreElements()) {
            Target target = (Target)e.nextElement();
            int retVal = this.synchronizeACLEntries(target);
            if (retVal <= result) continue;
            result = retVal;
        }
        return result;
    }

    private int synchronizeACLEntries(Target target) throws RemoteException, IllegalValueException {
        AclImpl acl = (AclImpl)this.getAllAcl().get(target);
        if (acl != null) {
            return acl.synchronize();
        }
        return 0;
    }
}

