/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.acl;

import java.io.Serializable;
import java.util.Vector;

public class Permission
implements Serializable {
    private static Vector permissions;
    public static final Permission READ_ONLY;
    public static final Permission READ_WRITE;
    public static final Permission WRITE_ONLY;
    public static final Permission N_A;
    private String name;
    private int intValue;

    private Permission(String name, int intValue) {
        this.name = name;
        this.intValue = intValue;
        if (permissions == null) {
            permissions = new Vector();
        }
        permissions.addElement(this);
    }

    public static Vector getAllPermissions() {
        return permissions;
    }

    public boolean equals(Object another) {
        if (another instanceof Permission) {
            return ((Permission)another).intValue == this.intValue;
        }
        return false;
    }

    public int hashCode() {
        return this.intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    public static Permission getPermission(int value) {
        switch (value) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                return READ_ONLY;
            }
            case 3: {
                return READ_WRITE;
            }
            case 4: {
                return WRITE_ONLY;
            }
            case 5: {
                return N_A;
            }
        }
        return N_A;
    }

    public String toString() {
        return this.name;
    }

    static {
        READ_ONLY = new Permission("RO", 2);
        READ_WRITE = new Permission("RW", 3);
        WRITE_ONLY = new Permission("WO", 4);
        N_A = new Permission("N/A", 5);
    }
}

