/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.acl;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.CommKeyRefMap;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SynchronizeEvent;
import com.sanrad.nms.server.logic.SynchronizeListener;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.acl.Acl;
import com.sanrad.nms.server.logic.acl.AclEntry;
import com.sanrad.nms.server.logic.acl.AclEntryImpl;
import com.sanrad.nms.server.logic.acl.AclEntryValidator;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.mgr.operation.CreateElementOperation;
import com.sanrad.nms.server.mgr.operation.ElementOperation;
import com.sanrad.nms.server.mgr.operation.ElementOperationList;
import com.sanrad.nms.server.mgr.operation.RemoveElementOperation;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.constants.IdentityPurposeConstant;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class AclImpl
extends SynchronizeableImpl
implements Acl,
SynchronizeListener {
    private Hashtable m_aclEntries = new Hashtable();
    private TargetImpl m_target;
    private int m_highestPosition = 0;
    private Vector m_operations;

    public AclImpl(Target target) throws RemoteException {
        super(ClassID.ACL);
        this.m_target = (TargetImpl)target;
        this.cluster = (ClusterImpl)target.getCluster();
        this.m_target.addSynchronizeListener(this);
        this.m_operations = new Vector();
    }

    public Vector getEntries() throws RemoteException {
        return this.sortEntriesAccordingtoPositions(this.getExposedOnTargetAclEntriesPositions());
    }

    public Vector getAllACLEntriesSorted() throws RemoteException {
        return this.sortEntriesAccordingtoPositions(this.m_aclEntries.keys());
    }

    public AclEntry getFirstEntry() throws RemoteException {
        Enumeration values = this.m_aclEntries.elements();
        while (values.hasMoreElements()) {
            AclEntry entry = (AclEntry)values.nextElement();
            if (entry.getPosition() != 0) continue;
            return entry;
        }
        return null;
    }

    public void addAclEntry(AclEntry entry) throws RemoteException {
        IdentityImpl identity = (IdentityImpl)entry.getIdentity();
        if (identity != null) {
            identity.addSynchronizeListener(this);
        }
        Integer pos = entry.getPosition();
        if (!identity.isOfRemoteInitiatorDR()) {
            this.setHighestPostionIfHighest(pos);
        }
        this.m_aclEntries.put(pos, entry);
        logger.debug("Adding an ACL entry.... executing next operation.");
        this.executeNextOperation();
    }

    public synchronized void setHighestPostionIfHighest(Integer position) {
        if (position > this.m_highestPosition) {
            this.m_highestPosition = position;
        }
    }

    private synchronized int getHighestPosition() {
        return this.m_highestPosition;
    }

    private synchronized int incrementHighestPostion() {
        ++this.m_highestPosition;
        int highestPosition = this.getHighestPosition();
        return highestPosition;
    }

    private Vector sortEntriesAccordingtoPositions(Enumeration keys) throws RemoteException {
        Vector positions = new Vector();
        Vector entries = new Vector();
        while (keys.hasMoreElements()) {
            positions.addElement(keys.nextElement());
        }
        Object[] positionsArray = positions.toArray();
        Arrays.sort(positionsArray);
        for (int i = 0; i < positionsArray.length; ++i) {
            Object entry = this.m_aclEntries.get(positionsArray[i]);
            entries.addElement(entry);
        }
        return entries;
    }

    private Enumeration getExposedOnTargetAclEntriesPositions() throws RemoteException {
        Vector entries = new Vector();
        Enumeration e = this.m_aclEntries.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            AclEntryImpl entry = (AclEntryImpl)this.m_aclEntries.get(key);
            if (!entry.isRelevantForExposedTarget() && entry.isRedundant()) continue;
            entries.addElement(key);
        }
        return entries.elements();
    }

    private ConfigElementData prepareAclEntry(IdentityImpl identity, Permission permission, int position) throws RemoteException, IllegalValueException {
        logger.debug("creating a new ACL entry.");
        AclEntryValidator aclEntryValidator = new AclEntryValidator(this, identity, this.m_target);
        if (aclEntryValidator.isValid()) {
            ConfigElementData element = new ConfigElementData(ClassID.ACL_ENTRY);
            if (!identity.isOfRemoteInitiatorDR()) {
                Parameter entryPermission = new Parameter(ParameterCode.ACL_ENTRY_ACCESS, new SrInteger(permission.intValue()));
                element.addParameter(entryPermission);
                Parameter entryPosition = new Parameter(ParameterCode.ACL_ENTRY_POSITION, new SrInteger(position));
                element.addParameter(entryPosition);
            }
            CommKeyClassId identCommkeyClassId = new CommKeyClassId(identity.getCommKeys(), ClassID.IDENTITY);
            Parameter identityParam = new Parameter(ParameterCode.ACL_ENTRY_IDENTITY, identCommkeyClassId);
            element.addParameter(identityParam);
            TargetImpl targetImpl = this.m_target;
            CommKeyClassId targetCommkeyClassId = new CommKeyClassId(targetImpl.getCommKeys(), ClassID.ISCSI_TARGET);
            Parameter targetParam = new Parameter(ParameterCode.ACL_ENTRY_TARGET_PARENT, targetCommkeyClassId);
            element.addParameter(targetParam);
            return element;
        }
        throw new IllegalValueException(aclEntryValidator.getErrorMsg());
    }

    public void createAclEntry(IdentityImpl identity, Permission permission, Integer position, Vector vswitches) throws RemoteException {
        AclEntryValidator aclEntryValidator = new AclEntryValidator(this, identity, this.m_target);
        if (aclEntryValidator.isValid()) {
            ConfigElementData element = new ConfigElementData(ClassID.ACL_ENTRY);
            if (permission == null) {
                permission = Permission.READ_WRITE;
            }
            if (!identity.isOfRemoteInitiatorDR()) {
                Parameter entryPermission = new Parameter(ParameterCode.ACL_ENTRY_ACCESS, new SrInteger(permission.intValue()));
                element.addParameter(entryPermission);
                Parameter entryPosition = new Parameter(ParameterCode.ACL_ENTRY_POSITION, new SrInteger(position));
                element.addParameter(entryPosition);
            }
            ClusterImpl cluster = (ClusterImpl)identity.getCluster();
            cluster.createElement(element, permission.toString(), vswitches);
        }
    }

    public void createAclEntry(CommKeyClassId identityCommKeyClassId, Permission permission, Integer position) throws RemoteException {
        IdentityImpl identity = (IdentityImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(identityCommKeyClassId);
        this.createAclEntry(identity, permission, position, null);
    }

    public void createAclEntry(AclEntry entry, Vector vswithces) throws RemoteException {
        IdentityImpl identity = (IdentityImpl)entry.getIdentity();
        Permission permission = entry.getPermission();
        Integer position = entry.getPosition();
        this.createAclEntry(identity, permission, position, vswithces);
    }

    public void updateAcl(Vector data) throws RemoteException, IllegalValueException {
        this.updateAcl(data, (Vector)null);
    }

    public void updateAcl(Vector data, Vector vSwitches) throws RemoteException, IllegalValueException {
        logger.debug("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ ------ UPDATE ACL !!!!");
        logger.debug(this.toDisplayString());
        int size = data.size();
        ClusterImpl clusterImpl = (ClusterImpl)this.m_target.getCluster();
        CommKeyRefMap refMap = clusterImpl.getCommKeyRefMap();
        ElementOperationList operationsList = new ElementOperationList();
        for (int i = 0; i < size; ++i) {
            int position;
            Vector rowData = (Vector)data.get(i);
            Object identityCommKey = rowData.get(0);
            IdentityImpl identityImpl = (IdentityImpl)refMap.getRefByCommKeyClassID((CommKey[])identityCommKey, ClassID.IDENTITY);
            Permission permission = (Permission)rowData.get(1);
            try {
                Object pos = rowData.get(2);
                position = pos instanceof Integer ? ((Integer)pos).intValue() : this.incrementHighestPostion();
            }
            catch (ArrayIndexOutOfBoundsException aiob) {
                position = this.incrementHighestPostion();
            }
            ConfigElementData element = this.prepareAclEntry(identityImpl, permission, position);
            if (identityImpl.isPurposeUnknown()) {
                ConfigElementData identityElement = new ConfigElementData(identityImpl.getCommKeyClassId());
                Parameter parameter = new Parameter(ParameterCode.IDENTITY_PURPOSE, IdentityPurposeConstant.REMOTE_INITIATOR);
                identityElement.addParameter(parameter);
                DataMgr.getInstance().changeElement(identityElement);
            }
            CreateElementOperation createOperation = new CreateElementOperation(element);
            operationsList.addElement(createOperation);
            logger.debug("create operation was added to operation list: " + createOperation.toString());
        }
        boolean isConnectedVswitchesConflict = false;
        if (vSwitches == null) {
            Vector<VSwitch> vSwitchesOfNotRedundantEntries = null;
            String msgForVSwitchConflicts = "The Access Control List is not synchronized within the cluster. Please perform \"Cluster Synchronize\".";
            Enumeration values = this.m_aclEntries.elements();
            while (values.hasMoreElements()) {
                boolean tryToRemoveEntry = true;
                AclEntryImpl entry = (AclEntryImpl)values.nextElement();
                if (entry.isEntryForDRRemoteInitiator() || entry.isEntryForDRIdentityAll() || entry.isDefAll()) continue;
                entry.setChangePosition(true);
                if (!entry.isRedundant()) {
                    Vector connectedVSwitches = entry.getConnectedVSwitchesAsVector();
                    VSwitch vSwitch = (VSwitch)connectedVSwitches.firstElement();
                    tryToRemoveEntry = vSwitch.isConnected();
                    if (tryToRemoveEntry) {
                        if (vSwitchesOfNotRedundantEntries != null && !vSwitchesOfNotRedundantEntries.contains(vSwitch)) {
                            throw new IllegalValueException(msgForVSwitchConflicts);
                        }
                        if (vSwitchesOfNotRedundantEntries == null) {
                            vSwitchesOfNotRedundantEntries = new Vector<VSwitch>();
                            vSwitchesOfNotRedundantEntries.add(vSwitch);
                        }
                    }
                } else if (vSwitchesOfNotRedundantEntries != null && !vSwitchesOfNotRedundantEntries.isEmpty()) {
                    throw new IllegalValueException(msgForVSwitchConflicts);
                }
                if (!tryToRemoveEntry) continue;
                if (entry.getCommKeys().length > 0) {
                    ConfigElementData ced = new ConfigElementData(entry.getCommKeys(), entry.getClassId());
                    RemoveElementOperation removeOperation = new RemoveElementOperation(ced);
                    operationsList.addElement(removeOperation);
                    logger.debug("remove operation was added to operation list: " + removeOperation.toString());
                }
                logger.warning(entry.getClassId() + " " + entry + " with no CommKey was found when  trying to create a RemoveElementOperation object");
            }
            if (vSwitchesOfNotRedundantEntries != null && !vSwitchesOfNotRedundantEntries.isEmpty()) {
                vSwitches = vSwitchesOfNotRedundantEntries;
            }
        }
        clusterImpl.executeOperations(operationsList, vSwitches);
    }

    public void updateAcl(Vector data, VSwitch vSwitch) throws RemoteException, IllegalValueException {
        Vector<VSwitch> vSwitches = null;
        if (vSwitch != null) {
            vSwitches = new Vector<VSwitch>(1);
            vSwitches.addElement(vSwitch);
        }
        this.updateAcl(data, vSwitches);
    }

    private Integer getNextPosition(Vector sortedACLEntries, int startFrom, VSwitch vSwitch) throws RemoteException {
        int prevPosition = 0;
        AclEntryImpl aclEntry = null;
        for (int i = startFrom - 1; i > 0; --i) {
            aclEntry = (AclEntryImpl)sortedACLEntries.elementAt(i);
            if (aclEntry.isDefAll() || !aclEntry.isKnownByVSwitch(vSwitch)) continue;
            prevPosition = aclEntry.getPosition(vSwitch);
            break;
        }
        if (aclEntry != null && (aclEntry.isEntryForDRIdentityAll() || aclEntry.isEntryForDRRemoteInitiator())) {
            return null;
        }
        return new Integer(++prevPosition);
    }

    private int synchronizeACLEntries() throws RemoteException, IllegalValueException {
        int result = 0;
        Vector sortedACLEntries = this.getAllACLEntriesSorted();
        Vector data = new Vector();
        VSwitch otherVSwitch = null;
        Enumeration e = sortedACLEntries.elements();
        while (e.hasMoreElements()) {
            AclEntryImpl aclEntry = (AclEntryImpl)e.nextElement();
            if (aclEntry.isRedundant() || aclEntry.isSynchronizePending()) continue;
            aclEntry.setSynchronizePending(true);
            VSwitch[] connectedVSwitches = aclEntry.getConnectedVSwitchesList();
            VSwitch connectedVSwitch = connectedVSwitches[0];
            if (!connectedVSwitch.isConnected()) continue;
            VSwitch vSwitch = ((ClusterImpl)aclEntry.getCluster()).getOtherVSwitch(connectedVSwitch);
            if (otherVSwitch == null) {
                otherVSwitch = vSwitch;
            }
            int entryIndex = sortedACLEntries.indexOf(aclEntry);
            Integer nextPosition = this.getNextPosition(sortedACLEntries, entryIndex, otherVSwitch);
            Vector<Object> rowData = new Vector<Object>(2);
            IdentityImpl identity = (IdentityImpl)aclEntry.getIdentity();
            rowData.addElement(identity.getCommKeys());
            if (!aclEntry.isEntryForDRIdentityAll() && !aclEntry.isEntryForDRRemoteInitiator()) {
                rowData.addElement(aclEntry.getPermission());
            } else {
                rowData.addElement(null);
            }
            if (nextPosition != null) {
                Integer position = new Integer(nextPosition + data.size());
                rowData.addElement(position);
            } else {
                rowData.addElement(null);
            }
            data.addElement(rowData);
        }
        if (data.size() > 0) {
            this.updateAcl(data, otherVSwitch);
        }
        return result;
    }

    private void executeNextOperation() throws RemoteException {
        if (this.m_operations.isEmpty()) {
            return;
        }
        Object operation = this.m_operations.remove(0);
        if (operation instanceof ElementOperation) {
            ConfigElementData element = ((ElementOperation)operation).getElement();
            ClusterImpl clusterImpl = (ClusterImpl)this.m_target.getCluster();
            logger.debug("EXECUTING CREATE ACL_ENTRY: " + element.getSnmpKey());
            clusterImpl.createElement(element, ClassID.ACL_ENTRY, element.getValue(ParameterCode.ACL_ENTRY_ACCESS).toString(), null);
        } else {
            try {
                logger.debug("EXECUTING REMOVE ACL_ENTRY ");
                ((AclEntryImpl)operation).deleteElement();
            }
            catch (Exception e) {
                logger.error("Could not delete Acl Entry ", e);
            }
        }
    }

    public Target getTargetParent() throws RemoteException {
        return this.m_target;
    }

    public boolean isTargetConnected(Identity identity) throws RemoteException {
        Enumeration elements = this.m_aclEntries.elements();
        while (elements.hasMoreElements()) {
            AclEntryImpl aclEntry = (AclEntryImpl)elements.nextElement();
            if (!((IdentityImpl)aclEntry.getIdentity()).equals((IdentityImpl)identity)) continue;
            return true;
        }
        return false;
    }

    public void deleteCorrespondingAclEntries(Identity identity) throws RemoteException, IllegalValueException {
        Enumeration elements = this.m_aclEntries.elements();
        while (elements.hasMoreElements()) {
            AclEntryImpl aclEntry = (AclEntryImpl)elements.nextElement();
            if (!((IdentityImpl)aclEntry.getIdentity()).equals((IdentityImpl)identity)) continue;
            aclEntry.deleteElement();
        }
    }

    public AclEntry getEntry(Identity identity, Permission permission, int position, boolean includePos) throws RemoteException {
        Enumeration entries = this.m_aclEntries.elements();
        while (entries.hasMoreElements()) {
            AclEntryImpl entry = (AclEntryImpl)entries.nextElement();
            String identityAlias = identity.getAlias();
            if (entry.getIdentity() == null || !identityAlias.equalsIgnoreCase(entry.getIdentity().getAlias())) continue;
            if (identityAlias.equals("DEF_ALL")) {
                return (AclEntry)this.m_aclEntries.get(new Integer(0));
            }
            if (entry.isChangePosition()) {
                if (entry.getPosition() != position) continue;
                entry.setChangePosition(false);
                return entry;
            }
            return entry;
        }
        return null;
    }

    public void removeAclEntry(AclEntry aclEntry) throws RemoteException {
        Object removed = this.m_aclEntries.remove(aclEntry.getPosition());
        if (removed == null) {
            logger.warning("COULD NOT DELETE ACL ENTRY FROM THE LIST OF ENTRIES !!!!!!!!!!!!");
        }
        logger.debug("Removing an ACL entry " + aclEntry.toString() + " .... executing next operation.");
        this.executeNextOperation();
    }

    public HashMap checkConsistencyBetweenVSwitches() throws RemoteException {
        HashMap<AclEntryImpl, HashMap> inconsistentValues = new HashMap<AclEntryImpl, HashMap>();
        Enumeration values = this.m_aclEntries.elements();
        while (values.hasMoreElements()) {
            HashMap map;
            AclEntryImpl entry = (AclEntryImpl)values.nextElement();
            if (entry.isDefAll() || (map = entry.checkConsistencyBetweenVSwitches()) == null || map.isEmpty()) continue;
            inconsistentValues.put(entry, map);
        }
        return inconsistentValues;
    }

    public HashMap isOrdered() throws RemoteException {
        logger.debug("checking order of positions");
        HashMap map = this.checkConsistencyBetweenVSwitches();
        Vector sorted = this.sortEntriesAccordingtoPositions(this.m_aclEntries.keys());
        VSwitch[] vSwitches = this.m_target.getConnectedVSwitches();
        if (vSwitches.length > 1) {
            int[] order = new int[vSwitches.length];
            for (int j = 1; j < sorted.size(); ++j) {
                AclEntryImpl entry = (AclEntryImpl)sorted.get(j);
                for (int i = 0; i < vSwitches.length; ++i) {
                    if (!entry.isKnownByVSwitch(vSwitches[i])) continue;
                    Integer pos = entry.getPosition(vSwitches[i]);
                    if (pos > order[i]) {
                        order[i] = pos;
                        continue;
                    }
                    logger.debug("order of positions is wrong: ");
                    HashMap<ParameterCode, AclEntryImpl> value = new HashMap<ParameterCode, AclEntryImpl>(1);
                    value.put(ParameterCode.ACL_ENTRY_POSITION, entry);
                    map.put(entry, value);
                }
            }
            logger.debug("order of positions is OK");
        }
        return map;
    }

    public Object[] isDefaultAccessInconsistent() throws RemoteException {
        AclEntry entry = (AclEntry)this.m_aclEntries.get(new Integer(0));
        if (entry != null) {
            Permission access = ((AclEntryImpl)entry).getPermission();
            VSwitch[] vswitches = entry.getConnectedVSwitchesList();
            Vector<String> values = new Vector<String>(2);
            for (int i = 0; i < vswitches.length; ++i) {
                Permission nextPermission = ((AclEntryImpl)entry).getPermission(vswitches[i]);
                if (access.equals(nextPermission)) continue;
                values.addElement(access.toString());
                values.addElement(nextPermission.toString());
                return values.toArray();
            }
        }
        return null;
    }

    protected String canBeSynchronized() throws RemoteException, IllegalValueException {
        if (this.m_target.isNeedToSynchronize()) {
            if (!this.m_target.isSynchronizePending()) {
                StringBuffer msg = new StringBuffer("ACL ");
                msg.append(this.toString());
                msg.append(" cannot be synchronized. ");
                msg.append(this.m_target.getClassId());
                msg.append(" ");
                msg.append(this.m_target);
                msg.append(" is not synchronized yet");
                throw new IllegalValueException(msg.toString());
            }
            String msg = "Target " + this.m_target.getAlias() + " is not synchronized yet.";
            return msg;
        }
        Enumeration e = this.m_aclEntries.elements();
        while (e.hasMoreElements()) {
            IdentityImpl identity;
            AclEntryImpl aclEntry = (AclEntryImpl)e.nextElement();
            if (aclEntry.isRedundant() || !(identity = (IdentityImpl)aclEntry.getIdentity()).isNeedToSynchronize()) continue;
            if (!identity.isSynchronizePending()) {
                StringBuffer msg = new StringBuffer("ACL ");
                msg.append(this.toString());
                msg.append(" cannot be synchronized. ");
                msg.append(identity.getClassId());
                msg.append(" ");
                msg.append(identity);
                msg.append(" is not synchronized yet");
                throw new IllegalValueException(msg.toString());
            }
            String msg = "Identity " + identity + " is not synchronized yet.";
            return msg;
        }
        return null;
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        logger.debug("Start Sync of ACL " + this.toString());
        if (this.isSynchronizePending()) {
            logger.debug("Already synchronizing " + this.getClassId() + " " + this.toString());
            return 1;
        }
        logger.debug("Start to synchronize " + this.getClassId() + " " + this.toString());
        this.setSynchronizePending(true);
        int retVal = 0;
        try {
            if (!this.isNeedToSynchronize()) {
                this.setSynchronizePending(false);
                return retVal;
            }
            retVal = this.synchronizeMe();
            logger.debug("Sync of ACL " + this.toString() + " SyncMe status " + retVal);
            return retVal;
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
            this.setSynchronizePending(false);
            throw ive;
        }
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        return null;
    }

    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    public String toDisplayString() throws RemoteException {
        Vector entries = this.sortEntriesAccordingtoPositions(this.m_aclEntries.keys());
        StringBuffer sb = new StringBuffer("Entries: ");
        for (int i = 0; i < entries.size(); ++i) {
            AclEntry entry = (AclEntry)entries.get(i);
            if (entry.getIdentity() != null) {
                sb.append(entry.getIdentity().getAlias());
            }
            sb.append(", ");
            sb.append(entry.getPermission().toString());
            sb.append(", ");
            sb.append(entry.getPosition());
            sb.append("\n");
        }
        return sb.toString();
    }

    public Vector getNotRedundantACLEntries() throws RemoteException {
        Vector<AclEntryImpl> notRedundantACLEntries = null;
        Enumeration e = this.m_aclEntries.elements();
        while (e.hasMoreElements()) {
            AclEntryImpl aclEntry = (AclEntryImpl)e.nextElement();
            if (aclEntry.isRedundant() || aclEntry.isDefAll()) continue;
            if (notRedundantACLEntries == null) {
                notRedundantACLEntries = new Vector<AclEntryImpl>();
            }
            notRedundantACLEntries.addElement(aclEntry);
        }
        return notRedundantACLEntries;
    }

    public int synchronizeMe() throws RemoteException, IllegalValueException {
        String msg = this.canBeSynchronized();
        if (msg != null) {
            return 2;
        }
        logger.info("Sync Me for ACL " + this.toString());
        this.synchronizeACLEntries();
        return 2;
    }

    public String getAlias() throws RemoteException {
        return this.getAlias(null);
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public void synchronizingCompleted(SynchronizeEvent e) {
        if (!this.isSynchronizePending()) {
            return;
        }
        try {
            if (this.isNeedToSynchronize()) {
                this.synchronizeMe();
                return;
            }
            this.doneSynchronizing();
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
            this.errorInSynchronizing();
        }
        catch (RemoteException re) {
            logger.error(re);
            this.errorInSynchronizing();
        }
    }

    public int getHighestACLEntryPositionForDR() {
        return this.getHighestPosition() + 1;
    }
}

