/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.acl;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.acl.Acl;
import com.sanrad.nms.server.logic.acl.AclEntry;
import com.sanrad.nms.server.logic.acl.AclImpl;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class AclEntryImpl
extends SynchronizeableImpl
implements AclEntry {
    private static final int DR_DEF_ALL_POSITION = 2147482647;
    private static final int DEF_ALL_POSITION = 0;
    private static List parameterCodeList;
    private AclImpl aclParent;
    private Identity identity;
    private Integer position = null;
    private Permission permission;
    private boolean changePosition = false;

    public AclEntryImpl(ClusterImpl cluster, ClassID classId, Acl aclParent) throws RemoteException {
        super(cluster, classId, parameterCodeList);
        this.aclParent = (AclImpl)aclParent;
    }

    public void changeElement(HashMap parameterList) throws RemoteException, IllegalValueException {
        Object access = parameterList.get(ClientParameterCode.ACL_ENTRY_ACCESS);
        if (access != null) {
            SrInteger permission = new SrInteger(((Permission)access).intValue());
            parameterList.put(ClientParameterCode.ACL_ENTRY_ACCESS, permission);
        }
        super.changeElement(parameterList);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        VSwitch vswitch = this.getExposedOnVswitch();
        try {
            this.identity = this.getIdentity(vswitch);
            this.position = this.getPosition(vswitch);
            this.permission = this.getPermission(vswitch);
        }
        catch (NullPointerException npe) {
            this.identity = this.getIdentity(null);
            this.position = this.getPosition(null);
            this.permission = this.getPermission(null);
        }
        if (this.identity == null) {
            StringBuffer sberr = new StringBuffer("Error!!! ACL entry CommkeyClassid = ");
            sberr.append(this.getCommKeyClassId());
            sberr.append(" ; Entry Identity on ");
            sberr.append(ClassID.VSWITCH.toString());
            sberr.append(" ");
            sberr.append(vswitch.getName());
            sberr.append(" is NULL!!!");
            logger.error(sberr.toString());
        } else if (!((IdentityImpl)this.identity).isOfRemoteInitiatorDR()) {
            this.aclParent.setHighestPostionIfHighest(this.position);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        if (this.getIdentity() != null) {
            sb.append(this.getIdentity().getAlias());
        }
        sb.append("][");
        sb.append(this.getPermission().toString());
        sb.append("][");
        sb.append(this.getPosition());
        sb.append("]");
        this.toStringValue = sb.toString();
        return changedValues;
    }

    public boolean isRelevantForExposedTarget() throws RemoteException {
        VSwitch vswitch = this.getExposedOnVswitch();
        return this.isKnownByVSwitch(vswitch);
    }

    protected VSwitch getExposedOnVswitch() throws RemoteException {
        String vswitch = this.aclParent.getTargetParent().getExposedOnVSwitch();
        return this.cluster.getVSwitchByName(vswitch);
    }

    public Identity getIdentity() throws RemoteException {
        return this.identity;
    }

    public Identity getIdentity(VSwitch vSwitch) throws RemoteException {
        CommKeyClassId identCommKeyClassId = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.ACL_ENTRY_IDENTITY, vSwitch == null);
        Identity identity = (Identity)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(identCommKeyClassId);
        return identity;
    }

    public Target getTargetParent() throws RemoteException {
        return this.getTargetParent(null);
    }

    public Target getTargetParent(VSwitch vSwitch) throws RemoteException {
        CommKeyClassId targetCommKeyClassId = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.ACL_ENTRY_TARGET_PARENT, vSwitch == null);
        Target target = (Target)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(targetCommKeyClassId);
        return target;
    }

    public Acl getAclParent() throws RemoteException {
        return this.aclParent;
    }

    public Integer getPosition() throws RemoteException {
        return this.position;
    }

    public Integer getPosition(VSwitch vSwitch) throws RemoteException {
        Integer pos = (Integer)this.getValueOf(vSwitch, ParameterCode.ACL_ENTRY_POSITION, vSwitch == null);
        return pos;
    }

    public Permission getPermission() throws RemoteException {
        return this.permission;
    }

    public Permission getPermission(VSwitch vSwitch) throws RemoteException {
        Integer permissionIntVal = (Integer)this.getValueOf(vSwitch, ParameterCode.ACL_ENTRY_ACCESS, vSwitch == null);
        return Permission.getPermission(permissionIntVal);
    }

    protected String canBeSynchronized() throws RemoteException, IllegalValueException {
        boolean isTargetSynchronized;
        boolean bl = isTargetSynchronized = !((TargetImpl)this.getTargetParent()).isNeedToSynchronize();
        if (isTargetSynchronized) {
            boolean isIdentitySynchronized;
            boolean bl2 = isIdentitySynchronized = !((IdentityImpl)this.getIdentity()).isNeedToSynchronize();
            if (isIdentitySynchronized) {
                return null;
            }
            return "cannot synchronize ACLEntry: identity not synchronized yet";
        }
        return "cannot synchronize ACLEntry: target not synchronized yet";
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        String msg = this.canBeSynchronized();
        if (msg != null) {
            return this.synchronizeMe();
        }
        return 2;
    }

    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (!this.isInSynchronizingMode()) {
            this.aclParent.createAclEntry(this, this.cluster.getOtherVSwitches(this.getVSwitches()));
            this.setSynchronizingMode(true);
        }
        return 2;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        return null;
    }

    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    public String getAlias() throws RemoteException {
        return this.getAlias(null);
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public boolean isDefAll() throws RemoteException {
        return this.getPosition() != null && this.getPosition() == 0;
    }

    public boolean isDRDefAll() throws RemoteException {
        return this.getPosition() != null && this.getPosition() == 2147482647;
    }

    public boolean isRemoteInitiatorDR() throws RemoteException {
        Identity entryIdentity = this.getIdentity();
        return ((IdentityImpl)entryIdentity).isOfRemoteInitiatorDR();
    }

    public void setChangePosition(boolean change) {
        this.changePosition = change;
    }

    public boolean isChangePosition() {
        return this.changePosition;
    }

    public boolean isRedundant() throws RemoteException {
        if (!this.isDefAll() && !this.isDRDefAll()) {
            return super.isRedundant();
        }
        return true;
    }

    public boolean isEntryForDRIdentityAll() throws RemoteException {
        Identity entryIdentity = this.getIdentity();
        if (this.identity == null) {
            StringBuffer sberr = new StringBuffer("Error!!! ACL entry CommkeyClassid = ");
            sberr.append(this.getCommKeyClassId());
            sberr.append(" ; Entry Identity is NULL!!!");
            logger.error(sberr.toString());
        }
        return ((IdentityImpl)entryIdentity).isDRIdentityAll();
    }

    public boolean isEntryForDRRemoteInitiator() throws RemoteException {
        Identity entryIdentity = this.getIdentity();
        if (this.identity == null) {
            StringBuffer sberr = new StringBuffer("Error!!! ACL entry CommkeyClassid = ");
            sberr.append(this.getCommKeyClassId());
            sberr.append(" ; Entry Identity is NULL!!!");
            logger.error(sberr.toString());
        }
        return ((IdentityImpl)entryIdentity).isOfRemoteInitiatorDR();
    }

    public void setSynchronizePending(boolean pending) {
        super.setSynchronizePending(pending);
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.ACL_ENTRY_IDENTITY);
        parameterCodes.addElement(ParameterCode.ACL_ENTRY_ACCESS);
        parameterCodes.addElement(ParameterCode.ACL_ENTRY_POSITION);
        parameterCodes.addElement(ParameterCode.ACL_ENTRY_TARGET_PARENT);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

