/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.nms.server.logic.LogicObjectValidator;
import com.sanrad.nms.server.logic.SiteImpl;
import com.sanrad.nms.server.logic.SystemRoot;
import com.sanrad.nms.server.logic.VSwitchGroup;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class VSwitchGroupValidator
extends LogicObjectValidator {
    private SiteImpl m_parent;
    private String m_alias;

    protected VSwitchGroupValidator(SiteImpl parent, String alias) {
        this.m_parent = parent;
        this.m_alias = alias;
    }

    protected abstract ArrayList getPotentialSiblings() throws RemoteException;

    protected boolean isValid() throws RemoteException {
        Iterator iter = this.getPotentialSiblings().iterator();
        while (iter.hasNext()) {
            VSwitchGroup vSwitchGroup = (VSwitchGroup)iter.next();
            if (!vSwitchGroup.getAlias().equals(this.getAlias())) continue;
            StringBuffer msg = new StringBuffer(vSwitchGroup.getClassId().toString());
            msg.append(" with alias ");
            msg.append(this.getAlias());
            msg.append(" is already exists in ");
            if (!(this.getParent() instanceof SystemRoot)) {
                msg.append(this.getParent().getClassId());
                msg.append(" ");
            }
            msg.append(this.getParent());
            msg.append(". Please selecet another alias");
            this.setErrorMsg(msg.toString());
            return false;
        }
        return true;
    }

    protected SiteImpl getParent() {
        return this.m_parent;
    }

    protected String getAlias() {
        return this.m_alias;
    }
}

