/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.PollingElement;
import com.sanrad.nms.server.logic.Site;
import com.sanrad.nms.server.logic.SiteImpl;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.VSwitchGroup;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public abstract class VSwitchGroupImpl
extends SynchronizeableImpl
implements VSwitchGroup,
PollingElement {
    private static List parameterCodeList;
    private SiteImpl m_siteParent = null;

    protected VSwitchGroupImpl(ClassID classId) throws RemoteException {
        super(classId, parameterCodeList);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        this.toStringValue = this.getAlias();
        CommKeyClassId siteCommKeyClassId = (CommKeyClassId)changedValues.get(ParameterCode.PARENT_SITE_ID);
        if (siteCommKeyClassId != null) {
            SiteImpl newParentSite = (SiteImpl)SystemRootImpl.getInstance().getRefByStub(siteCommKeyClassId);
            this.setParentSite(newParentSite);
        }
        return changedValues;
    }

    public Integer getVSwitchGroupId() throws RemoteException {
        return (Integer)this.getSrValueOf(null, ParameterCode.VSWITCH_GROUP_ID).value();
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    protected String canBeSynchronized() throws RemoteException {
        return null;
    }

    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        throw new UnsupportedOperationException();
    }

    private void setParentSite(SiteImpl site) throws RemoteException {
        if (this.m_siteParent != null) {
            this.m_siteParent.removeVSwitchGroup(this);
        }
        this.m_siteParent = site;
        this.m_siteParent.addVSwitchGroup(this);
    }

    public Site getParentSite() throws RemoteException {
        return this.m_siteParent;
    }

    public SrInteger getIntervalValue(ParameterCode pollIntervalParam, VSwitch vSwitch) throws RemoteException {
        SrInteger interval;
        Parameter pollInterval = this.getParameter((VSwitch)null, pollIntervalParam);
        if (pollInterval != null && (interval = (SrInteger)pollInterval.getValue()) != null && !interval.equals(0)) {
            return interval;
        }
        return null;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
        this.m_siteParent.addPropagationStateDependentObjectAndListener(this);
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.VSWITCH_GROUP_ID);
        parameterCodes.addElement(ParameterCode.PARENT_SITE_ID);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

