/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.DrAlarmMgrImpl;
import com.sanrad.nms.server.event.SrClusterDiscoveryCompletedEvent;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.EventServiceImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicMgr;
import com.sanrad.nms.server.logic.Site;
import com.sanrad.nms.server.logic.SiteImpl;
import com.sanrad.nms.server.logic.SystemRoot;
import com.sanrad.nms.server.logic.VSwitchGroup;
import com.sanrad.nms.server.logic.VSwitchGroupImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRRoot;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.DataBaseCommKey;
import com.sanrad.nms.server.util.FileInterface;
import com.sanrad.nms.server.util.FileInterfaceImpl;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.util.MultipleReadersSingleWriterLock;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class SystemRootImpl
extends SiteImpl
implements SystemRoot {
    private static int NO_INFO = 0;
    private static int ERROR = 1;
    private static int INFO = 2;
    private static SystemRootImpl theInstance = null;
    private Hashtable invalidNeighbors = new Hashtable();
    private static int NEXT_VSWITCH_GROUP_ID = 0;
    private static final int ROOT_ID = -1;
    private boolean m_siteSynchAfterDiscovery = false;
    private DRRootImpl drRoot;
    private boolean m_isDBDiscoveryCompleted = false;
    private MultipleReadersSingleWriterLock m_drAndClustersSynchronizationLock;
    private FileInterfaceImpl m_fileInterface = null;
    private Object m_alaramsUpdateLock = new Object();

    private SystemRootImpl() throws RemoteException, IllegalValueException {
        this.toStringValue = "System root";
        this.setVSwitchGroupIdAndCommKey();
        this.m_drAndClustersSynchronizationLock = new MultipleReadersSingleWriterLock();
        this.drRoot = DRRootImpl.getInstance();
        this.setFileInterfaceSupport();
    }

    private void setVSwitchGroupIdAndCommKey() throws RemoteException {
        CommKey[] rootCommKeys = new CommKey[]{new DataBaseCommKey(Integer.toString(-1))};
        this.setCommKeys(rootCommKeys);
        HashMap<ParameterCode, SrInteger> parameterList = new HashMap<ParameterCode, SrInteger>();
        parameterList.put(ParameterCode.VSWITCH_GROUP_ID, new SrInteger(-1));
        try {
            this.setParameterList(parameterList);
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
        }
    }

    public static SystemRootImpl getInstance() {
        if (theInstance == null) {
            try {
                theInstance = new SystemRootImpl();
            }
            catch (RemoteException re) {
                logger.error(re);
            }
            catch (IllegalValueException ive) {
                logger.warning(ive.getMessage());
            }
        }
        return theInstance;
    }

    public Object getAlarmsUpdateLock() {
        return this.m_alaramsUpdateLock;
    }

    public Object getRefByStub(CommKey[] commKeys, ClassID classId) throws RemoteException {
        Object ret;
        block2: {
            Site site;
            if (classId.equals(ClassID.CLUSTER) || classId.equals(ClassID.SITE)) {
                return LogicMgr.getVSwitchGroupByCommKeyClassId(commKeys, classId);
            }
            ret = this.findRefByStubInSite(this, commKeys, classId);
            if (ret != null) break block2;
            Iterator i = this.getSiteChildren().iterator();
            while (i.hasNext() && (ret = this.findRefByStubInSite(site = (Site)i.next(), commKeys, classId)) == null) {
            }
        }
        return ret;
    }

    private Object findRefByStubInSite(Site site, CommKey[] commKeys, ClassID classId) throws RemoteException {
        Iterator iter = site.getClusters().iterator();
        while (iter.hasNext()) {
            Cluster cluster = (Cluster)iter.next();
            Object obj = cluster.getCommKeyRefMap().getRefByCommKeyClassID(commKeys, classId);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public Object getRefByStub(CommKeyClassId data) throws RemoteException {
        return this.getRefByStub(data.getCommKeys(), data.getClassID());
    }

    public Cluster getClusterOfVSwitch(String vSwitchIp) throws RemoteException {
        Iterator i = this.getClustersRecursively().iterator();
        while (i.hasNext()) {
            ClusterImpl cluster = (ClusterImpl)i.next();
            if (!cluster.isContainVSwitch(vSwitchIp)) continue;
            return cluster;
        }
        return null;
    }

    public void sendEventToAllClusters(SrClusterDiscoveryCompletedEvent event) throws RemoteException {
        super.sendEventToAllClusters(event);
        if (this.getClustersRecursively().isEmpty()) {
            SystemRootImpl.setStatusReady();
            System.out.println("SystemDiscoveryCompletedEvent was sent to client");
            EventServiceImpl.getInstance().fireSystemDiscoveryCompleted(new ElementEventImpl(this, this));
        }
    }

    public VSwitchGroup changeVSwitchGroup(ConfigElementData ced) throws RemoteException, IllegalValueException {
        VSwitchGroup vSwitchGroup = LogicMgr.getVSwitchGroupByCommKeyClassId(ced.getCommKey(), ced.getClassId());
        HashMap parametersList = ced.getParametersList();
        HashMap changedValues = ((VSwitchGroupImpl)vSwitchGroup).setParameterList(parametersList);
        ElementEventImpl elementEvent = new ElementEventImpl(vSwitchGroup, vSwitchGroup);
        elementEvent.setParameterList(changedValues);
        EventServiceImpl.getInstance().fireElementChanged(elementEvent);
        StringBuffer debugMsg = new StringBuffer(vSwitchGroup.getClassId().toString());
        debugMsg.append(" ");
        debugMsg.append(vSwitchGroup);
        debugMsg.append(" was changed");
        logger.info(debugMsg.toString());
        return vSwitchGroup;
    }

    public VSwitchGroupImpl removeVSwitchGroup(ConfigElementData ced) throws RemoteException, IllegalValueException {
        VSwitchGroupImpl vSwitchGroup = (VSwitchGroupImpl)LogicMgr.getVSwitchGroupByCommKeyClassId(ced.getCommKey(), ced.getClassId());
        if (ClassID.CLUSTER.equals(vSwitchGroup.getClassId())) {
            ((ClusterImpl)vSwitchGroup).stopQueueConsumerThread();
        }
        AlarmMgrImpl.getInstance().removeAlarmList(vSwitchGroup);
        DrAlarmMgrImpl.getInstance().removeAlarmList(vSwitchGroup);
        LogicMgr.removeVSwitchGroup(vSwitchGroup);
        ((SiteImpl)vSwitchGroup.getParentSite()).removeVSwitchGroup(vSwitchGroup);
        this.drRoot.invokeAndWait(vSwitchGroup, 3);
        this.removePropagationStateDependentObjectAndListener(vSwitchGroup);
        ElementEventImpl elementEvent = new ElementEventImpl(vSwitchGroup, vSwitchGroup);
        EventServiceImpl.getInstance().fireElementRemove(elementEvent);
        StringBuffer debugMsg = new StringBuffer(vSwitchGroup.getClassId().toString());
        debugMsg.append(" ");
        debugMsg.append(this.cluster);
        debugMsg.append(" was removed");
        logger.info(debugMsg.toString());
        return vSwitchGroup;
    }

    public boolean isVSwitchAlreadyManaged(String ip) throws RemoteException {
        return this.getClusterOfVSwitch(ip) != null;
    }

    public void notifyDRDiscoveryCompleted() throws RemoteException {
        System.out.println("SystemDiscoveryCompletedEvent was sent to client");
        EventServiceImpl.getInstance().fireSystemDiscoveryCompleted(new ElementEventImpl(this, this));
    }

    public synchronized void notifyClusterDiscoveryCompleted(ClusterImpl cluster) throws RemoteException {
        SystemRootImpl.setStatusMsg("Cluster " + cluster + " discovery completed", INFO);
        Enumeration<Object> e = cluster.getVSwitches().elements();
        while (e.hasMoreElements()) {
            String invalidIp;
            VSwitchImpl vSwitch = (VSwitchImpl)e.nextElement();
            if (vSwitch.isNeighborValid() || this.invalidNeighbors.containsKey(invalidIp = vSwitch.getInvalidNeighborIp())) continue;
            String vSwitchIp = vSwitch.getMgmIPAddr();
            this.invalidNeighbors.put(vSwitchIp, invalidIp);
            logger.debug(ClassID.VSWITCH + " " + invalidIp + " is invalid neighbor of " + vSwitchIp + " they belong to different clusters");
        }
        if (!this.isDiscoverCompleted()) {
            return;
        }
        SystemRootImpl.setStatusReady();
        e = this.invalidNeighbors.keys();
        while (e.hasMoreElements()) {
            String vSwitchIp = (String)e.nextElement();
            VSwitchImpl vSwitch = (VSwitchImpl)this.getVSwitchByIPAddress(vSwitchIp);
            String invalidNeighbor = (String)this.invalidNeighbors.get(vSwitchIp);
            ClusterImpl cl = (ClusterImpl)this.getClusterOfVSwitch(invalidNeighbor);
            if (cl == null) continue;
            VSwitchImpl invalidVSwitch = (VSwitchImpl)cl.getVSwitchByIPAddress(invalidNeighbor);
            try {
                logger.debug("Trying to move " + invalidVSwitch + " from cluster " + cl + " to cluster " + vSwitch.getCluster());
                invalidVSwitch.moveToCluster(vSwitch.getCluster().getVSwitchGroupId());
            }
            catch (IllegalValueException ive) {
                logger.warning(ive);
            }
        }
        this.invalidNeighbors.clear();
        if (!this.m_siteSynchAfterDiscovery) {
            this.m_siteSynchAfterDiscovery = true;
            this.synchronizeSitesForDRPurpose();
        }
    }

    private void synchronizeSitesForDRPurpose() throws RemoteException {
        ArrayList allSites = this.getSites();
        ArrayList allClusters = new ArrayList();
        for (int index = 0; index < allSites.size(); ++index) {
            SiteImpl site = (SiteImpl)allSites.get(index);
            allClusters.addAll(site.getClusters());
        }
        for (int index1 = 0; index1 < allClusters.size(); ++index1) {
            ClusterImpl currentCluster = (ClusterImpl)allClusters.get(index1);
            currentCluster.synchronizeForDRPurpose();
        }
    }

    public VSwitch getVSwitchByIPAddress(String vSwitchIp) throws RemoteException {
        Iterator i = this.getClustersRecursively().iterator();
        while (i.hasNext()) {
            ClusterImpl cluster = (ClusterImpl)i.next();
            VSwitch vSwitch = cluster.getVSwitchByIPAddress(vSwitchIp);
            if (vSwitch == null) continue;
            return vSwitch;
        }
        return null;
    }

    public static void setStatusReady() {
        SystemRootImpl.setStatusMsg("Ready", INFO);
    }

    public static void setStatusInProcess(String processMsg) {
        SystemRootImpl.setStatusMsg(processMsg, "In process...", NO_INFO);
    }

    public static void addToStatusMessage(String addMsg) {
        StringBuffer msg = new StringBuffer(addMsg);
        msg.append(addMsg);
        SystemRootImpl.setStatusInProcess(msg.toString());
    }

    public String getAlias() throws RemoteException {
        return this.toStringValue;
    }

    public static void setStatusError(String errorMsg) {
        SystemRootImpl.setStatusMsg(errorMsg, ERROR);
    }

    private static void setStatusMsg(String msg, int level) {
        SystemRootImpl.setStatusMsg(msg, msg, level);
    }

    private static void setStatusMsg(String msg, String trayIconMsg, int level) {
        System.out.println(level + " " + msg);
    }

    public DRRoot getDRRoot() throws RemoteException {
        return this.drRoot;
    }

    public synchronized int getNextVSwitchGroupId() throws RemoteException {
        Iterator i = this.getAllVSwitchGroups().iterator();
        while (i.hasNext()) {
            VSwitchGroup vSwitchGroup = (VSwitchGroup)i.next();
            int vSwitchGroupId = vSwitchGroup.getVSwitchGroupId();
            NEXT_VSWITCH_GROUP_ID = Math.max(NEXT_VSWITCH_GROUP_ID, vSwitchGroupId);
        }
        int retVal = ++NEXT_VSWITCH_GROUP_ID;
        return retVal;
    }

    public ArrayList getAllVSwitchGroups() throws RemoteException {
        ArrayList allVSwitchGroups = new ArrayList(this.getVSwitchGroups());
        Iterator iter = this.getVSwitchGroups().iterator();
        while (iter.hasNext()) {
            VSwitchGroup vSwitchGroup = (VSwitchGroup)iter.next();
            if (!vSwitchGroup.getClassId().equals(ClassID.SITE)) continue;
            allVSwitchGroups.addAll(((Site)vSwitchGroup).getVSwitchGroups());
        }
        return allVSwitchGroups;
    }

    public boolean isSiteAliasExists(String alias) throws RemoteException {
        Iterator iter = this.getSites().iterator();
        while (iter.hasNext()) {
            Site site = (Site)iter.next();
            if (!site.getAlias().equals(alias)) continue;
            return true;
        }
        return false;
    }

    public boolean isDiscoverCompleted() throws RemoteException {
        if (!this.m_isDBDiscoveryCompleted) {
            return false;
        }
        ArrayList vSwitchGroups = this.getVSwitchGroups();
        for (int i = 0; i < vSwitchGroups.size(); ++i) {
            VSwitchGroup currVSwitchGroup = (VSwitchGroup)vSwitchGroups.get(i);
            if (currVSwitchGroup.isDiscoverCompleted()) continue;
            return false;
        }
        return true;
    }

    public TargetImpl getTarget(String targetName) throws RemoteException {
        Iterator i = this.getClustersRecursively().iterator();
        while (i.hasNext()) {
            ClusterImpl currCluster = (ClusterImpl)i.next();
            TargetImpl target = (TargetImpl)currCluster.getTargetListMgr().getTargetByName(targetName);
            if (target == null) continue;
            return target;
        }
        return null;
    }

    public void setDBDiscoveryCompleted() {
        this.m_isDBDiscoveryCompleted = true;
    }

    public MultipleReadersSingleWriterLock getDRAndClustersSynchronizationLock() {
        return this.m_drAndClustersSynchronizationLock;
    }

    public void exportConfigurationFile() throws RemoteException {
        StringBuffer pathToXmlDirectory = new StringBuffer();
        pathToXmlDirectory.append(Util.getLocalDir());
        pathToXmlDirectory.append('\\');
        pathToXmlDirectory.append(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SERVER_CONFIG_DIR_NAME));
        try {
            this.compressFiles(pathToXmlDirectory.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void importConfigurationFile() throws RemoteException {
    }

    private void compressFiles(String pathToXmlDirectory) throws IOException {
        StringBuffer sb = new StringBuffer(pathToXmlDirectory);
        sb.append('\\');
        sb.append(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.EXPORT_CONFIGURATION_FILE_NAME));
        String zipName = sb.toString();
        BufferedInputStream origin = null;
        int BUFFER = 2048;
        byte[] data = new byte[2048];
        FileOutputStream dest = new FileOutputStream(zipName);
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
        File dir = new File(pathToXmlDirectory);
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            int count;
            if (!files[i].toString().endsWith(".xml")) continue;
            FileInputStream fi = new FileInputStream(files[i]);
            origin = new BufferedInputStream(fi, 2048);
            ZipEntry entry = new ZipEntry(files[i].getName());
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 2048)) != -1) {
                out.write(data, 0, count);
            }
            origin.close();
        }
        out.close();
    }

    private void setFileInterfaceSupport() {
        try {
            this.m_fileInterface = new FileInterfaceImpl();
        }
        catch (RemoteException re) {
            logger.error("FileServer: " + re.getMessage(), re);
        }
    }

    public FileInterface getFileInterface() throws RemoteException {
        return this.m_fileInterface;
    }
}

