/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.logic.AliasObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SynchronizeEvent;
import com.sanrad.nms.server.logic.SynchronizeListener;
import com.sanrad.nms.server.logic.Synchronizeable;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.util.ClassID;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public abstract class SynchronizeableImpl
extends AliasObjectImpl
implements Synchronizeable {
    private Vector listeners = new Vector();
    private boolean synchronizePending = false;
    public static final int SYNC_STATUS_END_OK = 0;
    public static final int SYNC_STATUS_ALREADY_SYNCHING = 1;
    public static final int SYNC_STATUS_WAITING_TO_SNMP_COMPLETION = 2;
    public static final int SYNC_STATUS_ERROR = 3;

    protected SynchronizeableImpl(ClusterImpl cluster, ClassID classId, List parameterCodeList) throws RemoteException {
        super(cluster, classId, parameterCodeList);
    }

    protected SynchronizeableImpl(ClassID classId, List parameterCodeList) throws RemoteException {
        super(classId, parameterCodeList);
    }

    protected SynchronizeableImpl(ClassID classId) throws RemoteException {
        super(classId);
    }

    public void addSynchronizeListener(SynchronizeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeSynchronizeListener(SynchronizeListener listener) {
        this.listeners.removeElement(listener);
    }

    public boolean isSynchronizePending() {
        return this.synchronizePending;
    }

    protected void setSynchronizePending(boolean pending) {
        this.synchronizePending = pending;
    }

    public synchronized void syncDataWasChanged() throws RemoteException, IllegalValueException {
        LogMgr.getServerLog().info("syncDataWasChanged called  " + this.toString());
        this.doneSynchronizing();
    }

    public void doneSynchronizing() throws RemoteException {
        this.setSynchronizePending(false);
        this.setSynchronizingMode(false);
        this.fireSynchronizeCompleted();
    }

    protected void fireSynchronizeCompleted() throws RemoteException {
        logger.debug(this.getClassId() + " " + this + " has completed synchronizing");
        if (!this.listeners.isEmpty()) {
            SynchronizeEvent event = new SynchronizeEvent(this);
            Enumeration e = this.listeners.elements();
            while (e.hasMoreElements()) {
                ((SynchronizeListener)e.nextElement()).synchronizingCompleted(event);
            }
        }
    }

    public void errorInSynchronizing() {
        if (this.isSynchronizePending()) {
            this.setSynchronizePending(false);
            try {
                this.fireSynchronizeError();
            }
            catch (RemoteException re) {
                LogMgr.getServerLog().error("Failed to Fire Sync Error", re);
            }
        }
    }

    protected void fireSynchronizeError() throws RemoteException {
        logger.debug(this.getClassId() + " " + this + " has Error while synchronizing");
        if (!this.listeners.isEmpty()) {
            Enumeration e = this.listeners.elements();
            while (e.hasMoreElements()) {
                ((SynchronizeListener)e.nextElement()).errorInSynchronizing();
            }
        }
    }

    public boolean isNeedToSynchronize() throws RemoteException {
        return this.cluster.getVSwitches().size() > this.getConnectedVSwitchCounter();
    }

    protected abstract int synchronizeMe() throws RemoteException, IllegalValueException;

    protected String canBeSynchronized() throws RemoteException, IllegalValueException {
        return null;
    }

    public synchronized void internalSynchronize() throws RemoteException, IllegalValueException {
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        logger.debug("Checking synchronizing for " + this.getClassId() + " " + this.toString());
        if (this.isNeedToSynchronize()) {
            if (!this.isSynchronizePending()) {
                this.setSynchronizePending(true);
                String msg = this.canBeSynchronized();
                if (msg == null) {
                    logger.debug("Begin synchronizing " + this.getClassId() + " " + this.toString());
                    int syncMeRetVal = this.synchronizeMe();
                    if (syncMeRetVal == 3) {
                        this.setSynchronizePending(false);
                    }
                    return syncMeRetVal;
                }
                logger.debug(msg);
                this.setSynchronizePending(false);
                return 3;
            }
            return 1;
        }
        return 0;
    }
}

