/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.event.PropagatedStateEvent;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.event.SrClusterDiscoveryCompletedEvent;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.EventServiceImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.Site;
import com.sanrad.nms.server.logic.SiteValidator;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.VSwitchGroup;
import com.sanrad.nms.server.logic.VSwitchGroupImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.ClusterValidator;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRActivate;
import com.sanrad.nms.server.logic.dr.DRLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchValidator;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.SrDouble;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class SiteImpl
extends VSwitchGroupImpl
implements Site {
    private ArrayList m_vSwitchGroups = new ArrayList();
    private Hashtable m_waitingVSwitches = new Hashtable();
    protected static boolean clustersDiscoveryCompleted = false;
    private String msg = null;
    public static final int DEFAULT_GENERAL_POLL_INTERVAL = 1;
    public static final int DEFAULT_VIRTUALIZATION_POLL_INTERVAL = 1;
    public static final int DEFAULT_ACL_POLL_INTERVAL = 1;
    public static final int DEFAULT_NETWORKING_POLL_INTERVAL = 1;
    public static final double DEFAULT_STATISTIC_POLL_INTERVAL = 0.16666666666666666;
    private static final HashMap pollingParametersDefaultValues = new HashMap();

    public SiteImpl() throws RemoteException, IllegalValueException {
        super(ClassID.SITE);
        this.addParameterCode(ParameterCode.SITE_ALIAS);
        Iterator iter = pollingParametersDefaultValues.keySet().iterator();
        while (iter.hasNext()) {
            ParameterCode code = (ParameterCode)iter.next();
            this.setOneParameter(code, pollingParametersDefaultValues.get(code), null);
        }
    }

    public AlarmGenerator getAlarmGenerator() {
        throw new UnsupportedOperationException();
    }

    public void registerToPropagatedStateChange() throws RemoteException {
        throw new UnsupportedOperationException();
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        String alias = (String)parameterList.get(ClientParameterCode.SITE_ALIAS);
        if (alias != null) {
            if (alias.equals("")) {
                return "Alias cannot be empty";
            }
            if (SystemRootImpl.getInstance().isSiteAliasExists(alias)) {
                return "Alias " + alias + " already exists in " + SystemRootImpl.getInstance() + ". Please select a different alias for " + this.getClassId() + " " + this + ".";
            }
            parameterList.put(ClientParameterCode.SITE_ALIAS, new SrString(alias));
        }
        return null;
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    public ArrayList getVSwitchGroups() throws RemoteException {
        return this.m_vSwitchGroups;
    }

    public Vector getListCommKeysSameTypeOf(ClassID classId, CommKeyClassId vSwitchData) throws RemoteException {
        return this.getAllCommKeysByClassID(classId, vSwitchData, true);
    }

    public Vector getListOfCommKeys(ClassID classId, CommKeyClassId vSwitchData) throws RemoteException {
        return this.getAllCommKeysByClassID(classId, vSwitchData, false);
    }

    private Vector getAllCommKeysByClassID(ClassID classId, CommKeyClassId vSwitchData, boolean getAllOfSameType) throws RemoteException {
        ArrayList clusters = this.getClustersRecursively();
        Iterator i = clusters.iterator();
        while (i.hasNext()) {
            ClusterImpl cluster = (ClusterImpl)i.next();
            Vector list = null;
            list = getAllOfSameType ? cluster.getCommKeyRefMap().getListCommKeysSameTypeOf(classId, vSwitchData) : cluster.getCommKeyRefMap().getListOfCommKeys(classId, vSwitchData);
            if (list == null) continue;
            return list;
        }
        return null;
    }

    public ArrayList getSiteChildren() throws RemoteException {
        ArrayList<VSwitchGroup> children = new ArrayList<VSwitchGroup>();
        Iterator iter = this.getVSwitchGroups().iterator();
        while (iter.hasNext()) {
            VSwitchGroup vSwitchGroup = (VSwitchGroup)iter.next();
            if (!vSwitchGroup.getClassId().equals(ClassID.SITE)) continue;
            children.add(vSwitchGroup);
        }
        return children;
    }

    public ArrayList getClusters() throws RemoteException {
        ArrayList<VSwitchGroup> clusters = new ArrayList<VSwitchGroup>();
        Iterator i = this.getVSwitchGroups().iterator();
        while (i.hasNext()) {
            VSwitchGroup vSwitchGroup = (VSwitchGroup)i.next();
            if (!vSwitchGroup.getClassId().equals(ClassID.CLUSTER)) continue;
            clusters.add(vSwitchGroup);
        }
        return clusters;
    }

    public ArrayList getClustersRecursively() throws RemoteException {
        ArrayList<VSwitchGroup> clusters = new ArrayList<VSwitchGroup>();
        Iterator i = this.getVSwitchGroups().iterator();
        while (i.hasNext()) {
            VSwitchGroup vSwitchGroup = (VSwitchGroup)i.next();
            if (vSwitchGroup.getClassId().equals(ClassID.CLUSTER)) {
                clusters.add(vSwitchGroup);
                continue;
            }
            if (!vSwitchGroup.getClassId().equals(ClassID.SITE)) continue;
            clusters.addAll(((SiteImpl)vSwitchGroup).getClustersRecursively());
        }
        return clusters;
    }

    public ArrayList getClustersInOtherSites(Site site) throws RemoteException {
        ArrayList allClustersInSystem = this.getClustersRecursively();
        ArrayList clustersInSite = site.getClusters();
        allClustersInSystem.removeAll(clustersInSite);
        return allClustersInSystem;
    }

    public ArrayList getSites() throws RemoteException {
        ArrayList<VSwitchGroup> sites = new ArrayList<VSwitchGroup>();
        Iterator i = this.getVSwitchGroups().iterator();
        while (i.hasNext()) {
            VSwitchGroup vSwitchGroup = (VSwitchGroup)i.next();
            if (!vSwitchGroup.getClassId().equals(ClassID.SITE)) continue;
            sites.add(vSwitchGroup);
        }
        return sites;
    }

    public VSwitchGroup getVSwitchGroup(Integer id) throws RemoteException {
        Iterator i = this.m_vSwitchGroups.iterator();
        while (i.hasNext()) {
            VSwitchGroup vg;
            VSwitchGroupImpl vSwitchGroup = (VSwitchGroupImpl)i.next();
            if (vSwitchGroup.getVSwitchGroupId().compareTo(id) == 0) {
                return vSwitchGroup;
            }
            if (!vSwitchGroup.getClassId().equals(ClassID.SITE) || (vg = ((SiteImpl)vSwitchGroup).getVSwitchGroup(id)) == null) continue;
            return vg;
        }
        return null;
    }

    public void createCluster(String alias) throws RemoteException, IllegalValueException {
        this.createCluster(alias, false);
    }

    public void createSite(String alias) throws RemoteException, IllegalValueException {
        SiteValidator validator = new SiteValidator(this, alias);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ConfigElementData element = new ConfigElementData(ClassID.SITE);
        element.addParameter(new Parameter(ParameterCode.SITE_ALIAS, new SrString(alias)));
        this.createVSwitcGroup(element);
    }

    private SrType getPollingInterval(ParameterCode intervalParameterCode) throws RemoteException {
        Parameter pollInterval = this.getParameter((VSwitch)null, intervalParameterCode);
        if (pollInterval != null) {
            return (SrType)pollInterval.getValue();
        }
        return null;
    }

    private void addPollingInterval(ConfigElementData element, ParameterCode intervalParameterCode) throws RemoteException {
        SrType pollIntervalValue = this.getPollingInterval(intervalParameterCode);
        if (pollIntervalValue != null) {
            element.setValue(intervalParameterCode, pollIntervalValue);
        }
    }

    private void addPollingInterval(HashMap map, ParameterCode intervalParameterCode) throws RemoteException {
        SrType pollIntervalValue = this.getPollingInterval(intervalParameterCode);
        if (pollIntervalValue != null) {
            map.put(intervalParameterCode, pollIntervalValue);
        }
    }

    private void createVSwitcGroup(ConfigElementData element) throws RemoteException {
        int id = SystemRootImpl.getInstance().getNextVSwitchGroupId();
        element.addParameter(new Parameter(ParameterCode.VSWITCH_GROUP_ID, new SrInteger(id)));
        element.setValue(ParameterCode.PARENT_SITE_ID, this.getCommKeyClassId());
        Iterator iter = pollingParametersDefaultValues.keySet().iterator();
        while (iter.hasNext()) {
            ParameterCode code = (ParameterCode)iter.next();
            this.addPollingInterval(element, code);
        }
        DataMgr.getInstance().createElement(element);
    }

    private void createCluster(String alias, boolean singleVSwitch) throws RemoteException, IllegalValueException {
        ClusterValidator validator = new ClusterValidator(this, alias);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ConfigElementData element = new ConfigElementData(ClassID.CLUSTER);
        element.addParameter(new Parameter(ParameterCode.CLUSTER_ALIAS, new SrString(alias)));
        element.addParameter(new Parameter(ParameterCode.CLUSTER_MODE, new SrBoolean(singleVSwitch)));
        this.createVSwitcGroup(element);
    }

    public void addVSwitchGroup(VSwitchGroupImpl vSwitchGroup) throws RemoteException {
        if (!this.m_vSwitchGroups.contains(vSwitchGroup)) {
            this.m_vSwitchGroups.add(vSwitchGroup);
        }
        if (vSwitchGroup.getClassId().equals(ClassID.CLUSTER)) {
            this.addVSwitchIfClusterWaiting((Cluster)((Object)vSwitchGroup));
        }
        this.addPropagationStateDependentObjectAndListener(vSwitchGroup);
        this.setPropagatedState(vSwitchGroup.getPropagatedState());
    }

    public void removeVSwitchGroup(VSwitchGroup vSwitchGroup) throws RemoteException {
        this.m_vSwitchGroups.remove(vSwitchGroup);
        this.removePropagationStateDependentObjectAndListener((VSwitchGroupImpl)vSwitchGroup);
        ((VSwitchGroupImpl)vSwitchGroup).clear();
    }

    public void clear() throws RemoteException {
        ArrayList vswitchGroups = this.getVSwitchGroups();
        Iterator iter = vswitchGroups.iterator();
        while (iter.hasNext()) {
            VSwitchGroupImpl vswitchGroup = (VSwitchGroupImpl)iter.next();
            vswitchGroup.clear();
        }
        if (this.m_waitingVSwitches != null) {
            this.m_waitingVSwitches.clear();
        }
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public String getAlias() throws RemoteException {
        return (String)this.getValueOf(null, ParameterCode.SITE_ALIAS);
    }

    public void addVSwitch(String ipAddr, String mask, int snmpPort, int trapPort, String readCommunity, String writeCommunity, long timeout, int numberOfRetries, SnmpVersion snmpVersion) throws RemoteException, IllegalValueException {
        VSwitchValidator validator = new VSwitchValidator(null, ipAddr, mask, readCommunity, writeCommunity);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        HashMap<ParameterCode, Object> parameters = new HashMap<ParameterCode, Object>();
        parameters.put(ParameterCode.VSWITCH_IP_MASK, mask);
        parameters.put(ParameterCode.VSWITCH_SNMP_UDP_PORT, new Integer(snmpPort));
        parameters.put(ParameterCode.VSWITCH_TRAP_UDP_PORT, new Integer(trapPort));
        parameters.put(ParameterCode.VSWITCH_READ_COMMUNITY, readCommunity);
        parameters.put(ParameterCode.VSWITCH_WRITE_COMMUNITY, writeCommunity);
        parameters.put(ParameterCode.VSWITCH_TIMEOUT, new Long(timeout));
        parameters.put(ParameterCode.VSWITCH_MAX_RETRIES, new Integer(numberOfRetries));
        parameters.put(ParameterCode.VSWITCH_SNMP_VERSION, snmpVersion);
        Iterator iter = pollingParametersDefaultValues.keySet().iterator();
        while (iter.hasNext()) {
            ParameterCode code = (ParameterCode)iter.next();
            this.addPollingInterval(parameters, code);
        }
        this.m_waitingVSwitches.put(ipAddr, parameters);
        this.createCluster(ipAddr, true);
    }

    private void addVSwitchIfClusterWaiting(Cluster cluster) throws RemoteException {
        String vSwitchIp = cluster.getAlias();
        HashMap parameters = (HashMap)this.m_waitingVSwitches.get(vSwitchIp);
        if (parameters != null) {
            String mask = (String)parameters.get(ParameterCode.VSWITCH_IP_MASK);
            Integer snmpPort = (Integer)parameters.get(ParameterCode.VSWITCH_SNMP_UDP_PORT);
            Integer trapPort = (Integer)parameters.get(ParameterCode.VSWITCH_TRAP_UDP_PORT);
            String readCommunity = (String)parameters.get(ParameterCode.VSWITCH_READ_COMMUNITY);
            String writeCommunity = (String)parameters.get(ParameterCode.VSWITCH_WRITE_COMMUNITY);
            Long timeout = (Long)parameters.get(ParameterCode.VSWITCH_TIMEOUT);
            Integer numberOfRetries = (Integer)parameters.get(ParameterCode.VSWITCH_MAX_RETRIES);
            SnmpVersion snmpVersion = (SnmpVersion)parameters.get(ParameterCode.VSWITCH_SNMP_VERSION);
            try {
                cluster.addVSwitch(vSwitchIp, mask, snmpPort, trapPort, readCommunity, writeCommunity, timeout, numberOfRetries, snmpVersion);
                this.m_waitingVSwitches.remove(vSwitchIp);
            }
            catch (IllegalValueException ive) {
                logger.warning(ive.getMessage());
            }
        }
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        Iterator i = this.getVSwitchGroups().iterator();
        if (i.hasNext()) {
            VSwitchGroup vSwitchGroup = (VSwitchGroup)i.next();
            return vSwitchGroup.synchronize();
        }
        return 0;
    }

    public VSwitchGroupImpl newVSwitchGroup(ConfigElementData ced) throws RemoteException, IllegalValueException {
        VSwitchGroupImpl vSwitchGroup = null;
        if (ced.getClassId().equals(ClassID.CLUSTER)) {
            vSwitchGroup = new ClusterImpl();
        } else if (ced.getClassId().equals(ClassID.SITE)) {
            vSwitchGroup = new SiteImpl();
        }
        vSwitchGroup.setParameterList(ced.getParametersList());
        vSwitchGroup.setCommKeys(ced.getCommKey());
        if (ced.getClassId().equals(ClassID.CLUSTER)) {
            ClusterImpl cluster = (ClusterImpl)vSwitchGroup;
            if (clustersDiscoveryCompleted) {
                cluster.notifyClusterDBReadingCompleted();
            }
        }
        ElementEventImpl elementEvent = new ElementEventImpl(vSwitchGroup, vSwitchGroup);
        EventServiceImpl.getInstance().fireElementCreate(elementEvent);
        StringBuffer debugMsg = new StringBuffer(vSwitchGroup.getClassId().toString());
        debugMsg.append(" ");
        debugMsg.append(vSwitchGroup);
        debugMsg.append(" was created");
        logger.info(debugMsg.toString());
        return vSwitchGroup;
    }

    public void sendEventToAllClusters(SrClusterDiscoveryCompletedEvent event) throws RemoteException {
        if (event.getType() == 23) {
            clustersDiscoveryCompleted = true;
        }
        Iterator i = this.getVSwitchGroups().iterator();
        while (i.hasNext()) {
            VSwitchGroupImpl vSwitchGroup = (VSwitchGroupImpl)i.next();
            if (vSwitchGroup.getClassId().equals(ClassID.CLUSTER)) {
                ((ClusterImpl)vSwitchGroup).elementEvent(event);
                continue;
            }
            ((SiteImpl)vSwitchGroup).sendEventToAllClusters(event);
        }
    }

    public void deleteElement() throws RemoteException, IllegalValueException {
        if (this.canBeDeleted() == null) {
            ArrayList clusters = this.getClusters();
            Iterator iter = clusters.iterator();
            while (iter.hasNext()) {
                Cluster cluster = (Cluster)iter.next();
                cluster.deleteElement();
            }
        }
        super.deleteElement();
    }

    public void plannedFailover() throws RemoteException, IllegalValueException {
        ArrayList activateDRObjectsList = SystemRootImpl.getInstance().getDRRoot().getActivateDRObjects();
        DRActivate[] activateDRObjects = new DRActivate[activateDRObjectsList.size()];
        activateDRObjectsList.toArray(activateDRObjects);
        this.plannedFailover(activateDRObjects);
    }

    public void plannedFailover(DRActivate[] activateDRObjects) throws RemoteException, IllegalValueException {
        ArrayList<DRLogicObjectImpl> nullElementObjectsList = new ArrayList<DRLogicObjectImpl>();
        for (int i = 0; i < activateDRObjects.length; ++i) {
            DRActivate currActivateObjectStub = activateDRObjects[i];
            DRLogicObjectImpl currActivateObject = DRRootImpl.getInstance().getRefByStub(currActivateObjectStub.hashKey());
            DRClusterLogicObjectImpl localElement = currActivateObject.getLocalElement();
            if (localElement != null) {
                if (!localElement.getCluster().getParentSite().equals(this)) continue;
                try {
                    currActivateObjectStub.plannedFailover();
                }
                catch (IllegalValueException ive) {
                    this.msg = ive.getMessage();
                    nullElementObjectsList.add(currActivateObject);
                    System.out.println(ive.getMessage());
                }
                continue;
            }
            nullElementObjectsList.add(currActivateObject);
        }
        if (!nullElementObjectsList.isEmpty()) {
            throw new IllegalValueException(this.msg);
        }
    }

    public void startReplicate() throws RemoteException, IllegalValueException {
        ArrayList activateDRObjectsList = SystemRootImpl.getInstance().getDRRoot().getActivateDRObjects();
        DRActivate[] activateDRObjects = new DRActivate[activateDRObjectsList.size()];
        activateDRObjectsList.toArray(activateDRObjects);
        this.startReplicate(activateDRObjects);
    }

    public void startReplicate(DRActivate[] activateDRObjects) throws RemoteException, IllegalValueException {
        logger.debug(this.getClassId().toString() + " " + this + " : activating startReplicate on " + activateDRObjects.length + " DR objects");
        ArrayList<DRLogicObjectImpl> nullElementObjectsList = new ArrayList<DRLogicObjectImpl>();
        for (int i = 0; i < activateDRObjects.length; ++i) {
            DRActivate currActivateObjectStub = activateDRObjects[i];
            DRLogicObjectImpl currActivateObject = DRRootImpl.getInstance().getRefByStub(currActivateObjectStub.hashKey());
            DRClusterLogicObjectImpl element = (DRClusterLogicObjectImpl)currActivateObject.getClusterElementAccordingToMode();
            if (element != null) {
                if (!element.getCluster().getParentSite().equals(this)) continue;
                try {
                    currActivateObjectStub.startReplicate();
                }
                catch (IllegalValueException ive) {
                    this.msg = ive.getMessage();
                    nullElementObjectsList.add(currActivateObject);
                }
                continue;
            }
            nullElementObjectsList.add(currActivateObject);
        }
        if (!nullElementObjectsList.isEmpty()) {
            throw new IllegalValueException(this.msg);
        }
    }

    public void abortReplicate() throws RemoteException, IllegalValueException {
        ArrayList activateDRObjectsList = SystemRootImpl.getInstance().getDRRoot().getActivateDRObjects();
        DRActivate[] activateDRObjects = new DRActivate[activateDRObjectsList.size()];
        activateDRObjectsList.toArray(activateDRObjects);
        this.abortReplicate(activateDRObjects);
    }

    public void abortReplicate(DRActivate[] activateDRObjects) throws RemoteException, IllegalValueException {
        boolean isArrayEmpty = true;
        if (activateDRObjects == null || activateDRObjects.length == 0) {
            throw new IllegalValueException(" There is no active pairs on this site");
        }
        logger.debug(this.getClassId().toString() + " " + this + " : activating abortReplicate on " + activateDRObjects.length + " DR objects");
        ArrayList<DRLogicObjectImpl> nullElementObjectsList = new ArrayList<DRLogicObjectImpl>();
        for (int i = 0; i < activateDRObjects.length; ++i) {
            DRActivate currActivateObjectStub = activateDRObjects[i];
            DRLogicObjectImpl currActivateObject = DRRootImpl.getInstance().getRefByStub(currActivateObjectStub.hashKey());
            DRClusterLogicObjectImpl element = (DRClusterLogicObjectImpl)currActivateObject.getClusterElementAccordingToMode();
            if (element != null) {
                if (!element.getCluster().getParentSite().equals(this)) continue;
                try {
                    isArrayEmpty = false;
                    currActivateObjectStub.abortReplicate();
                }
                catch (IllegalValueException ive) {
                    this.msg = ive.getMessage();
                    nullElementObjectsList.add(currActivateObject);
                }
                continue;
            }
            nullElementObjectsList.add(currActivateObject);
        }
        if (!nullElementObjectsList.isEmpty()) {
            throw new IllegalValueException(this.msg);
        }
        if (isArrayEmpty) {
            throw new IllegalValueException("There is no element in this site");
        }
    }

    public void fallback() throws RemoteException, IllegalValueException {
        ArrayList activateDRObjectsList = SystemRootImpl.getInstance().getDRRoot().getActivateDRObjects();
        DRActivate[] activateDRObjects = new DRActivate[activateDRObjectsList.size()];
        activateDRObjectsList.toArray(activateDRObjects);
        this.fallback(activateDRObjects);
    }

    public void fallback(DRActivate[] activateDRObjects) throws RemoteException, IllegalValueException {
        logger.debug(this.getClassId().toString() + " " + this + " : activating fallback on " + activateDRObjects.length + " DR objects");
        ArrayList<DRLogicObjectImpl> nullElementObjectsList = new ArrayList<DRLogicObjectImpl>();
        for (int i = 0; i < activateDRObjects.length; ++i) {
            DRActivate currActivateObjectStub = activateDRObjects[i];
            DRLogicObjectImpl currActivateObject = DRRootImpl.getInstance().getRefByStub(currActivateObjectStub.hashKey());
            DRClusterLogicObjectImpl remoteElement = currActivateObject.getRemoteElement();
            if (remoteElement != null) {
                if (!remoteElement.getCluster().getParentSite().equals(this)) continue;
                try {
                    currActivateObjectStub.fallback();
                }
                catch (IllegalValueException ive) {
                    this.msg = ive.getMessage();
                    nullElementObjectsList.add(currActivateObject);
                }
                continue;
            }
            nullElementObjectsList.add(currActivateObject);
        }
        if (!nullElementObjectsList.isEmpty()) {
            throw new IllegalValueException(this.msg);
        }
    }

    public void disasterOccured() throws RemoteException, IllegalValueException {
        ArrayList activateDRObjectsList = SystemRootImpl.getInstance().getDRRoot().getActivateDRObjects();
        DRActivate[] activateDRObjects = new DRActivate[activateDRObjectsList.size()];
        activateDRObjectsList.toArray(activateDRObjects);
        this.disasterOccured(activateDRObjects);
    }

    public void disasterOccured(DRActivate[] activateDRObjects) throws RemoteException, IllegalValueException {
        int i;
        logger.debug(this.getClassId().toString() + " " + this + " : activating disasterOccured on " + activateDRObjects.length + " DR objects");
        if (activateDRObjects.length == 0) {
            throw new IllegalValueException("There is no element in site");
        }
        ArrayList<DRLogicObjectImpl> nullElementObjectsList = new ArrayList<DRLogicObjectImpl>();
        ArrayList<Cluster> clustersToBeRemoved = new ArrayList<Cluster>();
        for (i = 0; i < activateDRObjects.length; ++i) {
            DRActivate currActivateObjectStub = activateDRObjects[i];
            DRLogicObjectImpl currActivateObject = DRRootImpl.getInstance().getRefByStub(currActivateObjectStub.hashKey());
            DRClusterLogicObjectImpl remoteElement = currActivateObject.getRemoteElement();
            if (remoteElement != null) {
                Cluster localCluster;
                if (!remoteElement.getCluster().getParentSite().equals(this)) continue;
                try {
                    currActivateObjectStub.disasterOccured();
                }
                catch (IllegalValueException ive) {
                    this.msg = ive.getMessage();
                    nullElementObjectsList.add(currActivateObject);
                    continue;
                }
                DRClusterLogicObjectImpl localElement = currActivateObject.getLocalElement();
                if (localElement == null || clustersToBeRemoved.contains(localCluster = localElement.getCluster())) continue;
                clustersToBeRemoved.add(localCluster);
                continue;
            }
            nullElementObjectsList.add(currActivateObject);
        }
        for (i = 0; i < clustersToBeRemoved.size(); ++i) {
            Cluster currCluster = (Cluster)clustersToBeRemoved.get(i);
            if (currCluster.isInDeletionProcess()) continue;
            currCluster.deleteElement();
        }
        if (!nullElementObjectsList.isEmpty()) {
            throw new IllegalValueException(this.msg);
        }
    }

    private StringBuffer getObjectsList(ArrayList list) {
        StringBuffer objectsList = new StringBuffer();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (i != 0) {
                    objectsList.append(", ");
                }
                Object obj = list.get(i);
                objectsList.append(obj + " ");
            }
        }
        return objectsList;
    }

    public void rediscover() throws RemoteException {
        Iterator iter = this.getVSwitchGroups().iterator();
        while (iter.hasNext()) {
            VSwitchGroup vSwitchGroup = (VSwitchGroup)iter.next();
            if (vSwitchGroup.isDiscoverCompleted()) {
                vSwitchGroup.rediscover();
                continue;
            }
            logger.debug(this.getClassId() + " " + vSwitchGroup + " is already rediscovering...");
        }
    }

    public boolean isDiscoverCompleted() throws RemoteException {
        ArrayList allClusters = this.getClustersRecursively();
        for (int i = 0; i < allClusters.size(); ++i) {
            Cluster currCluster = (Cluster)allClusters.get(i);
            if (currCluster.isDiscoverCompleted()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setStateSeverity(AlarmSeverity newState) throws RemoteException {
        Object object = SystemRootImpl.getInstance().getAlarmsUpdateLock();
        synchronized (object) {
            return super.setStateSeverity(newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlarmSeverity getPropagatedState() throws RemoteException {
        Object object = SystemRootImpl.getInstance().getAlarmsUpdateLock();
        synchronized (object) {
            return super.getPropagatedState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlarmSeverity getPropagatedAcknowledgeState() throws RemoteException {
        Object object = SystemRootImpl.getInstance().getAlarmsUpdateLock();
        synchronized (object) {
            return super.getPropagatedAcknowledgeState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAcknowledgeStateSeverity(AlarmSeverity newAckState) throws RemoteException {
        Object object = SystemRootImpl.getInstance().getAlarmsUpdateLock();
        synchronized (object) {
            super.setAcknowledgeStateSeverity(newAckState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropagatedState(AlarmSeverity newPropagatedState) throws RemoteException {
        Object object = SystemRootImpl.getInstance().getAlarmsUpdateLock();
        synchronized (object) {
            super.setPropagatedState(newPropagatedState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagatedStateChanged(PropagatedStateEvent pse) {
        Object object = SystemRootImpl.getInstance().getAlarmsUpdateLock();
        synchronized (object) {
            super.propagatedStateChanged(pse);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Site) {
            try {
                return this.getAlias().equals(((Site)obj).getAlias());
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    static {
        pollingParametersDefaultValues.put(ParameterCode.GENERAL_POLL_INTERVAL, new SrDouble(1.0));
        pollingParametersDefaultValues.put(ParameterCode.VIRTUALIZATION_POLL_INTERVAL, new SrDouble(1.0));
        pollingParametersDefaultValues.put(ParameterCode.ACL_POLL_INTERVAL, new SrDouble(1.0));
        pollingParametersDefaultValues.put(ParameterCode.NET_POLL_INTERVAL, new SrDouble(1.0));
        pollingParametersDefaultValues.put(ParameterCode.STATISTIC_POLL_INTERVAL, new SrDouble(0.16666666666666666));
    }
}

