/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.log.Log;
import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.logic.AliasObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Vector;

public abstract class LogicObjectValidator {
    protected static Log logger = LogMgr.getServerLog();
    protected ClusterImpl cluster = null;
    private String errorMsg = null;

    protected LogicObjectValidator() {
    }

    protected abstract boolean isValid() throws RemoteException;

    protected void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg + ".";
        logger.debug(errorMsg);
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    protected CommKeyClassId[] getVSwitchesAllElementsExistIn(Object elements, Cluster cluster) throws IllegalValueException {
        try {
            Vector vSwitchesToSet = (Vector)cluster.getVSwitches().clone();
            if (elements instanceof Vector) {
                Iterator itr = ((Vector)elements).iterator();
                while (itr.hasNext()) {
                    AliasObjectImpl child = (AliasObjectImpl)itr.next();
                    if (child.isRedundant()) continue;
                    VSwitch[] childVSwitch = child.getConnectedVSwitches();
                    Iterator vSwitches = vSwitchesToSet.iterator();
                    while (vSwitches.hasNext()) {
                        boolean wasFound = false;
                        VSwitch vSwitch = (VSwitch)vSwitches.next();
                        for (int i = 0; i < childVSwitch.length; ++i) {
                            if (!childVSwitch[i].equals(vSwitch)) continue;
                            wasFound = true;
                            break;
                        }
                        if (wasFound) continue;
                        vSwitches.remove();
                    }
                }
                if (vSwitchesToSet.size() == 0) {
                    throw new IllegalValueException("Children volumes do not exist in the same VSwitches.");
                }
                CommKeyClassId[] retVal = new CommKeyClassId[vSwitchesToSet.size()];
                for (int i = 0; i < vSwitchesToSet.size(); ++i) {
                    retVal[i] = ((VSwitch)vSwitchesToSet.elementAt(i)).getCommKeyClassId();
                }
                return retVal;
            }
            VSwitch[] connectedVSwitches = ((AliasObjectImpl)elements).getConnectedVSwitches();
            CommKeyClassId[] retVal = new CommKeyClassId[connectedVSwitches.length];
            for (int i = 0; i < connectedVSwitches.length; ++i) {
                retVal[i] = connectedVSwitches[i].getCommKeyClassId();
            }
            return retVal;
        }
        catch (RemoteException re) {
            logger.error(re);
            return new CommKeyClassId[0];
        }
    }

    protected CommKeyClassId[] getVSwitchesToSet(CommKeyClassId[] vSwitchToSetOn, CommKeyClassId[] legalVSwitchesToSetOn) throws IllegalValueException {
        Vector<CommKeyClassId> listToSet = new Vector<CommKeyClassId>();
        for (int i = 0; i < vSwitchToSetOn.length; ++i) {
            for (int j = 0; j < legalVSwitchesToSetOn.length; ++j) {
                if (!vSwitchToSetOn[i].equals(legalVSwitchesToSetOn[j])) continue;
                listToSet.add(vSwitchToSetOn[i]);
            }
        }
        if (listToSet.size() == 0) {
            throw new IllegalValueException("Operation canot be set to any of the " + ClassID.VSWITCH + " in the cluster");
        }
        CommKeyClassId[] retVal = new CommKeyClassId[listToSet.size()];
        listToSet.toArray(retVal);
        return retVal;
    }

    public CommKeyClassId[] getLegalVSwitchesForOperation(CommKeyClassId[] vSwitchToSet) throws RemoteException, IllegalValueException {
        if (!this.isValid()) {
            return new CommKeyClassId[0];
        }
        return vSwitchToSet;
    }
}

