/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.event.PropagatedStateEventListener;
import com.sanrad.nms.server.event.SrRemoveElementEvent;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.CommKeyRefMap;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.MasterParameter;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterList;
import com.sanrad.nms.server.util.Parameters;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public abstract class LogicObjectImpl
extends GeneralLogicObjectImpl
implements LogicObject,
PropagatedStateEventListener {
    protected static final int INT_NOT_SET = -1;
    protected static final String NO_VAL = "N/A";
    private volatile short connectedVSwitchCounter = 1;
    private CommKey[] commKeys = null;
    private HashMap parameters = new HashMap();
    private HashMap parameterVSwitchList = new HashMap();
    protected ClusterImpl cluster;
    protected volatile boolean synchronizingMode = false;
    protected volatile boolean neighborCreatingMode = false;
    protected String toStringValue = null;
    private boolean deletionPending = false;
    private boolean inconsistencyWithTheVSwitch = false;
    protected boolean deleteFromDatabase = false;
    private boolean isMerged = false;
    private ArrayList mergeListeners = new ArrayList();
    private ArrayList mergeNotifiers = new ArrayList();

    protected LogicObjectImpl() throws RemoteException {
        this(null);
    }

    protected LogicObjectImpl(ClassID classId) throws RemoteException {
        super(classId);
        this.addParameterCode(ParameterCode.LAST_UPDATE);
    }

    protected LogicObjectImpl(ClusterImpl cluster, ClassID classId, List parameterCodeList) throws RemoteException {
        this(classId);
        this.cluster = cluster;
        Iterator i = parameterCodeList.iterator();
        while (i.hasNext()) {
            ParameterCode code = (ParameterCode)i.next();
            this.addParameterCode(code);
        }
    }

    protected LogicObjectImpl(ClusterImpl cluster, ClassID classId, ParameterCode[] parameterCodeList) throws RemoteException {
        this(classId);
        this.cluster = cluster;
        int i = parameterCodeList.length;
        while (i-- > 0) {
            this.addParameterCode(parameterCodeList[i]);
        }
    }

    protected LogicObjectImpl(ClassID classId, List parameterCodeList) throws RemoteException {
        this(null, classId, parameterCodeList);
    }

    protected LogicObjectImpl(ClassID classId, ParameterCode[] parameterCodeList) throws RemoteException {
        this(null, classId, parameterCodeList);
    }

    public void clearParameterListExceptForVSwitchID(VSwitch vSwitch) throws RemoteException {
        HashMap parameterListValues = this.getParameterListValuesMap(vSwitch);
        Iterator i = parameterListValues.keySet().iterator();
        while (i.hasNext()) {
            ParameterCode currParam = (ParameterCode)i.next();
            if (currParam == ParameterCode.VSWITCH_ID) continue;
            Parameter param = this.getParameter(vSwitch, currParam);
            param.setValue(null);
        }
    }

    public boolean isNewer(SrTimeTicks newTimestamp, VSwitch vSwitch) {
        try {
            SrType lastUpdate = this.getSrValueOf(vSwitch, ParameterCode.LAST_UPDATE);
            if (lastUpdate != null) {
                return newTimestamp.compareTo(lastUpdate) >= 0;
            }
            return true;
        }
        catch (RemoteException e) {
            logger.error(e);
            return false;
        }
    }

    protected void addParameterCode(ParameterCode code) {
        this.parameters.put(code, new Parameter(code));
    }

    protected Parameter getParameter(VSwitch vSwitch, ParameterCode code) throws RemoteException {
        HashMap parameterListValues = (HashMap)this.parameterVSwitchList.get(vSwitch);
        if (parameterListValues != null) {
            return this.getParameter(parameterListValues, code);
        }
        return this.getParameter(this.parameters, code);
    }

    protected VSwitch getFirstVSwitch() throws RemoteException {
        VSwitch disconnectVswitch = null;
        VSwitch[] vswitches = this.getConnectedVSwitches();
        for (int i = 0; i < vswitches.length; ++i) {
            if (vswitches[i].isConnected()) {
                return vswitches[i];
            }
            disconnectVswitch = vswitches[i];
        }
        return disconnectVswitch;
    }

    public final VSwitch getActiveVswitch() throws RemoteException {
        VSwitch vswitch = this.getDominentVswitch();
        if (vswitch != null) {
            return vswitch;
        }
        return this.getFirstVSwitch();
    }

    public VSwitch getDominentVswitch() throws RemoteException {
        return null;
    }

    public VSwitch getInactiveVSwitch() throws RemoteException {
        if (this.getConnectedVSwitchCounter() < 2) {
            return this.getFirstVSwitch();
        }
        if (!this.getConnectedVSwitchesList()[0].equals(this.getActiveVswitch())) {
            return this.getConnectedVSwitchesList()[0];
        }
        return this.getConnectedVSwitchesList()[1];
    }

    protected Parameter getParameter(HashMap parameters, ParameterCode code) {
        return (Parameter)parameters.get(code);
    }

    public void setCommKeys(CommKey[] commKeys) {
        this.commKeys = commKeys;
    }

    public CommKey[] getCommKeys() throws RemoteException {
        return this.commKeys;
    }

    public CommKeyClassId getCommKeyClassId() throws RemoteException {
        return new CommKeyClassId(this.getCommKeys(), this.getClassId());
    }

    public void addCommKeys(CommKey[] commKeys) {
        this.commKeys = CommKeyUtil.mergerCommKeyLists(this.commKeys, commKeys);
        this.incrementConnectedVSwitchCounter();
    }

    protected void deleteElement(ConfigElementData ced) throws RemoteException, IllegalValueException {
        String msg = this.canBeDeleted();
        if (msg != null) {
            logger.debug(msg);
            throw new IllegalValueException(msg);
        }
        if (!this.isInDeletionProcess()) {
            this.setInDeletionProcess();
            this.deleteElementFromDataMgr(ced);
        } else {
            logger.debug("Delete in process for " + this.getClassId() + " " + this.toString());
        }
    }

    protected void deleteElementFromDataMgr(ConfigElementData ced) throws RemoteException {
        logger.debug("Trying to delete " + this.getClassId() + " " + this.toString());
        DataMgr.getInstance().removeElement(ced);
    }

    protected void deleteElement(ConfigElementDataList cedl) throws RemoteException, IllegalValueException {
        String msg = this.canBeDeleted();
        if (msg != null) {
            logger.debug(msg);
            throw new IllegalValueException(msg);
        }
        logger.debug("Trying to delete " + this.getClassId() + " " + this.toString());
        DataMgr.getInstance().removeElementAsync(cedl);
    }

    public VSwitch getVSwitch(HashMap parameterList) throws RemoteException {
        Object vSwitchObj = parameterList.get(ParameterCode.VSWITCH_ID);
        if (vSwitchObj != null) {
            CommKeyClassId vSwitchCommKeyClassId = (CommKeyClassId)vSwitchObj;
            VSwitch vSwitch = (VSwitch)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(vSwitchCommKeyClassId);
            return vSwitch;
        }
        return null;
    }

    private HashMap getParameterListValuesEmptyMap(HashMap parameters) {
        HashMap<ParameterCode, Parameter> parameterListValuesEmptyMap = new HashMap<ParameterCode, Parameter>(parameters.size());
        Set keys = parameters.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            ParameterCode code = (ParameterCode)i.next();
            parameterListValuesEmptyMap.put(code, new Parameter(code));
        }
        return parameterListValuesEmptyMap;
    }

    public HashMap getParameterListValuesMap(VSwitch vSwitch) throws RemoteException {
        HashMap parameterListValues = null;
        if (!this.getClassId().equals(ClassID.VSWITCH) && vSwitch != null && (parameterListValues = (HashMap)this.parameterVSwitchList.get(vSwitch)) == null) {
            parameterListValues = this.getParameterListValuesEmptyMap(this.parameters);
            this.parameterVSwitchList.put(vSwitch, parameterListValues);
        }
        if (parameterListValues != null) {
            return parameterListValues;
        }
        return this.parameters;
    }

    public HashMap getParameterListValues(VSwitch vSwitch) throws RemoteException {
        HashMap parameterListValuesMap = this.getParameters(vSwitch);
        HashMap<ParameterCode, Object> parameterListValues = new HashMap<ParameterCode, Object>();
        Iterator i = parameterListValuesMap.keySet().iterator();
        while (i.hasNext()) {
            ParameterCode currParam = (ParameterCode)i.next();
            Parameter currValue = (Parameter)parameterListValuesMap.get(currParam);
            parameterListValues.put(currParam, currValue.getValue());
        }
        return parameterListValues;
    }

    public HashMap getParameters(VSwitch vSwitch) throws RemoteException {
        HashMap parameterListValues = null;
        if (!this.getClassId().equals(ClassID.VSWITCH) && vSwitch != null) {
            parameterListValues = (HashMap)this.parameterVSwitchList.get(vSwitch);
        }
        if (parameterListValues != null) {
            return parameterListValues;
        }
        return this.parameters;
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        VSwitch vSwitch = this.getVSwitch(parameterList);
        this.getParameterListValuesMap(vSwitch);
        HashMap changedValues = new HashMap();
        Set keys = parameterList.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            ParameterCode key = (ParameterCode)i.next();
            Parameter param = this.getParameter(vSwitch, key);
            if (param != null) {
                Object value = parameterList.get(key);
                if (value == null && (!key.isNullable() || key.isNullable() && !parameterList.containsKey(key))) {
                    logger.debug("Value for \"" + key + "\" is NULL in " + this.getClass() + "::setParameterList()");
                    continue;
                }
                Object oldValue = param.getValue();
                if ((oldValue == null || oldValue.equals(value)) && (oldValue != null || value == null)) continue;
                param.setValue(value);
                changedValues.put(key, value);
                continue;
            }
            if (key.equals(ParameterCode.VSWITCH_ID)) continue;
            logger.debug("Parameter \"" + key + "\" is not known in " + this.getClass() + "::setParameterList()");
        }
        return changedValues;
    }

    public boolean setOneParameter(ParameterCode code, Object value, VSwitch vSwitch) throws RemoteException, IllegalValueException {
        Object val;
        HashMap parameterListValues = this.getParameterListValuesMap(vSwitch);
        if (parameterListValues == null) {
            parameterListValues = this.parameters;
        }
        if (parameterListValues.containsKey(code) && (val = parameterListValues.get(code)).equals(value)) {
            return false;
        }
        parameterListValues.put(code, new Parameter(code, value));
        return true;
    }

    public boolean setOneParameter(Parameter param, VSwitch vSwitch) throws RemoteException, IllegalValueException {
        return this.setOneParameter(param.getCode(), param.getValue(), vSwitch);
    }

    public void setParametersBadValue(VSwitch vSwitch, ParameterCode[] badValues) throws RemoteException {
        for (int i = 0; i < badValues.length; ++i) {
            SrType value = this.getSrValueOf(vSwitch, badValues[i]);
            value.setBadValue(true);
        }
    }

    public Vector getParametersBadValue(VSwitch vSwitch) throws RemoteException {
        Vector<Parameter> badValues = null;
        HashMap parameterList = (HashMap)this.parameterVSwitchList.get(vSwitch);
        if (parameterList == null) {
            parameterList = this.parameters;
        }
        Iterator i = parameterList.keySet().iterator();
        while (i.hasNext()) {
            Parameter parameter = (Parameter)parameterList.get(i.next());
            SrType value = (SrType)parameter.getValue();
            if (value == null || !value.isBadValue()) continue;
            if (badValues == null) {
                badValues = new Vector<Parameter>();
            }
            badValues.addElement(parameter);
        }
        return badValues;
    }

    public boolean isRedundant() throws RemoteException {
        int connectedVSwitchCounter = this.getConnectedVSwitchCounter();
        return this.cluster.getVSwitchesCount() == connectedVSwitchCounter || connectedVSwitchCounter == 0;
    }

    public boolean isKnownByVSwitch(VSwitch vSwitch) {
        return this.parameterVSwitchList.get(vSwitch) != null;
    }

    public void clear() throws RemoteException {
        this.connectedVSwitchCounter = 1;
    }

    private Object getParameterSrValueOf(VSwitch vSwitch, ParameterCode code) throws RemoteException {
        Parameter param = this.getParameter(vSwitch, code);
        if (param != null) {
            return param.getValue();
        }
        return null;
    }

    protected SrType getSrValueOf(VSwitch vSwitch, ParameterCode code, boolean anyVSwitch) throws RemoteException {
        if (anyVSwitch) {
            return this.getSrValueOf(code);
        }
        return this.getSrValueOf(vSwitch, code);
    }

    protected SrType getSrValueOf(VSwitch vSwitch, ParameterCode code) throws RemoteException {
        return (SrType)this.getParameterSrValueOf(vSwitch, code);
    }

    protected SrType getSrValueOf(ParameterCode code) throws RemoteException {
        SrType srValue;
        VSwitch activeVSwitch = this.getActiveVswitch();
        if (activeVSwitch != null && (srValue = this.getSrValueOf(activeVSwitch, code)) != null) {
            return srValue;
        }
        Iterator i = this.parameterVSwitchList.keySet().iterator();
        while (i.hasNext()) {
            SrType srValue2;
            VSwitch vSwitch = (VSwitch)i.next();
            if (vSwitch == null || !this.isKnownByVSwitch(vSwitch) || (srValue2 = this.getSrValueOf(vSwitch, code)) == null) continue;
            return srValue2;
        }
        return null;
    }

    public SrType getSrValueOf(MasterParameterCode mCode) throws RemoteException {
        ParameterCode pCode = mCode.getParameterCode(this);
        return this.getSrValueOf(pCode);
    }

    protected CommKeyClassId getCommKeyClassIdValueOf(ParameterCode code) throws RemoteException {
        CommKeyClassId srValue = null;
        Iterator i = this.parameterVSwitchList.keySet().iterator();
        while (i.hasNext()) {
            VSwitch vSwitch = (VSwitch)i.next();
            if (vSwitch == null || !this.isKnownByVSwitch(vSwitch)) continue;
            CommKeyClassId nextCommKey = (CommKeyClassId)this.getSrValueOf(vSwitch, code);
            if (srValue != null && nextCommKey != null) {
                srValue = CommKeyUtil.mergeCommKeyClassIDs(srValue, nextCommKey);
                continue;
            }
            srValue = nextCommKey;
        }
        return srValue;
    }

    protected SrType[] getSrArrayValueOf(VSwitch vSwitch, ParameterCode code, boolean anyVSwitch) throws RemoteException {
        if (anyVSwitch) {
            return this.getSrArrayValueOf(code);
        }
        return this.getSrArrayValueOf(vSwitch, code);
    }

    public SrType[] getSrArrayValueOf(VSwitch vSwitch, ParameterCode code) throws RemoteException {
        SrType[] value = (SrType[])this.getParameterSrValueOf(vSwitch, code);
        if (value == null) {
            logger.debug("Value of " + code + " is null");
            return null;
        }
        return value;
    }

    protected SrType[] getSrArrayValueOf(ParameterCode code) throws RemoteException {
        Iterator i = this.parameterVSwitchList.keySet().iterator();
        while (i.hasNext()) {
            Parameter param;
            VSwitch vSwitch = (VSwitch)i.next();
            if (vSwitch == null || (param = this.getParameter(vSwitch, code)) == null) continue;
            SrType[] value = (SrType[])param.getValue();
            return value;
        }
        return null;
    }

    protected Object getValueOf(VSwitch vSwitch, ParameterCode code, boolean anyVSwitch) throws RemoteException {
        if (anyVSwitch) {
            return this.getValueOf(code);
        }
        return this.getValueOf(vSwitch, code);
    }

    protected Object getValueOf(VSwitch vSwitch, ParameterCode code) throws RemoteException {
        SrType value = this.getSrValueOf(vSwitch, code);
        if (value == null) {
            return null;
        }
        return value.value();
    }

    public Object getValueOf(ParameterCode code) throws RemoteException {
        SrType value = this.getSrValueOf(code);
        if (value == null) {
            return null;
        }
        return value.value();
    }

    protected String getDisplayStringOf(VSwitch vSwitch, ParameterCode code, boolean anyVSwitch) throws RemoteException {
        SrType value = this.getSrValueOf(vSwitch, code, anyVSwitch);
        if (value == null) {
            return null;
        }
        return value.toDisplayString();
    }

    protected String getDisplayStringOf(VSwitch vSwitch, ParameterCode code) throws RemoteException {
        SrType value = this.getSrValueOf(vSwitch, code);
        if (value == null) {
            return null;
        }
        return value.toDisplayString();
    }

    public void deleteElement() throws RemoteException, IllegalValueException {
        ConfigElementData ced = new ConfigElementData(this.getCommKeys(), this.getClassId());
        this.deleteElement(ced);
    }

    public void changeElement(ClientParameterCode code, Object value) throws RemoteException, IllegalValueException {
        HashMap<ClientParameterCode, Object> parameterList = new HashMap<ClientParameterCode, Object>();
        parameterList.put(code, value);
        this.changeElement(parameterList);
    }

    public void changeElement(HashMap parameterList) throws RemoteException, IllegalValueException {
        ConfigElementData element;
        String msg = this.isValid(parameterList);
        if (msg == null) {
            Set keys = parameterList.keySet();
            element = new ConfigElementData(this.getCommKeys(), this.getClassId());
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                ClientParameterCode clientParameterCode = (ClientParameterCode)i.next();
                Object value = parameterList.get(clientParameterCode);
                ParameterCode parameterCode = clientParameterCode.getParameterCode();
                if (parameterCode == null) {
                    logger.debug(clientParameterCode + " is not a \"server\" parameter in " + this.getClass() + "::changeElement()");
                    continue;
                }
                Parameter parameter = new Parameter(parameterCode, value);
                element.addParameter(parameter);
            }
        } else {
            logger.debug(msg);
            throw new IllegalValueException(msg);
        }
        this.setVswitchesToPerformOperation(element, parameterList);
        logger.debug("Trying to change element " + this.getClassId() + " " + this.toString());
        DataMgr.getInstance().changeElement(element);
    }

    protected void setVswitchesToPerformOperation(ConfigElementData element, HashMap parameterList) throws RemoteException, IllegalValueException {
    }

    public int getConnectedVSwitchCounter() throws RemoteException {
        return this.getConnectedVSwitches().length;
    }

    private int incrementConnectedVSwitchCounter() {
        this.connectedVSwitchCounter = (short)(this.connectedVSwitchCounter + 1);
        this.setSynchronizingMode(false);
        this.neighborCreatingMode = false;
        return this.connectedVSwitchCounter;
    }

    public int decrementConnectedVSwitchCounter(CommKey[] vSwitchCommKeys) {
        Vector<CommKey> commKeysVec = new Vector<CommKey>(this.commKeys.length);
        for (int i = 0; i < this.commKeys.length; ++i) {
            commKeysVec.addElement(this.commKeys[i]);
        }
        boolean result = CommKeyUtil.removeSpecificCommKeys(commKeysVec, vSwitchCommKeys);
        if (result) {
            this.commKeys = new CommKey[commKeysVec.size()];
            commKeysVec.toArray(this.commKeys);
            if (this.connectedVSwitchCounter == 0) {
                try {
                    logger.debug("connectedVSwitchCounter cannot be negative for " + this.getClassId() + " " + this.toString());
                }
                catch (RemoteException re) {
                    logger.error(re);
                }
            } else {
                this.connectedVSwitchCounter = (short)(this.connectedVSwitchCounter - 1);
            }
        }
        return this.connectedVSwitchCounter;
    }

    public Vector getVSwitches() throws RemoteException {
        CommKeyClassId[] vSwitchCommKeyClassIDs = CommKeyUtil.getVSwitchCommKeyClassIDs(this.commKeys);
        Vector<VSwitch> vSwitches = new Vector<VSwitch>();
        for (int i = 0; i < vSwitchCommKeyClassIDs.length; ++i) {
            VSwitch vSwitch = (VSwitch)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(vSwitchCommKeyClassIDs[i]);
            vSwitches.addElement(vSwitch);
        }
        return vSwitches;
    }

    protected void setSynchronizingMode(boolean mode) {
        this.synchronizingMode = mode;
    }

    public boolean isInSynchronizingMode() {
        return this.synchronizingMode;
    }

    public Cluster getCluster() throws RemoteException {
        return this.cluster;
    }

    public CommKey[] getCommKeysOfVSwitch(VSwitch vSwitch) throws RemoteException {
        return this.getCommKeysOfVSwitch(vSwitch, null);
    }

    public CommKey[] getCommKeysOfVSwitch(VSwitch vSwitch, Vector commKeysVec) throws RemoteException {
        CommKey[] removedCommKey = null;
        Vector<CommKey> removedCommKeyVec = null;
        if (commKeysVec == null) {
            commKeysVec = new Vector<CommKey>(this.commKeys.length);
        }
        for (int i = 0; i < this.commKeys.length; ++i) {
            commKeysVec.addElement(this.commKeys[i]);
        }
        boolean result = CommKeyUtil.removeSpecificCommKeys(commKeysVec, vSwitch.getCommKeys());
        if (result) {
            removedCommKeyVec = new Vector<CommKey>(this.commKeys.length - commKeysVec.size());
            for (int i = 0; i < this.commKeys.length; ++i) {
                if (commKeysVec.contains(this.commKeys[i])) continue;
                removedCommKeyVec.addElement(this.commKeys[i]);
            }
            removedCommKey = new CommKey[removedCommKeyVec.size()];
            removedCommKeyVec.toArray(removedCommKey);
        }
        return removedCommKey;
    }

    public CommKey[] removeFromVSwitch(VSwitch vSwitch) throws RemoteException {
        Vector commKeysVec = new Vector(this.commKeys.length);
        CommKey[] removedCommKey = this.getCommKeysOfVSwitch(vSwitch, commKeysVec);
        this.commKeys = new CommKey[commKeysVec.size()];
        commKeysVec.toArray(this.commKeys);
        if (this.parameterVSwitchList.remove(vSwitch) != null) {
            this.connectedVSwitchCounter = (short)(this.connectedVSwitchCounter - 1);
        }
        return removedCommKey;
    }

    public VSwitch[] getConnectedVSwitchesList() throws RemoteException {
        return this.getConnectedVSwitches();
    }

    public VSwitch[] getNetworkConnectedVSwitches() {
        return this.cluster.getConnectedVSwitches();
    }

    public VSwitch[] getConnectedVSwitches() {
        ArrayList vSwitches = new ArrayList();
        Iterator keys = this.parameterVSwitchList.keySet().iterator();
        while (keys.hasNext()) {
            Object obj = keys.next();
            if (this.parameterVSwitchList.get(obj) == null) continue;
            vSwitches.add(obj);
        }
        return vSwitches.toArray(new VSwitch[vSwitches.size()]);
    }

    public Vector getConnectedVSwitchesAsVector() {
        VSwitch[] vSwitches = this.getConnectedVSwitches();
        return new Vector<VSwitch>(Arrays.asList(vSwitches));
    }

    public CommKeyClassId[] getConnectedVswitchesData() {
        VSwitch[] vSwitches = this.getConnectedVSwitches();
        CommKeyClassId[] vSwitchesData = new CommKeyClassId[vSwitches.length];
        for (int i = 0; i < vSwitches.length; ++i) {
            try {
                vSwitchesData[i] = new CommKeyClassId(vSwitches[i].getCommKeys(), vSwitches[i].getClassId());
                continue;
            }
            catch (RemoteException e) {
                logger.warning("Not expected Error occured", e);
            }
        }
        return vSwitchesData;
    }

    public VSwitch getOtherVSwitch(VSwitch vSwitch) throws RemoteException {
        VSwitch otherVSwitch = null;
        Iterator i = this.parameterVSwitchList.keySet().iterator();
        while (i.hasNext()) {
            otherVSwitch = (VSwitch)i.next();
            if (otherVSwitch.equals(vSwitch)) continue;
            return otherVSwitch;
        }
        return otherVSwitch;
    }

    protected VSwitch getOtherVSwitchFromCluster(VSwitch vSwitch) throws RemoteException {
        Iterator i = this.cluster.getVSwitches().iterator();
        while (i.hasNext()) {
            VSwitch otherVSwitch = (VSwitch)i.next();
            if (otherVSwitch.equals(vSwitch)) continue;
            return otherVSwitch;
        }
        return null;
    }

    protected boolean isInArray(Object value, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!value.equals(array[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isArraysEqual(Object[] array1, Object[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (this.isInArray(array1[i], array2)) continue;
            return false;
        }
        return true;
    }

    protected boolean isConsistentValues(Object[] values) {
        Object value = values[0];
        boolean valueIsArray = value instanceof Object[];
        if (value != null) {
            for (int i = 1; i < values.length; ++i) {
                if (!(!valueIsArray ? !value.equals(values[i]) : !this.isArraysEqual((Object[])value, (Object[])values[i]))) continue;
                return false;
            }
        }
        return true;
    }

    private Object getValueFromSrValue(SrType srValue) {
        if (srValue instanceof CommKeyClassId) {
            return this.cluster.getCommKeyRefMap().getRefByCommKeyClassID((CommKeyClassId)srValue);
        }
        return srValue.value();
    }

    public HashMap checkConsistencyBetweenVSwitches() throws RemoteException {
        VSwitch[] vSwitches = this.getConnectedVSwitches();
        if (vSwitches.length > 1) {
            HashMap<ParameterCode, Object[]> inconsistentValues = new HashMap<ParameterCode, Object[]>();
            Iterator iter = this.parameters.keySet().iterator();
            while (iter.hasNext()) {
                Object[] values = new Object[vSwitches.length];
                ParameterCode code = (ParameterCode)iter.next();
                if (!code.isCodeRelevantForConsistencyCheck()) continue;
                for (int i = 0; i < vSwitches.length; ++i) {
                    values[i] = this.getParameterSrValueOf(vSwitches[i], code);
                    if (values[i] == null || values[i] instanceof SrType) {
                        if (values[i] != null) {
                            if (!(values[i] instanceof CommKeyClassId)) continue;
                            values[i] = this.cluster.getCommKeyRefMap().getRefByCommKeyClassID((CommKeyClassId)values[i]);
                            continue;
                        }
                        values[i] = "<none>";
                        continue;
                    }
                    if (!(values[i] instanceof SrType[])) continue;
                    SrType[] srValues = (SrType[])values[i];
                    Object[] logicValues = new Object[srValues.length];
                    for (int j = 0; j < srValues.length; ++j) {
                        Object val = this.getValueFromSrValue(srValues[j]);
                        if (val != null) {
                            logicValues[j] = val.toString();
                        }
                        logicValues[j] = val;
                    }
                    values[i] = logicValues;
                }
                if (this.isConsistentValues(values)) continue;
                inconsistentValues.put(code, values);
            }
            return inconsistentValues;
        }
        return null;
    }

    public abstract AlarmGenerator getAlarmGenerator();

    public String toString() {
        if (this.toStringValue == null) {
            return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode());
        }
        return this.toStringValue;
    }

    public void setDeletionPending() {
        this.deletionPending = true;
    }

    public void clearDeletionStatus() {
        this.deletionPending = false;
        this.clearInDeletionProcess();
    }

    public void setInconsistentWithTheVSwitch() {
        this.inconsistencyWithTheVSwitch = true;
    }

    public boolean isInconsistentWithTheVSwitch() {
        return this.inconsistencyWithTheVSwitch;
    }

    public boolean isDeletionPending() {
        return this.deletionPending;
    }

    public CommKeyRefMap getCommKeyRefMap() throws RemoteException {
        return this.cluster.getCommKeyRefMap();
    }

    public String getAllObjectDataString() throws RemoteException {
        StringBuffer data = new StringBuffer("Object data: \n ClassID: ");
        data.append(this.getClassId().toString());
        data.append("CommKeys are: ");
        for (int i = 0; i < this.commKeys.length; ++i) {
            data.append(this.commKeys[i].toString());
            data.append("; ");
        }
        data.append("\n Parameters are: \n");
        Iterator iter = this.parameterVSwitchList.keySet().iterator();
        while (iter.hasNext()) {
            VSwitch key = (VSwitch)iter.next();
            data.append("VSwitch: ");
            data.append(key.getCommKeys().toString());
            data.append("  - Params: ");
            data.append(this.parameterVSwitchList.get(key).toString());
            data.append("\n");
        }
        return data.toString();
    }

    public boolean isDeletedFromDatabaseOnly() {
        return this.deleteFromDatabase;
    }

    public HashMap getClientParameterList() throws RemoteException {
        HashMap parameterList = this.parameterVSwitchList.isEmpty() ? this.parameters : (HashMap)this.parameterVSwitchList.values().iterator().next();
        HashMap clientParams = ElementEventImpl.convertParameterList(parameterList, this);
        clientParams.put(ClientParameterCode.PROPAGATION_STATE, this.getPropagatedState());
        return clientParams;
    }

    protected ConfigElementData buildCedForVswitch(VSwitch vSwitch, ParameterList params) throws RemoteException {
        if (vSwitch == null) {
            return null;
        }
        ConfigElementData ced = new ConfigElementData(this.commKeys, this.getClassId());
        ced.addParameter(params.getParamerListToHashMap());
        ced.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitch.getCommKeyClassId()));
        return ced;
    }

    public void changeElementInInactiveVswitch(ParameterList params) throws RemoteException {
        VSwitch vswitch = this.getInactiveVSwitch();
        if (vswitch == null) {
            return;
        }
        DataMgr.getInstance().changeElement(this.buildCedForVswitch(vswitch, params));
    }

    public void changeElementForActiveVswitch(ParameterList params) throws RemoteException {
        DataMgr.getInstance().changeElement(this.buildCedForVswitch(this.getActiveVswitch(), params));
    }

    public void changeElementForActiveVswitch(MasterParameter param) throws RemoteException {
        ParameterList params = new ParameterList(param);
        this.changeElementForActiveVswitch(params);
    }

    public void changeElementForInactiveVswitch(MasterParameter param) throws RemoteException {
        ParameterList params = new ParameterList(param);
        this.changeElementInInactiveVswitch(params);
    }

    public Cluster[] getAllClusters() throws RemoteException {
        Cluster[] clusters = new Cluster[]{this.getCluster()};
        return clusters;
    }

    public boolean isParameterCodeExsist(ParameterCode code) {
        return this.parameters.keySet().contains(code);
    }

    public boolean isParameterEqual(Parameters param, VSwitch vswitch) throws RemoteException {
        return param.getValue().equals(this.getSrValueOf(vswitch, (ParameterCode)param.getCode(this)));
    }

    protected void refreshFields(ParameterCode[] codes) throws RemoteException {
        this.refreshFields(this.getCommKeyClassId(), codes);
    }

    protected void refreshFields(CommKeyClassId elementData, ParameterCode[] codes) throws RemoteException {
        VSwitch[] vSwithces = this.getNetworkConnectedVSwitches();
        if (vSwithces != null && vSwithces.length > 0) {
            CommKeyClassId[] vSwitchesData = new CommKeyClassId[vSwithces.length];
            int i = vSwithces.length;
            while (i-- > 0) {
                if (!this.isKnownByVSwitch(vSwithces[i])) continue;
                vSwitchesData[i] = vSwithces[i].getCommKeyClassId();
            }
            ConfigElementData element = new ConfigElementData(this.getClassId());
            int i2 = codes.length;
            while (i2-- > 0) {
                element.setValue(codes[i2], (SrType)null);
            }
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchesData));
            element.setCommKeyClassId(elementData);
            this.refreshFields(element);
        }
    }

    protected void refreshFields(ConfigElementData element) throws RemoteException {
        DataMgr.getInstance().readElementFields(element);
    }

    public void refreshFields(ClientParameterCode[] codes) throws RemoteException {
        ArrayList<ParameterCode> parameterCodesList = new ArrayList<ParameterCode>();
        int i = codes.length;
        while (i-- > 0) {
            ParameterCode paramCode = codes[i].getParameterCode();
            if (paramCode == null) continue;
            parameterCodesList.add(paramCode);
        }
        if (!parameterCodesList.isEmpty()) {
            this.refreshFields(parameterCodesList.toArray(new ParameterCode[parameterCodesList.size()]));
        }
    }

    public void refresh() throws RemoteException {
        VSwitch[] vSwithces = this.getConnectedVSwitches();
        if (vSwithces != null && vSwithces.length > 0) {
            CommKeyClassId[] vSwitchesData = new CommKeyClassId[vSwithces.length];
            int i = vSwithces.length;
            while (i-- > 0) {
                vSwitchesData[i] = vSwithces[i].getCommKeyClassId();
            }
            ConfigElementData element = new ConfigElementData(this.getClassId());
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchesData));
            element.setCommKeyClassId(this.getCommKeyClassId());
            DataMgr.getInstance().readElement(element);
        }
    }

    public void updateElementWithCreationParameters(ConfigElementData element, Cluster remoteCluster) throws RemoteException, IllegalValueException {
        element.setClassId(this.getClassId());
        CommKeyClassId logicElement = this.getElementIfAlreadyExsist(element, remoteCluster);
        if (logicElement != null) {
            element.setCommKeys(logicElement.getCommKeys());
        }
        Object[] vswitches = remoteCluster.getVSwitches().toArray();
        CommKeyClassId[] vswitchesToSend = new CommKeyClassId[vswitches.length];
        for (int i = 0; i < vswitches.length; ++i) {
            vswitchesToSend[i] = ((VSwitchImpl)vswitches[i]).getCommKeyClassId();
        }
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vswitchesToSend));
    }

    protected CommKeyClassId getElementIfAlreadyExsist(ConfigElementData elem, Cluster remoteCluster) throws RemoteException, IllegalValueException {
        LogicObject result;
        logger.debug("check if element alread exsist" + this);
        VolumeNode element = null;
        if (elem.getFirstChild() != null && elem.getFirstChild().getCommKey() != null) {
            element = (VolumeNode)remoteCluster.getCommKeyRefMap().getRefByCommKeyClassID(elem.getFirstChild().getCommKeyClassId());
        }
        if ((result = this.findEquivelentElement(remoteCluster, element)) != null) {
            ((LogicObjectImpl)result).setExsistentElementIfNeeded(this);
            return result.getCommKeyClassId();
        }
        return null;
    }

    protected void setExsistentElementIfNeeded(LogicObjectImpl source) throws RemoteException, IllegalValueException {
    }

    protected LogicObject findEquivelentElement(Cluster remoteCluster, LogicObject element) throws RemoteException, IllegalValueException {
        return null;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        try {
            LogicObject compareToObj;
            if (obj instanceof LogicObject && (compareToObj = (LogicObject)obj).getCommKeys() != null && this.getCommKeys() != null) {
                return this.getCommKeyClassId().equals(compareToObj.getCommKeyClassId());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    public boolean equalsByCommKey(Object obj) {
        return this.equals(obj);
    }

    public boolean isConsistentBetweenVSwitches(ParameterCode code) throws RemoteException {
        HashMap inconsistentValues = this.checkConsistencyBetweenVSwitches();
        if (inconsistentValues == null) {
            return true;
        }
        return !inconsistentValues.containsKey(code);
    }

    public final void merge(LogicObjectImpl other) throws RemoteException {
        if (!other.getClassId().equals(this.getClassId())) {
            throw new IllegalArgumentException("Cannot merge entities with different types");
        }
        Iterator i = other.parameterVSwitchList.keySet().iterator();
        while (i.hasNext()) {
            if (!this.parameterVSwitchList.containsKey(i.next())) continue;
            throw new IllegalArgumentException("This element already contains parameters from the other element");
        }
        Object[] mergeListenersArray = other.mergeListeners.toArray();
        for (int i2 = 0; i2 < mergeListenersArray.length; ++i2) {
            ((LogicObjectImpl)mergeListenersArray[i2]).notifyChildElementsWillBeMerged(other, this);
        }
        this.doMerge(other);
    }

    public boolean canMerge(LogicObjectImpl other) throws RemoteException {
        if (other == null) {
            return false;
        }
        if (!other.getClassId().equals(this.getClassId())) {
            return false;
        }
        Iterator i = other.parameterVSwitchList.keySet().iterator();
        while (i.hasNext()) {
            if (!this.parameterVSwitchList.containsKey(i.next())) continue;
            return false;
        }
        return true;
    }

    public final void addMergeListener(LogicObjectImpl mergeListener) {
        if (!this.mergeListeners.contains(mergeListener)) {
            this.mergeListeners.add(mergeListener);
            mergeListener.addMergeNotifier(this);
        }
    }

    public final void removeMergeListener(LogicObjectImpl mergeListener) {
        this.mergeListeners.remove(mergeListener);
    }

    private void addMergeNotifier(LogicObjectImpl mergeListener) {
        if (!this.mergeNotifiers.contains(mergeListener)) {
            this.mergeNotifiers.add(mergeListener);
        }
    }

    public void clearMergeNotifiers() {
        Iterator i = this.mergeNotifiers.iterator();
        while (i.hasNext()) {
            LogicObjectImpl mergeNotifier = (LogicObjectImpl)i.next();
            mergeNotifier.removeMergeListener(this);
        }
        this.mergeNotifiers.clear();
    }

    protected void doMerge(LogicObjectImpl other) throws RemoteException {
        CommKey[] otherCommKeys = other.getCommKeys();
        HashMap otherParamterList = new HashMap(other.parameterVSwitchList);
        Vector vswitchesBeforMerge = this.getConnectedVSwitchesAsVector();
        this.cleanMergedElement(other);
        this.addCommKeys(otherCommKeys);
        this.parameterVSwitchList.putAll(otherParamterList);
        this.cluster.getCommKeyRefMap().addCommKeyClassIdAndRef(otherCommKeys, other.getClassId(), (Object)this);
        AlarmMgrImpl.getInstance().generateAlarms(this.cluster, 2, this, (VSwitchImpl)vswitchesBeforMerge.firstElement());
    }

    public boolean isMerged() {
        return this.isMerged;
    }

    private void cleanMergedElement(LogicObjectImpl mergedElement) throws RemoteException {
        mergedElement.isMerged = true;
        ClusterImpl cluster = (ClusterImpl)mergedElement.getCluster();
        ConfigElementData elementCED = new ConfigElementData(mergedElement.getCommKeyClassId());
        Vector storageVSwitches = mergedElement.getConnectedVSwitchesAsVector();
        elementCED.setValue(ParameterCode.VSWITCH_ID, ((VSwitchImpl)storageVSwitches.firstElement()).getCommKeyClassId());
        SrRemoveElementEvent removeEvent = new SrRemoveElementEvent((Object)this, elementCED);
        cluster.elementEvent(removeEvent, true, true);
    }

    protected void notifyChildElementsWillBeMerged(LogicObjectImpl childElement, LogicObjectImpl mantainedElement) throws RemoteException {
    }
}

