/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.log.Log;
import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.event.DataMgrListener;
import com.sanrad.nms.server.event.ErrorEvent;
import com.sanrad.nms.server.event.ErrorListener;
import com.sanrad.nms.server.event.SnmpErrorEvent;
import com.sanrad.nms.server.event.SnmpErrorListener;
import com.sanrad.nms.server.event.SrClusterDiscoveryCompletedEvent;
import com.sanrad.nms.server.event.SrElementEvent;
import com.sanrad.nms.server.event.SrEvent;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.EventServiceImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SiteImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.VSwitchGroup;
import com.sanrad.nms.server.logic.VSwitchGroupImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.VSwitchClusterMap;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.util.Queue;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;

public class LogicMgr
implements DataMgrListener,
ErrorListener,
SnmpErrorListener {
    private static Log logger = LogMgr.getServerLog();
    private static LogicMgr theInstance = new LogicMgr();
    private volatile Thread queueConsumerThread = null;
    private Queue eventQueue = new Queue();
    private SystemRootImpl systemRoot = SystemRootImpl.getInstance();
    private static HashMap vSwitchGroupCommKeyRefMap;

    private LogicMgr() {
        vSwitchGroupCommKeyRefMap = new HashMap();
        SrEventHandler.getErrorMgr().addListener(this);
        SrEventHandler.getEventMgr().addListener(this);
        SrEventHandler.getSnmpErrorMgr().addListener(this);
        this.startQueueConsumerThread();
        try {
            this.addVSwitchGroupCommKeyRefMap(this.systemRoot.getCommKeyClassId(), this.systemRoot);
        }
        catch (RemoteException re) {
            logger.error(re);
        }
    }

    public static LogicMgr getInstance() {
        return theInstance;
    }

    private void startQueueConsumerThread() {
        this.queueConsumerThread = new Thread("LogicMgr Queue/Consumer Thread"){

            public void run() {
                Thread thisThread = Thread.currentThread();
                while (LogicMgr.this.queueConsumerThread == thisThread) {
                    try {
                        Object event = LogicMgr.this.eventQueue.removeHead();
                        if (event instanceof ErrorEvent) {
                            LogicMgr.this.handleErrorEvent((ErrorEvent)event);
                            continue;
                        }
                        SrEvent eventQueueElement = (SrEvent)event;
                        ClusterImpl relevantCluster = null;
                        int eventType = eventQueueElement.getType();
                        if (eventType == 1 || eventType == 2 || eventType == 4 || eventType == 3 || eventType == 8 || eventType == 9 || eventType == 13 || eventType == 10 || eventType == 15 || eventType == 11 || eventType == 18 || eventType == 12) {
                            SrElementEvent eventElement = (SrElementEvent)eventQueueElement;
                            ConfigElementDataList cedList = eventElement.getElements();
                            if (cedList != null) {
                                Enumeration iter = cedList.elements();
                                while (iter.hasMoreElements()) {
                                    ConfigElementData ced = (ConfigElementData)iter.nextElement();
                                    if (ced.getClassId().isVSwitchGroup()) {
                                        LogicMgr.this.vSwitchGroupEvent(ced, eventType);
                                    } else if ((eventType == 1 || eventType == 8) && ced.getClassId().equals(ClassID.VSWITCH)) {
                                        SrInteger clusterId = (SrInteger)ced.getValue(ParameterCode.VSWITCH_GROUP_ID);
                                        if (clusterId != null) {
                                            relevantCluster = (ClusterImpl)LogicMgr.this.systemRoot.getVSwitchGroup((Integer)clusterId.value());
                                        } else {
                                            String ip = ((SrIpAddress)ced.getValue(ParameterCode.VSWITCH_IP_ADDRESS)).toDisplayString();
                                            relevantCluster = (ClusterImpl)LogicMgr.this.systemRoot.getClusterOfVSwitch(ip);
                                        }
                                    } else if (eventType != 1 && eventType != 2 || !ced.getClassId().equals(ClassID.ALARM_TYPE) && !ced.getClassId().equals(ClassID.EMAIL_CONTACT)) {
                                        CommKeyClassId vSwitchId = (CommKeyClassId)ced.getValue(ParameterCode.VSWITCH_ID);
                                        if (vSwitchId != null) {
                                            CommKeyClassId clusterId = VSwitchClusterMap.getInstance().getClusterId(vSwitchId);
                                            relevantCluster = (ClusterImpl)LogicMgr.getVSwitchGroupByCommKeyClassId(clusterId);
                                        } else {
                                            logger.warning("EventType: " + eventType + " " + ced.getClassId() + " " + ClassID.VSWITCH + " id is null");
                                        }
                                    }
                                    if (relevantCluster == null) continue;
                                    LogicMgr.this.sendEventToCluster(relevantCluster, eventQueueElement);
                                    relevantCluster = null;
                                    break;
                                }
                            }
                        } else if (eventType == 14) {
                            DataMgr.getInstance().siteDiscovery();
                        } else if (eventType == 23) {
                            LogicMgr.this.systemRoot.sendEventToAllClusters((SrClusterDiscoveryCompletedEvent)eventQueueElement);
                            LogicMgr.this.systemRoot.setDBDiscoveryCompleted();
                        } else if (eventType != 20) {
                            if (eventType == 6 || eventType == 7 || eventType == 16 || eventType == 17) {
                                CommKeyClassId vSwitchId = eventQueueElement.getVSwitchData();
                                if (vSwitchId != null) {
                                    CommKeyClassId clusterId = VSwitchClusterMap.getInstance().getClusterId(vSwitchId);
                                    relevantCluster = (ClusterImpl)LogicMgr.getVSwitchGroupByCommKeyClassId(clusterId);
                                }
                            } else {
                                logger.error("Event type " + eventType + " not found in LogicMgr");
                            }
                        }
                        if (relevantCluster == null) continue;
                        LogicMgr.this.sendEventToCluster(relevantCluster, eventQueueElement);
                        relevantCluster = null;
                    }
                    catch (RemoteException re) {
                        logger.error(re);
                    }
                    catch (Throwable th) {
                        logger.error(th);
                    }
                }
            }
        };
        this.queueConsumerThread.start();
    }

    public static void removeVSwitchGroup(VSwitchGroup vSwitchGroup) {
        try {
            if (vSwitchGroupCommKeyRefMap.remove(vSwitchGroup.getCommKeyClassId()) == null) {
                logger.warning("Failed to remove " + vSwitchGroup.getClassId() + " " + vSwitchGroup);
            } else {
                AlarmMgrImpl.getInstance().vSwitchGroupWasRemoved(vSwitchGroup);
            }
        }
        catch (RemoteException re) {
            logger.error(re);
        }
    }

    public static VSwitchGroup getVSwitchGroupByCommKeyClassId(CommKey[] commKeys, ClassID classId) throws RemoteException {
        return LogicMgr.getVSwitchGroupByCommKeyClassId(new CommKeyClassId(commKeys, classId));
    }

    public static VSwitchGroup getVSwitchGroupByCommKeyClassId(CommKeyClassId vSwitchGroupId) throws RemoteException {
        return (VSwitchGroup)vSwitchGroupCommKeyRefMap.get(vSwitchGroupId);
    }

    private void vSwitchGroupEvent(ConfigElementData ced, int eventType) throws RemoteException {
        if (eventType == 1) {
            this.newVSwitchGroup(ced);
        } else if (eventType == 3) {
            this.removeVSwitchGroup(ced);
        } else if (eventType == 2) {
            this.changeVSwitchGroup(ced);
        } else if (eventType == 12 || eventType == 13 || eventType == 11) {
            ClusterImpl vSwitchGroup = (ClusterImpl)LogicMgr.getVSwitchGroupByCommKeyClassId(ced.getCommKey(), ced.getClassId());
            this.vSwitchGroupOperationFailed(eventType, vSwitchGroup, ced.getParametersList());
        }
    }

    private void vSwitchGroupOperationFailed(int eventType, VSwitchGroupImpl element, HashMap parameterList) throws RemoteException {
        StringBuffer msg = null;
        if (eventType == 13) {
            msg = new StringBuffer("Failed to read ");
        } else if (eventType == 12) {
            msg = new StringBuffer("Failed to remove ");
        } else if (eventType == 11) {
            msg = new StringBuffer("Failed to change ");
        } else {
            msg = new StringBuffer("Undefined \"Failed\" event type in operationFailed()");
            msg.append(eventType);
            logger.error(msg.toString());
            return;
        }
        msg.append(element.getClassId());
        if (eventType == 12) {
            element.clearDeletionStatus();
        }
        msg.append(" ");
        msg.append(element);
        ElementEventImpl event = new ElementEventImpl(element, element);
        event.setErrorMesaage(msg.toString());
        EventServiceImpl.getInstance().fireConfigurationError(event);
        logger.warning(msg.toString());
    }

    private void sendEventToCluster(ClusterImpl cluster, SrEvent event) {
        cluster.elementEvent(event);
    }

    private void changeVSwitchGroup(ConfigElementData ced) throws RemoteException {
        try {
            this.systemRoot.changeVSwitchGroup(ced);
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
        }
    }

    private void removeVSwitchGroup(ConfigElementData ced) throws RemoteException {
        try {
            this.systemRoot.removeVSwitchGroup(ced);
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
        }
    }

    private void newVSwitchGroup(ConfigElementData ced) throws RemoteException {
        try {
            CommKeyClassId parentSiteCommKeyClassId = (CommKeyClassId)ced.getValue(ParameterCode.PARENT_SITE_ID);
            if (parentSiteCommKeyClassId == null || parentSiteCommKeyClassId.getCommKeys() == null) {
                parentSiteCommKeyClassId = this.systemRoot.getCommKeyClassId();
                ced.setValue(ParameterCode.PARENT_SITE_ID, parentSiteCommKeyClassId);
            }
            SiteImpl parentSite = (SiteImpl)LogicMgr.getVSwitchGroupByCommKeyClassId(parentSiteCommKeyClassId);
            VSwitchGroupImpl vSwitchGroup = parentSite.newVSwitchGroup(ced);
            CommKeyClassId vSwitchGroupCommKeyClassId = new CommKeyClassId(ced.getCommKey(), ced.getClassId());
            this.addVSwitchGroupCommKeyRefMap(vSwitchGroupCommKeyClassId, vSwitchGroup);
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
        }
    }

    private void addVSwitchGroupCommKeyRefMap(CommKeyClassId vSwitchGroupCommKeyClassId, VSwitchGroup vSwitchGroup) {
        vSwitchGroupCommKeyRefMap.put(vSwitchGroupCommKeyClassId, vSwitchGroup);
    }

    public void elementEvent(SrEvent e) {
        this.addToQueue(e);
    }

    private void addToQueue(Object queueElement) {
        this.eventQueue.addElement(queueElement);
    }

    private void handleErrorEvent(ErrorEvent event) {
        switch (event.getErrorType()) {
            case 2: {
                this.handleSnmpError((SnmpErrorEvent)event);
                break;
            }
            case 1: {
                this.handleSnmpTimeoutError((SnmpErrorEvent)event);
                break;
            }
            case 3: {
                this.handleConfigurationError(event);
                break;
            }
            case 4: {
                this.handleFatalConfigurationError(event);
            }
        }
    }

    public void fatalConfigurationError(ErrorEvent event) {
        this.addToQueue(event);
    }

    private void handleFatalConfigurationError(ErrorEvent event) {
        try {
            CommKeyClassId source = event.getVSwitchData();
            if (source != null) {
                CommKeyClassId clusterId = VSwitchClusterMap.getInstance().getClusterId(source);
                ClusterImpl cluster = (ClusterImpl)LogicMgr.getVSwitchGroupByCommKeyClassId(clusterId);
                if (cluster != null) {
                    cluster.elementEvent(event);
                } else {
                    logger.warning("Cluster " + clusterId + " not found - fatal configuration error " + event + " was received");
                }
            } else {
                logger.warning(ClassID.VSWITCH + " is missing in Fatal Configuration Error of " + event.getSource() + " " + event.getMessage());
            }
        }
        catch (RemoteException re) {
            logger.error(re);
        }
    }

    public void configurationError(ErrorEvent event) {
        this.addToQueue(event);
    }

    private void handleConfigurationError(ErrorEvent event) {
        try {
            CommKeyClassId source = event.getVSwitchData();
            CommKeyClassId clusterId = VSwitchClusterMap.getInstance().getClusterId(source);
            ClusterImpl cluster = (ClusterImpl)LogicMgr.getVSwitchGroupByCommKeyClassId(clusterId);
            if (cluster != null) {
                cluster.elementEvent(event);
            } else {
                logger.warning("Cluster " + clusterId + " not found - configuration error " + event + " was received");
            }
        }
        catch (RemoteException re) {
            logger.error(re);
        }
    }

    public void newSnmpError(SnmpErrorEvent event) {
        this.addToQueue(event);
    }

    private void handleSnmpError(SnmpErrorEvent event) {
        try {
            CommKeyClassId source = event.getVSwitchData();
            CommKeyClassId clusterId = VSwitchClusterMap.getInstance().getClusterId(source);
            ClusterImpl cluster = (ClusterImpl)LogicMgr.getVSwitchGroupByCommKeyClassId(clusterId);
            if (cluster != null) {
                cluster.elementEvent(event);
            } else {
                logger.warning("Cluster " + clusterId + " not found - SNMP error " + event + " was received");
            }
        }
        catch (RemoteException re) {
            logger.error(re);
        }
    }

    public void newSnmpTimeOutError(SnmpErrorEvent event) {
        this.addToQueue(event);
    }

    private void handleSnmpTimeoutError(SnmpErrorEvent event) {
        try {
            CommKeyClassId source = event.getVSwitchData();
            if (source == null) {
                return;
            }
            CommKeyClassId clusterId = VSwitchClusterMap.getInstance().getClusterId(source);
            ClusterImpl cluster = (ClusterImpl)LogicMgr.getVSwitchGroupByCommKeyClassId(clusterId);
            if (cluster != null) {
                cluster.elementEvent(event);
            } else {
                logger.warning("Cluster " + clusterId + " not found - SNMP timeOut " + event + " was received");
            }
        }
        catch (RemoteException re) {
            logger.error(re);
        }
    }

    public void discover() {
        DataMgr.getInstance().systemDiscovery();
    }
}

