/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.event.PropagatedStateEvent;
import com.sanrad.nms.server.alarm.event.PropagatedStateEventImpl;
import com.sanrad.nms.server.alarm.event.PropagatedStateEventListener;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.EventServiceImpl;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.util.ClassID;
import java.rmi.RemoteException;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public abstract class GeneralLogicObjectImpl
extends RemoteObjectImpl
implements GeneralLogicObject,
PropagatedStateEventListener {
    private ClassID m_classId = null;
    private BitSet m_state = new BitSet(AlarmType.getCount());
    private AlarmSeverity state = AlarmSeverity.OK;
    private AlarmSeverity propagationState = AlarmSeverity.OK;
    private AlarmSeverity ackState = AlarmSeverity.OK;
    private Vector propagationStateListeners = new Vector();
    private Vector propagationStateDependent = new Vector();
    private boolean inDeletionProcess = false;
    private boolean deletionProcessCompleted = false;
    private boolean deletionProcessStarted = false;

    protected GeneralLogicObjectImpl() throws RemoteException {
    }

    public GeneralLogicObjectImpl(ClassID classId) throws RemoteException {
        this.m_classId = classId;
    }

    public ClassID getClassId() throws RemoteException {
        return this.m_classId;
    }

    public boolean isInDeletionProcess() throws RemoteException {
        return this.inDeletionProcess;
    }

    public void setInDeletionProcess() {
        this.inDeletionProcess = true;
    }

    protected void clearInDeletionProcess() {
        this.inDeletionProcess = false;
    }

    protected void setOn(AlarmType alarmType) {
        this.m_state.set(alarmType.getStateIndex());
    }

    protected void setOff(AlarmType alarmType) {
        this.m_state.clear(alarmType.getStateIndex());
    }

    public boolean isStateOn(AlarmType alarmType) {
        return this.m_state.get(alarmType.getStateIndex());
    }

    public boolean setStateSeverity(AlarmSeverity newState) throws RemoteException {
        if (!this.state.equals(newState)) {
            AlarmSeverity currentPropagatedState = this.getPropagatedState();
            this.state = newState;
            this.notifyNewPropagationState(currentPropagatedState);
            return true;
        }
        return false;
    }

    public AlarmSeverity getPropagatedState() throws RemoteException {
        AlarmSeverity as = AlarmSeverity.moreSevere(this.state, this.propagationState);
        return as;
    }

    private void notifyNewPropagationState(AlarmSeverity propagatedStateBeforeChange) throws RemoteException {
        if (!propagatedStateBeforeChange.equals(this.getPropagatedState())) {
            PropagatedStateEventImpl event = new PropagatedStateEventImpl(this, this.getPropagatedState());
            EventServiceImpl.getInstance().firePropagatedStateChanged(event);
        }
    }

    public AlarmSeverity getPropagatedAcknowledgeState() throws RemoteException {
        AlarmSeverity as = AlarmSeverity.moreSevere(this.ackState, this.propagationState);
        return as;
    }

    public void setAcknowledgeStateSeverity(AlarmSeverity newAckState) throws RemoteException {
        AlarmSeverity currentPropagatedAckState = this.getPropagatedAcknowledgeState();
        this.ackState = newAckState;
        this.notifyNewPropagationAcknowledgeState(currentPropagatedAckState);
    }

    private void notifyNewPropagationAcknowledgeState(AlarmSeverity propagatedAckStateBeforeChange) throws RemoteException {
        if (!propagatedAckStateBeforeChange.equals(this.getPropagatedAcknowledgeState())) {
            PropagatedStateEventImpl eventToProp = new PropagatedStateEventImpl(this, this.getPropagatedAcknowledgeState());
            Enumeration e = this.propagationStateListeners.elements();
            while (e.hasMoreElements()) {
                PropagatedStateEventListener listener = (PropagatedStateEventListener)e.nextElement();
                listener.propagatedStateChanged(eventToProp);
            }
        }
    }

    public void setPropagatedState(AlarmSeverity newPropagatedState) throws RemoteException {
        boolean propagationStateIsNew;
        boolean bl = propagationStateIsNew = !newPropagatedState.equals(this.propagationState);
        if (propagationStateIsNew) {
            AlarmSeverity currentPropagatedState = this.getPropagatedState();
            AlarmSeverity currentAckPropagatedState = this.getPropagatedAcknowledgeState();
            if (newPropagatedState.isMoreSevereThan(this.propagationState)) {
                this.propagationState = newPropagatedState;
            } else if (newPropagatedState.isLessSevereThan(this.propagationState)) {
                this.propagationState = this.getDependentPropagatedState();
            }
            this.notifyNewPropagationState(currentPropagatedState);
            this.notifyNewPropagationAcknowledgeState(currentAckPropagatedState);
            this.notifyNewPropagationAcknowledgeState(newPropagatedState);
        }
    }

    public void propagatedStateChanged(PropagatedStateEvent pse) {
        try {
            this.setPropagatedState(pse.getState());
        }
        catch (RemoteException re) {
            logger.error(re);
        }
    }

    private AlarmSeverity getDependentPropagatedState() throws RemoteException {
        AlarmSeverity propState = AlarmSeverity.OK;
        Enumeration e = this.propagationStateDependent.elements();
        while (e.hasMoreElements()) {
            GeneralLogicObjectImpl dependent = (GeneralLogicObjectImpl)e.nextElement();
            AlarmSeverity dependentState = dependent.getPropagatedAcknowledgeState();
            if (!dependentState.isMoreSevereThan(propState)) continue;
            propState = dependentState;
        }
        return propState;
    }

    public void addPropagatedStateEventListener(PropagatedStateEventListener listener) {
        if (!this.propagationStateListeners.contains(listener)) {
            this.propagationStateListeners.addElement(listener);
        }
    }

    public void removePropagatedStateEventListener(PropagatedStateEventListener listener) {
        this.propagationStateListeners.removeElement(listener);
    }

    public void addPropagationStateDependentObject(GeneralLogicObjectImpl obj) throws RemoteException {
        if (!this.propagationStateDependent.contains(obj)) {
            this.propagationStateDependent.addElement(obj);
            this.setPropagatedState(this.getDependentPropagatedState());
        }
    }

    public void addPropagationStateDependentObject(Vector objs) throws RemoteException {
        Enumeration e = objs.elements();
        while (e.hasMoreElements()) {
            LogicObjectImpl obj = (LogicObjectImpl)e.nextElement();
            if (this.propagationStateDependent.contains(obj)) continue;
            this.propagationStateDependent.addElement(obj);
        }
        this.setPropagatedState(this.getDependentPropagatedState());
    }

    public void clearPropagationStateDependentObject() throws RemoteException {
        Enumeration e = this.propagationStateDependent.elements();
        while (e.hasMoreElements()) {
            LogicObjectImpl obj = (LogicObjectImpl)e.nextElement();
            obj.clearPropagatedStateOf();
            obj.clearPropagationStateDependentObject();
        }
        this.propagationStateDependent.clear();
        this.setStateSeverity(AlarmSeverity.OK);
        this.setAcknowledgeStateSeverity(AlarmSeverity.OK);
        this.setPropagatedState(AlarmSeverity.OK);
    }

    public void clearPropagatedStateOf() {
    }

    public void removePropagationStateDependentObjectAndListener(GeneralLogicObjectImpl obj) throws RemoteException {
        obj.removePropagatedStateEventListener(this);
        this.propagationStateDependent.removeElement(obj);
        this.setPropagatedState(this.getDependentPropagatedState());
    }

    public Vector getPropagationStateDependent() throws RemoteException {
        Vector propagationDependent = new Vector(this.propagationStateDependent);
        Enumeration e = this.propagationStateDependent.elements();
        while (e.hasMoreElements()) {
            GeneralLogicObjectImpl obj = (GeneralLogicObjectImpl)e.nextElement();
            propagationDependent.addAll(obj.getPropagationStateDependent());
        }
        return propagationDependent;
    }

    public abstract void registerToPropagatedStateChange() throws RemoteException;

    public void unregisterToPropagatedStateChange() throws RemoteException {
    }

    public boolean isDeletionProcessCompleted() {
        return this.deletionProcessCompleted;
    }

    public void setDeletionProcessCompleted() {
        this.deletionProcessCompleted = true;
    }

    public int getConnectedVSwitchCounter() throws RemoteException {
        return this.getConnectedVSwitches().length;
    }

    public void addPropagationStateDependentObjectAndListener(GeneralLogicObjectImpl obj) throws RemoteException {
        obj.addPropagatedStateEventListener(this);
        this.addPropagationStateDependentObject(obj);
    }

    public void setDeletionProcessStarted() {
        this.deletionProcessStarted = true;
    }

    public boolean isDeletionProcessStarted() {
        return this.deletionProcessStarted;
    }

    public int hashCode() {
        try {
            if (this.getClassId() == null) {
                return super.hashCode();
            }
            return this.getClassId().hashCode();
        }
        catch (RemoteException re) {
            logger.error(re);
            return super.hashCode();
        }
    }

    public void refresh() throws RemoteException {
    }

    public void refreshFields(ClientParameterCode[] codes) throws RemoteException {
    }

    protected abstract String isValid(HashMap var1) throws RemoteException;

    protected abstract String canBeDeleted() throws RemoteException;

    public abstract boolean equalsByCommKey(Object var1);
}

