/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.nms.server.EventType;
import com.sanrad.nms.server.RemoteEvent;
import com.sanrad.nms.server.RemoteEventImpl;
import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.alarm.event.AlarmEvent;
import com.sanrad.nms.server.alarm.event.PropagatedStateEvent;
import com.sanrad.nms.server.logic.ClientStateEvent;
import com.sanrad.nms.server.logic.ClientStateListener;
import com.sanrad.nms.server.logic.ClientThread;
import com.sanrad.nms.server.logic.ElementEvent;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.ElementListener;
import com.sanrad.nms.server.logic.EventService;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.util.Queue;
import java.rmi.ConnectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class EventServiceImpl
extends RemoteObjectImpl
implements EventService {
    private static EventServiceImpl theInstance = null;
    private Vector listeners = new Vector();
    private Vector listenerThreads = new Vector();
    private Vector clientStateListeners = new Vector();
    private Queue eventQueue = new Queue();
    private volatile Thread queueConsumerThread = null;
    private byte serialNumber;

    private EventServiceImpl() throws RemoteException {
        this.clearSerialNumber();
        this.startQueueConsumerThread();
    }

    public static EventServiceImpl getInstance() throws RemoteException {
        if (theInstance == null) {
            theInstance = new EventServiceImpl();
        }
        return theInstance;
    }

    private String getClientAddress(Remote listener) {
        String startString = "[endpoint:[";
        String endString = "](remote)";
        int start = listener.toString().indexOf(startString) + startString.length();
        int end = listener.toString().indexOf(endString);
        if (end >= 0) {
            return listener.toString().substring(start, end);
        }
        return listener.getClass().toString();
    }

    public void addClientStateListener(ClientStateListener listener) {
        this.clientStateListeners.addElement(listener);
    }

    public void removeClientStateListener(ClientStateListener listener) {
        this.clientStateListeners.removeElement(listener);
    }

    public synchronized boolean addElementListener(ElementListener listener) throws RemoteException {
        logger.debug("Trying to register client " + this.getClientAddress(listener) + " ...");
        if (!this.listeners.contains(listener)) {
            Enumeration e = this.listeners.elements();
            while (e.hasMoreElements()) {
                ElementListener l = (ElementListener)e.nextElement();
                if (!this.getClientAddress(l).equals(this.getClientAddress(listener))) continue;
                logger.warning("Client " + this.getClientAddress(l) + " is already a listener");
                this.listeners.remove(l);
            }
            if (this.checkConnectivity(listener)) {
                this.listeners.addElement(listener);
                this.listenerThreads.addElement(new ClientThread(listener, this.getClientAddress(listener)));
                logger.info("Register: Client " + this.getClientAddress(listener) + " registered");
                logger.debug("Index of listener: " + this.listeners.indexOf(listener));
            }
        } else {
            logger.debug("Client " + this.getClientAddress(listener) + " is already registered");
        }
        return true;
    }

    public synchronized void removeElementListener(ElementListener listener) throws RemoteException {
        logger.debug("Trying to unregister client " + this.getClientAddress(listener) + " ...");
        logger.debug("Index of listener: " + this.listeners.indexOf(listener));
        if (this.listeners.removeElement(listener)) {
            Enumeration e = this.listenerThreads.elements();
            while (e.hasMoreElements()) {
                ClientThread clientThread = (ClientThread)e.nextElement();
                if (!clientThread.getListener().equals(listener)) continue;
                if (this.listenerThreads.removeElement(clientThread)) {
                    clientThread = null;
                    logger.debug("Client " + listener + " thread was killed");
                    break;
                }
                logger.debug("Failed to kill client " + listener + " thread");
                break;
            }
            logger.info("Unregister: Client " + this.getClientAddress(listener) + " removed");
            ClientStateEvent event = new ClientStateEvent(listener, this.getConnectedRemoteClientIPAddresses().size());
            Enumeration e2 = this.clientStateListeners.elements();
            while (e2.hasMoreElements()) {
                ClientStateListener l = (ClientStateListener)e2.nextElement();
                l.remoteClientClosed(event);
            }
        } else {
            logger.info("Unregister: Client " + this.getClientAddress(listener) + " not registered");
        }
    }

    boolean checkConnectivity(ElementListener listener) {
        try {
            listener.checkConnectivity();
            return true;
        }
        catch (ConnectException ce) {
            logger.info("Cannot connect to " + this.getClientAddress(listener) + ".  Client won't receive events from server.", ce);
            return false;
        }
        catch (RemoteException re) {
            logger.warning("Cannot connect to " + this.getClientAddress(listener) + ".  Client won't receive events from server.", re);
            return false;
        }
    }

    public boolean isRegisterAsListener(ElementListener listener) throws RemoteException {
        return this.listeners.contains(listener);
    }

    public synchronized void fireElementCreate(ElementEvent elementEvent) {
        this.addToQueue(elementEvent, EventType.ELEMENT_CREATED);
    }

    public synchronized void fireElementRemove(ElementEvent elementEvent) {
        this.addToQueue(elementEvent, EventType.ELEMENT_REMOVED);
    }

    public synchronized void fireElementChanged(Object source, Object element, HashMap map) throws RemoteException {
        ElementEventImpl elementEvent = new ElementEventImpl(source, element);
        elementEvent.setParameterList(map);
        this.fireElementChanged(elementEvent);
    }

    public synchronized void fireElementChanged(ElementEvent elementEvent) {
        try {
            if (!elementEvent.getParameterList().isEmpty()) {
                this.addToQueue(elementEvent, EventType.ELEMENT_CHANGED);
            }
        }
        catch (RemoteException re) {
            logger.debug(re);
        }
    }

    public synchronized void fireElementChanged(ElementEvent elementEvent, boolean forceFire) {
        if (forceFire) {
            this.addToQueue(elementEvent, EventType.ELEMENT_CHANGED);
        } else {
            this.fireElementChanged(elementEvent);
        }
    }

    public synchronized void fireStartManualDiscovering(ElementEvent elementEvent) throws RemoteException {
        this.addToQueue(elementEvent, EventType.START_MANUAL_DISCOVERING);
    }

    public synchronized void fireStartReset(ElementEvent elementEvent) throws RemoteException {
        this.addToQueue(elementEvent, EventType.START_RESET);
    }

    public synchronized void fireStartDiscovering(ElementEvent elementEvent) throws RemoteException {
        this.addToQueue(elementEvent, EventType.START_DISCOVERING);
    }

    public synchronized void fireLoginSucceed(ElementEvent elementEvent) throws RemoteException {
        this.addToQueue(elementEvent, EventType.LOGIN_SUCCEED);
    }

    public synchronized void fireDiscoverCompleted(ElementEvent elementEvent) {
        this.addToQueue(elementEvent, EventType.DISCOVER_COMPLETED);
    }

    public synchronized void fireSnmpError(ElementEvent elementEvent) {
        this.addToQueue(elementEvent, EventType.SNMP_ERROR);
    }

    public void fireServerShutDown(ElementEvent elementEvent) {
        ((ElementEventImpl)elementEvent).setType(EventType.SERVER_SHUTDOWN);
        this.fireEventToAllListeners(elementEvent);
    }

    public synchronized void fireConfigurationError(ElementEvent elementEvent) {
        this.addToQueue(elementEvent, EventType.CONFIGURATION_ERROR);
    }

    public synchronized void fireFatalConfigurationError(ElementEvent elementEvent) {
        this.addToQueue(elementEvent, EventType.FATAL_CONFIGURATION_ERROR);
    }

    public synchronized void fireAlarmOpened(AlarmEvent event) throws RemoteException {
        if (!event.getAlarm().isSilent()) {
            this.addToQueue(event, EventType.ALARM_OPENED);
        }
    }

    public synchronized void fireAlarmClosed(AlarmEvent event) {
        this.addToQueue(event, EventType.ALARM_CLOSED);
    }

    public synchronized void fireAlarmChanged(AlarmEvent event) {
        this.addToQueue(event, EventType.ALARM_CHANGED);
    }

    public synchronized void firePropagatedStateChanged(PropagatedStateEvent event) {
        this.addToQueue(event, EventType.PROP_STATE_CHANGED);
    }

    public synchronized void fireDRDiscoveryStarted(ElementEvent event) {
        this.addToQueue(event, EventType.DR_DISCOVER_STARTED);
    }

    public synchronized void fireDRDiscoveryCompleted(ElementEvent event) {
        this.addToQueue(event, EventType.DR_DISCOVER_COMPLETED);
    }

    public synchronized void fireSystemDiscoveryCompleted(ElementEvent event) {
        this.addToQueue(event, EventType.SYSTEM_DISCOVER_COMPLETED);
    }

    private void startQueueConsumerThread() {
        this.queueConsumerThread = new Thread("EventServiceImpl Queue/Consumer Thread"){

            public void run() {
                Thread thisThread = Thread.currentThread();
                while (EventServiceImpl.this.queueConsumerThread == thisThread) {
                    RemoteEventImpl eventQueueElement = (RemoteEventImpl)EventServiceImpl.this.eventQueue.removeHead();
                    EventServiceImpl.this.fireEventToAllListeners(eventQueueElement);
                }
            }
        };
        this.queueConsumerThread.start();
    }

    private void fireEventToAllListeners(RemoteEvent event) {
        Enumeration e = this.listenerThreads.elements();
        while (e.hasMoreElements()) {
            ClientThread client = (ClientThread)e.nextElement();
            client.addToQueue(event);
        }
    }

    public synchronized byte getCurrentSerialNumber() throws RemoteException {
        return this.serialNumber;
    }

    private synchronized void clearSerialNumber() {
        this.serialNumber = (byte)-128;
    }

    private synchronized byte getNextSerialNumberAndIncrementIt() {
        if (this.serialNumber == 122) {
            this.clearSerialNumber();
        }
        byte by = this.serialNumber;
        this.serialNumber = (byte)(by + 1);
        byte sn = by;
        return sn;
    }

    private void addToQueue(RemoteEvent event, EventType type) {
        try {
            Object element = event.getSource();
            if (element instanceof LogicObject) {
                boolean isClusterRemoveEvent;
                Cluster cluster = ((LogicObject)element).getCluster();
                boolean bl = isClusterRemoveEvent = element instanceof Cluster && type.equals(EventType.ELEMENT_REMOVED);
                if (cluster != null && !cluster.isDiscoverCompleted() && type.isConfigurationEvent() && !isClusterRemoveEvent) {
                    return;
                }
            }
        }
        catch (RemoteException re) {
            logger.warning(re);
        }
        ((RemoteEventImpl)event).setSerialNumber(this.getNextSerialNumberAndIncrementIt());
        ((RemoteEventImpl)event).setType(type);
        this.eventQueue.addElement(event);
        try {
            logger.debug("Event " + type + " on source " + event.getSource().getClass() + " " + event.getSource() + " is ready in client's event queue");
        }
        catch (RemoteException re) {
            logger.debug(re);
        }
    }

    public Vector getConnectedRemoteClientIPAddresses() {
        Vector<String> clients = new Vector<String>();
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ElementListener listener = (ElementListener)e.nextElement();
            if (!this.checkConnectivity(listener)) continue;
            String ip = this.getClientAddress(listener);
            clients.addElement(ip);
        }
        return clients;
    }
}

