/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.log.Log;
import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.EventType;
import com.sanrad.nms.server.RemoteEvent;
import com.sanrad.nms.server.RemoteEventImpl;
import com.sanrad.nms.server.alarm.event.AlarmEvent;
import com.sanrad.nms.server.alarm.event.PropagatedStateEvent;
import com.sanrad.nms.server.logic.ElementEvent;
import com.sanrad.nms.server.logic.ElementListener;
import com.sanrad.nms.server.logic.EventServiceImpl;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.util.Queue;
import java.rmi.ConnectException;
import java.rmi.RemoteException;

class ClientThread
extends Thread {
    private ElementListener client;
    private Queue eventQueue = new Queue();
    protected static Log logger = LogMgr.getServerLog();

    public ClientThread(ElementListener listener, String name) {
        super("Client " + name);
        this.client = listener;
        this.start();
    }

    private void fireEvent(RemoteEvent event) throws RemoteException {
        Object element = null;
        EventType type = null;
        try {
            type = event.getType();
            StringBuffer debugMsg = new StringBuffer("Event ");
            debugMsg.append(type);
            debugMsg.append(" (serial# ");
            debugMsg.append(event.getSerialNumber());
            debugMsg.append(") on source ");
            debugMsg.append(event.getSource().getClass());
            debugMsg.append(" ");
            debugMsg.append(event.getSource());
            debugMsg.append(" is going to be fired to ");
            debugMsg.append(this.client);
            logger.debug(debugMsg.toString());
            element = event.getSource();
            debugMsg = new StringBuffer("Fire ");
            debugMsg.append(type);
            debugMsg.append(" (serial# ");
            debugMsg.append(event.getSerialNumber());
            debugMsg.append(") event for ");
            if (element instanceof GeneralLogicObject) {
                debugMsg.append(((GeneralLogicObject)element).getClassId());
                debugMsg.append(" ");
            }
            debugMsg.append(element);
            if (type.equals(EventType.ELEMENT_CREATED)) {
                this.client.elementCreate((ElementEvent)event);
            } else if (type.equals(EventType.ELEMENT_CHANGED)) {
                this.client.elementChanged((ElementEvent)event);
            } else if (type.equals(EventType.ELEMENT_REMOVED)) {
                this.client.elementRemove((ElementEvent)event);
            } else if (type.equals(EventType.ALARM_OPENED)) {
                this.client.alarmOpened((AlarmEvent)event);
                debugMsg.append(" (" + ((AlarmEvent)event).getAlarm() + ") ");
            } else if (type.equals(EventType.ALARM_CLOSED)) {
                this.client.alarmClosed((AlarmEvent)event);
                debugMsg.append(" (" + ((AlarmEvent)event).getAlarm() + ") ");
            } else if (type.equals(EventType.ALARM_CHANGED)) {
                this.client.alarmChanged((AlarmEvent)event);
                debugMsg.append(" (" + ((AlarmEvent)event).getAlarm() + ") ");
            } else if (type.equals(EventType.PROP_STATE_CHANGED)) {
                this.client.propagatedStateChanged((PropagatedStateEvent)event);
                debugMsg.append(" (" + ((PropagatedStateEvent)event).getState() + ") ");
            } else if (type.equals(EventType.START_MANUAL_DISCOVERING)) {
                this.client.startManualDiscovering((ElementEvent)event);
            } else if (type.equals(EventType.START_DISCOVERING)) {
                this.client.startDiscovering((ElementEvent)event);
            } else if (type.equals(EventType.DISCOVER_COMPLETED)) {
                this.client.discoverCompleted((ElementEvent)event);
            } else if (type.equals(EventType.START_RESET)) {
                this.client.startReset((ElementEvent)event);
            } else if (type.equals(EventType.LOGIN_SUCCEED)) {
                this.client.loginSucceed((ElementEvent)event);
            } else if (type.equals(EventType.SNMP_ERROR)) {
                this.client.snmpError((ElementEvent)event);
            } else if (type.equals(EventType.CONFIGURATION_ERROR)) {
                this.client.configurationError((ElementEvent)event);
            } else if (type.equals(EventType.FATAL_CONFIGURATION_ERROR)) {
                this.client.fatalConfigurationError((ElementEvent)event);
            } else if (type.equals(EventType.SERVER_SHUTDOWN)) {
                this.client.serverWasShutdown((ElementEvent)event);
            } else if (type.equals(EventType.DR_DISCOVER_STARTED)) {
                this.client.drDiscoveryStarted((ElementEvent)event);
            } else if (type.equals(EventType.DR_DISCOVER_COMPLETED)) {
                this.client.drDiscoveryCompleted((ElementEvent)event);
            } else if (type.equals(EventType.SYSTEM_DISCOVER_COMPLETED)) {
                this.client.systemDiscoveryCompleted((ElementEvent)event);
            } else {
                logger.error("Event type " + type + " not found in fireEvent()");
                return;
            }
            debugMsg.append(" to ");
            debugMsg.append(this.client);
            logger.debug(debugMsg.toString());
        }
        catch (ConnectException re) {
            logger.debug(re.getMessage() + " when trying to fire event (serial# " + event.getSerialNumber() + ") " + type + " on " + element + " " + element.getClass());
            EventServiceImpl.getInstance().removeElementListener(this.client);
        }
        catch (RemoteException re) {
            logger.debug(re.getMessage() + " when trying to fire event (serial# " + event.getSerialNumber() + ") " + type + " on " + element + " " + element.getClass());
            logger.error(re.getMessage(), re);
        }
    }

    public ElementListener getListener() {
        return this.client;
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this == thisThread) {
            RemoteEventImpl eventQueueElement = (RemoteEventImpl)this.eventQueue.removeHead();
            try {
                this.fireEvent(eventQueueElement);
            }
            catch (RemoteException re) {
                logger.error(re);
            }
        }
    }

    public void addToQueue(RemoteEvent event) {
        this.eventQueue.addElement(event);
    }
}

