/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.event;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.event.ErrorEvent;
import com.sanrad.nms.server.event.ErrorListener;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.event.SrEventMgr;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import java.util.Iterator;

public class ErrorMgr
extends SrEventMgr {
    private static ErrorMgr theInstance = new ErrorMgr();

    private ErrorMgr() {
        super(SrEventHandler.getInstance());
    }

    public static ErrorMgr getInstance() {
        return theInstance;
    }

    public void addListener(ErrorListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ErrorListener listener) {
        this.listeners.remove(listener);
    }

    public void sendConfigurationError(String message, CommKeyClassId vSwitch) {
        ErrorEvent event = new ErrorEvent((Object)vSwitch, message, 3);
        Iterator listenerIter = this.listeners.iterator();
        while (listenerIter.hasNext()) {
            ((ErrorListener)listenerIter.next()).configurationError(event);
        }
        LogMgr.getServerLog().debug(message);
    }

    public void sendConfigurationError(String message, char snmpAgentIndex) {
        CommKeyClassId vSwitch = CommKeyUtil.getVSwitchData(snmpAgentIndex);
        this.sendConfigurationError(message, vSwitch);
    }

    public void sendFatalConfigurationError(String message, CommKeyClassId vSwitch) {
        ErrorEvent event = new ErrorEvent((Object)vSwitch, message, vSwitch, 4);
        Iterator listenerIter = this.listeners.iterator();
        while (listenerIter.hasNext()) {
            ((ErrorListener)listenerIter.next()).fatalConfigurationError(event);
        }
        LogMgr.getServerLog().debug(message);
    }
}

