/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp.trap;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTrapPortIsBusyException;
import com.sanrad.nms.server.comm.snmp.trap.SnmpTrapMonitor;
import com.sanrad.nms.server.comm.snmp.trap.TrapListener;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.util.NetUtil;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class TrapManager {
    private static TrapManager instance = null;
    private Hashtable m_trapMonitorsMap = new Hashtable(4);
    private HashMap m_busyTrapsMap = null;
    private Vector listenersToAllMonitors = new Vector();

    private TrapManager() {
    }

    public static TrapManager getInstance() {
        if (instance == null) {
            instance = new TrapManager();
        }
        return instance;
    }

    public void addTrapListenerToAllMonitors(TrapListener listener) {
        this.listenersToAllMonitors.addElement(listener);
    }

    public void removeTrapListenerFromAllMonitors(TrapListener listener) {
        this.listenersToAllMonitors.remove(listener);
    }

    public int createTrapMonitorIfNeeded(int port, char agentIndex, SrIpAddress ip) throws SrSnmpException {
        return this.createTrapMonitorIfNeeded(port, agentIndex, ip.toString());
    }

    public int createTrapMonitorIfNeeded(int port, char agentIndex, String ip) throws SrSnmpException {
        SnmpTrapMonitor monitor = (SnmpTrapMonitor)this.m_trapMonitorsMap.get(new Integer(port));
        if (monitor != null) {
            LogMgr.getServerLog().debug("Trap port " + port + " already has a monitor");
            monitor.addAgentIndex(agentIndex, ip);
            this.m_trapMonitorsMap.put(new Character(agentIndex), monitor);
            return port;
        }
        if (NetUtil.isUDPPortBusy(port)) {
            int originBusyPort;
            Integer alternativePort;
            if (this.m_busyTrapsMap != null && (alternativePort = (Integer)this.m_busyTrapsMap.get(new Integer(port))) != null) {
                return this.createTrapMonitorIfNeeded((int)alternativePort, agentIndex, ip);
            }
            int busyPort = originBusyPort = port;
            port += 1000;
            while (NetUtil.isUDPPortBusy(port)) {
                if (port > 65535) {
                    port = ++busyPort;
                    if (busyPort > 65535) {
                        port = originBusyPort;
                        LogMgr.getServerLog().error("Couldn't find free trap port");
                        break;
                    }
                }
                port += 1000;
            }
            if (this.m_busyTrapsMap == null) {
                this.m_busyTrapsMap = new HashMap(1);
            }
            this.m_busyTrapsMap.put(new Integer(originBusyPort), new Integer(port));
        }
        monitor = new SnmpTrapMonitor(port);
        monitor.addAgentIndex(agentIndex, ip);
        this.m_trapMonitorsMap.put(new Integer(port), monitor);
        this.m_trapMonitorsMap.put(new Character(agentIndex), monitor);
        monitor.addTrapListeners(this.listenersToAllMonitors);
        LogMgr.getServerLog().debug("Trap Monitor created for trap port - " + port);
        return port;
    }

    public void removeTrapMonitorIfNeeded(char index) {
        Character agent = new Character(index);
        SnmpTrapMonitor monitor = (SnmpTrapMonitor)this.m_trapMonitorsMap.get(agent);
        if (monitor == null) {
            LogMgr.getServerLog().debug("Found No monitor for agent - " + index + " Remove Operation N/A");
            return;
        }
        boolean needsToBeDeleted = monitor.removeAgentIndex(index);
        this.m_trapMonitorsMap.remove(agent);
        LogMgr.getServerLog().debug("Agent - " + index + "was removed from Monitor: " + monitor.toString());
        if (needsToBeDeleted) {
            monitor.terminateMonitorOperation();
            LogMgr.getServerLog().debug("Deleting Monitor - " + monitor.toString() + ". has no agents.");
            this.m_trapMonitorsMap.remove(new Integer(monitor.getTrapPort()));
            monitor.removeAllTrapListeners();
        }
    }

    public int changeTrapPort(char snmpAgentIndex, int port, String ip) throws SrSnmpException {
        SnmpTrapMonitor monitor = (SnmpTrapMonitor)this.m_trapMonitorsMap.get(new Character(snmpAgentIndex));
        int prevPort = 0;
        if (monitor != null) {
            prevPort = monitor.getTrapPort();
            if (prevPort == port) {
                return port;
            }
            this.removeTrapMonitorIfNeeded(snmpAgentIndex);
        }
        try {
            int trapPort = this.createTrapMonitorIfNeeded(port, snmpAgentIndex, ip);
            return trapPort;
        }
        catch (SrSnmpTrapPortIsBusyException e) {
            LogMgr.getServerLog().debug(e);
            if (monitor != null && prevPort != 0) {
                int trapPort = this.createTrapMonitorIfNeeded(prevPort, snmpAgentIndex, ip);
                return trapPort;
            }
            throw e;
        }
    }
}

