/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp.trap;

import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.util.ClassID;
import java.util.HashMap;

public class SrTrapType {
    private int trapId;
    private String trapMsg;
    private static HashMap trapToTrapId = new HashMap(10);
    public static final int PHYSICAL_STORAGE_REMOVED_TRAP_ID = 0;
    public static final int PHYSICAL_STORAGE_ADDED_TRAP_ID = 1;
    public static final int PHYSICAL_STORAGE_STATUS_CHANGE_TRAP_ID = 2;
    public static final int VOLUME_STATE_CHANGE_TRAP_ID = 3;
    public static final int VOLUME_MIRROR_SYNC_CHANGE_TRAP_ID = 4;
    public static final int VOLUME_OPERATION_CHANGE_TRAP_ID = 5;
    public static final int LU_OPERATION_STATUS_CHANGE_TRAP_ID = 6;
    public static final int CLUSTER_NEIGHBOUR_STATUS_CHANGE_TRAP_ID = 7;
    public static final int VSWITCH_TAKE_OVER_STATE_CHANGE_TRAP_ID = 8;
    public static final int VSWITCH_COLD_START_TRAP_ID = 9;
    public static final int SUB_DISK_REMOVED_TRAP_ID = 10;
    public static final int SUB_DISK_ADDED_TRAP_ID = 11;
    public static final int PHYSICAL_STORAGE_COM_OPER_STATUS_CHANGE_TRAP_ID = 12;
    public static final int SNAPSHOT_LOAD_PERCENTAGE_ABOVE_THRESH_ID = 13;
    public static final int VSWITCH_STATUS_ID = 14;
    public static final int INTERFACE_LINK_UP_ID = 15;
    public static final int INTERFACE_LINK_DOWN_ID = 16;
    public static final int POWER_SUPPLY_NUMBER_CHANGED_ID = 17;
    public static final int FAN_NUMBER_CHANGED_ID = 18;
    public static final int FACTORY_TEMP_TRESHOLD_ID = 19;
    public static final int WARNING_TEMP_TRESHOLD_ID = 20;
    public static final int ISCSI_SESSION_FAILURE_ID = 21;
    public static final int ISCSI_TARGET_LOGIN_FAILURE_ID = 22;
    public static final int ISCSI_INITIATOR_LOGIN_FAILURE_ID = 23;
    public static final int JOURNAL_LOAD_PERCENTAGE_ABOVE_THRESH_ID = 24;
    public static final int PAIR_CREATED_TRAP_ID = 25;
    public static final int PAIR_DELETED_TRAP_ID = 26;
    public static final int SYNC_PAIR_STATE_CHANGED_TRAP_ID = 27;
    public static final int ASYNC_PAIR_STATE_CHANGED_TRAP_ID = 28;
    public static final int DR_GROUP_CREATED_TRAP_ID = 29;
    public static final int DR_GROUP_DELETED_TRAP_ID = 30;
    public static final int DR_GROUP_STATE_CHANGED_TRAP_ID = 31;
    public static final int CF_CONSISTENCY_GROUP_ID = 32;
    public static final int CF_ASYNC_PAIR_ID = 33;
    public static final int CF_SYNC_PAIR_ID = 34;
    public static final SrTrapType PHYSICAL_STORAGE_REMOVED = new SrTrapType(0, "The Physical Storage device was removed", MibItem.TRAP_PHYSICAL_STORAGE_REMOVED);
    public static final SrTrapType PHYSICAL_STORAGE_STATUS_CHANGE = new SrTrapType(2, "The Operetional Status of the Physical Storage was changed", MibItem.TRAP_PHYSICAL_STORAGE_STATUS_CHANGE);
    public static final SrTrapType PHYSICAL_STORAGE_ADDED = new SrTrapType(1, "New Physical Storage device was added", MibItem.TRAP_PHYSICAL_STORAGE_ADDED);
    public static final SrTrapType VOLUME_STATE_CHANGE = new SrTrapType(3, "The state of the volume was changed", MibItem.TRAP_VOLUME_STATE_CHANGE);
    public static final SrTrapType VOLUME_SYNC_CHANGE = new SrTrapType(4, "Synchronization state of the volume was changed", MibItem.TRAP_VOLUME_SYNC_CHANGE);
    public static final SrTrapType VOLUME_OPERATION_CHANGE = new SrTrapType(5, "Volume Operation status was changed", MibItem.TRAP_VOLUME_OPERATION_CHANGE);
    public static final SrTrapType LU_OPERATION_STATUS_CHANGE = new SrTrapType(6, "The Operational Status of the LU was changed", MibItem.TRAP_LU_OPERATION_STATUS_CHANGE);
    public static final SrTrapType CLUSTER_NEIGHBOUR_STATUS_CHANGE = new SrTrapType(7, "Neighbor status was changed", MibItem.TRAP_CLUSTER_NEIGHBOUR_STATUS_CHANGE);
    public static final SrTrapType VSWITCH_TAKE_OVER_STATE_CHANGE = new SrTrapType(8, "Cluster Take Over State was changed", MibItem.TRAP_VSWITCH_TAKE_OVER_STATE_CHANGE);
    public static final SrTrapType VSWITCH_COLD_START = new SrTrapType(9, "Cold Start occured in the " + ClassID.VSWITCH, MibItem.TRAP_VSWITCH_COLD_START);
    public static final SrTrapType PHYSICAL_STORAGE_COM_OPER_STATUS_CHANGE = new SrTrapType(12, "Physical storage command oper-status changed", MibItem.TRAP_PHYS_STOR_COM_OPER_STAT_CHANGED);
    public static final SrTrapType VSWITCH_STATUS = new SrTrapType(14, "Status of " + ClassID.VSWITCH, MibItem.TRAP_VSWITCH_STATUS_CHANGED);
    public static final SrTrapType INTERFACE_LINK_UP = new SrTrapType(15, "Interface link up", MibItem.TRAP_INTERFACE_LINK_UP);
    public static final SrTrapType INTERFACE_LINK_DOWN = new SrTrapType(16, "Interface link down", MibItem.TRAP_INTERFACE_LINK_DOWN);
    public static final SrTrapType SNAPSHOT_LOAD_PERCENTAGE_ABOVE_THRESH = new SrTrapType(13, "Snapshot volume load percentage above threshold", MibItem.TRAP_SNAPSHOT_LOAD_PERCENTAGE_ABOVE_THRESH);
    public static final SrTrapType POWER_SUPPLY_NUMBER_CHANGED = new SrTrapType(17, "The number of the power suplies was changed", MibItem.TRAP_POWER_SUPPLY_NUMBER_CHANGED);
    public static final SrTrapType FAN_NUMBER_CHANGED = new SrTrapType(18, "The number of the working fan was changed", MibItem.TRAP_FAN_NUMBER_CHANGED);
    public static final SrTrapType FACTORY_TEMP_TRESHOLD = new SrTrapType(19, "the tempeture was rise above the factory threshold", MibItem.TRAP_FACTORY_TEMP_TRESHOLD);
    public static final SrTrapType WARNING_TEMP_TRESHOLD = new SrTrapType(20, "the tempeture was rise above the warning threshold", MibItem.TRAP_WARNING_TEMP_TRESHOLD);
    public static final SrTrapType ISCSI_SESSION_FAILURE = new SrTrapType(21, "an active session is failed by either the initiator or the target", MibItem.TRAP_ISCSI_SESSION_FAILURE);
    public static final SrTrapType ISCSI_TARGET_LOGIN_FAILURE = new SrTrapType(22, "a login to the target is failed by the target", MibItem.TRAP_ISCSI_TARGET_LOGIN_FAIL);
    public static final SrTrapType ISCSI_INITIATOR_LOGIN_FAILURE = new SrTrapType(23, "a login to the target is failed by the initiator", MibItem.TRAP_ISCSI_INITIATOR_LOGIN_FAIL);
    public static final SrTrapType JOURNAL_LOAD_PERCENTAGE_ABOVE_THRESH = new SrTrapType(24, "Journal volume load percentage above threshold", MibItem.TRAP_JOURNAL_LOAD_PERCENTAGE_ABOVE_THRESH);
    public static final SrTrapType PAIR_CREATED = new SrTrapType(25, "a DR Pair created", MibItem.TRAP_PAIR_CREATED);
    public static final SrTrapType PAIR_DELETED = new SrTrapType(26, "a DR Pair deleted", MibItem.TRAP_PAIR_DELETED);
    public static final SrTrapType SYNC_PAIR_STATE_CHANGED = new SrTrapType(27, "a DR Pair state changed", MibItem.TRAP_SYNC_PAIR_STATE_CHANGED);
    public static final SrTrapType ASYNC_PAIR_STATE_CHANGED = new SrTrapType(28, "a DR Pair state changed", MibItem.TRAP_ASYNC_PAIR_STATE_CHANGED);
    public static final SrTrapType DR_GROUP_CREATED = new SrTrapType(29, "a DR Group created", MibItem.TRAP_DR_GROUP_CREATED);
    public static final SrTrapType DR_GROUP_DELETED = new SrTrapType(30, "a DR Group deleted", MibItem.TRAP_DR_GROUP_DELETED);
    public static final SrTrapType DR_GROUP_STATE_CHANGED = new SrTrapType(31, "a DR Group state changed", MibItem.TRAP_DR_GROUP_STATE_CHANGED);
    public static final SrTrapType CF_CONSISTENCY_GROUP_ = new SrTrapType(32, "cf for group was changed", MibItem.TRAP_CONSISTENCY_GROUP_CF);
    public static final SrTrapType CF_ASYNC_PAIR = new SrTrapType(33, "cf for async pair was changed", MibItem.TRAP_ASYNC_PAIR_CF);
    public static final SrTrapType CF_SYNC_PAIR = new SrTrapType(34, "cf for sync pair was changed", MibItem.TRAP_SYNC_PAIR_CF);

    private SrTrapType(int id, String msg, MibItem mibItem) {
        this.trapId = id;
        this.trapMsg = msg;
        trapToTrapId.put(mibItem.toString(), this);
    }

    public boolean equals(Object trapType) {
        if (trapType instanceof SrTrapType) {
            return ((SrTrapType)trapType).getTrapId() == this.trapId;
        }
        return false;
    }

    public int getTrapId() {
        return this.trapId;
    }

    public static SrTrapType getSrTrapType(String trapStr) {
        return (SrTrapType)trapToTrapId.get(trapStr);
    }

    public static SrTrapType getSrTrapType(MibItem trapItem) {
        return (SrTrapType)trapToTrapId.get(trapItem.toString());
    }

    public String toString() {
        return this.trapMsg;
    }
}

