/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp.trap;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.snmp.DsnmpUtil;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBindList;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpConversionException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTrapPortIsBusyException;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.comm.snmp.trap.SrTrapType;
import com.sanrad.nms.server.comm.snmp.trap.TrapEvent;
import com.sanrad.nms.server.comm.snmp.trap.TrapListener;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.util.Queue;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import monfox.toolkit.snmp.SnmpException;
import monfox.toolkit.snmp.SnmpOid;
import monfox.toolkit.snmp.SnmpVarBindList;
import monfox.toolkit.snmp.engine.SnmpTransportException;
import monfox.toolkit.snmp.engine.TransportEntity;
import monfox.toolkit.snmp.engine.UdpEntity;
import monfox.toolkit.snmp.mgr.SnmpSession;
import monfox.toolkit.snmp.mgr.SnmpTrap;
import monfox.toolkit.snmp.mgr.SnmpTrapListener;

public class SnmpTrapMonitor
implements SnmpTrapListener {
    private SnmpSession trapSession = null;
    private int port;
    private Hashtable agents;
    private Vector listeners;
    private Queue trapsQueue = new Queue();
    private static int trapCounter = 0;
    TrapsInvoker trapsInvoker = new TrapsInvoker(this.trapsQueue, this);

    public SnmpTrapMonitor(int port) throws SrSnmpException {
        this.agents = new Hashtable(4);
        this.listeners = new Vector(4);
        try {
            this.trapSession = new SnmpSession(port);
            this.trapSession.addTrapListener((SnmpTrapListener)this);
            this.port = port;
        }
        catch (SnmpTransportException e) {
            LogMgr.getServerLog().error("Failed to Create Trap Port Monitor - Port " + port + " may be in use.");
            throw new SrSnmpTrapPortIsBusyException("Failed to Create Trap Port Monitor - Port " + port + " may be in use.");
        }
        catch (SnmpException e) {
            throw new SrSnmpException(e.getMessage());
        }
        this.trapsInvoker.start();
    }

    protected void finalize() throws Throwable {
        LogMgr.getServerLog().debug(new StringBuffer(" **********  Trap Monitor deleted for port: ").append(this.port));
        super.finalize();
    }

    public void terminateMonitorOperation() {
        this.trapSession.removeTrapListener((SnmpTrapListener)this);
        this.trapSession.shutdown();
        this.trapSession = null;
        while (!this.trapsQueue.isEmpty()) {
            try {
                System.err.println("Traps Are in the Queue - Waiting");
                this.trapsQueue.wait();
            }
            catch (InterruptedException ie) {
                LogMgr.getServerLog().debug(ie);
            }
        }
    }

    public void addTrapListener(TrapListener listener) {
        this.listeners.addElement(listener);
    }

    public void addTrapListeners(Vector trapListeners) {
        this.listeners.addAll(trapListeners);
    }

    public void removeAllTrapListeners() {
        this.listeners.clear();
    }

    public void removeTrapListener(TrapListener listener) {
        this.listeners.remove(listener);
    }

    public void handleTrap(SnmpTrap trap) {
        long receivedTime = System.currentTimeMillis();
        TrapWrap trapW = new TrapWrap(trap, receivedTime, trapCounter++);
        this.trapsQueue.addElement(trapW);
    }

    private void convertTrap(TrapWrap trapW) {
        SnmpTrap trap = trapW.trap;
        long receivedTime = trapW.time;
        TransportEntity trans = trap.getSource();
        String host = "";
        if (trans instanceof UdpEntity) {
            host = ((UdpEntity)trans).getAddress().getHostAddress();
        }
        LogMgr.getTrapsLog().debug(new StringBuffer("New Trap From: ").append(host).append(trapW));
        Character c = (Character)this.agents.get(host);
        if (c == null) {
            LogMgr.getTrapsLog().debug(new StringBuffer("Monitor  - ").append(this).append(" Got trap from unknown host ").append(host));
            return;
        }
        char agentIndex = c.charValue();
        SnmpOid trapOid = trap.getTrapOid();
        SrTrapType trapType = DsnmpUtil.convertDSnmpTrapTypeToSrTrapType(trapOid);
        if (trapType == null) {
            LogMgr.getServerLog().warning("Unknown Trap " + trapOid + " " + trap.getMessage());
            return;
        }
        SnmpVarBindList vbList = trap.getVarBindList();
        SrSnmpVarBindList srList = null;
        try {
            srList = DsnmpUtil.convertDSnmpVarBindListToSrSnmpVarBindList(vbList);
        }
        catch (SrSnmpConversionException sse) {
            LogMgr.getServerLog().warning("Cannot convert Trap data. Type format mismatch.", sse);
            return;
        }
        catch (Exception ex) {
            LogMgr.getServerLog().warning("Cannot convert Trap data.", ex);
            return;
        }
        SrDateAndTime time = new SrDateAndTime(new Long(receivedTime));
        SrTrap srTrap = new SrTrap(trapType, srList, time, agentIndex, host);
        this.fireTrapCreatedEvent(srTrap);
    }

    private void fireTrapCreatedEvent(SrTrap trap) {
        TrapEvent event = new TrapEvent(this, trap);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TrapListener)this.listeners.get(i)).newTrap(event);
        }
    }

    public int getTrapPort() {
        return this.port;
    }

    public void addAgentIndex(char index, SrIpAddress ip) {
        this.agents.put(ip.toString(), new Character(index));
        LogMgr.getServerLog().debug(new StringBuffer("Add IP to Trap Monitor. ").append(ip).append(" Agent: ").append((int)index));
    }

    public void addAgentIndex(char index, String ip) {
        this.agents.put(ip, new Character(index));
        LogMgr.getServerLog().debug(new StringBuffer("Add IP to Trap Monitor. ").append(ip).append(" Agent: ").append((int)index));
    }

    public boolean removeAgentIndex(char index) {
        Character value = new Character(index);
        Enumeration keys = this.agents.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (!this.agents.get(key).equals(value)) continue;
            LogMgr.getServerLog().debug(new StringBuffer("Remove IP from Trap Monitor. ").append(this.agents.get(key)).append(" Agent: ").append((int)index));
            this.agents.remove(key);
            return this.agents.isEmpty();
        }
        return this.agents.isEmpty();
    }

    public boolean holdsIndex(char index) {
        return this.agents.contains(new Character(index));
    }

    public String toString() {
        return "[port - " + this.port + "]";
    }

    public String getAgentIp(char index) {
        Character value = new Character(index);
        Enumeration keys = this.agents.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (!this.agents.get(key).equals(value)) continue;
            return (String)key;
        }
        return null;
    }

    class TrapsInvoker
    extends Thread {
        private Queue theQueue = null;
        private SnmpTrapMonitor myMonitor = null;

        public TrapsInvoker(Queue trapQueue, SnmpTrapMonitor monitor) {
            super("Traps Invoker");
            this.theQueue = trapQueue;
            this.myMonitor = monitor;
        }

        public void run() {
            while (true) {
                TrapWrap headTrap = (TrapWrap)this.theQueue.removeHead();
                try {
                    this.myMonitor.convertTrap(headTrap);
                    continue;
                }
                catch (Exception e) {
                    LogMgr.getTrapsLog().info("Error Converting Trap! " + headTrap.trap.toString(), e);
                    continue;
                }
                break;
            }
        }
    }

    class TrapWrap {
        public long time;
        public SnmpTrap trap;
        public int trapIndex;

        TrapWrap(SnmpTrap theTrap, long recieveTime, int trapId) {
            this.time = recieveTime;
            this.trap = theTrap;
            this.trapIndex = trapId;
        }

        public String toString() {
            StringBuffer str = new StringBuffer("--- Id: ");
            str.append(this.trapIndex);
            str.append(" Trap Data: ");
            str.append(this.trap.toString());
            return str.toString();
        }
    }
}

