/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp;

import com.sanrad.nms.server.util.types.SrType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public final class SnmpVersion
extends SrType
implements Serializable {
    private static ArrayList versionList;
    public static final SnmpVersion V1;
    public static final SnmpVersion V2C;
    public static final SnmpVersion V3;
    private String version;

    private SnmpVersion() {
        super("SnmpVersion");
    }

    private SnmpVersion(String version) {
        super("SnmpVersion");
        this.version = version;
        if (versionList == null) {
            versionList = new ArrayList();
        }
        versionList.add(this);
    }

    public String toString() {
        return this.version;
    }

    public static SnmpVersion getVersion(String ver) {
        Iterator verIter = versionList.iterator();
        while (verIter.hasNext()) {
            SnmpVersion currnt = (SnmpVersion)verIter.next();
            if (!currnt.toString().equals(ver)) continue;
            return currnt;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SnmpVersion) {
            return this.version.equals(((SnmpVersion)obj).version);
        }
        return false;
    }

    public Object value() {
        return this.version;
    }

    public String errorDisplayString() {
        return this.version;
    }

    public int getTypeNumber() {
        return 15;
    }

    static {
        V1 = new SnmpVersion("v1");
        V2C = new SnmpVersion("v2c");
        V3 = new SnmpVersion("v3");
    }
}

