/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.snmp.DefaultSnmpMgr;
import com.sanrad.nms.server.comm.snmp.DsnmpUtil;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpConversionException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpException;
import com.sanrad.nms.server.event.SnmpErrorEvent;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import monfox.toolkit.snmp.SnmpException;
import monfox.toolkit.snmp.SnmpVarBindList;
import monfox.toolkit.snmp.mgr.SnmpErrorException;
import monfox.toolkit.snmp.mgr.SnmpTimeoutException;

public class SnmpErrorAnalyzer {
    private static final int TOO_BIG_ERROR = 1;
    private static final int NO_ACCESS_ERROR = 6;
    private static final int WRONG_TYPE_ERROR = 7;
    private static final int WRONG_LENGTH_ERROR = 8;
    private static final int WRONG_ENCODING_ERROR = 9;
    private static final int WRONG_VALUE_ERROR = 10;
    private static final int NO_CREATION_ERROR = 11;
    private static final int INCONSISTENT_VALUE_ERROR = 12;
    private static final int RESOURCE_UNAVAILABLE_ERROR = 13;
    private static final int COMMIT_FAILED_ERROR = 14;
    private static final int UNDO_FAILED_ERROR = 15;
    private static final int AUTHORIZATION_ERROR = 16;
    private static final int NOT_WRITEABLE_ERROR = 17;
    private static final int INCONSISTENT_NAME_ERROR = 18;
    private static SnmpErrorAnalyzer theInstance = new SnmpErrorAnalyzer();

    private SnmpErrorAnalyzer() {
    }

    public static SnmpErrorAnalyzer getInstance() {
        return theInstance;
    }

    public static void snmpTimeOutOccured(SnmpTimeoutException e) {
    }

    public void analyzeSNMPException(SnmpErrorException e, SnmpVarBindList vbList, DefaultSnmpMgr snmpMgr) throws SrSnmpException {
        int errorStatus = e.getErrorStatus();
        int vbIndex = e.getErrorIndex();
        String ip = snmpMgr.getAgentIpAddress();
        StringBuffer usrMsg = new StringBuffer("**** SNMP Operation Failed for agent: ").append(ip);
        try {
            DsnmpUtil.convertDSnmpVarBindListToSrSnmpVarBindList(vbList);
            if (vbIndex > 0) {
                DsnmpUtil.convertDSnmpVarBindToSrSnmpVarBind(vbList.get(vbIndex - 1));
            }
        }
        catch (SrSnmpConversionException ce) {
            LogMgr.getServerLog().debug(ce);
        }
        usrMsg.append(" . Error: ");
        switch (errorStatus) {
            case 12: {
                usrMsg.append("inconsistentValue.");
                break;
            }
            case 6: {
                usrMsg.append("noAccess.");
                break;
            }
            case 7: {
                usrMsg.append("wrongType.");
                break;
            }
            case 8: {
                usrMsg.append("wrongLength.");
                break;
            }
            case 9: {
                usrMsg.append("wrongEncoding.");
                break;
            }
            case 10: {
                usrMsg.append("wrongValue.");
                break;
            }
            case 11: {
                usrMsg.append("noCreation.");
                break;
            }
            case 13: {
                usrMsg.append("resourceUnavailable.");
                break;
            }
            case 14: {
                usrMsg.append("commitFailed.");
                break;
            }
            case 15: {
                usrMsg.append("undoFailed.");
                break;
            }
            case 16: {
                usrMsg.append("authorizationError.");
                break;
            }
            case 17: {
                usrMsg.append("notWritable.");
                break;
            }
            case 18: {
                usrMsg.append("inconsistentName.");
                break;
            }
        }
        this.sendErrorEvent(usrMsg.toString(), snmpMgr);
        LogMgr.getServerLog().info(usrMsg.append(" Index: ").append(e.getErrorIndex()).append(vbList.toString()).toString());
        throw new SrSnmpException(usrMsg.append(" Error: ").append(e.getMessage()).toString());
    }

    public void analyzeSNMPException(SnmpException e, SnmpVarBindList vbList, DefaultSnmpMgr snmpMgr) throws SrSnmpException {
        String msg = "**** SNMP Operation Failed for: " + snmpMgr.getAgentIpAddress();
        this.sendErrorEvent(msg, snmpMgr);
        LogMgr.getServerLog().info(msg + vbList.toString());
        throw new SrSnmpException(msg + " Error: " + e.getMessage());
    }

    public void analyzeTableException(SnmpErrorException e, String tableName, DefaultSnmpMgr snmpMgr) throws SrSnmpException {
        int errorStatus = e.getErrorStatus();
        StringBuffer usrMsg = new StringBuffer("**** SNMP Operation Failed for table: ");
        usrMsg.append(tableName);
        usrMsg.append(" at: ");
        usrMsg.append(snmpMgr.getAgentIpAddress());
        usrMsg.append(" .Error: ");
        switch (errorStatus) {
            case 12: {
                usrMsg.append("inconsistentValue.");
                break;
            }
            case 6: {
                usrMsg.append("noAccess.");
                break;
            }
            case 7: {
                usrMsg.append("wrongType.");
                break;
            }
            case 8: {
                usrMsg.append("wrongLength.");
                break;
            }
            case 9: {
                usrMsg.append("wrongEncoding.");
                break;
            }
            case 10: {
                usrMsg.append("wrongValue.");
                break;
            }
            case 11: {
                usrMsg.append("noCreation.");
                break;
            }
            case 13: {
                usrMsg.append("resourceUnavailable.");
                break;
            }
            case 14: {
                usrMsg.append("commitFailed.");
                break;
            }
            case 15: {
                usrMsg.append("undoFailed.");
                break;
            }
            case 16: {
                usrMsg.append("authorizationError.");
                break;
            }
            case 17: {
                usrMsg.append("notWritable.");
                break;
            }
            case 18: {
                usrMsg.append("inconsistentName.");
                break;
            }
            case 1: {
                usrMsg.append("TOOBIGError.");
                break;
            }
        }
        this.sendErrorEvent(usrMsg.toString(), snmpMgr);
        LogMgr.getServerLog().info(usrMsg.append(" ").append(tableName).toString());
        if (errorStatus == 1) {
            return;
        }
        throw new SrSnmpException(usrMsg.append(" Error: ").append(e.getMessage()).toString());
    }

    public void analyzeTableException(SnmpException e, String tableName, DefaultSnmpMgr snmpMgr) throws SrSnmpException {
        String msg = "**** SNMP Operation Failed for: " + snmpMgr.getAgentIpAddress();
        this.sendErrorEvent(msg, snmpMgr);
        LogMgr.getServerLog().info(msg + tableName);
        throw new SrSnmpException(msg + " Error: " + e.getMessage());
    }

    private void sendErrorEvent(String msg, DefaultSnmpMgr mgr) {
        CommKeyClassId vSwitchData = CommKeyUtil.getVSwitchData(CommMgr.getSnmpMgrIndex(mgr));
        SnmpErrorEvent event = new SnmpErrorEvent((Object)this, msg, vSwitchData, 2);
        SrEventHandler.getSnmpErrorMgr().sendSnmpErrorEvent(event);
    }
}

