/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrLong;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.Util;
import java.net.URL;

public class SnmpAgentParams {
    private SrString hostname = new SrString("");
    private SrIpAddress ipAddress;
    private SrIpAddress ipMask = new SrIpAddress(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_IP_MASK));
    private SnmpVersion version = SnmpVersion.V2C;
    private SrString readCommunity = new SrString(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_READ_COMMUNITY));
    private SrString writeCommunity = new SrString(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_WRITE_COMMUNITY));
    private SrString infoCommunity = new SrString(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_INFO_COMMUNITY));
    private SrLong timeout = new SrLong(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_TIMEOUT_MILISEC));
    private SrInteger retries = new SrInteger(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_NUM_OF_RETRIES));
    private SrInteger snmpPort = new SrInteger(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_PORT));
    private SrInteger trapPort = new SrInteger(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_TRAP_PORT));
    private static final SrString mibFile = new SrString("mibs/sanrad-mibs.xml");

    public SnmpAgentParams(SrIpAddress ip) {
        if (ip == null) {
            LogMgr.getServerLog().error("Missing IP Address for new SNMP Agent");
            throw new NullPointerException();
        }
        this.ipAddress = ip;
    }

    public void setWriteCommunity(SrString community) {
        this.writeCommunity = community;
    }

    public void setReadCommunity(SrString community) {
        this.readCommunity = community;
    }

    public void setTimeout(SrLong timeout) {
        this.timeout = timeout;
    }

    public void setNumberOfRetries(SrInteger retries) {
        this.retries = retries;
    }

    public void setHostName(SrString name) {
        this.hostname = name;
    }

    public void setSnmpPort(SrInteger port) {
        this.snmpPort = port;
    }

    public void setTrapPort(SrInteger port) {
        this.trapPort = port;
    }

    public void setSnmpVersion(SnmpVersion ver) {
        this.version = ver;
    }

    public void setIpMask(SrIpAddress mask) {
        this.ipMask = mask;
    }

    public SrString getWriteCommunity() {
        return this.writeCommunity;
    }

    public SrString getInfoCommunity() {
        return this.infoCommunity;
    }

    public SrString getReadCommunity() {
        return this.readCommunity;
    }

    public SrLong getTimeout() {
        return this.timeout;
    }

    public SrInteger getNumberOfRetries() {
        return this.retries;
    }

    public SrString getHostname() {
        return this.hostname;
    }

    public SrInteger getSnmpPort() {
        return this.snmpPort;
    }

    public SrInteger getTrapPort() {
        return this.trapPort;
    }

    public SnmpVersion getSnmpVersion() {
        return this.version;
    }

    public SrString getMibDataFile() {
        return mibFile;
    }

    public static URL getMibDataFileURL() {
        Util util = new Util();
        return util.getURL((String)mibFile.value());
    }

    public SrIpAddress getIpAddress() {
        return this.ipAddress;
    }

    public SrIpAddress getIpMask() {
        return this.ipMask;
    }
}

